/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.jsi;

import com.blixx.boom.RTLogger;
import com.blixx.boom.StrUtils;
import com.blixx.jsi.ICommand;
import com.blixx.jsi._if;
import com.blixx.jsi._math;
import com.blixx.shared.PatternB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Run {
    public static final String FUCTION_RESULT = "_FUNCTION_RESULT";
    private final List<String> lines = new ArrayList<String>();
    Map<String, Object> variables = new HashMap<String, Object>();
    static final Pattern DIGITS_PATTERN = Pattern.compile("\\d+\\.*\\d*");
    static final Pattern IF_PATTERN = Pattern.compile("if\\s*\\((.*)\\)\\s*\\{\\s*");
    static final Pattern FOR_PATTERN = Pattern.compile("for\\s*\\((.*)\\)\\s*\\{\\s*");
    static final Pattern WHILE_PATTERN = Pattern.compile("while\\s*\\((.*)\\)\\s*\\{\\s*");
    static final Pattern COND_PATTERN = Pattern.compile("(\\S*)\\s*([!<>=]+)\\s*(.*)");
    public static boolean trace = false;
    private static boolean noExitFlag = false;
    public static final List<String> errors = new ArrayList<String>();

    public static void main(String[] args) {
        File sc;
        if (args.length == 0) {
            Run.usage();
            return;
        }
        String filename = args[0];
        if (filename.toLowerCase().startsWith("-ver") || filename.toLowerCase().startsWith("--ver")) {
            System.out.println("3.5.0");
            System.exit(0);
        }
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                String param = args[i];
                if (param == null || !param.equalsIgnoreCase("-trace")) continue;
                trace = true;
                break;
            }
        }
        if ((sc = new File(filename)).canRead()) {
            Run run = new Run(null);
            RTLogger.setFile(filename + ".log");
            run.function(sc);
        } else {
            Run.error("File not found: " + filename);
        }
    }

    public Run(Map<String, Object> globalVars) {
        if (globalVars != null) {
            this.variables.putAll(globalVars);
        }
    }

    public void function(File sc) {
        try (FileReader in = new FileReader(sc);
             BufferedReader br = new BufferedReader(in);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).endsWith(";")) {
                    line = line.substring(0, line.length() - 1);
                }
                this.lines.add(line);
            }
        }
        catch (FileNotFoundException e) {
            Run.error("File not found: " + sc.getName());
        }
        catch (IOException e) {
            Run.error("Reading failed: " + sc.getName());
        }
        try {
            this.processLines(this.lines, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processLines(List<String> lines, int currentLineNumber) {
        int ifstarted = 0;
        int nextifelse = 0;
        ArrayList<Integer> stackBackpoints = new ArrayList<Integer>();
        while (currentLineNumber < lines.size()) {
            block30: {
                block37: {
                    String line;
                    block38: {
                        String rest;
                        String var;
                        int equalsIndex;
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block40: {
                                                block39: {
                                                    int bracketIndex;
                                                    block36: {
                                                        String var2;
                                                        String comp;
                                                        String var1;
                                                        String condition;
                                                        block35: {
                                                            block34: {
                                                                int bracketEndIndex;
                                                                block32: {
                                                                    block33: {
                                                                        Integer lineBack;
                                                                        block31: {
                                                                            line = lines.get(currentLineNumber);
                                                                            if (line.startsWith("//") || line.startsWith("#") || line.length() == 0) break block30;
                                                                            equalsIndex = line.indexOf(61);
                                                                            bracketIndex = line.indexOf(40);
                                                                            bracketEndIndex = line.indexOf(41);
                                                                            if (nextifelse <= 0) break block31;
                                                                            int cbi = line.indexOf(123);
                                                                            if (line.indexOf("else") != 1 && cbi != -1 && line.indexOf(125) != -1 && nextifelse > 1) break block30;
                                                                            if (bracketIndex > 0 && bracketIndex < bracketEndIndex && bracketEndIndex < cbi && line.lastIndexOf(34) < cbi) {
                                                                                ++nextifelse;
                                                                            }
                                                                            if (line.startsWith("}")) {
                                                                                --nextifelse;
                                                                            }
                                                                            break block30;
                                                                        }
                                                                        if (ifstarted <= 0 || !line.startsWith("}")) break block32;
                                                                        if ((lineBack = (Integer)stackBackpoints.remove(--ifstarted)) == null || lineBack <= 0) break block33;
                                                                        currentLineNumber = lineBack - 1;
                                                                        break block30;
                                                                    }
                                                                    if (!line.contains("else") && !line.contains("else if")) break block32;
                                                                    ++nextifelse;
                                                                    break block30;
                                                                }
                                                                if (line.startsWith("//") || line.startsWith("#")) break block30;
                                                                if (line.startsWith("return(")) {
                                                                    if (bracketEndIndex - bracketIndex > 0) {
                                                                        String returnObject = line.substring(bracketIndex + 1, bracketEndIndex);
                                                                        String var3 = StrUtils.removeQuotes(returnObject);
                                                                        this.variables.put(FUCTION_RESULT, this.variables.get(var3));
                                                                        return currentLineNumber;
                                                                    }
                                                                    this.variables.put(FUCTION_RESULT, null);
                                                                    return currentLineNumber;
                                                                }
                                                                if (!line.startsWith("function(")) break block34;
                                                                Run sub = new Run(this.variables);
                                                                String file = line.substring(bracketIndex + 1, bracketEndIndex);
                                                                File file2 = new File(file);
                                                                if (file2.exists()) {
                                                                    sub.function(file2);
                                                                    break block30;
                                                                } else {
                                                                    Run.error("function file not found: " + file);
                                                                }
                                                                break block30;
                                                            }
                                                            if (!line.startsWith("if(")) break block35;
                                                            stackBackpoints.add(-1);
                                                            Matcher m = IF_PATTERN.matcher(line);
                                                            m.matches();
                                                            condition = m.group(1);
                                                            Matcher matcher = COND_PATTERN.matcher(condition);
                                                            matcher.matches();
                                                            var1 = matcher.group(1);
                                                            comp = matcher.group(2);
                                                            var2 = matcher.group(3);
                                                            ++ifstarted;
                                                            if (_if.eq(var1, comp, var2, this.variables)) break block30;
                                                            ++nextifelse;
                                                            break block30;
                                                        }
                                                        if (line.startsWith("for(")) break block30;
                                                        if (!line.startsWith("while(")) break block36;
                                                        stackBackpoints.add(currentLineNumber);
                                                        Matcher m = WHILE_PATTERN.matcher(line);
                                                        m.matches();
                                                        condition = m.group(1);
                                                        Matcher matcher = COND_PATTERN.matcher(condition);
                                                        matcher.matches();
                                                        var1 = matcher.group(1);
                                                        comp = matcher.group(2);
                                                        var2 = matcher.group(3);
                                                        ++ifstarted;
                                                        if (_if.eq(var1, comp, var2, this.variables)) break block30;
                                                        stackBackpoints.set(stackBackpoints.size() - 1, -1);
                                                        ++nextifelse;
                                                        break block30;
                                                    }
                                                    if (line.equals("break")) break block37;
                                                    if (equalsIndex == -1 || bracketIndex != -1 && equalsIndex >= bracketIndex) break block38;
                                                    var = line.substring(0, equalsIndex).trim();
                                                    rest = null;
                                                    if (!var.startsWith("int ")) break block39;
                                                    var = var.substring(4).trim();
                                                    rest = line.substring(equalsIndex + 1).trim();
                                                    if (rest.indexOf(40) != -1) {
                                                        this.call(var, rest, currentLineNumber, lines);
                                                        break block30;
                                                    } else {
                                                        Integer n = Integer.parseInt(rest);
                                                        this.variables.put(var, n);
                                                    }
                                                    break block30;
                                                }
                                                if (!var.startsWith("boolean ")) break block40;
                                                var = var.substring(8).trim();
                                                rest = line.substring(equalsIndex + 1).trim();
                                                if (rest.indexOf(40) != -1) {
                                                    this.call(var, rest, currentLineNumber, lines);
                                                    break block30;
                                                } else {
                                                    Boolean bl = Boolean.parseBoolean(rest);
                                                    this.variables.put(var, bl);
                                                }
                                                break block30;
                                            }
                                            if (!var.startsWith("long ")) break block41;
                                            var = var.substring(5).trim();
                                            rest = line.substring(equalsIndex + 1).trim();
                                            if (rest.indexOf(40) != -1) {
                                                this.call(var, rest, currentLineNumber, lines);
                                                break block30;
                                            } else {
                                                Long l = Long.parseLong(rest);
                                                this.variables.put(var, l);
                                            }
                                            break block30;
                                        }
                                        if (!var.startsWith("double ")) break block42;
                                        var = var.substring(7).trim();
                                        rest = line.substring(equalsIndex + 1).trim();
                                        if (rest.indexOf(40) != -1) {
                                            this.call(var, rest, currentLineNumber, lines);
                                            break block30;
                                        } else {
                                            Double d = Double.parseDouble(rest);
                                            this.variables.put(var, d);
                                        }
                                        break block30;
                                    }
                                    if (!var.startsWith("String ")) break block43;
                                    var = var.substring(7).trim();
                                    rest = line.substring(equalsIndex + 1).trim();
                                    if (rest.indexOf(40) != -1) {
                                        this.call(var, rest, currentLineNumber, lines);
                                        break block30;
                                    } else if (StrUtils.processQuoted(rest, "\\+").length > 1) {
                                        this.concatenateStrings(var, rest);
                                        break block30;
                                    } else {
                                        this.variables.put(var, StrUtils.replaceSpecials(StrUtils.removeQuotes(rest)));
                                    }
                                    break block30;
                                }
                                if (!var.startsWith("List ")) break block44;
                                var = var.substring(5).trim();
                                rest = line.substring(equalsIndex + 1).trim();
                                if (rest.indexOf(40) != -1) {
                                    this.call(var, rest, currentLineNumber, lines);
                                    break block30;
                                } else {
                                    this.variables.put(var, new ArrayList());
                                }
                                break block30;
                            }
                            if (!var.startsWith("Map ")) break block45;
                            var = var.substring(4).trim();
                            rest = line.substring(equalsIndex + 1).trim();
                            if (rest.indexOf(40) != -1) {
                                this.call(var, rest, currentLineNumber, lines);
                                break block30;
                            } else {
                                this.variables.put(var, new HashMap());
                            }
                            break block30;
                        }
                        if (var.startsWith("PatternB ")) {
                            var = var.substring(9).trim();
                            rest = line.substring(equalsIndex + 1).trim();
                            if (Pattern.matches("\\s*[^\"]+\\(.*\\);.*", rest)) {
                                this.call(var, rest, currentLineNumber, lines);
                                break block30;
                            } else {
                                try {
                                    this.variables.put(var, PatternB.getPattern(StrUtils.removeQuotes(rest)));
                                }
                                catch (Exception exception) {}
                            }
                            break block30;
                        } else {
                            rest = line.substring(equalsIndex + 1).trim();
                            this.call(var, StrUtils.replaceOptVars(rest, this.variables), currentLineNumber, lines);
                        }
                        break block30;
                    }
                    this.call(null, StrUtils.replaceOptVars(line, this.variables), currentLineNumber, lines);
                    break block30;
                }
                for (int i = stackBackpoints.size() - 1; i >= 0; ++nextifelse, --i) {
                    if ((Integer)stackBackpoints.get(i) == -1) continue;
                    stackBackpoints.set(i, -1);
                    break;
                }
            }
            ++currentLineNumber;
        }
        return currentLineNumber;
    }

    public void call(String varname, String line, int pos, List<String> lines) {
        block29: {
            int st = line.indexOf(40);
            if (st != -1) {
                String classname = line.substring(0, st);
                int end = line.lastIndexOf(41);
                if (end == -1) {
                    end = line.length();
                }
                String param = line.substring(st + 1, end);
                param = StrUtils.replaceSpecials(param);
                param = StrUtils.replaceOptVars(param, this.variables);
                try {
                    Object result = null;
                    if (classname.equalsIgnoreCase("function")) {
                        Run sub = new Run(this.variables);
                        File subFile = new File(param);
                        if (subFile.exists()) {
                            sub.function(subFile);
                            result = sub.variables.get(FUCTION_RESULT);
                        } else {
                            Run.error("function file not found: " + param);
                        }
                    } else {
                        Class<?> cl = Class.forName("com.blixx.jsi." + classname);
                        Object o = cl.newInstance();
                        ICommand cmd = (ICommand)o;
                        result = cmd.run(param.trim(), this.variables, pos, lines);
                    }
                    if (varname == null || result == null) break block29;
                    Object existing = this.variables.get(varname);
                    if (existing == null) {
                        this.variables.put(varname, result);
                        break block29;
                    }
                    String resAsStr = String.valueOf(result);
                    if (existing instanceof String) {
                        this.variables.put(varname, resAsStr);
                        break block29;
                    }
                    if (existing instanceof Integer) {
                        this.variables.put(varname, Integer.parseInt(resAsStr));
                        break block29;
                    }
                    if (existing instanceof Long) {
                        this.variables.put(varname, Long.parseLong(resAsStr));
                        break block29;
                    }
                    if (existing instanceof Boolean) {
                        this.variables.put(varname, Boolean.parseBoolean(resAsStr));
                        break block29;
                    }
                    if (existing instanceof Double) {
                        this.variables.put(varname, Double.parseDouble(resAsStr));
                        break block29;
                    }
                    if (existing instanceof PatternB) {
                        this.variables.put(varname, PatternB.getPattern(resAsStr));
                        break block29;
                    }
                    this.variables.put(varname, result);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Run.error("ClassNotFound " + classname);
                }
            } else if (varname != null) {
                Object val = this.variables.get(varname);
                if (line.indexOf(34) != -1 && line.indexOf(43) != -1) {
                    this.concatenateStrings(varname, line);
                } else if (val instanceof String) {
                    val = StrUtils.replaceOptVars(StrUtils.removeQuotes(line), this.variables);
                    this.variables.put(varname, val);
                } else if (val instanceof Boolean) {
                    this.variables.put(varname, Boolean.parseBoolean(StrUtils.removeQuotes(line)));
                } else {
                    double dd = _math.calculateLine(line, this.variables);
                    Object varInstance = this.variables.get(varname);
                    if (varInstance != null) {
                        if (varInstance instanceof Double) {
                            this.variables.put(varname, dd);
                        } else if (varInstance instanceof Integer) {
                            this.variables.put(varname, (int)dd);
                        } else if (varInstance instanceof Long) {
                            this.variables.put(varname, (long)dd);
                        }
                    }
                }
            }
        }
    }

    private void concatenateStrings(String varname, String line) {
        String[] quotedStrings;
        line = StrUtils.replaceOptVars(line, this.variables);
        StringBuilder nl = new StringBuilder();
        for (String quotedString : quotedStrings = StrUtils.processQuoted(line, "\\+")) {
            nl.append(StrUtils.removeQuotes(quotedString.trim()));
        }
        this.variables.put(varname, nl.toString());
    }

    public static void usage() {
        RTLogger.println("java -cp srv/libs/xercesImpl.jar:srv/libs/mysql-connector-java-commercial-5.1.7-bin.jar:srv/libs/ojdbc5.jar:srv/libs/boom_jsi.jar com.blixx.jsi.Run jsi/install.jsi [-trace]");
    }

    public static void setNoExit(boolean noExit) {
        noExitFlag = noExit;
    }

    public static void error(String error) {
        if (noExitFlag) {
            errors.add(error);
            return;
        }
        RTLogger.println("Error! " + error);
        System.exit(-1);
    }
}

