/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.jsi;

import com.blixx.jsi.Run;
import java.util.Map;
import java.util.regex.Pattern;

public class _math {
    private static final Pattern DIGITS_PATTERN = Pattern.compile("\\s*[-]*\\d+.*");
    private static final Pattern OPERAND_PATTERN = Pattern.compile("\\s*[\\*+-/]+\\s*");
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int DIV = 2;
    public static final int MUL = 3;
    public static final int DIV1 = 4;

    public static double calculateLine(String tocalc, Map<String, Object> variables) {
        String[] calcs = tocalc.split("\\s+");
        double temp = 0.0;
        int operand = 0;
        for (String c : calcs) {
            Double dd;
            if (c.startsWith("<$")) {
                dd = (Double)variables.get(c);
                if (dd == null) continue;
                temp = _math.oper(operand, temp, dd);
                continue;
            }
            if (DIGITS_PATTERN.matcher(c).matches()) {
                try {
                    dd = Double.parseDouble(c.trim().replace(',', '.'));
                    temp = _math.oper(operand, temp, dd);
                }
                catch (NumberFormatException dd2) {}
                continue;
            }
            if (OPERAND_PATTERN.matcher(c).matches()) {
                String operandNew = c.trim();
                if (operandNew.equals("+")) {
                    operand = 0;
                    continue;
                }
                if (operandNew.equals("-")) {
                    operand = 1;
                    continue;
                }
                if (operandNew.equals("/")) {
                    operand = 2;
                    continue;
                }
                if (operandNew.equals("*")) {
                    operand = 3;
                    continue;
                }
                if (!operandNew.equals("\\")) continue;
                operand = 4;
                continue;
            }
            Run.error("Opm function has wrong syntax: " + tocalc);
        }
        return temp;
    }

    public static double oper(int operand, double d1, double d2) {
        double res = 0.0;
        switch (operand) {
            case 0: {
                res = d1 + d2;
                break;
            }
            case 1: {
                res = d1 - d2;
                break;
            }
            case 2: {
                if (d2 == 0.0) {
                    Run.error("Division by 0.");
                    break;
                }
                res = d1 / d2;
                break;
            }
            case 3: {
                res = d1 * d2;
                break;
            }
            case 4: {
                if (d1 == 0.0) {
                    Run.error("Division by 0.");
                    break;
                }
                res = d2 / d1;
                break;
            }
        }
        return res;
    }
}

