/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.jsi;

import com.blixx.boom.RTLogger;
import com.blixx.boom.StrUtils;
import com.blixx.jsi.ICommand;
import com.blixx.jsi.Run;
import com.blixx.jsi.askUserYNC;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.PolicyParsingException;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.FileFilter;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.VersionComparator;
import com.blixx.shared.utils.XMLTree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.w3c.dom.Document;

public class importPolicies
implements ICommand {
    private static final String ASSIGNMENT_GROUPS_XML = "assignmentGroups.xml";
    private static final String POLICY_GROUPS_XML = "policyGroups.xml";
    public GroupTreeObject policyTreeSource = new GroupTreeObject(new TreeObject("root", null, null));
    public GroupTreeObject policyTreeTarget = new GroupTreeObject(new TreeObject("root", null, null));
    public GroupTreeObject assignmentTreeSource = new GroupTreeObject(new TreeObject("root", null, null));
    public GroupTreeObject assignmentTreeTarget = new GroupTreeObject(new TreeObject("root", null, null));
    public Map<String, AbstractPolicy> nameToPolicySource = new HashMap<String, AbstractPolicy>();
    public Map<String, AbstractPolicy> nameToPolicyTarget = new HashMap<String, AbstractPolicy>();
    public Map<String, File> policyNameToFileSource = new HashMap<String, File>();
    public Map<String, File> policyNameToFileTarget = new HashMap<String, File>();
    public Map<String, Long> policyNameToCRCSource = new HashMap<String, Long>();
    public Map<String, Long> policyNameToCRCTarget = new HashMap<String, Long>();
    public Map<String, AbstractPolicy> policyNameToNewNonConflictingPolicy = new HashMap<String, AbstractPolicy>();
    public Map<String, AbstractPolicy> policyNameToCustomNonConflictingPolicy = new HashMap<String, AbstractPolicy>();
    public Map<String, AbstractPolicy> policyNameToConflictingPolicy = new HashMap<String, AbstractPolicy>();
    public static PolicyFactory pf = new PolicyFactory();
    public File targetDirectory = null;

    @Override
    public Object run(Object input, Map<String, Object> variables, int line, List<String> lines) {
        RTLogger.setFile("import.log");
        RTLogger.println("### Import Policies and Assignments ");
        RTLogger.println("### Analysis phase started... ");
        String[] arr = StrUtils.processQuoted(String.valueOf(input), ",");
        File sourceDir = new File(StrUtils.removeQuotes(arr[0]));
        File targetDir = new File(StrUtils.removeQuotes(arr[1]));
        this.targetDirectory = arr.length == 3 ? new File(StrUtils.removeQuotes(arr[2])) : targetDir;
        try {
            if (!sourceDir.exists()) {
                RTLogger.println(" Source policy directory not found: " + sourceDir.getCanonicalPath());
                return false;
            }
            if (!targetDir.exists()) {
                RTLogger.println(" Target policy directory not found: " + targetDir.getCanonicalPath());
                return false;
            }
        }
        catch (IOException e1) {
            RTLogger.println(" Target or Source policy directory not found: ");
            return false;
        }
        boolean isOK = true;
        this.readDir(sourceDir, this.nameToPolicySource, this.policyTreeSource, this.assignmentTreeSource, this.policyNameToFileSource, this.policyNameToCRCSource);
        this.readDir(targetDir, this.nameToPolicyTarget, this.policyTreeTarget, this.assignmentTreeTarget, this.policyNameToFileTarget, this.policyNameToCRCTarget);
        RTLogger.println("=========  new only ===========");
        this.printNewPolicies();
        RTLogger.println("=========  custom only ===========");
        this.addCustomPolicies();
        RTLogger.println("=========  conflicts only ===========");
        this.printConflictPolicies();
        this.listAssignments();
        RTLogger.println("### Analysis phase finished... ");
        RTLogger.println("");
        askUserYNC au = new askUserYNC();
        try {
            String[] arrI = new String[]{"Import changes into " + this.targetDirectory.getCanonicalPath()};
            Integer res = (Integer)au.run(arrI, variables, line, lines);
            if (res == 0) {
                this.save();
            } else {
                if (res == 1) {
                    return true;
                }
                System.exit(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isOK;
    }

    public void printConflictPolicies() {
        ArrayList<String> names = new ArrayList<String>(this.nameToPolicySource.keySet());
        Collections.sort(names);
        for (String name : names) {
            if (this.policyNameToNewNonConflictingPolicy.containsKey(name) || this.policyNameToCustomNonConflictingPolicy.containsKey(name)) continue;
            Long tcrc = this.policyNameToCRCTarget.get(name);
            Long scrc = this.policyNameToCRCSource.get(name);
            AbstractPolicy apSource = this.nameToPolicySource.get(name);
            AbstractPolicy apTarget = this.nameToPolicyTarget.get(name);
            String nVersion = apSource.getVersion();
            VersionComparator vc = new VersionComparator();
            int res = vc.compare(apTarget.getVersion(), apSource.getVersion());
            if (res <= 0) {
                if (res == 0) {
                    if (tcrc.longValue() == scrc.longValue()) {
                        RTLogger.println("(Skip) policies: " + name + " are identical on both sides");
                        continue;
                    }
                } else if (tcrc.longValue() == scrc.longValue()) {
                    RTLogger.println("(Skip) policies: " + name + " are identical on both sides. But have different versions:  (v" + apSource.getVersion() + " -> v" + apTarget.getVersion() + ")");
                    continue;
                }
                nVersion = PolicyFactory.getNextVersion(apTarget.getVersion());
            }
            RTLogger.println("(Import) Conflicting policy: " + name + " (v" + apSource.getVersion() + " -> v" + apTarget.getVersion() + ") will be imported as v" + nVersion);
            apSource.setVersion(nVersion);
            this.policyNameToConflictingPolicy.put(name, apSource);
        }
    }

    public void printNewPolicies() {
        ArrayList<String> names = new ArrayList<String>(this.nameToPolicySource.keySet());
        Collections.sort(names);
        for (String name : names) {
            if (this.nameToPolicyTarget.containsKey(name)) continue;
            this.policyNameToNewNonConflictingPolicy.put(name, this.nameToPolicySource.get(name));
            RTLogger.println("(Import) new non-conflicting policy: " + name);
        }
    }

    public void addCustomPolicies() {
        ArrayList<String> names = new ArrayList<String>(this.nameToPolicyTarget.keySet());
        Collections.sort(names);
        for (String name : names) {
            if (this.nameToPolicySource.containsKey(name)) continue;
            AbstractPolicy o = this.nameToPolicyTarget.get(name);
            String type = null;
            if (o instanceof MsgPolicy) {
                type = "msg";
            } else if (o instanceof Policy) {
                type = "mon";
            }
            if (type == null) continue;
            GroupTreeObjectLast gtol = this.policyTreeTarget.findElement(name, type);
            String parentPath = gtol.getParent().getPath();
            GroupTreeObject par = null;
            par = this.policyTreeSource.searchPath(parentPath, "");
            if (par == null) {
                GroupTreeObject.createPath(parentPath, this.policyTreeSource);
                par = this.policyTreeSource.searchPath(parentPath, "");
            }
            par.addElement(gtol);
            this.policyNameToCustomNonConflictingPolicy.put(name, o);
            RTLogger.println("(Keep) non-conflicting policy: " + name);
        }
    }

    private void readDir(File sourceDir, Map<String, AbstractPolicy> map2, GroupTreeObject policyTree, GroupTreeObject asnTree, Map<String, File> files, Map<String, Long> crc) {
        FileFilter ffmon = new FileFilter(".xml");
        File[] list2 = sourceDir.listFiles(ffmon);
        File policyTreeFile = new File(sourceDir, POLICY_GROUPS_XML);
        GroupTreeObject root_Policies = null;
        if (policyTreeFile.exists()) {
            XMLTree xml = new XMLTree();
            try {
                policyTree.addElements(xml.parseXML(new FileInputStream(policyTreeFile)).getElements());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            root_Policies = policyTree.searchPath("/root/Policies", "");
            if (root_Policies == null) {
                root_Policies = GroupTreeObject.createPath("/root/Policies", policyTree);
            }
        } else {
            root_Policies = GroupTreeObject.createPath("/root/Policies", policyTree);
        }
        for (int i = 0; i < list2.length; ++i) {
            String filename = list2[i].getName();
            try {
                GroupTreeObjectLast gtol;
                if (filename.endsWith(".mon.xml")) {
                    Policy p = pf.initPolicy(list2[i]);
                    gtol = policyTree.findElement(p.getName(), "mon");
                    if (gtol == null) {
                        root_Policies.addElement(new GroupTreeObjectLast(new TreeObject(p.getName(), "mon", p), null, null));
                    }
                    map2.put(p.getName(), p);
                    files.put(p.getName(), list2[i]);
                    crc.put(p.getName(), this.doChecksum(list2[i]));
                    continue;
                }
                if (filename.endsWith(".msg.xml")) {
                    MsgPolicy mp = pf.initMsgPolicy(list2[i]);
                    gtol = policyTree.findElement(mp.getName(), "msg");
                    if (gtol == null) {
                        root_Policies.addElement(new GroupTreeObjectLast(new TreeObject(mp.getName(), "msg", mp), null, null));
                    }
                    map2.put(mp.getName(), mp);
                    files.put(mp.getName(), list2[i]);
                    crc.put(mp.getName(), this.doChecksum(list2[i]));
                    continue;
                }
                if (filename.equalsIgnoreCase(POLICY_GROUPS_XML) || !filename.equalsIgnoreCase(ASSIGNMENT_GROUPS_XML)) continue;
                XMLTree xml = new XMLTree();
                try {
                    asnTree.addElements(xml.parseXML(new FileInputStream(list2[i])).getElements());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (PolicyParsingException e) {
                try {
                    RTLogger.println("Policy invalid: " + list2[i].getCanonicalPath());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void save() {
        if (!this.targetDirectory.exists()) {
            this.targetDirectory.mkdirs();
        }
        boolean forceWrite = true;
        ArrayList<String> names = new ArrayList<String>(this.policyNameToCustomNonConflictingPolicy.keySet());
        Map<String, AbstractPolicy> map2 = this.policyNameToCustomNonConflictingPolicy;
        this.saveMap(forceWrite, names, map2, this.targetDirectory);
        forceWrite = true;
        names = new ArrayList<String>(this.policyNameToNewNonConflictingPolicy.keySet());
        map2 = this.policyNameToNewNonConflictingPolicy;
        this.saveMap(forceWrite, names, map2, this.targetDirectory);
        names = new ArrayList<String>(this.policyNameToConflictingPolicy.keySet());
        map2 = this.policyNameToConflictingPolicy;
        this.saveMap(forceWrite, names, map2, this.targetDirectory);
        XMLTree xt = new XMLTree();
        File pgf = new File(this.targetDirectory, POLICY_GROUPS_XML);
        Document doc = xt.getXML(this.policyTreeSource);
        try {
            XMLFactory.writeXml(doc, pgf);
            RTLogger.println("policyGroups.xml saved.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Run.error("Error saving policyGroups.xml");
        }
        File asn = new File(this.targetDirectory, ASSIGNMENT_GROUPS_XML);
        doc = xt.getXML(this.assignmentTreeTarget);
        try {
            XMLFactory.writeXml(doc, asn);
            RTLogger.println("assignmentGroups.xml saved.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Run.error("Error saving assignmentGroups.xml");
        }
    }

    public void listAssignments() {
        if (this.assignmentTreeTarget != null && this.assignmentTreeSource != null) {
            this.updateLinksAsn();
            this.updateIncomingAsn();
        } else if (this.assignmentTreeTarget == null && this.assignmentTreeSource != null) {
            RTLogger.println("Assignments has no conflicts");
        } else if (this.assignmentTreeTarget != null && this.assignmentTreeSource == null) {
            this.updateLinksAsn();
        } else if (this.assignmentTreeTarget == null && this.assignmentTreeSource == null) {
            RTLogger.println("Assignments not found");
        }
    }

    private void updateIncomingAsn() {
        List<GroupTreeObject> list2 = this.assignmentTreeSource.getAllElements();
        GroupTreeObject asnAA = this.assignmentTreeTarget.getFirstChild("Assignments");
        for (int i = 0; i < list2.size(); ++i) {
            GroupTreeObject gto = list2.get(i);
            if (!gto.getTreeObject().getType().equals("pga")) continue;
            GroupTreeObject old = this.assignmentTreeTarget.findFirstGroup(gto.getName(), "pga");
            if (old != null) {
                GroupTreeObject parent = old.getParent();
                String newAsnName = this.getNewAssignmentName(old.getName(), this.assignmentTreeTarget);
                String msg = "\nConflicting incoming Assignment: " + gto.getName();
                RTLogger.print(1, msg);
                askUserYNC au = new askUserYNC();
                String[] arrI = new String[]{msg + "\nReplace(Y) or import with unique name(N)", "Y"};
                Integer res = (Integer)au.run(arrI, null, 0, null);
                if (res == 0) {
                    RTLogger.println("Assignment: " + gto.getName() + " will be replaced");
                    parent.removeElement(old);
                    parent.addElement(gto);
                    continue;
                }
                if (res == 1) {
                    RTLogger.println("Conflicting incoming Assignment will be renamed: " + gto.getName() + " -> " + newAsnName);
                    gto.setName(newAsnName);
                    parent.addElement(gto);
                    continue;
                }
                System.exit(0);
                continue;
            }
            RTLogger.println("New incoming Assignment will be added: " + gto.getName());
            asnAA.addElement(gto);
        }
    }

    private String getNewAssignmentName(String asnName, GroupTreeObject tree) {
        int n = 1;
        Object finAsnName = asnName;
        while (tree.findFirstGroup((String)finAsnName, "pga") != null) {
            finAsnName = asnName + "(" + n + ")";
            ++n;
        }
        return finAsnName;
    }

    private void updateLinksAsn() {
        List<GroupTreeObject> list2 = this.assignmentTreeTarget.getAllElements();
        for (int i = 0; i < list2.size(); ++i) {
            String realPath;
            GroupTreeObjectLast ro;
            GroupTreeObject obj = list2.get(i);
            if (!(obj instanceof GroupTreeObjectLast)) continue;
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
            String name = gtol.getName();
            String type = gtol.getTreeObject().getType();
            if (name == null || type == null || !type.equals("mon") && !type.equals("msg") || (ro = this.policyTreeSource.findElement(name, type)) == null || (realPath = ro.getPath()).equals(gtol.getLinkedPath())) continue;
            RTLogger.println("Assignment link will be updated:");
            RTLogger.println("\t(old) " + gtol.getLinkedPath());
            RTLogger.println("\t(new) " + realPath);
            gtol.setLinkedPath(realPath);
        }
    }

    private void saveMap(boolean forceWrite, List<String> names, Map<String, AbstractPolicy> map2, File parentDir) {
        Collections.sort(names);
        for (String name : names) {
            AbstractPolicy o = map2.get(name);
            String type = null;
            String file_type = null;
            if (o instanceof MsgPolicy) {
                type = "msg";
                file_type = ".msg.xml";
            } else if (o instanceof Policy) {
                type = "mon";
                file_type = ".mon.xml";
            }
            if (type == null) continue;
            File f = new File(parentDir, name + file_type);
            if (!forceWrite && f.exists()) continue;
            AbstractPolicy abstractPolicy = this.nameToPolicyTarget.get(name);
            if (o instanceof MsgPolicy) {
                if (f.exists() && abstractPolicy != null) {
                    ver = abstractPolicy.getVersion();
                    nf = new File(parentDir, name + file_type + "." + ver);
                    try {
                        FileUtils.copyFile(f, nf);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                pf.storePolicy((MsgPolicy)o, f);
            } else if (o instanceof Policy) {
                if (f.exists() && abstractPolicy != null) {
                    ver = abstractPolicy.getVersion();
                    nf = new File(parentDir, name + file_type + "." + ver);
                    try {
                        FileUtils.copyFile(f, nf);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                pf.storePolicy((Policy)o, f);
            }
            RTLogger.println("Policy " + name + " imported.");
        }
    }

    private long doChecksum(File file) {
        long checksum = 0L;
        CRC32 cksum = new CRC32();
        try (FileReader fr = new FileReader(file);
             BufferedReader br = new BufferedReader(fr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains("POLICY_VERSION")) continue;
                line = line.trim().replace("\r\n", "\n");
                line = line.trim().replace("\n\r", "\n");
                cksum.update(line.getBytes());
            }
            checksum = cksum.getValue();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return checksum;
    }
}

