/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.jsi;

import com.blixx.boom.RTLogger;
import com.blixx.boom.StrUtils;
import com.blixx.jsi.ICommand;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class p261mv
implements ICommand {
    @Override
    public Object run(Object input, Map<String, Object> variables, int line, List<String> lines) {
        String[] arr = StrUtils.processQuoted(String.valueOf(input), ",");
        File targetDir = new File(StrUtils.removeQuotes(arr[0]));
        try {
            if (!targetDir.exists()) {
                RTLogger.println(" Target policy directory not found: " + targetDir.getCanonicalPath());
                return false;
            }
        }
        catch (IOException e) {
            RTLogger.println(" Target policy directory not found: ");
            return false;
        }
        PolicyFactory pf = new PolicyFactory();
        File[] policies = targetDir.listFiles(new MessagePoliciesFF());
        if (policies == null || policies.length == 0) {
            RTLogger.println("No Message policy found");
        } else {
            for (File mpol : policies) {
                String filename = mpol.getName();
                String nameBasedOnFile = filename.replace(".msg.xml", "");
                try {
                    MsgPolicy mp = pf.initMsgPolicy(mpol);
                    boolean changed = false;
                    if (!nameBasedOnFile.equals(mp.getName())) {
                        mp.setName(nameBasedOnFile);
                        changed = true;
                    }
                    for (MsgCondition msgCondition : mp.getConditions().getConditionList()) {
                        int space;
                        if (msgCondition.getVfilterAsInPolicy() == null || msgCondition.getVfilterAsInPolicy().indexOf(95) == -1 || msgCondition.getVfilterAsInPolicy().indexOf(9827) != -1 || (space = msgCondition.getVfilterAsInPolicy().indexOf(32)) == -1) continue;
                        String filter = msgCondition.getVfilterAsInPolicy().substring(0, space);
                        String pattern = msgCondition.getVfilterAsInPolicy().substring(space + 1);
                        String[] farr = filter.split("_");
                        String[] parr = pattern.split("_");
                        if (farr.length > 1 && farr.length == parr.length) {
                            msgCondition.setVfilterAsInPolicy(msgCondition.getVfilterAsInPolicy().replace('_', '\u2663'));
                            changed = true;
                            continue;
                        }
                        RTLogger.println("  WARNING: Policy " + nameBasedOnFile + " Condition: " + msgCondition.getDescription() + " Variables Flter cannot be converted!");
                    }
                    if (!changed) continue;
                    String oldVersion = mp.getVersion();
                    File nf = new File(mpol.getParentFile(), filename + "." + oldVersion);
                    try {
                        FileUtils.copyFile(mpol, nf);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    mp.setVersion(PolicyFactory.getNextVersion(oldVersion));
                    pf.storePolicy(mp, mpol);
                    RTLogger.println("policy: " + filename + " fixed");
                    RTLogger.println("");
                }
                catch (Throwable e) {
                    RTLogger.println("Error processing file: " + filename);
                }
            }
            RTLogger.println(policies.length + " policies checked.");
        }
        return true;
    }

    public static class MessagePoliciesFF
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            boolean isMsgPol = name.endsWith(".msg.xml");
            return isMsgPol;
        }
    }
}

