/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.db.mpi;

import com.blixx.ext.IAction;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.test.NullMonSubmitter;
import com.blixx.ext.test.NullMsgSubmitter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleConnector
implements IMonitorExt,
IAction {
    public static boolean DRIVER_REGISTERED = false;
    public static String TYPE = "TYPE";
    public static String OBJECT = "OBJECT";
    public static String MONITOR = "MONITOR";
    public static String VALUE = "VALUE";
    public String m_monitor = null;
    public String m_JDBC = null;
    public List<String> m_SQL = new ArrayList<String>();
    public String m_Driver = "oracle.jdbc.OracleDriver";
    public long m_interval = 0L;
    protected IMonitorSubmitter m_submitter = null;
    protected IMessage m_msgSubmitter = null;
    protected Connection m_connection = null;
    protected boolean m_isOracleOnline = true;
    protected boolean m_isStatus = false;
    protected static String m_statusMonitorName = null;
    protected Map<String, Double> m_counts = new HashMap<String, Double>();

    public static OracleConnector getInstance(String monitor, String[] parameters) {
        OracleConnector mon = new OracleConnector();
        mon.m_monitor = monitor;
        mon.m_JDBC = parameters[0];
        mon.m_SQL = mon.parseSQLs(parameters, 1);
        OracleConnector.initDriver(mon);
        return mon;
    }

    private static void initDriver(OracleConnector mon) {
        if (!DRIVER_REGISTERED) {
            try {
                Class.forName(mon.m_Driver).newInstance();
                DRIVER_REGISTERED = true;
            }
            catch (Throwable e) {
                RuntimeException rte = new RuntimeException(e.getMessage());
                rte.setStackTrace(e.getStackTrace());
                throw rte;
            }
        }
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String run(String[] parameters, int timeout) {
        String resultSTR = "";
        OracleConnector.initDriver(this);
        this.m_JDBC = parameters[0];
        String sql = parameters[1];
        if (sql.startsWith("V$")) {
            String[] arr = sql.split("\\Q.\\E");
            String view = arr[0];
            String param = arr[1];
            if (param.startsWith("\"")) {
                param = param.substring(1);
            }
            if (param.equals("\"")) {
                param = param.substring(0, param.length() - 1);
            }
            sql = "SELECT VALUE FROM " + view + " WHERE NAME = '" + param + "'";
            resultSTR = this.queryValue(sql);
        } else if (sql.startsWith("-f")) {
            String[] sqlArr = this.loadFromFile(sql.substring(2).trim());
            int i = 0;
            while (i < sqlArr.length) {
                resultSTR = String.valueOf(resultSTR) + this.query(sqlArr[i]);
                resultSTR = String.valueOf(resultSTR) + "\n\n";
                ++i;
            }
        } else {
            resultSTR = this.query(sql);
        }
        return resultSTR;
    }

    private String queryValue(String sql) {
        String res = null;
        try {
            try {
                Properties props = new Properties();
                this.m_connection = DriverManager.getConnection(this.m_JDBC, props);
                Statement stMain = this.m_connection.createStatement(1003, 1007);
                try {
                    ResultSet rs = stMain.executeQuery(sql);
                    if (rs.next()) {
                        res = "" + rs.getObject("VALUE");
                    }
                    rs.close();
                }
                catch (Throwable e) {
                    res = e.getMessage();
                }
            }
            catch (Throwable e) {
                RuntimeException rte = new RuntimeException(e.getMessage());
                rte.setStackTrace(e.getStackTrace());
                throw rte;
            }
        }
        finally {
            try {
                this.m_connection.close();
            }
            catch (Throwable throwable) {}
        }
        return res;
    }

    private String query(String sql) {
        StringBuffer sb = new StringBuffer();
        try {
            try {
                Properties props = new Properties();
                this.m_connection = DriverManager.getConnection(this.m_JDBC, props);
                Statement stMain = this.m_connection.createStatement(1003, 1007);
                try {
                    ResultSet rs = stMain.executeQuery(sql);
                    ResultSetMetaData rsMD = rs.getMetaData();
                    LinkedList result = new LinkedList();
                    this.processResultSet(result, rs, rsMD);
                    int i = 1;
                    while (i <= rsMD.getColumnCount()) {
                        sb.append(rsMD.getColumnName(i)).append("\t| ");
                        ++i;
                    }
                    sb.append("\n");
                    i = 0;
                    while (i < result.size()) {
                        Hashtable t = (Hashtable)result.get(i);
                        int j = 1;
                        while (j <= rsMD.getColumnCount()) {
                            sb.append(t.get(rsMD.getColumnName(j))).append("\t| ");
                            ++j;
                        }
                        sb.append("\n");
                        ++i;
                    }
                    rs.close();
                }
                catch (Throwable e) {
                    sb.append(e.getMessage());
                }
            }
            catch (Throwable e) {
                RuntimeException rte = new RuntimeException(e.getMessage());
                rte.setStackTrace(e.getStackTrace());
                throw rte;
            }
        }
        finally {
            try {
                this.m_connection.close();
            }
            catch (Throwable throwable) {}
        }
        return sb.toString();
    }

    public String runMonitor() {
        DriverManager.setLoginTimeout(30);
        try {
            try {
                Statement stMain;
                Properties props = new Properties();
                try {
                    this.m_connection = DriverManager.getConnection(this.m_JDBC, props);
                    stMain = this.m_connection.createStatement(1003, 1007);
                }
                catch (Throwable e1) {
                    if (this.m_isStatus) {
                        this.m_submitter.submitMonitorValue(this.m_monitor, 0.0, "", null);
                    }
                    throw e1;
                }
                try {
                    stMain.setQueryTimeout(300);
                    int i = 0;
                    while (i < this.m_SQL.size()) {
                        String sql = this.m_SQL.get(i);
                        try {
                            ResultSet rs = stMain.executeQuery(sql);
                            ResultSetMetaData rsMD = rs.getMetaData();
                            LinkedList<Hashtable> result = new LinkedList<Hashtable>();
                            this.processResultSet(result, rs, rsMD);
                            this.submitValues(result);
                            rs.close();
                        }
                        catch (Throwable e) {
                            if (this.m_isStatus) {
                                this.m_submitter.submitMonitorValue(this.m_monitor, 0.0, "", null);
                            }
                            this.m_msgSubmitter.sendMessage(null, "Monitor", "BoomAgent", this.m_monitor, "SQL Error: \n" + e.getMessage() + "\n" + this.m_SQL.get(i), "warning", null);
                        }
                        ++i;
                    }
                }
                finally {
                    try {
                        stMain.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                if (m_statusMonitorName != null) {
                    this.m_submitter.submitMonitorValue(m_statusMonitorName, 0.0, "", null);
                    if (!this.m_monitor.equals(m_statusMonitorName)) {
                        this.m_submitter.submitMonitorValue(this.m_monitor, -1.0, "", null);
                    }
                } else {
                    RuntimeException rte = new RuntimeException(e.getMessage());
                    rte.setStackTrace(e.getStackTrace());
                    throw rte;
                }
                try {
                    this.m_connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                this.m_connection.close();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    protected void submitValues(List<Hashtable> records) {
        if (records != null) {
            int i = 0;
            while (i < records.size()) {
                Double prev;
                String mon_obj;
                String type;
                Hashtable row = records.get(i);
                String monitor = this.m_monitor;
                if (row.get(MONITOR) != null) {
                    monitor = (String)row.get(MONITOR);
                }
                String object = null;
                if (row.get(OBJECT) != null) {
                    object = (String)row.get(OBJECT);
                }
                Double value = -1.0;
                Object obj = row.get(VALUE);
                if (obj instanceof Number) {
                    if (obj != null) {
                        value = ((Number)obj).doubleValue();
                    }
                } else {
                    try {
                        String obstr = "" + obj;
                        value = Double.parseDouble(obstr.replace(',', '.'));
                    }
                    catch (Throwable obstr) {
                        // empty catch block
                    }
                }
                if ((type = (String)row.get(TYPE)) != null && type.equalsIgnoreCase("COUNT")) {
                    mon_obj = String.valueOf(monitor) + "@@@" + object;
                    prev = this.m_counts.get(mon_obj);
                    this.m_counts.put(mon_obj, value);
                    value = prev != null ? Double.valueOf(value - prev) : Double.valueOf(0.0);
                } else if (type != null && type.equalsIgnoreCase("COUNT/INTERVAL_SEC")) {
                    mon_obj = String.valueOf(monitor) + "@@@" + object;
                    prev = this.m_counts.get(mon_obj);
                    this.m_counts.put(mon_obj, value);
                    value = prev != null ? Double.valueOf(value - prev) : Double.valueOf(0.0);
                    value = value / (double)(this.m_interval / 1000L);
                }
                row.remove(MONITOR);
                row.remove(TYPE);
                row.remove(VALUE);
                row.remove(OBJECT);
                HashMap map = new HashMap(row);
                this.m_submitter.submitMonitorValue(monitor, value.doubleValue(), object, map);
                ++i;
            }
        }
    }

    protected void processResultSet(LinkedList result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        int cSize = rsMD.getColumnCount();
        while (rs.next()) {
            Hashtable<String, Object> row = new Hashtable<String, Object>();
            int i = 1;
            while (i <= cSize) {
                Object valueObj = null;
                String name = rsMD.getColumnName(i);
                name = name.replace('\'', ' ');
                name = name.replace('\"', ' ');
                if ((name = name.trim()).equalsIgnoreCase(MONITOR)) {
                    name = MONITOR;
                }
                if (name.equalsIgnoreCase(OBJECT)) {
                    name = OBJECT;
                }
                if (name.equalsIgnoreCase(TYPE)) {
                    name = TYPE;
                }
                if (name.equalsIgnoreCase(VALUE)) {
                    name = VALUE;
                }
                if (rsMD.getColumnType(i) != 2004 && rsMD.getColumnType(i) != -4 && rsMD.getColumnType(i) != 2005) {
                    valueObj = rsMD.getColumnType(i) == 91 ? Long.valueOf(rs.getDate(i).getTime()) : rs.getObject(i);
                }
                row.put(name, valueObj);
                ++i;
            }
            result.add(row);
        }
    }

    protected List parseSQLs(String[] params, int startLine) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (params[startLine] != null && params[startLine].startsWith("-f")) {
                params = this.loadFromFile(params[startLine].substring(2).trim());
                startLine = 0;
            }
            StringBuffer sb = new StringBuffer();
            boolean isCommentsStarted = false;
            int i = startLine;
            while (i < params.length) {
                block14: {
                    int tcharpos;
                    int commentStart;
                    String lineF;
                    block17: {
                        int commentEnd;
                        block16: {
                            block15: {
                                lineF = params[i];
                                commentStart = lineF.indexOf("/*");
                                commentEnd = lineF.indexOf("*/");
                                if (lineF.trim().startsWith("#") || lineF.trim().startsWith("-") || lineF.trim().startsWith("REM ")) break block14;
                                if (!isCommentsStarted) break block15;
                                if (commentEnd != -1) {
                                    if (commentEnd < lineF.length() - 2) {
                                        lineF = lineF.substring(commentEnd + 2);
                                        sb.append(lineF).append("\n");
                                    }
                                    isCommentsStarted = false;
                                }
                                break block14;
                            }
                            if (commentStart != -1) break block16;
                            sb.append(lineF).append("\n");
                            break block14;
                        }
                        if (commentStart < 0) break block17;
                        if (commentEnd > commentStart && lineF.endsWith("*/")) break block14;
                        lineF = lineF.substring(0, commentStart);
                        sb.append(lineF).append("\n");
                    }
                    if ((tcharpos = commentStart + 2) < lineF.length() && lineF.charAt(tcharpos) == '!') {
                        sb.append(lineF).append("\n");
                    } else {
                        isCommentsStarted = true;
                    }
                }
                ++i;
            }
            String[] linearr = OracleConnector.processQuoted(sb.toString(), ";");
            int i2 = 0;
            while (i2 < linearr.length) {
                list.add(linearr[i2]);
                if (linearr[i2].equalsIgnoreCase("select '1' as VALUE from DUAL")) {
                    this.m_isStatus = true;
                    m_statusMonitorName = this.m_monitor;
                }
                ++i2;
            }
        }
        catch (Throwable e) {
            RuntimeException rte = new RuntimeException("Error parsing SQL queries");
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
        return list;
    }

    public static String[] processQuoted(String cmd, String separator) {
        cmd = cmd.replace("\r", "");
        String[] inCMD = null;
        if (cmd.indexOf(34) != -1) {
            inCMD = cmd.split("\\s*" + separator + "{1}\\s*");
            ArrayList<String> params = new ArrayList<String>();
            boolean quoteStarted = false;
            String quoted = null;
            int i = 0;
            while (i < inCMD.length) {
                String el;
                int firstQ = inCMD[i].indexOf("\"");
                int lastQ = inCMD[i].lastIndexOf("\"");
                if (!quoteStarted && firstQ != -1 && firstQ == lastQ) {
                    quoteStarted = true;
                    quoted = String.valueOf(inCMD[i]) + separator;
                } else if (quoteStarted && inCMD[i].endsWith("\\\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i] + separator;
                } else if (quoteStarted && !inCMD[i].endsWith("\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i] + separator;
                } else if (quoteStarted && inCMD[i].endsWith("\"")) {
                    quoted = String.valueOf(quoted) + inCMD[i];
                    quoteStarted = false;
                    el = quoted.replace("\\\"", "\"");
                    params.add(el);
                    quoted = null;
                } else {
                    el = inCMD[i].replace("\\\"", "\"");
                    if (!el.equals("")) {
                        params.add(el);
                    }
                }
                ++i;
            }
            if (quoted != null && !quoted.equals("")) {
                params.add(quoted.replace("\\\"", "\""));
            }
            inCMD = params.toArray(new String[0]);
        } else {
            inCMD = cmd.split("\\s*" + separator + "{1}\\s*");
        }
        return inCMD;
    }

    protected String[] loadFromFile(String filename) {
        String[] lines = null;
        BufferedReader br = null;
        InputStreamReader fr = null;
        try {
            try {
                ArrayList<String> strlist = new ArrayList<String>();
                fr = new FileReader(new File(filename));
                br = new BufferedReader(fr);
                String lineF = null;
                while ((lineF = br.readLine()) != null) {
                    strlist.add(lineF);
                }
                lines = strlist.toArray(new String[0]);
            }
            catch (FileNotFoundException e) {
                RuntimeException rte = new RuntimeException("FileNotFound: " + filename);
                rte.setStackTrace(e.getStackTrace());
                throw rte;
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException("Error reading file: " + filename);
                rte.setStackTrace(e.getStackTrace());
                throw rte;
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable throwable) {}
            try {
                fr.close();
            }
            catch (Throwable throwable) {}
        }
        return lines;
    }

    public static void main(String[] args) {
        OracleConnector.run1();
    }

    private static void run1() {
        String[] params = new String[]{"jdbc:oracle:thin:boom/boom@localhost:1521/ORCL", "-f orampi.sql"};
        OracleConnector mon = OracleConnector.getInstance("TEST", params);
        mon.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        mon.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        mon.setInterval(1000L);
        mon.runMonitor();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println();
        mon.runMonitor();
    }

    private static void run2() {
        String[] params = new String[]{"jdbc:oracle:thin:boom/boom@localhost:1521/ORCL", "-f tblspaces.sql"};
        OracleConnector mon = OracleConnector.getInstance("TESTTBLSPC", params);
        mon.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        mon.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        mon.setInterval(1000L);
        mon.runMonitor();
    }

    private static void run3() {
        String[] params = new String[]{"jdbc:oracle:thin:boom/boom@localhost:1521/ORCL", "-f waits.sql"};
        OracleConnector mon = OracleConnector.getInstance("TESTWAITS", params);
        mon.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        mon.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
        mon.setInterval(1000L);
        mon.runMonitor();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println();
        mon.runMonitor();
    }
}

