/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.mysqlmpi;

import com.blixx.ext.IAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class MySQLMPIAction
implements IAction {
    public String run(String[] parameters, int timeout) {
        if (parameters == null || parameters.length < 2) {
            return "MySQLMPIAction [Error] invalid parameters. Expected:\n<MySQL MPI directory>\n<Action>\n[<params>]";
        }
        if (parameters[1].equalsIgnoreCase("-licreq")) {
            StringBuffer sb = new StringBuffer();
            sb.append("SPI for MySQL DB v2.00").append("\n");
            sb.append("hostname=").append(this.getHostname());
            return sb.toString();
        }
        StringBuffer action = new StringBuffer();
        int i = 1;
        while (i < parameters.length) {
            if (parameters[i].indexOf(32) != -1) {
                action.append('\"').append(parameters[i]).append('\"');
            } else {
                action.append(parameters[i]);
            }
            if (i < parameters.length - 1) {
                action.append(' ');
            }
            ++i;
        }
        action.append("\n");
        String mpiDir = parameters[0];
        if (!mpiDir.endsWith("/") && !mpiDir.endsWith("\\")) {
            mpiDir = String.valueOf(mpiDir) + File.separator;
        }
        File p = new File(String.valueOf(mpiDir) + "tsport.cfg");
        int portN = 4611;
        if (p.exists()) {
            try {
                portN = this.getPort(p);
            }
            catch (Throwable e) {
                return "MySQLMPIAction [Error] Cant't read port from the file tsport.cfg";
            }
            try {
                StringBuffer out = new StringBuffer();
                Socket socket = new Socket("127.0.0.1", portN);
                socket.setSoTimeout(timeout * 1000);
                socket.setSoLinger(true, 1);
                InputStream is = socket.getInputStream();
                OutputStream os = socket.getOutputStream();
                int ch = is.read();
                if (ch == 35) {
                    os.write(action.toString().getBytes());
                    int r = -1;
                    byte[] arr = new byte[1024];
                    while ((r = is.read(arr)) != -1) {
                        String s = new String(arr, 0, r);
                        out.append(s);
                        if (out.toString().endsWith("#") && is.available() == 0) break;
                    }
                    os.write("exit\n".getBytes());
                    is.read(arr);
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return out.toString();
                }
                return "MySQLMPIAction [Error] Cant't connect to the Engine";
            }
            catch (UnknownHostException e) {
                return "MySQLMPIAction [Error] Cant't connect to the Engine";
            }
            catch (IOException e) {
                return "MySQLMPIAction [Error] Cant't connect to the Engine";
            }
        }
        return "MySQLMPIAction [Error] Engine is not running or wrong directory specified";
    }

    private int getPort(File p) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(p);
        byte[] arr = new byte[fis.available()];
        fis.read(arr);
        fis.close();
        String port = new String(arr);
        int portN = Integer.parseInt(port);
        return portN;
    }

    public String getHostname() {
        String m_hostname = "ERROR GETTING HOSTNAME";
        try {
            m_hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            try {
                m_hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return m_hostname;
    }
}

