/*
 * Decompiled with CFR 0.152.
 */
package com.boom.dbmpi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;

public class CliArgsParser {
    private String[] args = null;
    private HashMap<String, Integer> switchIndexes = new HashMap();
    private TreeSet<Integer> takenIndexes = new TreeSet();

    public CliArgsParser(String[] args) {
        this.parse(args);
    }

    public void parse(String[] arguments) {
        this.args = arguments;
        this.switchIndexes.clear();
        this.takenIndexes.clear();
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (!arg.startsWith("-")) continue;
            if (arg.contains(" ")) {
                int indexOfSpace = arg.indexOf(" ");
                String key = arg.substring(0, indexOfSpace);
                this.switchIndexes.put(key, i);
                this.takenIndexes.add(i);
                continue;
            }
            this.switchIndexes.put(arg, i);
            this.takenIndexes.add(i);
        }
    }

    public String[] args() {
        return this.args;
    }

    public String arg(int index) {
        return this.args[index];
    }

    public boolean switchPresent(String switchName) {
        return this.switchIndexes.containsKey(switchName);
    }

    public String switchValue(String switchName) {
        return this.switchValue(switchName, null);
    }

    public String switchValue(String switchName, String defaultValue) {
        if (!this.switchIndexes.containsKey(switchName)) {
            return defaultValue;
        }
        int switchIndex = this.switchIndexes.get(switchName);
        StringBuilder sb = new StringBuilder(this.args[switchIndex++]);
        while (switchIndex < this.args.length && !this.args[switchIndex].startsWith("-")) {
            sb.append(" ").append(this.args[switchIndex++]);
        }
        return sb.toString().replace(switchName, "").trim();
    }

    public Long switchLongValue(String switchName) {
        return this.switchLongValue(switchName, null);
    }

    public Long switchLongValue(String switchName, Long defaultValue) {
        String switchValue = this.switchValue(switchName, null);
        if (switchValue == null) {
            return defaultValue;
        }
        return Long.parseLong(switchValue);
    }

    public Double switchDoubleValue(String switchName) {
        return this.switchDoubleValue(switchName, null);
    }

    public Double switchDoubleValue(String switchName, Double defaultValue) {
        String switchValue = this.switchValue(switchName, null);
        if (switchValue == null) {
            return defaultValue;
        }
        return Double.parseDouble(switchValue);
    }

    public String[] switchValues(String switchName) {
        int nextArgIndex;
        if (!this.switchIndexes.containsKey(switchName)) {
            return new String[0];
        }
        int switchIndex = this.switchIndexes.get(switchName);
        for (nextArgIndex = switchIndex + 1; nextArgIndex < this.args.length && !this.args[nextArgIndex].startsWith("-"); ++nextArgIndex) {
            this.takenIndexes.add(nextArgIndex);
        }
        String[] values = new String[nextArgIndex - switchIndex - 1];
        for (int j = 0; j < values.length; ++j) {
            values[j] = this.args[switchIndex + j + 1];
        }
        return this.flattenParameters(values);
    }

    private String[] flattenParameters(String[] values) {
        ArrayList<String> flattenVals = new ArrayList<String>();
        boolean continiousParam = false;
        StringBuilder tempVal = new StringBuilder();
        for (String v : values) {
            if (v.contains("=[[")) {
                if (v.endsWith("]]")) {
                    flattenVals.add(v.replace("[[", "").replace("]]", ""));
                    continue;
                }
                tempVal.append(v.replace("[[", ""));
                continiousParam = true;
                continue;
            }
            if (v.endsWith("]]")) {
                tempVal.append(" ").append(v.replace("]]", ""));
                flattenVals.add(tempVal.toString());
                tempVal = new StringBuilder();
                continiousParam = false;
                continue;
            }
            if (continiousParam) {
                tempVal.append(" ").append(v);
                continue;
            }
            flattenVals.add(v);
        }
        String[] response = new String[flattenVals.size()];
        return flattenVals.toArray(response);
    }

    public <T> T switchPojo(Class<T> pojoClass) {
        try {
            Field[] fields;
            T pojo = pojoClass.newInstance();
            for (Field field : fields = pojoClass.getFields()) {
                String[] values;
                Class<?> fieldType = field.getType();
                String fieldName = "-" + field.getName().replace('_', '-');
                if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                    String val = this.switchValue(fieldName, "" + field.getBoolean(pojo));
                    field.set(pojo, Boolean.parseBoolean(val));
                    continue;
                }
                if (fieldType.equals(String.class)) {
                    if (this.switchValue(fieldName) == null) continue;
                    field.set(pojo, this.switchValue(fieldName));
                    continue;
                }
                if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                    if (this.switchLongValue(fieldName) == null) continue;
                    field.set(pojo, this.switchLongValue(fieldName));
                    continue;
                }
                if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                    if (this.switchLongValue(fieldName) == null) continue;
                    field.set(pojo, this.switchLongValue(fieldName).intValue());
                    continue;
                }
                if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                    if (this.switchLongValue(fieldName) == null) continue;
                    field.set(pojo, this.switchLongValue(fieldName).shortValue());
                    continue;
                }
                if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                    if (this.switchLongValue(fieldName) == null) continue;
                    field.set(pojo, this.switchLongValue(fieldName).byteValue());
                    continue;
                }
                if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                    if (this.switchDoubleValue(fieldName) == null) continue;
                    field.set(pojo, this.switchDoubleValue(fieldName));
                    continue;
                }
                if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                    if (this.switchDoubleValue(fieldName) == null) continue;
                    field.set(pojo, Float.valueOf(this.switchDoubleValue(fieldName).floatValue()));
                    continue;
                }
                if (!fieldType.equals(String[].class) || (values = this.switchValues(fieldName)).length == 0) continue;
                field.set(pojo, values);
            }
            return pojo;
        }
        catch (Exception e) {
            RuntimeException runtimeException = new RuntimeException("Error creating switch POJO " + e.getMessage());
            runtimeException.setStackTrace(e.getStackTrace());
            throw runtimeException;
        }
    }

    public String[] targets() {
        String[] targetArray = new String[this.args.length - this.takenIndexes.size()];
        int targetIndex = 0;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.takenIndexes.contains(i)) continue;
            targetArray[targetIndex++] = this.args[i];
        }
        return targetArray;
    }
}

