/*
 * Decompiled with CFR 0.152.
 */
package com.boom.dbmpi;

import com.blixx.ext.IMonitorSubmitter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DatabaseConnector {
    public static String TYPE = "TYPE";
    public static String OBJECT = "OBJECT";
    public static String MONITOR = "MONITOR";
    public static String VALUE = "VALUE";
    protected String connectionUrl = "";
    protected String driver = "";
    protected String userName = "";
    protected String password = "";
    protected Map<String, Double> counts = new HashMap<String, Double>();

    public DatabaseConnector(String connectionUrl, String driver, String userName, String password) {
        this.connectionUrl = connectionUrl;
        this.driver = driver;
        this.userName = userName;
        this.password = password;
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            RuntimeException rte = new RuntimeException("Driver failed to load is:" + driver + e.getMessage());
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
    }

    public String runMonitor(String monitorName, IMonitorSubmitter monSubmitter, long interval, String sql, String method, int timeoutSec) {
        this.executeSql(monitorName, monSubmitter, interval, sql, method, timeoutSec);
        return null;
    }

    protected void processResultSet(LinkedList<Hashtable<String, Object>> result, ResultSet rs, ResultSetMetaData rsMD) throws SQLException {
        int cSize = rsMD.getColumnCount();
        while (rs.next()) {
            Hashtable<String, Object> row = new Hashtable<String, Object>();
            for (int i = 1; i <= cSize; ++i) {
                Object valueObj = null;
                String name = rsMD.getColumnLabel(i);
                name = name.replace('\'', ' ');
                name = name.replace('\"', ' ');
                if ((name = name.trim()).equalsIgnoreCase(MONITOR)) {
                    name = MONITOR;
                }
                if (name.equalsIgnoreCase(OBJECT)) {
                    name = OBJECT;
                }
                if (name.equalsIgnoreCase(TYPE)) {
                    name = TYPE;
                }
                if (name.equalsIgnoreCase(VALUE)) {
                    name = VALUE;
                }
                if (rsMD.getColumnType(i) == 2004 || rsMD.getColumnType(i) == -4 || rsMD.getColumnType(i) == 2005) {
                    throw new RuntimeException("Unsupported column types: " + rsMD.getColumnTypeName(i) + " for column: " + name);
                }
                valueObj = rsMD.getColumnType(i) == 91 ? Long.valueOf(rs.getDate(i).getTime()) : rs.getObject(i);
                if (valueObj == null) {
                    valueObj = "";
                }
                row.put(name, valueObj);
            }
            result.add(row);
        }
    }

    protected void submitValues(String monitorName, List<Hashtable<String, Object>> records, IMonitorSubmitter monSubmitter, long interval) {
        if (records != null) {
            for (Hashtable<String, Object> row : records) {
                Double prev;
                String mon_obj;
                String monitor = monitorName;
                if (row.get(MONITOR) != null) {
                    monitor = (String)row.get(MONITOR);
                }
                String object = null;
                if (row.get(OBJECT) != null) {
                    object = (String)row.get(OBJECT);
                }
                double value = -1.0;
                Object obj = row.get(VALUE);
                if (obj instanceof Number) {
                    value = ((Number)obj).doubleValue();
                } else {
                    try {
                        String obstr = "" + obj;
                        value = Double.parseDouble(obstr.replace(',', '.'));
                    }
                    catch (Throwable obstr) {
                        // empty catch block
                    }
                }
                String type = (String)row.get(TYPE);
                if (type != null && type.equalsIgnoreCase("COUNT")) {
                    mon_obj = monitor + "@@@" + object;
                    prev = this.counts.get(mon_obj);
                    this.counts.put(mon_obj, value);
                    value = prev != null ? (value -= prev.doubleValue()) : 0.0;
                } else if (type != null && type.equalsIgnoreCase("COUNT/INTERVAL_SEC")) {
                    mon_obj = monitor + "@@@" + object;
                    prev = this.counts.get(mon_obj);
                    this.counts.put(mon_obj, value);
                    value = prev != null ? (value -= prev.doubleValue()) : 0.0;
                    value /= (double)interval / 1000.0;
                }
                row.remove(MONITOR);
                row.remove(TYPE);
                row.remove(VALUE);
                row.remove(OBJECT);
                HashMap<String, Object> map = new HashMap<String, Object>(row);
                monSubmitter.submitMonitorValue(monitor, value, object, map);
            }
        }
    }

    public String run(List<String> sqlQueries, String[] sqlArgs, String method, int timeoutSec) throws Exception {
        StringBuilder resultSTR = new StringBuilder();
        HashMap<String, String> dynParams = new HashMap<String, String>();
        if (sqlArgs != null) {
            for (String arg : sqlArgs) {
                String[] keyVal = arg.split("=");
                if (keyVal.length != 2) continue;
                dynParams.put("{" + keyVal[0] + "}", keyVal[1]);
            }
        }
        for (String sql : sqlQueries) {
            if (sql.startsWith("V$")) {
                String[] arr = sql.split("\\Q.\\E");
                String view = arr[0];
                String param = arr[1];
                if (param.startsWith("\"")) {
                    param = param.substring(1);
                }
                if (param.equals("\"")) {
                    param = param.substring(0, param.length() - 1);
                }
                sql = "SELECT VALUE FROM " + view + " WHERE NAME = '" + param + "'";
                resultSTR.append(this.executeSql("", null, 0L, sql, "SELECT", timeoutSec));
                continue;
            }
            resultSTR.append(this.executeSql("", null, 0L, this.replaceArgValues(sql, dynParams), method, timeoutSec));
            resultSTR.append("\n\n");
        }
        return resultSTR.toString();
    }

    private String executeSql(String monitorName, IMonitorSubmitter monSubmitter, long interval, String sql, String method, int timeoutSec) {
        String response = "";
        response = "DELETE".equalsIgnoreCase(method) || "UPDATE".equalsIgnoreCase(method) || "INSERT".equalsIgnoreCase(method) ? response + this.update(monitorName, monSubmitter, interval, sql, timeoutSec) : response + this.query(monitorName, monSubmitter, interval, sql, timeoutSec);
        return response;
    }

    private String query(String monitorName, IMonitorSubmitter monSubmitter, long interval, String sql, int timeoutSec) {
        StringBuilder sb = new StringBuilder();
        Connection connection = null;
        try {
            connection = this.connect();
            try (Statement stMain = connection.createStatement(1003, 1007);){
                stMain.setQueryTimeout(timeoutSec);
                try (ResultSet rs = stMain.executeQuery(sql);){
                    ResultSetMetaData rsMD = rs.getMetaData();
                    LinkedList<Hashtable<String, Object>> result = new LinkedList<Hashtable<String, Object>>();
                    this.processResultSet(result, rs, rsMD);
                    if (monSubmitter != null) {
                        this.submitValues(monitorName, result, monSubmitter, interval);
                    } else {
                        for (int i = 1; i <= rsMD.getColumnCount(); ++i) {
                            sb.append(rsMD.getColumnName(i)).append("\t| ");
                        }
                        sb.append("\n");
                        for (Hashtable hashtable : result) {
                            for (int j = 1; j <= rsMD.getColumnCount(); ++j) {
                                sb.append(hashtable.get(rsMD.getColumnLabel(j))).append("\t| ");
                            }
                            sb.append("\n");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            sb.append("Error executing sql: ").append(sql).append("\n").append(e.toString());
            RuntimeException rte = new RuntimeException(sb.toString());
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
        finally {
            this.closeConnection(connection);
        }
        return sb.toString();
    }

    private String update(String monitorName, IMonitorSubmitter monSubmitter, long interval, String sql, int timeoutSec) {
        StringBuilder sb = new StringBuilder();
        Connection connection = null;
        try {
            connection = this.connect();
            try (Statement statement = connection.createStatement();){
                statement.setQueryTimeout(timeoutSec);
                boolean isResultSet = statement.execute(sql);
                if (isResultSet) {
                    ResultSet rs = statement.getResultSet();
                    try {
                        ResultSetMetaData rsMD = rs.getMetaData();
                        LinkedList<Hashtable<String, Object>> responses = new LinkedList<Hashtable<String, Object>>();
                        this.processResultSet(responses, rs, rsMD);
                        if (monSubmitter != null) {
                            this.submitValues(monitorName, responses, monSubmitter, interval);
                        } else {
                            for (int i = 1; i <= rsMD.getColumnCount(); ++i) {
                                sb.append(rsMD.getColumnName(i)).append("\t| ");
                            }
                            sb.append("\n");
                            for (Hashtable hashtable : responses) {
                                for (int j = 1; j <= rsMD.getColumnCount(); ++j) {
                                    sb.append(hashtable.get(rsMD.getColumnName(j))).append("\t| ");
                                }
                                sb.append("\n");
                            }
                        }
                        rs.close();
                    }
                    catch (Throwable e) {
                        sb.append(Arrays.toString(e.getStackTrace()));
                        sb.append(e.getMessage());
                    }
                } else {
                    int effectedRows = statement.getUpdateCount();
                    if (effectedRows == -1) {
                        sb.append("Job finished nothing to return.");
                    } else {
                        sb.append(effectedRows);
                    }
                    if (monSubmitter != null) {
                        monSubmitter.submitMonitorValue(monitorName, (double)effectedRows, null, null);
                    }
                }
            }
        }
        catch (Exception e) {
            sb.append("Error executing sql: ").append(sql).append("\n").append(e.toString());
            RuntimeException rte = new RuntimeException(sb.toString());
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
        finally {
            this.closeConnection(connection);
        }
        return sb.toString();
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String replaceArgValues(String sql, HashMap<String, String> dynArgs) throws Exception {
        String newSql = sql;
        for (Map.Entry<String, String> e : dynArgs.entrySet()) {
            newSql = newSql.replace(e.getKey(), e.getValue().replace("\"", ""));
        }
        return newSql;
    }

    private Connection connect() throws SQLException {
        Connection connection = this.userName == null || this.userName.isEmpty() ? DriverManager.getConnection(this.connectionUrl) : DriverManager.getConnection(this.connectionUrl, this.userName, this.password);
        return connection;
    }
}

