/*
 * Decompiled with CFR 0.152.
 */
package com.boom.dbmpi;

import com.blixx.db.mpi.JdbcData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SealedObject;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionManager {
    private static SecretKeySpec secretKey;

    public static void setKey(String myKey) {
        MessageDigest sha = null;
        try {
            byte[] key = myKey.getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unsupported Encoding : " + e.getMessage());
        }
    }

    public static void WriteToFile(JdbcData cfgData, String fileName) {
        try {
            EncryptionManager.setKey(fileName);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            SealedObject sealedObject = new SealedObject(cfgData, cipher);
            try (CipherOutputStream cipherOutputStream = new CipherOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0])), cipher);
                 ObjectOutputStream outputStream = new ObjectOutputStream(cipherOutputStream);){
                outputStream.writeObject(sealedObject);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while writing file:" + e.getMessage());
        }
    }

    public static JdbcData ReadFromFile(String fileName) {
        try {
            JdbcData jdbcData;
            EncryptionManager.setKey(fileName);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, secretKey);
            try (CipherInputStream cipherInputStream = new CipherInputStream(new BufferedInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0])), cipher);
                 ObjectInputStream inputStream = new ObjectInputStream(cipherInputStream);){
                SealedObject sealedObject = (SealedObject)inputStream.readObject();
                jdbcData = (JdbcData)sealedObject.getObject(cipher);
            }
            return jdbcData;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading file:" + e.getMessage());
        }
    }
}

