/*
 * Decompiled with CFR 0.152.
 */
package com.boom.dbmpi;

import com.blixx.db.mpi.JdbcData;
import com.blixx.ext.IAction;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import com.boom.dbmpi.CliArgsParser;
import com.boom.dbmpi.CliSwitches;
import com.boom.dbmpi.DatabaseConnector;
import com.boom.dbmpi.EncryptionManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Executor
implements IMonitorExt,
IAction {
    public static final String MSSQLDRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String ORACLEDRIVER = "oracle.jdbc.OracleDriver";
    public static final String POSTGREDRIVER = "org.postgresql.Driver";
    public static final String MYSQLDRIVER = "com.mysql.jdbc.Driver";
    private DatabaseConnector connector = null;
    private String monitor;
    private CliSwitches switches;
    private IMonitorSubmitter monSubmitter = null;
    private IMessage msgSubmitter = null;
    public long interval = 0L;

    public static Executor getInstance(String monitor, String[] parameters) {
        Executor ex = new Executor();
        ex.monitor = monitor;
        ex.switches = new CliArgsParser(parameters).switchPojo(CliSwitches.class);
        if (ex.switches.cfg != null && !ex.switches.cfg.isEmpty()) {
            JdbcData jdbcData = EncryptionManager.ReadFromFile(ex.switches.cfg);
            if (ex.switches.jdbc == null) {
                ex.switches.jdbc = jdbcData.jdbc;
            }
            if (ex.switches.u == null) {
                ex.switches.u = jdbcData.user;
            }
            if (ex.switches.p == null) {
                ex.switches.p = jdbcData.password;
            }
            if (ex.switches.d == null) {
                ex.switches.d = jdbcData.getDriver();
            }
        }
        Executor.validateSwitches(ex.switches);
        ex.connector = Executor.getConnector(ex.switches);
        return ex;
    }

    private static void validateSwitches(CliSwitches switches) {
        Executor.getConnector(switches);
        if ((switches.jdbc == null || switches.jdbc.isEmpty()) && switches.cfg.isEmpty()) {
            throw new IllegalArgumentException("Please define JDBC connection or Cfg file.");
        }
        if (switches.d == null || switches.d.isEmpty()) {
            throw new IllegalArgumentException("Driver is not found for jdbc: " + switches.jdbc);
        }
        if ((switches.f == null || switches.f.isEmpty()) && (switches.sql == null || switches.sql.isEmpty())) {
            throw new IllegalArgumentException("At least one of the Sql arguments must be defined, either define a sql script file or plain sql.");
        }
    }

    private static DatabaseConnector getConnector(CliSwitches switches) {
        if (switches.d == null || switches.d.isEmpty()) {
            if (switches.jdbc.startsWith("jdbc:oracle:")) {
                switches.d = ORACLEDRIVER;
            } else if (switches.jdbc.startsWith("jdbc:sqlserver:")) {
                switches.d = MSSQLDRIVER;
            } else if (switches.jdbc.startsWith("jdbc:postgresql:")) {
                switches.d = POSTGREDRIVER;
            } else if (switches.jdbc.startsWith("jdbc:mysql:")) {
                switches.d = MYSQLDRIVER;
            }
        }
        return switches.d == null || switches.d.isEmpty() ? null : new DatabaseConnector(switches.jdbc, switches.d, switches.u, switches.p);
    }

    public String runMonitor() {
        ArrayList<String> queries = new ArrayList<String>();
        if (this.switches.f == null || this.switches.f.isEmpty()) {
            queries.add(this.switches.getSql());
        } else {
            this.loadQuery(this.switches.f, this.switches.s);
        }
        for (String sql : queries) {
            this.connector.runMonitor(this.monitor, this.monSubmitter, this.interval, sql, this.switches.m, this.switches.t);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.msgSubmitter = submitter;
    }

    public void stop() {
    }

    public String run(String[] parameters, int timeout) {
        try {
            Executor ex = Executor.getInstance("", parameters);
            List<String> queries = new ArrayList<String>();
            if (ex.switches.f == null || ex.switches.f.isEmpty()) {
                queries.add(ex.switches.getSql());
            } else {
                queries = this.loadQuery(ex.switches.f, ex.switches.s);
            }
            return ex.connector.run(queries, ex.switches.a, ex.switches.m, ex.switches.t);
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.monSubmitter = submitter;
    }

    public List<String> loadQuery(String filename, boolean singlestatement) {
        ArrayList<String> sqlQueries = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        FileReader fr = null;
        try {
            fr = new FileReader(filename);
            br = new BufferedReader(fr);
            String lineF = null;
            while ((lineF = br.readLine()) != null) {
                if (singlestatement) {
                    sb.append(lineF);
                    sb.append(' ');
                    continue;
                }
                sqlQueries.add(lineF);
            }
        }
        catch (FileNotFoundException e) {
            RuntimeException rte = new RuntimeException("FileNotFound: " + filename);
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException("Error reading file: " + filename);
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Throwable throwable) {}
        }
        if (sb.length() > 0) {
            sqlQueries.add(sb.toString());
        }
        return sqlQueries;
    }

    public CliSwitches getCliSwitches() {
        return this.switches;
    }
}

