/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CCallableStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CDriverExtension
extends OracleDriverExtension {
    T4CDriverExtension() {
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    Connection getConnection(String string, Properties properties) throws SQLException {
        T4CConnection t4CConnection = new T4CConnection(string, properties, this);
        t4CConnection.connect();
        return t4CConnection;
    }

    @Override
    OracleStatement allocateStatement(PhysicalConnection physicalConnection, int n2, int n3) throws SQLException {
        return new T4CStatement(physicalConnection, n2, n3);
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T4CPreparedStatement(physicalConnection, string, n2, n3);
    }

    @Override
    OracleCallableStatement allocateCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        return new T4CCallableStatement(physicalConnection, string, n2, n3);
    }

    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        return new T4CInputStream(oracleStatement, n2, accessor);
    }
}

