/*
databases: BOOM, BOOM_PERF 
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

create database if not exists `BOOM`;

USE `BOOM`;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

/*Table structure for table `agents` */

DROP TABLE IF EXISTS `BOOM`.`AGENTS`;

CREATE TABLE `BOOM`.`AGENTS` (
  `ID` char(36) default NULL,
  `HOSTNAME` varchar(255) default NULL,
  `IP` varchar(255) default NULL,
  `MODE` int(11) default NULL,
  `DESCRIPTION` varchar(1024) default NULL,
  `LABEL` varchar(255) default NULL,
  `OS` varchar(255) default NULL,
  `APPROVED` tinyint(1) default '1',
  `DISABLED` tinyint(1) default '0',
  `PORT` int(11) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `annotations` */

DROP TABLE IF EXISTS `BOOM`.`ANNOTATIONS`;

CREATE TABLE `BOOM`.`ANNOTATIONS` (
  `ID` char(36) default NULL,
  `ANNOTATION` blob,
  `TIME` bigint(20) default NULL,
  `STATUS` varchar(3) default NULL,
  KEY `ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `assignments` */

DROP TABLE IF EXISTS `BOOM`.`ASSIGNMENTS`;

CREATE TABLE `BOOM`.`ASSIGNMENTS` (
  `ID` char(36) NOT NULL default '',
  `AGENT_ID` char(36) NOT NULL default '',
  `ASSIGNMENT` varchar(100) NOT NULL,
  `_TYPE` char(3) default 'pga',
  `FTIME` bigint(20) default NULL,
  `UTIME` bigint(20) default NULL,
  `USER` varchar(100) default NULL,
  `_LOCK` int(1) default '0',
  PRIMARY KEY  (`ID`),
  KEY `ASSIGNMENT_NAMETYPE` (`ASSIGNMENT`,`_TYPE`,`ID`) 
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Table structure for table `events` */

DROP TABLE IF EXISTS `BOOM`.`EVENTS`;

CREATE TABLE `BOOM`.`EVENTS` (
  `ID` char(36) NOT NULL default '',
  `SERVICE` varchar(1024) default NULL,
  `NODE` varchar(255) default NULL,
  `APPLICATION` varchar(1024) default NULL,
  `OBJECT` varchar(1024) default NULL,
  `MSGGRP` varchar(1024) default NULL,
  `MSGTEXT` varchar(8192) default NULL,
  `TIME` bigint(20) NOT NULL,
  `MSGKEY` varchar(1024) default NULL,
  `ACKKEY` varchar(1024) default NULL,
  `SEVERITY` int(11) default '0',
  `DUPL` int(11) default '0',
  `STATE` char(1) default '-',
  `INSTRUCTIONID` char(36) default NULL,
  `AUTOACTION` varchar(1024) default NULL,
  `OPACTION` varchar(1024) default NULL,
  `STIME` bigint(20) default NULL,
  `SOURCE` varchar(1024) default NULL,
  `VALUE` double default NULL,
  `MONITOR` varchar(1024) default NULL,
  `AGENTNODE` varchar(255) default NULL,
  `ANNOT` int(11) default NULL,
  `TYPE_A` int(11) default NULL,
  `TYPE_K` int(11) default NULL,
  `FTIME` bigint(20) default NULL,
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `EVENTID_STATE` (`ID`,`STATE`),                                          
  UNIQUE KEY `EVENT_DUPL_STATE` (`ID`,`DUPL`,`STATE`)                                 
) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/* indexes */
ALTER TABLE `BOOM`.`EVENTS` add index `STATE` (`STATE`);
ALTER TABLE `BOOM`.`EVENTS` add index `NODE` (`NODE`);

/*Table structure for table `events_ext` */
DROP TABLE IF EXISTS `BOOM`.`EVENTS_EXT`;

CREATE TABLE `BOOM`.`EVENTS_EXT` (             
              `ID_E` char(36) NOT NULL default '',  
              `SRV` varchar(512) default NULL,      
              `SRVTYPE` varchar(512) default NULL,   
              `EXTID` char(36) default NULL,        
              `T1` varchar(512) default NULL,       
              `T2` varchar(512) default NULL,       
              `T3` varchar(512) default NULL,       
              `T4` varchar(512) default NULL,       
              `T5` varchar(512) default NULL,       
              `T6` varchar(512) default NULL,       
              `T7` varchar(512) default NULL,       
              `T8` varchar(512) default NULL,       
              `T9` varchar(512) default NULL,       
              `T10` varchar(512) default NULL,      
              `TFA` varchar(50) default NULL,       
              `VFA` varchar(50) default NULL,       
              `CA1` varchar(1024) default NULL,      
              `CA2` varchar(1024) default NULL,      
              `CA3` varchar(1024) default NULL,      
              `CA4` varchar(1024) default NULL,      
              `CA5` varchar(1024) default NULL,      
              `CA6` varchar(1024) default NULL,      
              `CA7` varchar(1024) default NULL,      
              `CA8` varchar(1024) default NULL,      
              `CA9` varchar(1024) default NULL,      
              `CA10` varchar(1024) default NULL,     
              `CA11` varchar(1024) default NULL,     
              `CA12` varchar(1024) default NULL,     
              `CA13` varchar(1024) default NULL,     
              `CA14` varchar(1024) default NULL,     
              `CA15` varchar(1024) default NULL,     
              PRIMARY KEY  (`ID_E`)                 
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
			
/*Table structure for table `events_a` */

DROP TABLE IF EXISTS `BOOM`.`EVENTS_A`;

CREATE TABLE `BOOM`.`EVENTS_A` (
  `ID` char(36) NOT NULL default '',
  `SERVICE` varchar(1024) default NULL,
  `NODE` varchar(255) default NULL,
  `APPLICATION` varchar(1024) default NULL,
  `OBJECT` varchar(1024) default NULL,
  `MSGGRP` varchar(1024) default NULL,
  `MSGTEXT` varchar(8192) default NULL,
  `TIME` bigint(20) NOT NULL,
  `MSGKEY` varchar(1024) default NULL,
  `ACKKEY` varchar(1024) default NULL,
  `SEVERITY` int(11) default '0',
  `DUPL` int(11) default '0',
  `STATE` char(1) default '-',
  `INSTRUCTIONID` char(36) default NULL,
  `AUTOACTION` varchar(1024) default NULL,
  `OPACTION` varchar(1024) default NULL,
  `STIME` bigint(20) default NULL,
  `SOURCE` varchar(1024) default NULL,
  `VALUE` double default NULL,
  `MONITOR` varchar(1024) default NULL,
  `AGENTNODE` varchar(255) default NULL,
  `ANNOT` int(11) default NULL,
  `TYPE_A` int(11) default NULL,
  `TYPE_K` int(11) default NULL,
  `FTIME` bigint(20) default NULL,
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ID` (`ID`,`STATE`),
  INDEX EVENTS_A_STIME_IDX (STIME)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

ALTER TABLE `BOOM`.`EVENTS_A` add index `STIME` (`STIME`);

/*Table structure for table `events_ext_a` */
DROP TABLE IF EXISTS `BOOM`.`EVENTS_EXT_A`;

CREATE TABLE `BOOM`.`EVENTS_EXT_A` (             
              `ID_E` char(36) NOT NULL default '',  
              `SRV` varchar(512) default NULL,      
              `SRVTYPE` varchar(512) default NULL,   
              `EXTID` char(36) default NULL,        
              `T1` varchar(512) default NULL,       
              `T2` varchar(512) default NULL,       
              `T3` varchar(512) default NULL,       
              `T4` varchar(512) default NULL,       
              `T5` varchar(512) default NULL,       
              `T6` varchar(512) default NULL,       
              `T7` varchar(512) default NULL,       
              `T8` varchar(512) default NULL,       
              `T9` varchar(512) default NULL,       
              `T10` varchar(512) default NULL,      
              `TFA` varchar(50) default NULL,       
              `VFA` varchar(50) default NULL,       
              `CA1` varchar(1024) default NULL,      
              `CA2` varchar(1024) default NULL,      
              `CA3` varchar(1024) default NULL,      
              `CA4` varchar(1024) default NULL,      
              `CA5` varchar(1024) default NULL,      
              `CA6` varchar(1024) default NULL,      
              `CA7` varchar(1024) default NULL,      
              `CA8` varchar(1024) default NULL,      
              `CA9` varchar(1024) default NULL,      
              `CA10` varchar(1024) default NULL,     
              `CA11` varchar(1024) default NULL,     
              `CA12` varchar(1024) default NULL,     
              `CA13` varchar(1024) default NULL,     
              `CA14` varchar(1024) default NULL,     
              `CA15` varchar(1024) default NULL,     
              PRIMARY KEY  (`ID_E`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
			

/*Table structure for table `instructions` */

DROP TABLE IF EXISTS `BOOM`.`INSTRUCTIONS`;

CREATE TABLE `BOOM`.`INSTRUCTIONS` (
  `ID` char(36) NOT NULL default '',
  `HELP` varchar(8192) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Table structure for table `policies` */

DROP TABLE IF EXISTS `BOOM`.`POLICIES`;

CREATE TABLE `BOOM`.`POLICIES` (
  `ID` char(36) NOT NULL,
  `NAME` varchar(255) NOT NULL,
  `TYPE` char(1) default NULL,
  `FILENAME` varchar(255) default NULL,
  `VERSION` int(11) default NULL,
  PRIMARY KEY  (`NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Table structure for table `items` */

DROP TABLE IF EXISTS `BOOM`.`ITEMS`;

CREATE TABLE `BOOM`.`ITEMS` (
  `ID` int(4) NOT NULL auto_increment,
  `NAME` varchar(40) NOT NULL default '',
  `DESCRIPTION` varchar(250) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `items` */

insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1000,'Indications','Access to the Indication View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1001,'Policies','Access to the Policies View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1002,'Hosts','Access to the Hosts View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1003,'Statistic','Access to the Statistic View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1004,'User Management','Access to the User Management View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1005,'Operator Remote Actions','Allow to execute Operator Actions defined in Indications');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1006,'Packages','Access to the Packages View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1007,'Actions','Access to the Actions View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1008,'Assignments','Access to the Assignments View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1009,'Server Filters','Access to the Server Filters View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (1010,'Service Tree','Access to the Service Tree');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2001,'Service Dashboard (Global)','Allow configuration of the Global Service Dashboard');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2002,'Service Dashboard (Local)','Allow configuration of the Local Service Dashboard');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2003,'Server Jobs','Access to the Server Jobs View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2004,'Server Configuration', 'Access to the Server Configuration View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2010,'Scheduled Maintenance', 'Access to the Scheduled Maintenance View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2011,'AdHoc Maintenance', 'Access to the AdHoc Maintenance View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2012,'Server Policies', 'Access to the Server Policies View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2014,'Notification Interfaces','Access to the Notifications View');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2015,'Extended Agent Attributes','Allow to see or edit Extended Agent Attributes');
insert  into `BOOM`.`ITEMS`(`ID`,`NAME`,`DESCRIPTION`) values (2016,'Maintenance Indications','Access to the Maintenance Indications View');

/*Table structure for table `rights` */

DROP TABLE IF EXISTS `BOOM`.`RIGHTS`;

CREATE TABLE `BOOM`.`RIGHTS` (
  `ROLE_ID` char(36) character set latin1 collate latin1_german1_ci NOT NULL default '',
  `ITEM_ID` int(4) NOT NULL,
  `DISABLED` tinyint(1) NOT NULL default '0',
  `GUEST` tinyint(1) NOT NULL default '0',
  `OWNER` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ROLE_ID`,`ITEM_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `rights` */

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1000,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1001,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1002,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1003,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1004,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1005,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1006,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1007,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1008,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1009,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1010,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2001,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2002,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2003,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2004,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2010,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2011,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2012,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2014,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2015,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2016,0,0,1);

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1000,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1001,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1002,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1003,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1004,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1005,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1006,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1007,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1008,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1009,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1010,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2001,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2002,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2003,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2004,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2010,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2011,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2012,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2014,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2015,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2016,0,0,1);

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1000,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1001,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1002,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1003,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1004,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1005,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1006,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1007,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1008,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1009,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1010,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2001,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2002,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2003,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2004,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2010,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2011,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2012,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2014,1,0,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2015,0,1,0);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2016,0,0,1);

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1000,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1001,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1002,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1003,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1004,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1005,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1006,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1007,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1008,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1009,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1010,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2001,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2002,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2003,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2004,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2010,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2011,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2012,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2014,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2015,0,0,1);
insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2016,0,0,1);

/*Table structure for table `roles` */

DROP TABLE IF EXISTS `BOOM`.`ROLES`;

CREATE TABLE `BOOM`.`ROLES` (
  `ID` char(36) NOT NULL default '',
  `ROLENAME` varchar(250) NOT NULL default '',
  `DESCRIPTION` varchar(250) default '',
  PRIMARY KEY  (`ID`,`ROLENAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `roles` */

insert  into `BOOM`.`ROLES`(`ID`,`ROLENAME`,`DESCRIPTION`) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2','DB Admins','Sample group');
insert  into `BOOM`.`ROLES`(`ID`,`ROLENAME`,`DESCRIPTION`) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638','Default','Sample group');
insert  into `BOOM`.`ROLES`(`ID`,`ROLENAME`,`DESCRIPTION`) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa','Operator Team A','Sample Operator group');
insert  into `BOOM`.`ROLES`(`ID`,`ROLENAME`,`DESCRIPTION`) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a','Administrator','Admin group');

/*Table structure for table `users` */

DROP TABLE IF EXISTS `BOOM`.`USERS`;

CREATE TABLE `BOOM`.`USERS` (
  `ID` char(36) character set latin1 collate latin1_german1_ci NOT NULL default '',
  `LOGIN` varchar(255) NOT NULL default '',
  `PASSWORD` varchar(255) NOT NULL default '',
  `FIRSTNAME` varchar(255) default NULL,
  `LASTNAME` varchar(255) default NULL,
  `ROLE_ID` char(36) default '',
  `EMAIL` varchar(1024) default NULL,
  `PHONE` varchar(1024) default NULL,
  `PAGER` varchar(1024) default NULL,
  `ACTIVE` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `FK_users` (`ROLE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;

/*Data for the table `users` */
insert  into `BOOM`.`USERS`(`ID`,`LOGIN`,`PASSWORD`,`FIRSTNAME`,`LASTNAME`,`ROLE_ID`,`EMAIL`,`PHONE`,`PAGER`,`ACTIVE`) values ('8970e735-f341-405b-b82c-5df9e7e56745','dbadm1','405403402405414354','John','Doe','ae99710f-f2da-4862-b292-f1afd88dd5a2','john.doe@gmail.com','','',1);
insert  into `BOOM`.`USERS`(`ID`,`LOGIN`,`PASSWORD`,`FIRSTNAME`,`LASTNAME`,`ROLE_ID`,`EMAIL`,`PHONE`,`PAGER`,`ACTIVE`) values ('92eb765e-0e0d-44d7-8088-2ecd1b08a4bc','dbadm2','405403402405414355','Jane','Doe','ae99710f-f2da-4862-b292-f1afd88dd5a2','jane.doe@gmail.com','','',1);
insert  into `BOOM`.`USERS`(`ID`,`LOGIN`,`PASSWORD`,`FIRSTNAME`,`LASTNAME`,`ROLE_ID`,`EMAIL`,`PHONE`,`PAGER`,`ACTIVE`) values ('e0e9a67c-89d8-4156-a0be-6f79b01a9e9d','admin','402405414410415','','Admin','dec7d845-ef3e-4400-980e-f6f54e9b357a','','','',1);

DROP TABLE IF EXISTS `BOOM`.`EVENTS_TEMP`;
CREATE TABLE `BOOM`.`EVENTS_TEMP` (
	`ID` char(36) NOT NULL default ''
	, KEY `EVENTS_TEMP_ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*create database if not exists `BOOM_PERF`;*/

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
