/*
database: BOOM 
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

USE `BOOM`;

DROP TABLE IF EXISTS `BOOM`.`O_AGENTS`;

CREATE TABLE `BOOM`.`O_AGENTS` (                  
            `ID` char(36) NOT NULL,                  
            `AGENTID` char(36) DEFAULT NULL,         
            `PATTERNS` varchar(2048) DEFAULT NULL,   
            `STARTTIME` bigint(20) DEFAULT '0',      
            `EXPDURATION` bigint(20) DEFAULT '0',    
            `ENDTIME` bigint(20) DEFAULT '0',        
            `ENABLED` int(2) DEFAULT '0',            
            `DISABLEDBY` varchar(255) DEFAULT NULL,  
            `ACTION` int(2) DEFAULT '3',             
            `POSTACTION` int(2) DEFAULT '0',         
            `INTERVAL` bigint(20) DEFAULT '0',       
            PRIMARY KEY (`ID`)                       
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC ;

DROP TABLE IF EXISTS `BOOM`.`O_ANNOTATIONS`;
		  
CREATE TABLE `BOOM`.`O_ANNOTATIONS` (                                                        
		 `ID` char(36) DEFAULT NULL,                                                         
		 `ANNOTATION` blob,                                                                  
		 `TIME` bigint(20) DEFAULT NULL,                                                     
		 `STATUS` varchar(3) DEFAULT NULL,                                                   
		 KEY `ID` (`ID`)                                                                     
	   ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC	;	  

DROP TABLE IF EXISTS `BOOM`.`O_EVENTS`;	
		   
CREATE TABLE `BOOM`.`O_EVENTS` (
		  `ID` char(36) NOT NULL default '',
		  `SERVICE` varchar(1024) default NULL,
		  `NODE` varchar(255) default NULL,
		  `APPLICATION` varchar(1024) default NULL,
		  `OBJECT` varchar(1024) default NULL,
		  `MSGGRP` varchar(1024) default NULL,
		  `MSGTEXT` varchar(8192) default NULL,
		  `TIME` bigint(20) NOT NULL,
		  `MSGKEY` varchar(1024) default NULL,
		  `ACKKEY` varchar(1024) default NULL,
		  `SEVERITY` int(11) default '0',
		  `DUPL` int(11) default '0',
		  `STATE` char(1) default '-',
		  `INSTRUCTIONID` char(36) default NULL,
		  `AUTOACTION` varchar(1024) default NULL,
		  `OPACTION` varchar(1024) default NULL,
		  `STIME` bigint(20) default NULL,
		  `SOURCE` varchar(1024) default NULL,
		  `VALUE` double default NULL,
		  `MONITOR` varchar(1024) default NULL,
		  `AGENTNODE` varchar(255) default NULL,
		  `ANNOT` int(11) default NULL,
		  `TYPE_A` int(11) default NULL,
		  `TYPE_K` int(11) default NULL,
		  `FTIME` bigint(20) default NULL,
		  PRIMARY KEY  (`ID`),
		  UNIQUE KEY `EVENTID_STATE` (`ID`,`STATE`),                                          
		  UNIQUE KEY `EVENT_DUPL_STATE` (`ID`,`DUPL`,`STATE`)                                 
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
		
ALTER TABLE `BOOM`.`O_EVENTS` add index `O_STATE` (`STATE`);
ALTER TABLE `BOOM`.`O_EVENTS` add index `O_NODE` (`NODE`);

DROP TABLE IF EXISTS `BOOM`.`O_EVENTS_EXT`;
		
CREATE TABLE `BOOM`.`O_EVENTS_EXT` (             
              `ID_E` char(36) NOT NULL default '',  
              `SRV` varchar(512) default NULL,      
              `SRVTYPE` varchar(512) default NULL,   
              `EXTID` char(36) default NULL,        
              `T1` varchar(512) default NULL,       
              `T2` varchar(512) default NULL,       
              `T3` varchar(512) default NULL,       
              `T4` varchar(512) default NULL,       
              `T5` varchar(512) default NULL,       
              `T6` varchar(512) default NULL,       
              `T7` varchar(512) default NULL,       
              `T8` varchar(512) default NULL,       
              `T9` varchar(512) default NULL,       
              `T10` varchar(512) default NULL,      
              `TFA` varchar(50) default NULL,       
              `VFA` varchar(50) default NULL,       
              `CA1` varchar(1024) default NULL,      
              `CA2` varchar(1024) default NULL,      
              `CA3` varchar(1024) default NULL,      
              `CA4` varchar(1024) default NULL,      
              `CA5` varchar(1024) default NULL,      
              `CA6` varchar(1024) default NULL,      
              `CA7` varchar(1024) default NULL,      
              `CA8` varchar(1024) default NULL,      
              `CA9` varchar(1024) default NULL,      
              `CA10` varchar(1024) default NULL,     
              `CA11` varchar(1024) default NULL,     
              `CA12` varchar(1024) default NULL,     
              `CA13` varchar(1024) default NULL,     
              `CA14` varchar(1024) default NULL,     
              `CA15` varchar(1024) default NULL,     
              PRIMARY KEY  (`ID_E`)                 
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;