/*
	This script will update the MySQL boom database layout of Version 1.x/2.0/3.0
        to the latest 4.00 layout.
*/
alter table `BOOM`.`USERS` change `LOGIN` `LOGIN` varchar (255) CHARACTER SET utf8  COLLATE utf8_general_ci  DEFAULT '' NOT NULL , change `PASSWORD` `PASSWORD` varchar (255) CHARACTER SET utf8  COLLATE utf8_general_ci  DEFAULT '' NOT NULL , change `FIRSTNAME` `FIRSTNAME` varchar (255) CHARACTER SET utf8  COLLATE utf8_general_ci   NULL , change `LASTNAME` `LASTNAME` varchar (255) CHARACTER SET utf8  COLLATE utf8_general_ci   NULL;
alter table `BOOM`.`AGENTS` change `IP` `IP` varchar (255) CHARACTER SET utf8  COLLATE utf8_general_ci   NULL;
alter table `BOOM`.`INSTRUCTIONS` change `HELP` `HELP` varchar (8192) CHARACTER SET utf8  COLLATE utf8_general_ci   NULL;

/* add new data */

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 1010,'Service Tree','Access to the Service Tree'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=1010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',1010,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=1010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1010,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=1010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1010,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=1010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',1010,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=1010) limit 1;


insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2001,'Service Dashboard (Global)','Allow configuration of the Global Service Dashboard'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2001) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2001,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2001) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2001,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2001) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2001,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2001) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2001,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2001) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2002,'Service Dashboard (Local)','Allow configuration of the Local Service Dashboard'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2002) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2002,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2002) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2002,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2002) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2002,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2002) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2002,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2002) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2003,'Server Jobs','Access to the Server Jobs View'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2003) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2003,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2003) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2003,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2003) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2003,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2003) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2003,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2003) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2004,'Server Configuration', 'Access to the Server Configuration View'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2004) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2004,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2004) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2004,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2004) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2004,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2004) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2004,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2004) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2010,'Scheduled Maintenance', 'Access to the Scheduled Maintenance View'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2010,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2010,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2010,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2010) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2010,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2010) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2011,'AdHoc Maintenance', 'Access to the AdHoc Maintenance View'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2011) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2011,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2011) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2011,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2011) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2011,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2011) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2011,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2011) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2012,'Server Policies', 'Access to the Server Policies View'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2012) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2012,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2012) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2012,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2012) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2012,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2012) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2012,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2012) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2014,'Notification Interfaces','Access to the Notifications View'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2014) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2014,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2014) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2014,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2014) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2014,1,0,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2014) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2014,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2014) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2015,'Extended Agent Attributes','Allow to see or edit Extended Agent Attributes'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2015) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2015,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2015) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2015,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2015) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2015,0,1,0
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2015) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2015,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2015) limit 1;

insert into `BOOM`.`ITEMS` (ID,NAME,DESCRIPTION) select 2016,'Maintenance Indications','Access to the Maintenance Indications View'
 from DUAL where not exists (select 1 from `BOOM`.`ITEMS` where ID=2016) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2016,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='ae99710f-f2da-4862-b292-f1afd88dd5a2' and `ITEM_ID`=2016) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2016,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and `ITEM_ID`=2016) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2016,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and `ITEM_ID`=2016) limit 1;

insert  into `BOOM`.`RIGHTS`(`ROLE_ID`,`ITEM_ID`,`DISABLED`,`GUEST`,`OWNER`) 
select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2016,0,0,1
from DUAL where not exists (select 1 from `BOOM`.`RIGHTS` where
`ROLE_ID`='dec7d845-ef3e-4400-980e-f6f54e9b357a' and `ITEM_ID`=2016) limit 1;

UPDATE `BOOM`.`ITEMS` SET `NAME`='Indications', `DESCRIPTION`='Access to the Indication View' WHERE `ID`='1000';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Policies', `DESCRIPTION`='Access to the Policies View' WHERE `ID`='1001';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Hosts', `DESCRIPTION`='Access to the Hosts View' WHERE `ID`='1002';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Statistic', `DESCRIPTION`='Access to the Statistic View' WHERE `ID`='1003';
UPDATE `BOOM`.`ITEMS` SET `NAME`='User Management', `DESCRIPTION`='Access to the User Management View' WHERE `ID`='1004';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Operator Remote Actions', `DESCRIPTION`='Allow to execute Operator Actions defined in Indications' WHERE `ID`='1005';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Packages', `DESCRIPTION`='Access to the Packages View' WHERE `ID`='1006';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Actions', `DESCRIPTION`='Access to the Actions View' WHERE `ID`='1007';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Assignments', `DESCRIPTION`='Access to the Assignments View' WHERE `ID`='1008';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Server Filters', `DESCRIPTION`='Access to the Server Filters View' WHERE `ID`='1009';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Service Tree', `DESCRIPTION`='Access to the Service Tree' WHERE `ID`='1010';

UPDATE `BOOM`.`ITEMS` SET `NAME`='Service Dashboard (Global)', `DESCRIPTION`='Allow configuration of the Global Service Dashboard' WHERE `ID`='2001';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Service Dashboard (Local)', `DESCRIPTION`='Allow configuration of the Local Service Dashboard' WHERE `ID`='2002';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Server Jobs', `DESCRIPTION`='Access to the Server Jobs View' WHERE `ID`='2003';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Server Configuration', `DESCRIPTION`='Access to the Server Configuration View' WHERE `ID`='2004';

UPDATE `BOOM`.`ITEMS` SET `NAME`='Scheduled Maintenance', `DESCRIPTION`='Access to the Scheduled Maintenance View' WHERE `ID`='2010';
UPDATE `BOOM`.`ITEMS` SET `NAME`='AdHoc Maintenance', `DESCRIPTION`='Access to the AdHoc Maintenance View' WHERE `ID`='2011';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Server Policies', `DESCRIPTION`='Access to the Server Policies View' WHERE `ID`='2012';

UPDATE `BOOM`.`ITEMS` SET `NAME`='Notification Interfaces', `DESCRIPTION`='Access to the Notifications View' WHERE `ID`='2014';
UPDATE `BOOM`.`ITEMS` SET `NAME`='Extended Agent Attributes', `DESCRIPTION`='Allow to see or edit Extended Agent Attributes' WHERE `ID`='2015';

commit;
ALTER TABLE `BOOM`.`EVENTS_A` add index `STIME` (`STIME`);
commit;
alter table `BOOM`.`AGENTS` add column `PORT` int (11)  NULL;
commit;

CREATE TABLE `BOOM`.`O_AGENTS` (                  
            `ID` char(36) NOT NULL,                  
            `AGENTID` char(36) DEFAULT NULL,         
            `PATTERNS` varchar(2048) DEFAULT NULL,   
            `STARTTIME` bigint(20) DEFAULT '0',      
            `EXPDURATION` bigint(20) DEFAULT '0',    
            `ENDTIME` bigint(20) DEFAULT '0',        
            `ENABLED` int(2) DEFAULT '0',            
            `DISABLEDBY` varchar(255) DEFAULT NULL,  
            `ACTION` int(2) DEFAULT '3',             
            `POSTACTION` int(2) DEFAULT '0',         
            `INTERVAL` bigint(20) DEFAULT '0',       
            PRIMARY KEY (`ID`)                       
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC ;

	  
CREATE TABLE `BOOM`.`O_ANNOTATIONS` (                                                        
		 `ID` char(36) DEFAULT NULL,                                                         
		 `ANNOTATION` blob,                                                                  
		 `TIME` bigint(20) DEFAULT NULL,                                                     
		 `STATUS` varchar(3) DEFAULT NULL,                                                   
		 KEY `ID` (`ID`)                                                                     
	   ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC	;	  
		   
CREATE TABLE `BOOM`.`O_EVENTS` (
		  `ID` char(36) NOT NULL default '',
		  `SERVICE` varchar(1024) default NULL,
		  `NODE` varchar(255) default NULL,
		  `APPLICATION` varchar(1024) default NULL,
		  `OBJECT` varchar(1024) default NULL,
		  `MSGGRP` varchar(1024) default NULL,
		  `MSGTEXT` varchar(8192) default NULL,
		  `TIME` bigint(20) NOT NULL,
		  `MSGKEY` varchar(1024) default NULL,
		  `ACKKEY` varchar(1024) default NULL,
		  `SEVERITY` int(11) default '0',
		  `DUPL` int(11) default '0',
		  `STATE` char(1) default '-',
		  `INSTRUCTIONID` char(36) default NULL,
		  `AUTOACTION` varchar(1024) default NULL,
		  `OPACTION` varchar(1024) default NULL,
		  `STIME` bigint(20) default NULL,
		  `SOURCE` varchar(1024) default NULL,
		  `VALUE` double default NULL,
		  `MONITOR` varchar(1024) default NULL,
		  `AGENTNODE` varchar(255) default NULL,
		  `ANNOT` int(11) default NULL,
		  `TYPE_A` int(11) default NULL,
		  `TYPE_K` int(11) default NULL,
		  `FTIME` bigint(20) default NULL,
		  PRIMARY KEY  (`ID`),
		  UNIQUE KEY `EVENTID_STATE` (`ID`,`STATE`),                                          
		  UNIQUE KEY `EVENT_DUPL_STATE` (`ID`,`DUPL`,`STATE`)                                 
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
		
ALTER TABLE `BOOM`.`O_EVENTS` add index `O_STATE` (`STATE`);
ALTER TABLE `BOOM`.`O_EVENTS` add index `O_NODE` (`NODE`);
		
CREATE TABLE `BOOM`.`O_EVENTS_EXT` (             
              `ID_E` char(36) NOT NULL default '',  
              `SRV` varchar(512) default NULL,      
              `SRVTYPE` varchar(512) default NULL,   
              `EXTID` char(36) default NULL,        
              `T1` varchar(512) default NULL,       
              `T2` varchar(512) default NULL,       
              `T3` varchar(512) default NULL,       
              `T4` varchar(512) default NULL,       
              `T5` varchar(512) default NULL,       
              `T6` varchar(512) default NULL,       
              `T7` varchar(512) default NULL,       
              `T8` varchar(512) default NULL,       
              `T9` varchar(512) default NULL,       
              `T10` varchar(512) default NULL,      
              `TFA` varchar(50) default NULL,       
              `VFA` varchar(50) default NULL,       
              `CA1` varchar(1024) default NULL,      
              `CA2` varchar(1024) default NULL,      
              `CA3` varchar(1024) default NULL,      
              `CA4` varchar(1024) default NULL,      
              `CA5` varchar(1024) default NULL,      
              `CA6` varchar(1024) default NULL,      
              `CA7` varchar(1024) default NULL,      
              `CA8` varchar(1024) default NULL,      
              `CA9` varchar(1024) default NULL,      
              `CA10` varchar(1024) default NULL,     
              `CA11` varchar(1024) default NULL,     
              `CA12` varchar(1024) default NULL,     
              `CA13` varchar(1024) default NULL,     
              `CA14` varchar(1024) default NULL,     
              `CA15` varchar(1024) default NULL,     
              PRIMARY KEY  (`ID_E`)                 
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
			
CREATE TABLE `BOOM`.`PGITEMS` (                  
            `PGID` char(36) NOT NULL,                  
            `PGI` varchar(2048) DEFAULT NULL                     
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC ;
		  
CREATE TABLE `BOOM`.`PGRIGHTS` (                                                        
		 `ROLEID` char(36) NOT NULL,                                                         
		 `PGID` char(36) NOT NULL                                                               
	   ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC	;

CREATE TABLE `BOOM`.`PGROUPS` (
		  `ID` char(36) NOT NULL,
		  `NAME` varchar(255) default '',
		  `DESCRIPTION` varchar(2048) default '',
		  PRIMARY KEY  (`ID`)                                
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;   

CREATE TABLE `BOOM`.`AGENTS_EXT` (             
              `ID` char(36) NOT NULL default '',  
              `EMAIL` varchar(255) default NULL,
              `CONTACT` varchar(1024) default NULL, 
              `LIT` bigint(20) default 0,   
              `ACID` varchar(255) default NULL,
              `EID` varchar(255) default NULL,        
              `BIGINT1` bigint(20) default NULL,       
              `BIGINT2` bigint(20) default NULL,       
              `BIGINT3` bigint(20) default NULL,       
              `BIGINT4` bigint(20) default NULL,       
              `BIGINT5` bigint(20) default NULL,       
              `BIGINT6` bigint(20) default NULL,       
              `BIGINT7` bigint(20) default NULL,       
              `BIGINT8` bigint(20) default NULL,       
              `BIGINT9` bigint(20) default NULL,       
              `BIGINT10` bigint(20) default NULL,
              `INT1` int(11) default NULL,       
              `INT2` int(11) default NULL,       
              `INT3` int(11) default NULL,       
              `INT4` int(11) default NULL,       
              `INT5` int(11) default NULL,       
              `INT6` int(11) default NULL,       
              `INT7` int(11) default NULL,       
              `INT8` int(11) default NULL,       
              `INT9` int(11) default NULL,       
              `INT10` int(11) default NULL,
              `DOUBLE1` double default NULL,       
              `DOUBLE2` double default NULL,       
              `DOUBLE3` double default NULL,       
              `DOUBLE4` double default NULL,       
              `DOUBLE5` double default NULL,       
              `DOUBLE6` double default NULL,       
              `DOUBLE7` double default NULL,       
              `DOUBLE8` double default NULL,       
              `DOUBLE9` double default NULL,       
              `DOUBLE10` double default NULL,			  
              `VARCHAR1` varchar(1024) default NULL,      
              `VARCHAR2` varchar(1024) default NULL,      
              `VARCHAR3` varchar(1024) default NULL,      
              `VARCHAR4` varchar(1024) default NULL,      
              `VARCHAR5` varchar(1024) default NULL,      
              `VARCHAR6` varchar(1024) default NULL,      
              `VARCHAR7` varchar(1024) default NULL,      
              `VARCHAR8` varchar(1024) default NULL,      
              `VARCHAR9` varchar(1024) default NULL,      
              `VARCHAR10` varchar(1024) default NULL,     
              `VARCHAR11` varchar(1024) default NULL,     
              `VARCHAR12` varchar(1024) default NULL,     
              `VARCHAR13` varchar(1024) default NULL,     
              `VARCHAR14` varchar(1024) default NULL,     
              `VARCHAR15` varchar(1024) default NULL, 
              `TIMESTAMP1` timestamp NULL,
              `TIMESTAMP2` timestamp NULL,
              `TIMESTAMP3` timestamp NULL,
              `TIMESTAMP4` timestamp NULL,
              `TIMESTAMP5` timestamp NULL,
              PRIMARY KEY  (`ID`)                 
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
		
CREATE TABLE `BOOM`.`AGENTS_EXT_LABELS` (
			  `COLUMNNAME` varchar(25) default NULL,
			  `LABEL` varchar(255) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;



INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'ID','ID' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='ID') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'EMAIL','Email' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='EMAIL') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'CONTACT','Contact person' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='CONTACT') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'LIT','Last Indication (Time)' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='LIT') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'ACID','Related Agent ID' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='ACID') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'EID','External ID' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='EID') limit 1;

INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT1','Long_1' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT1') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT2','Long_2' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT2') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT3','Long_3' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT3') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT4','Long_4' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT4') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT5','Long_5' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT5') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT6','Long_6' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT6') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT7','Long_7' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT7') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT8','Long_8' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT8') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT9','Long_9' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT9') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'BIGINT10','Long_10' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='BIGINT10') limit 1;

INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT1','Integer_1' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT1') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT2','Integer_2' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT2') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT3','Integer_3' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT3') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT4','Integer_4' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT4') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT5','Integer_5' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT5') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT6','Integer_6' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT6') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT7','Integer_7' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT7') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT8','Integer_8' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT8') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT9','Integer_9' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT9') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'INT10','Integer_10' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='INT10') limit 1;

INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE1','Double_1' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE1') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE2','Double_2' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE2') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE3','Double_3' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE3') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE4','Double_4' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE4') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE5','Double_5' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE5') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE6','Double_6' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE6') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE7','Double_7' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE7') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE8','Double_8' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE8') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE9','Double_9' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE9') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'DOUBLE10','Double_10' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='DOUBLE10') limit 1;

INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR1','Text1024_1' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR1') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR2','Text1024_2' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR2') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR3','Text1024_3' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR3') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR4','Text1024_4' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR4') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR5','Text1024_5' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR5') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR6','Text1024_6' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR6') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR7','Text1024_7' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR7') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR8','Text1024_8' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR8') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR9','Text1024_9' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR9') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR10','Text1024_10' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR10') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR11','Text1024_11' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR11') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR12','Text1024_12' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR12') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR13','Text1024_13' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR13') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR14','Text1024_14' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR14') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'VARCHAR15','Text1024_15' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='VARCHAR15') limit 1;

INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'TIMESTAMP1','Timestamp_1' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='TIMESTAMP1') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'TIMESTAMP2','Timestamp_2' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='TIMESTAMP2') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'TIMESTAMP3','Timestamp_3' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='TIMESTAMP3') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'TIMESTAMP4','Timestamp_4' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='TIMESTAMP4') limit 1;
INSERT INTO `BOOM`.`AGENTS_EXT_LABELS` (`COLUMNNAME`,`LABEL`) select 'TIMESTAMP5','Timestamp_5' from DUAL where not exists (select 1 from `BOOM`.`AGENTS_EXT_LABELS` where `COLUMNNAME`='TIMESTAMP5') limit 1;