/*
--- example creation of tablespaces
E.g. Unix:
CREATE SMALLFILE TABLESPACE "BOOM" LOGGING DATAFILE './ORADATA/ORCL/BOOM' SIZE 100M REUSE AUTOEXTEND ON NEXT 10240K MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO DEFAULT NOCOMPRESS
CREATE SMALLFILE TABLESPACE "BOOM_PERF" LOGGING DATAFILE './ORADATA/ORCL/BOOM_PERF' SIZE 100M REUSE AUTOEXTEND ON NEXT 10240K MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO DEFAULT NOCOMPRESS
E.g. Windows:
CREATE SMALLFILE TABLESPACE "BOOM" LOGGING DATAFILE 'E:/oracle/data/BOOM.ORA' SIZE 50M REUSE AUTOEXTEND ON NEXT 10240K MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO;
CREATE SMALLFILE TABLESPACE "BOOM_PERF" LOGGING DATAFILE 'E:/oracle/data/BOOM_PERF.ORA' SIZE 50M REUSE AUTOEXTEND ON NEXT 10240K MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO;

--- example creation of BOOM user
create user boom identified by boom DEFAULT TABLESPACE BOOM QUOTA UNLIMITED ON BOOM;
GRANT CONNECT TO BOOM;
GRANT CREATE SEQUENCE TO "BOOM";
GRANT CREATE TABLE TO "BOOM";
GRANT ALTER SESSION TO "BOOM";

--- example creation of BOOM_PERF user
create user boom_perf identified by boom DEFAULT TABLESPACE BOOM_PERF QUOTA UNLIMITED ON BOOM_PERF;
GRANT CONNECT TO BOOM_PERF;
GRANT CREATE SEQUENCE TO "BOOM_PERF";
GRANT CREATE TABLE TO "BOOM_PERF";
GRANT ALTER SESSION TO "BOOM_PERF";
 

*/

 ----------------------------
 -- DROP TABLE "INSTRUCTIONS";
 ----------------------------
  DROP TABLE "BOOM"."INSTRUCTIONS";
 ----------------------------
 -- DROP TABLE "AGENTS";
 ----------------------------
  DROP TABLE "BOOM"."AGENTS";
 ----------------------------
 -- DROP TABLE "EVENTS_A";
 ----------------------------
  DROP TABLE "BOOM"."EVENTS_A";
----------------------------
 -- DROP TABLE "EVENTS";
 ----------------------------
  DROP TABLE "BOOM"."EVENTS";
----------------------------
 -- DROP TABLE "ANNOTATIONS";
 ----------------------------
  DROP TABLE "BOOM"."ANNOTATIONS";
 ----------------------------
 -- DROP TABLE "USERS";
 ----------------------------
  DROP TABLE "BOOM"."USERS";
 ----------------------------
 -- DROP TABLE "ROLES";
 ----------------------------
  DROP TABLE "BOOM"."ROLES";
 ----------------------------
 -- DROP TABLE "ASSIGNMENTS";
 ----------------------------
  DROP TABLE "BOOM"."ASSIGNMENTS";
 ----------------------------
 -- DROP TABLE "ITEMS";
 ----------------------------
  DROP TABLE "BOOM"."ITEMS";
  ----------------------------
 -- DROP TABLE "EVENTS_EXT_A";
 ----------------------------
  DROP TABLE "BOOM"."EVENTS_EXT_A";
 ----------------------------
 -- DROP TABLE "EVENTS_EXT";
 ----------------------------
  DROP TABLE "BOOM"."EVENTS_EXT";
 ----------------------------
 -- DROP TABLE "RIGHTS";
 ----------------------------
  DROP TABLE "BOOM"."RIGHTS";
 ----------------------------
 -- DROP TABLE "EVENTS_TEMP";
 ---------------------------- 
  DROP TABLE "BOOM"."EVENTS_TEMP";

--------------------------------------------------------
--  DDL for Table INSTRUCTIONS
--------------------------------------------------------

  CREATE TABLE "BOOM"."INSTRUCTIONS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"HELP" CLOB DEFAULT NULL
   ) ;
 
--------------------------------------------------------
--  DDL for Table AGENTS
--------------------------------------------------------

  CREATE TABLE "BOOM"."AGENTS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"HOSTNAME" VARCHAR2(255) DEFAULT NULL, 
	"IP" VARCHAR2(255) DEFAULT NULL, 
	"MODE" NUMBER DEFAULT NULL, 
	"DESCRIPTION" VARCHAR2(1024) DEFAULT NULL, 
	"LABEL" VARCHAR2(255) DEFAULT NULL, 
	"OS" VARCHAR2(255) DEFAULT NULL, 
	"APPROVED" NUMBER DEFAULT 1, 
	"DISABLED" NUMBER DEFAULT 0,
	"PORT" NUMBER DEFAULT NULL
   ) ;
 
--------------------------------------------------------
--  DDL for Table EVENTS_A
--------------------------------------------------------

  CREATE TABLE "BOOM"."EVENTS_A" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"SERVICE" VARCHAR2(1024 CHAR) DEFAULT '',
	"NODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"APPLICATION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OBJECT" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGGRP" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGTEXT" CLOB DEFAULT NULL,
	"TIME" NUMBER(20,0),
	"MSGKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"ACKKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"SEVERITY" NUMBER(2,0) DEFAULT 0,
	"DUPL" NUMBER DEFAULT 0,
	"STATE" CHAR(1) DEFAULT '-',
	"INSTRUCTIONID" CHAR(36) DEFAULT NULL,
	"AUTOACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OPACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"STIME" NUMBER(20,0) DEFAULT NULL,
	"SOURCE" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"VALUE" FLOAT(126) DEFAULT NULL,
	"MONITOR" VARCHAR2(1024 CHAR) DEFAULT '',
	"AGENTNODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"ANNOT" NUMBER DEFAULT NULL,
	"TYPE_A" NUMBER(1,0) DEFAULT NULL,
	"TYPE_K" NUMBER(1,0) DEFAULT NULL,
	"FTIME" NUMBER(20,0) DEFAULT NULL
   ) ;
 
--------------------------------------------------------
--  DDL for Table EVENTS
--------------------------------------------------------

  CREATE TABLE "BOOM"."EVENTS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"SERVICE" VARCHAR2(1024 CHAR) DEFAULT '',
	"NODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"APPLICATION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OBJECT" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGGRP" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGTEXT" CLOB DEFAULT NULL,
	"TIME" NUMBER(20,0),
	"MSGKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"ACKKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"SEVERITY" NUMBER(2,0) DEFAULT 0,
	"DUPL" NUMBER DEFAULT 0,
	"STATE" CHAR(1) DEFAULT '-',
	"INSTRUCTIONID" CHAR(36) DEFAULT NULL,
	"AUTOACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OPACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"STIME" NUMBER(20,0) DEFAULT NULL,
	"SOURCE" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"VALUE" FLOAT(126) DEFAULT NULL,
	"MONITOR" VARCHAR2(1024 CHAR) DEFAULT '',
	"AGENTNODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"ANNOT" NUMBER DEFAULT NULL,
	"TYPE_A" NUMBER(1,0) DEFAULT NULL,
	"TYPE_K" NUMBER(1,0) DEFAULT NULL,
	"FTIME" NUMBER(20,0) DEFAULT NULL,
	 CONSTRAINT "EVENTS_PK" PRIMARY KEY ("ID") ENABLE
   ) ;
 
--------------------------------------------------------
--  DDL for Table ANNOTATIONS
--------------------------------------------------------

  CREATE TABLE "BOOM"."ANNOTATIONS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"ANNOTATION" CLOB, 
	"TIME" NUMBER, 
	"STATUS" VARCHAR2(3 CHAR)
   ) ;
 
--------------------------------------------------------
--  DDL for Table USERS
--------------------------------------------------------

  CREATE TABLE "BOOM"."USERS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"LOGIN" VARCHAR2(255 CHAR) NOT NULL ENABLE, 
	"PASSWORD" VARCHAR2(255 CHAR) NOT NULL ENABLE, 
	"FIRSTNAME" VARCHAR2(255 CHAR) DEFAULT NULL, 
	"LASTNAME" VARCHAR2(255 CHAR) DEFAULT NULL, 
	"ROLE_ID" CHAR(36) DEFAULT '', 
	"EMAIL" VARCHAR2(1024 CHAR) DEFAULT NULL, 
	"PHONE" VARCHAR2(1024 CHAR) DEFAULT NULL, 
	"PAGER" VARCHAR2(1024 CHAR) DEFAULT NULL, 
	"ACTIVE" NUMBER(1,0) DEFAULT 1 NOT NULL ENABLE, 
	 PRIMARY KEY ("ID") ENABLE
   ) ;
 
--------------------------------------------------------
--  DDL for Table ROLES
--------------------------------------------------------

  CREATE TABLE "BOOM"."ROLES" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"ROLENAME" VARCHAR2(250 CHAR) NOT NULL ENABLE, 
	"DESCRIPTION" VARCHAR2(250 CHAR) DEFAULT '', 
	 PRIMARY KEY ("ID", "ROLENAME") ENABLE
   ) ;
 
--------------------------------------------------------
--  DDL for Table ASSIGNMENTS
--------------------------------------------------------

  CREATE TABLE "BOOM"."ASSIGNMENTS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"AGENT_ID" CHAR(36) NOT NULL ENABLE, 
	"ASSIGNMENT" VARCHAR2(100) NOT NULL ENABLE, 
	"_TYPE" CHAR(3) DEFAULT 'pga', 
	"FTIME" NUMBER DEFAULT NULL, 
	"UTIME" NUMBER DEFAULT NULL, 
	"USER" VARCHAR2(100) DEFAULT NULL, 
	"_LOCK" NUMBER DEFAULT 0, 
	 CONSTRAINT "ASSIGNMENTS_PK" PRIMARY KEY ("ID") ENABLE
   ) ;
 

--------------------------------------------------------
--  DDL for Table ITEMS
--------------------------------------------------------

  CREATE TABLE "BOOM"."ITEMS" 
   (	"ID" NUMBER(10,0) NOT NULL ENABLE, 
	"NAME" VARCHAR2(255 CHAR) NOT NULL ENABLE, 
	"DESCRIPTION" VARCHAR2(255 CHAR) DEFAULT NULL
   ) ;
 
 
--------------------------------------------------------
--  DDL for Table EVENTS_EXT_A
--------------------------------------------------------

  CREATE TABLE "BOOM"."EVENTS_EXT_A" 
   (	"ID_E" CHAR(36) NOT NULL ENABLE, 
	"SRV" VARCHAR2(1024 CHAR), 
	"SRVTYPE" VARCHAR2(1024) DEFAULT 0, 
	"EXTID" CHAR(36), 
	"T1" VARCHAR2(1024), 
	"T2" VARCHAR2(1024), 
	"T3" VARCHAR2(1024), 
	"T4" VARCHAR2(1024), 
	"T5" VARCHAR2(1024), 
	"T6" VARCHAR2(1024), 
	"T7" VARCHAR2(1024), 
	"T8" VARCHAR2(1024), 
	"T9" VARCHAR2(1024), 
	"T10" VARCHAR2(1024), 
	"TFA" VARCHAR2(50), 
	"VFA" VARCHAR2(50), 
	"CA1" VARCHAR2(1024), 
	"CA2" VARCHAR2(1024), 
	"CA3" VARCHAR2(1024), 
	"CA4" VARCHAR2(1024), 
	"CA5" VARCHAR2(1024), 
	"CA6" VARCHAR2(1024), 
	"CA7" VARCHAR2(1024), 
	"CA8" VARCHAR2(1024), 
	"CA9" VARCHAR2(1024), 
	"CA10" VARCHAR2(1024), 
	"CA11" VARCHAR2(1024), 
	"CA12" VARCHAR2(1024), 
	"CA13" VARCHAR2(1024), 
	"CA14" VARCHAR2(1024), 
	"CA15" VARCHAR2(1024), 
	 CONSTRAINT "EVENTS_EXT_A_PK" PRIMARY KEY ("ID_E") ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table EVENTS_EXT
--------------------------------------------------------

  CREATE TABLE "BOOM"."EVENTS_EXT" 
   (	"ID_E" CHAR(36) NOT NULL ENABLE, 
	"SRV" VARCHAR2(1024 CHAR), 
	"SRVTYPE" VARCHAR2(1024) DEFAULT 0, 
	"EXTID" CHAR(36), 
	"T1" VARCHAR2(1024), 
	"T2" VARCHAR2(1024), 
	"T3" VARCHAR2(1024), 
	"T4" VARCHAR2(1024), 
	"T5" VARCHAR2(1024), 
	"T6" VARCHAR2(1024), 
	"T7" VARCHAR2(1024), 
	"T8" VARCHAR2(1024), 
	"T9" VARCHAR2(1024), 
	"T10" VARCHAR2(1024), 
	"TFA" VARCHAR2(50), 
	"VFA" VARCHAR2(50), 
	"CA1" VARCHAR2(1024), 
	"CA2" VARCHAR2(1024), 
	"CA3" VARCHAR2(1024), 
	"CA4" VARCHAR2(1024), 
	"CA5" VARCHAR2(1024), 
	"CA6" VARCHAR2(1024), 
	"CA7" VARCHAR2(1024), 
	"CA8" VARCHAR2(1024), 
	"CA9" VARCHAR2(1024), 
	"CA10" VARCHAR2(1024), 
	"CA11" VARCHAR2(1024), 
	"CA12" VARCHAR2(1024), 
	"CA13" VARCHAR2(1024), 
	"CA14" VARCHAR2(1024), 
	"CA15" VARCHAR2(1024), 
	 CONSTRAINT "EVENTS_EXT_PK" PRIMARY KEY ("ID_E") ENABLE
   ) ;
 
--------------------------------------------------------
--  DDL for Table RIGHTS
--------------------------------------------------------

  CREATE TABLE "BOOM"."RIGHTS" 
   (	"ROLE_ID" CHAR(36) NOT NULL ENABLE, 
	"ITEM_ID" NUMBER(10,0) NOT NULL ENABLE, 
	"DISABLED" NUMBER(1,0) DEFAULT 1 NOT NULL ENABLE, 
	"GUEST" NUMBER(1,0) DEFAULT 0 NOT NULL ENABLE, 
	"OWNER" NUMBER(1,0) DEFAULT 0 NOT NULL ENABLE, 
	 PRIMARY KEY ("ROLE_ID", "ITEM_ID") ENABLE
   ) ;

   ----------------------------
-- DROP INDEX "BOOM_ANNOTATIONS_INDEX1";
----------------------------
  DROP INDEX "BOOM"."BOOM_ANNOTATIONS_INDEX1";

--------------------------------------------------------
--  DDL for Index BOOM_ANNOTATIONS_INDEX1
--------------------------------------------------------

  CREATE INDEX "BOOM"."BOOM_ANNOTATIONS_INDEX1" ON "BOOM"."ANNOTATIONS" ("ID");

----------------------------
-- DROP INDEX "EVENTS_STATE";
----------------------------
  DROP INDEX "BOOM"."EVENTS_STATE";

--------------------------------------------------------
--  DDL for Index EVENTS_STATE
--------------------------------------------------------

  CREATE BITMAP INDEX "BOOM"."EVENTS_STATE" ON "BOOM"."EVENTS" ("STATE");
 
 ----------------------------
 -- DROP INDEX "EVENTS_NODE";
 ----------------------------
  DROP INDEX "BOOM"."EVENTS_NODE";

--------------------------------------------------------
--  DDL for Index EVENTS_NODE
--------------------------------------------------------

  CREATE INDEX "BOOM"."EVENTS_NODE" ON "BOOM"."EVENTS" ("NODE");
--------------------------------------------------------
--  DDL for Index EVENTS_A_STIME
--------------------------------------------------------

  CREATE INDEX "BOOM"."EVENTS_A_STIME" ON "BOOM"."EVENTS_A" ("STIME");
 
 ---------------------------------------------------
--   DATA FOR TABLE ITEMS
--   FILTER = none used
---------------------------------------------------
REM INSERTING into ITEMS
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1000,'Indications','Access to the Indication View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1001,'Policies','Access to the Policies View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1002,'Hosts','Access to the Hosts View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1003,'Statistic','Access to the Statistic View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1004,'User Management','Access to the User Management View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1005,'Operator Remote Actions','Allow to execute Operator Actions defined in Indications');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1006,'Packages','Access to the Packages View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1007,'Actions','Access to the Actions View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1008,'Assignments','Access to the Assignments View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1009,'Server Filters','Access to the Server Filters View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (1010,'Service Tree','Access to the Service Tree');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2001,'Service Dashboard (Global)','Allow configuration of the Global Service Dashboard');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2002,'Service Dashboard (Local)','Allow configuration of the Local Service Dashboard');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2003,'Server Jobs','Access to the Server Jobs View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2004,'Server Configuration', 'Access to the Server Configuration View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2010,'Scheduled Maintenance', 'Access to the Scheduled Maintenance View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2011,'AdHoc Maintenance', 'Access to the AdHoc Maintenance View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2012,'Server Policies', 'Access to the Server Policies View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2014,'Notification Interfaces','Access to the Notifications View');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2015,'Extended Agent Attributes','Allow to see or edit Extended Agent Attributes');
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) values (2016,'Maintenance Indications','Access to the Maintenance Indications View');

---------------------------------------------------
--   END DATA FOR TABLE ITEMS
---------------------------------------------------

---------------------------------------------------
--   DATA FOR TABLE RIGHTS
--   FILTER = none used
---------------------------------------------------
REM INSERTING into RIGHTS

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1000,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1001,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1002,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1003,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1004,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1005,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1006,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1007,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1008,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1009,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',1010,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2001,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2002,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2003,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2004,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2010,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2011,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2012,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2014,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2015,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2',2016,0,0,1);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1000,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1001,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1002,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1003,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1004,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1005,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1006,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1007,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1008,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1009,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1010,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2001,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2002,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2003,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2004,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2010,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2011,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2012,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2014,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2015,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2016,0,0,1);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1000,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1001,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1002,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1003,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1004,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1005,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1006,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1007,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1008,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1009,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1010,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2001,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2002,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2003,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2004,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2010,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2011,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2012,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2014,1,0,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2015,0,1,0);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2016,0,0,1);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1000,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1001,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1002,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1003,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1004,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1005,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1006,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1007,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1008,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1009,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',1010,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2001,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2002,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2003,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2004,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2010,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2011,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2012,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2014,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2015,0,0,1);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a',2016,0,0,1);

---------------------------------------------------
--   END DATA FOR TABLE RIGHTS
---------------------------------------------------

---------------------------------------------------
--   DATA FOR TABLE ROLES
--   FILTER = none used
---------------------------------------------------
REM INSERTING into ROLES
insert into "BOOM"."ROLES" (ID,ROLENAME,DESCRIPTION) values ('ae99710f-f2da-4862-b292-f1afd88dd5a2','DB Admins','Sample group');
insert into "BOOM"."ROLES" (ID,ROLENAME,DESCRIPTION) values ('bb1c817f-a3be-42e4-bcbf-be3ff43f4638','Default','Sample group');
insert into "BOOM"."ROLES" (ID,ROLENAME,DESCRIPTION) values ('c16dc28c-69c3-498a-b6e8-6ff3990a5cfa','Operator Team A','Sample Operator group');
insert into "BOOM"."ROLES" (ID,ROLENAME,DESCRIPTION) values ('dec7d845-ef3e-4400-980e-f6f54e9b357a','Administrator','Admin group');

---------------------------------------------------
--   END DATA FOR TABLE ROLES
---------------------------------------------------

---------------------------------------------------
--   DATA FOR TABLE USERS
--   FILTER = none used
---------------------------------------------------
REM INSERTING into USERS
insert into "BOOM"."USERS" (ID,LOGIN,PASSWORD,FIRSTNAME,LASTNAME,ROLE_ID,EMAIL,PHONE,PAGER,ACTIVE) values ('8970e735-f341-405b-b82c-5df9e7e56745','dbadm1','405403402405414354','John','Doe','ae99710f-f2da-4862-b292-f1afd88dd5a2','john.doe@gmail.com','','',1);
insert into "BOOM"."USERS" (ID,LOGIN,PASSWORD,FIRSTNAME,LASTNAME,ROLE_ID,EMAIL,PHONE,PAGER,ACTIVE) values ('92eb765e-0e0d-44d7-8088-2ecd1b08a4bc','dbadm2','405403402405414355','Jane','Doe','ae99710f-f2da-4862-b292-f1afd88dd5a2','jane.doe@gmail.com','','',1);
insert into "BOOM"."USERS" (ID,LOGIN,PASSWORD,FIRSTNAME,LASTNAME,ROLE_ID,EMAIL,PHONE,PAGER,ACTIVE) values ('e0e9a67c-89d8-4156-a0be-6f79b01a9e9d','admin','402405414410415','','Admin','dec7d845-ef3e-4400-980e-f6f54e9b357a','','','',1);
---------------------------------------------------
--   END DATA FOR TABLE USERS
---------------------------------------------------

 CREATE TABLE "BOOM"."EVENTS_TEMP" 
   ( "ID" CHAR(36) DEFAULT '' NOT NULL) ;
   
 CREATE INDEX "BOOM"."EVENTS_TEMP_ID" ON "BOOM"."EVENTS_TEMP" ("ID");
