/*
Pre-requisite to execute this script:
	BOOM schema already created.
	
*/

DROP TABLE "BOOM"."O_AGENTS";
DROP TABLE "BOOM"."O_ANNOTATIONS";
DROP TABLE "BOOM"."O_EVENTS";
DROP TABLE "BOOM"."O_EVENTS_EXT";
--------------------------------------------------------
--  DDL for Table O_AGENTS
-------------------------------------------------------- 
CREATE TABLE "BOOM"."O_AGENTS"
 (		"ID" CHAR(36 byte) NOT NULL ENABLE, 
		"AGENTID" CHAR(36 byte) NOT NULL, 
		"PATTERNS" VARCHAR2(2048 byte) NOT NULL, 
		"STARTTIME" NUMBER(20) DEFAULT 0 NOT NULL, 
        	"EXPDURATION" NUMBER(20) DEFAULT 0, 
		"ENDTIME" NUMBER(20) DEFAULT 0, 
		"ENABLED" NUMBER(2) DEFAULT 0 NOT NULL, 
		"DISABLEDBY" VARCHAR2(255 byte), 
		"ACTION" NUMBER(2) DEFAULT 3 NOT NULL, 
		"POSTACTION" NUMBER(2) DEFAULT 0 NOT NULL, 
		"INTERVAL" NUMBER(20),
		CONSTRAINT "O_AGENTS_PK" PRIMARY KEY ("ID") ENABLE
 ) ;
--------------------------------------------------------
--  DDL for Table O_ANNOTATIONS
-------------------------------------------------------- 
 CREATE TABLE "BOOM"."O_ANNOTATIONS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"ANNOTATION" CLOB, 
	"TIME" NUMBER, 
	"STATUS" VARCHAR2(3 CHAR)
   ) ;
--------------------------------------------------------
--  DDL for Table O_EVENTS
--------------------------------------------------------   
  CREATE TABLE "BOOM"."O_EVENTS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"SERVICE" VARCHAR2(1024 CHAR) DEFAULT '',
	"NODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"APPLICATION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OBJECT" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGGRP" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGTEXT" CLOB DEFAULT NULL,
	"TIME" NUMBER(20,0),
	"MSGKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"ACKKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"SEVERITY" NUMBER(2,0) DEFAULT 0,
	"DUPL" NUMBER DEFAULT 0,
	"STATE" CHAR(1) DEFAULT '-',
	"INSTRUCTIONID" CHAR(36) DEFAULT NULL,
	"AUTOACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OPACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"STIME" NUMBER(20,0) DEFAULT NULL,
	"SOURCE" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"VALUE" FLOAT(126) DEFAULT NULL,
	"MONITOR" VARCHAR2(1024 CHAR) DEFAULT '',
	"AGENTNODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"ANNOT" NUMBER DEFAULT NULL,
	"TYPE_A" NUMBER(1,0) DEFAULT NULL,
	"TYPE_K" NUMBER(1,0) DEFAULT NULL,
	"FTIME" NUMBER(20,0) DEFAULT NULL,
	 CONSTRAINT "O_EVENTS_PK" PRIMARY KEY ("ID") ENABLE
   ) ;
   
--------------------------------------------------------
--  DDL for Table O_EVENTS_EXT
--------------------------------------------------------

  CREATE TABLE "BOOM"."O_EVENTS_EXT" 
   (	"ID_E" CHAR(36) NOT NULL ENABLE, 
	"SRV" VARCHAR2(1024 CHAR), 
	"SRVTYPE" VARCHAR2(1024) DEFAULT 0, 
	"EXTID" CHAR(36), 
	"T1" VARCHAR2(1024), 
	"T2" VARCHAR2(1024), 
	"T3" VARCHAR2(1024), 
	"T4" VARCHAR2(1024), 
	"T5" VARCHAR2(1024), 
	"T6" VARCHAR2(1024), 
	"T7" VARCHAR2(1024), 
	"T8" VARCHAR2(1024), 
	"T9" VARCHAR2(1024), 
	"T10" VARCHAR2(1024), 
	"TFA" VARCHAR2(50), 
	"VFA" VARCHAR2(50), 
	"CA1" VARCHAR2(1024), 
	"CA2" VARCHAR2(1024), 
	"CA3" VARCHAR2(1024), 
	"CA4" VARCHAR2(1024), 
	"CA5" VARCHAR2(1024), 
	"CA6" VARCHAR2(1024), 
	"CA7" VARCHAR2(1024), 
	"CA8" VARCHAR2(1024), 
	"CA9" VARCHAR2(1024), 
	"CA10" VARCHAR2(1024), 
	"CA11" VARCHAR2(1024), 
	"CA12" VARCHAR2(1024), 
	"CA13" VARCHAR2(1024), 
	"CA14" VARCHAR2(1024), 
	"CA15" VARCHAR2(1024), 
	 CONSTRAINT "O_EVENTS_EXT_PK" PRIMARY KEY ("ID_E") ENABLE
   ) ;
  
  DROP INDEX "BOOM"."O_ANNOTATIONS";
  CREATE INDEX "BOOM"."O_ANNOTATIONS" ON "BOOM"."O_ANNOTATIONS" ("ID");
   
  DROP INDEX "BOOM"."O_EVENTS_STATE";
  CREATE BITMAP INDEX "BOOM"."O_EVENTS_STATE" ON "BOOM"."O_EVENTS" ("STATE");
 
  DROP INDEX "BOOM"."O_EVENTS_NODE";
  CREATE INDEX "BOOM"."O_EVENTS_NODE" ON "BOOM"."O_EVENTS" ("NODE");
