/*
	This script will update the Oracle boom database layout of Version 1.x/2.x/3.x
        to the latest 4.00 layout.
*/
ALTER TABLE "BOOM"."AGENTS" MODIFY("IP" VARCHAR2(255));
ALTER TABLE "BOOM"."ANNOTATIONS" MODIFY("STATUS" VARCHAR2(3));
ALTER TABLE "BOOM"."EVENTS" MODIFY("SERVICE" VARCHAR2(1024), "APPLICATION" VARCHAR2(1024), "OBJECT" VARCHAR2(1024), "MSGGRP" VARCHAR2(1024), "MSGKEY" VARCHAR2(1024), "ACKKEY" VARCHAR2(1024), "SOURCE" VARCHAR2(1024), "MONITOR" VARCHAR2(1024));
ALTER TABLE "BOOM"."EVENTS_A" MODIFY("SERVICE" VARCHAR2(1024), "APPLICATION" VARCHAR2(1024), "OBJECT" VARCHAR2(1024), "MSGGRP" VARCHAR2(1024), "MSGKEY" VARCHAR2(1024), "ACKKEY" VARCHAR2(1024), "SOURCE" VARCHAR2(1024), "MONITOR" VARCHAR2(1024));
ALTER TABLE "BOOM"."ITEMS" MODIFY("NAME" VARCHAR2(255), "DESCRIPTION" VARCHAR2(255));
ALTER TABLE "BOOM"."USERS" MODIFY("LOGIN" VARCHAR2(255), "PASSWORD" VARCHAR2(255), "FIRSTNAME" VARCHAR2(255), "LASTNAME" VARCHAR2(255));
/* add new data */
Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 1010,'Service Tree','Access to the Service Tree'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=1010);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',1010,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=1010);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',1010,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=1010);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',1010,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=1010);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',1010,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=1010);


Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2001,'Service Dashboard (Global)','Allow configuration of the Global Service Dashboard'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2001);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2001,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2001);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2001,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2001);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2001,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2001);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2001,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2001);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2002,'Service Dashboard (Local)','Allow configuration of the Local Service Dashboard'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2002);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2002,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2002);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2002,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2002);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2002,0,1,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2002);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2002,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2002);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2003,'Server Jobs','Access to the Server Jobs View'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2003);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2003,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2003);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2003,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2003);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2003,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2003);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2003,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2003);


Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2004, 'Server Configuration', 'Access to the Server Configuration View'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2004);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2004,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2004);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2004,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2004);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2004,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2004);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2004,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2004);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2010, 'Scheduled Maintenance', 'Access to the Scheduled Maintenance View'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2010);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2010,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2010);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2010,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2010);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2010,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2010);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2010,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2010);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2011, 'AdHoc Maintenance', 'Access to the AdHoc Maintenance View'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2011);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2011,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2011);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2011,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2011);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2011,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2011);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2011,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2011);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2012, 'Server Policies', 'Access to the Server Policies View'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2012);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2012,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2012);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2012,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2012);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2012,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2012);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2012,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2012);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2014, 'Notification Interfaces', 'Access to the Notifications View'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2014);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2014,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2014);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2014,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2014);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2014,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2014);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2014,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2014);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2015, 'Extended Agent Attributes', 'Allow to see or edit Extended Agent Attributes'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2015);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2015,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2015);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2015,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2015);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2015,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2015);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2015,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2015);

Insert into "BOOM"."ITEMS" (ID,NAME,DESCRIPTION) select 2016, 'Maintenance Indications', 'Access to the Maintenance Indications View'
from dual where not exists (select 1 from "BOOM"."ITEMS" where ID=2016);

insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'ae99710f-f2da-4862-b292-f1afd88dd5a2',2016,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='ae99710f-f2da-4862-b292-f1afd88dd5a2' and ITEM_ID=2016);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'bb1c817f-a3be-42e4-bcbf-be3ff43f4638',2016,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='bb1c817f-a3be-42e4-bcbf-be3ff43f4638' and ITEM_ID=2016);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'c16dc28c-69c3-498a-b6e8-6ff3990a5cfa',2016,1,0,0
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='c16dc28c-69c3-498a-b6e8-6ff3990a5cfa' and ITEM_ID=2016);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2016,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2016);

UPDATE "BOOM"."ITEMS" SET NAME='Indications', DESCRIPTION='Access to the Indication View' WHERE ID='1000';
UPDATE "BOOM"."ITEMS" SET NAME='Policies', DESCRIPTION='Access to the Policies View' WHERE ID='1001';
UPDATE "BOOM"."ITEMS" SET NAME='Hosts', DESCRIPTION='Access to the Hosts View' WHERE ID='1002';
UPDATE "BOOM"."ITEMS" SET NAME='Statistic', DESCRIPTION='Access to the Statistic View' WHERE ID='1003';
UPDATE "BOOM"."ITEMS" SET NAME='User Management', DESCRIPTION='Access to the User Management View' WHERE ID='1004';
UPDATE "BOOM"."ITEMS" SET NAME='Operator Remote Actions', DESCRIPTION='Allow to execute Operator Actions defined in Indications' WHERE ID='1005';
UPDATE "BOOM"."ITEMS" SET NAME='Packages', DESCRIPTION='Access to the Packages View' WHERE ID='1006';
UPDATE "BOOM"."ITEMS" SET NAME='Actions', DESCRIPTION='Access to the Actions View' WHERE ID='1007';
UPDATE "BOOM"."ITEMS" SET NAME='Assignments', DESCRIPTION='Access to the Assignments View' WHERE ID='1008';
UPDATE "BOOM"."ITEMS" SET NAME='Server Filters', DESCRIPTION='Access to the Server Filters View' WHERE ID='1009';
UPDATE "BOOM"."ITEMS" SET NAME='Service Tree', DESCRIPTION='Access to the Service Tree' WHERE ID='1010';

UPDATE "BOOM"."ITEMS" SET NAME='Service Dashboard (Global)', DESCRIPTION='Allow configuration of the Global Service Dashboard' WHERE ID='2001';
UPDATE "BOOM"."ITEMS" SET NAME='Service Dashboard (Local)', DESCRIPTION='Allow configuration of the Local Service Dashboard' WHERE ID='2002';
UPDATE "BOOM"."ITEMS" SET NAME='Server Jobs', DESCRIPTION='Access to the Server Jobs View' WHERE ID='2003';
UPDATE "BOOM"."ITEMS" SET NAME='Server Configuration', DESCRIPTION='Access to the Server Configuration View' WHERE ID='2004';

UPDATE "BOOM"."ITEMS" SET NAME='Scheduled Maintenance', DESCRIPTION='Access to the Scheduled Maintenance View' WHERE ID='2010';
UPDATE "BOOM"."ITEMS" SET NAME='AdHoc Maintenance', DESCRIPTION='Access to the AdHoc Maintenance View' WHERE ID='2011';
UPDATE "BOOM"."ITEMS" SET NAME='Server Policies', DESCRIPTION='Access to the Server Policies View' WHERE ID='2012';

UPDATE "BOOM"."ITEMS" SET NAME='Notification Interfaces', DESCRIPTION='Access to the Notifications View' WHERE ID='2014';
UPDATE "BOOM"."ITEMS" SET NAME='Extended Agent Attributes', DESCRIPTION='Allow to see or edit Extended Agent Attributes' WHERE ID='2015';

commit;
CREATE INDEX "BOOM"."EVENTS_A_STIME" ON "BOOM"."EVENTS_A" ("STIME");
commit;
ALTER TABLE "BOOM"."AGENTS" ADD ("PORT" NUMBER NULL);
commit;
--------------------------------------------------------
--  DDL for Table O_AGENTS
-------------------------------------------------------- 
CREATE TABLE "BOOM"."O_AGENTS"
 (		"ID" CHAR(36 byte) NOT NULL ENABLE, 
		"AGENTID" CHAR(36 byte) NOT NULL, 
		"PATTERNS" VARCHAR2(2048 byte) NOT NULL, 
		"STARTTIME" NUMBER(20) DEFAULT 0 NOT NULL, 
        	"EXPDURATION" NUMBER(20) DEFAULT 0, 
		"ENDTIME" NUMBER(20) DEFAULT 0, 
		"ENABLED" NUMBER(2) DEFAULT 0 NOT NULL, 
		"DISABLEDBY" VARCHAR2(255 byte), 
		"ACTION" NUMBER(2) DEFAULT 3 NOT NULL, 
		"POSTACTION" NUMBER(2) DEFAULT 0 NOT NULL, 
		"INTERVAL" NUMBER(20),
		CONSTRAINT "O_AGENTS_PK" PRIMARY KEY ("ID") ENABLE
 ) ;
--------------------------------------------------------
--  DDL for Table O_ANNOTATIONS
-------------------------------------------------------- 
 CREATE TABLE "BOOM"."O_ANNOTATIONS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"ANNOTATION" CLOB, 
	"TIME" NUMBER, 
	"STATUS" VARCHAR2(3 CHAR)
   ) ;
--------------------------------------------------------
--  DDL for Table O_EVENTS
--------------------------------------------------------   
  CREATE TABLE "BOOM"."O_EVENTS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
	"SERVICE" VARCHAR2(1024 CHAR) DEFAULT '',
	"NODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"APPLICATION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OBJECT" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGGRP" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"MSGTEXT" CLOB DEFAULT NULL,
	"TIME" NUMBER(20,0),
	"MSGKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"ACKKEY" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"SEVERITY" NUMBER(2,0) DEFAULT 0,
	"DUPL" NUMBER DEFAULT 0,
	"STATE" CHAR(1) DEFAULT '-',
	"INSTRUCTIONID" CHAR(36) DEFAULT NULL,
	"AUTOACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"OPACTION" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"STIME" NUMBER(20,0) DEFAULT NULL,
	"SOURCE" VARCHAR2(1024 CHAR) DEFAULT NULL,
	"VALUE" FLOAT(126) DEFAULT NULL,
	"MONITOR" VARCHAR2(1024 CHAR) DEFAULT '',
	"AGENTNODE" VARCHAR2(255 CHAR) DEFAULT NULL,
	"ANNOT" NUMBER DEFAULT NULL,
	"TYPE_A" NUMBER(1,0) DEFAULT NULL,
	"TYPE_K" NUMBER(1,0) DEFAULT NULL,
	"FTIME" NUMBER(20,0) DEFAULT NULL,
	 CONSTRAINT "O_EVENTS_PK" PRIMARY KEY ("ID") ENABLE
   ) ;
   
--------------------------------------------------------
--  DDL for Table O_EVENTS_EXT
--------------------------------------------------------

  CREATE TABLE "BOOM"."O_EVENTS_EXT" 
   (	"ID_E" CHAR(36) NOT NULL ENABLE, 
	"SRV" VARCHAR2(1024 CHAR), 
	"SRVTYPE" VARCHAR2(1024) DEFAULT 0, 
	"EXTID" CHAR(36), 
	"T1" VARCHAR2(1024), 
	"T2" VARCHAR2(1024), 
	"T3" VARCHAR2(1024), 
	"T4" VARCHAR2(1024), 
	"T5" VARCHAR2(1024), 
	"T6" VARCHAR2(1024), 
	"T7" VARCHAR2(1024), 
	"T8" VARCHAR2(1024), 
	"T9" VARCHAR2(1024), 
	"T10" VARCHAR2(1024), 
	"TFA" VARCHAR2(50), 
	"VFA" VARCHAR2(50), 
	"CA1" VARCHAR2(1024), 
	"CA2" VARCHAR2(1024), 
	"CA3" VARCHAR2(1024), 
	"CA4" VARCHAR2(1024), 
	"CA5" VARCHAR2(1024), 
	"CA6" VARCHAR2(1024), 
	"CA7" VARCHAR2(1024), 
	"CA8" VARCHAR2(1024), 
	"CA9" VARCHAR2(1024), 
	"CA10" VARCHAR2(1024), 
	"CA11" VARCHAR2(1024), 
	"CA12" VARCHAR2(1024), 
	"CA13" VARCHAR2(1024), 
	"CA14" VARCHAR2(1024), 
	"CA15" VARCHAR2(1024), 
	 CONSTRAINT "O_EVENTS_EXT_PK" PRIMARY KEY ("ID_E") ENABLE
   ) ;


  CREATE INDEX "BOOM"."O_ANNOTATIONS" ON "BOOM"."O_ANNOTATIONS" ("ID");

  CREATE BITMAP INDEX "BOOM"."O_EVENTS_STATE" ON "BOOM"."O_EVENTS" ("STATE");

  CREATE INDEX "BOOM"."O_EVENTS_NODE" ON "BOOM"."O_EVENTS" ("NODE");
  
--------------------------------------------------------
--  DDL for Table PGITEMS
-------------------------------------------------------- 
  CREATE TABLE "BOOM"."PGITEMS"
	(	"PGID" CHAR(36 byte) NOT NULL, 
		"PGI" VARCHAR2(2048 byte) DEFAULT NULL
	) ;
--------------------------------------------------------
--  DDL for Table PGRIGHTS
-------------------------------------------------------- 
  CREATE TABLE "BOOM"."PGRIGHTS" 
	(	"ROLEID" CHAR(36) NOT NULL, 
		"PGID" CHAR(36) NOT NULL
	) ;
--------------------------------------------------------
--  DDL for Table PGROUPS
--------------------------------------------------------   
  CREATE TABLE "BOOM"."PGROUPS" 
   (	"ID" CHAR(36) NOT NULL ENABLE, 
		"NAME" VARCHAR2(255 CHAR) DEFAULT '',
		"DESCRIPTION" VARCHAR2(2048 CHAR) DEFAULT '',
		CONSTRAINT "O_PGROUPS_PK" PRIMARY KEY ("ID") ENABLE
   ) ;

   CREATE TABLE "BOOM"."AGENTS_EXT" (             
              "ID" CHAR(36) NOT NULL ENABLE,  
              "EMAIL" VARCHAR2(255 CHAR),
              "CONTACT" VARCHAR2(1024 CHAR),
              "LIT" NUMBER(20,0) DEFAULT 0,   
              "EID" VARCHAR2(255 CHAR),
              "ACID" VARCHAR2(255 CHAR) DEFAULT NULL, 
              "BIGINT1" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT2" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT3" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT4" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT5" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT6" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT7" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT8" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT9" NUMBER(20,0) DEFAULT NULL,       
              "BIGINT10" NUMBER(20,0) DEFAULT NULL,
              "INT1" NUMBER(11,0) DEFAULT NULL,       
              "INT2" NUMBER(11,0) DEFAULT NULL,       
              "INT3" NUMBER(11,0) DEFAULT NULL,       
              "INT4" NUMBER(11,0) DEFAULT NULL,       
              "INT5" NUMBER(11,0) DEFAULT NULL,       
              "INT6" NUMBER(11,0) DEFAULT NULL,       
              "INT7" NUMBER(11,0) DEFAULT NULL,       
              "INT8" NUMBER(11,0) DEFAULT NULL,       
              "INT9" NUMBER(11,0) DEFAULT NULL,       
              "INT10" NUMBER(11,0) DEFAULT NULL,
              "DOUBLE1" FLOAT(126) DEFAULT NULL,       
              "DOUBLE2" FLOAT(126) DEFAULT NULL,       
              "DOUBLE3" FLOAT(126) DEFAULT NULL,       
              "DOUBLE4" FLOAT(126) DEFAULT NULL,       
              "DOUBLE5" FLOAT(126) DEFAULT NULL,       
              "DOUBLE6" FLOAT(126) DEFAULT NULL,       
              "DOUBLE7" FLOAT(126) DEFAULT NULL,       
              "DOUBLE8" FLOAT(126) DEFAULT NULL,       
              "DOUBLE9" FLOAT(126) DEFAULT NULL,       
              "DOUBLE10" FLOAT(126) DEFAULT NULL,  
              "VARCHAR1" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR2" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR3" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR4" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR5" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR6" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR7" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR8" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR9" VARCHAR2(1024 CHAR) DEFAULT NULL,      
              "VARCHAR10" VARCHAR2(1024 CHAR) DEFAULT NULL,     
              "VARCHAR11" VARCHAR2(1024 CHAR) DEFAULT NULL,     
              "VARCHAR12" VARCHAR2(1024 CHAR) DEFAULT NULL,     
              "VARCHAR13" VARCHAR2(1024 CHAR) DEFAULT NULL,     
              "VARCHAR14" VARCHAR2(1024 CHAR) DEFAULT NULL,     
              "VARCHAR15" VARCHAR2(1024 CHAR) DEFAULT NULL, 
              "TIMESTAMP1" DATE DEFAULT NULL,
              "TIMESTAMP2" DATE DEFAULT NULL,
              "TIMESTAMP3" DATE DEFAULT NULL,
              "TIMESTAMP4" DATE DEFAULT NULL,
              "TIMESTAMP5" DATE DEFAULT NULL,
              CONSTRAINT "AGENTS_EXT_PK" PRIMARY KEY ("ID") ENABLE                
            );

CREATE TABLE "BOOM"."AGENTS_EXT_LABELS" (   
			"COLUMNNAME" VARCHAR2(1024 CHAR) DEFAULT NULL,      
            "LABEL" VARCHAR2(1024 CHAR) DEFAULT NULL
			);
insert into "BOOM"."RIGHTS" (ROLE_ID,ITEM_ID,DISABLED,GUEST,OWNER) select 'dec7d845-ef3e-4400-980e-f6f54e9b357a',2015,0,0,1
from dual where not exists (select 1 from "BOOM"."RIGHTS" where ROLE_ID='dec7d845-ef3e-4400-980e-f6f54e9b357a' and ITEM_ID=2015);
			
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'ID','ID'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='ID');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'EMAIL','Email'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='EMAIL');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'CONTACT','Contact person'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='CONTACT');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'LIT','Last Indication (Time)'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='LIT');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'ACID','Related Agent ID'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='ACID');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'EID','External ID'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='EID');
			
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT1','Long_1'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT1');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT2','Long_2'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT2');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT3','Long_3'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT3');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT4','Long_4'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT4');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT5','Long_5'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT5');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT6','Long_6'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT6');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT7','Long_7'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT7');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT8','Long_8'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT8');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT9','Long_9'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT9');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'BIGINT10','Long_10'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='BIGINT10');

INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT1','Integer_1'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT1');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT2','Integer_2'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT2');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT3','Integer_3'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT3');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT4','Integer_4'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT4');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT5','Integer_5'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT5');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT6','Integer_6'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT6');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT7','Integer_7'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT7');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT8','Integer_8'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT8');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT9','Integer_9'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT9');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'INT10','Integer_10'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='INT10');

INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE1','Double_1'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE1');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE2','Double_2'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE2');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE3','Double_3'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE3');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE4','Double_4'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE4');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE5','Double_5'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE5');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE6','Double_6'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE6');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE7','Double_7'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE7');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE8','Double_8'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE8');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE9','Double_9'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE9');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'DOUBLE10','Double_10'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='DOUBLE10');

INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR1','Text1024_1'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR1');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR2','Text1024_2'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR2');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR3','Text1024_3'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR3');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR4','Text1024_4'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR4');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR5','Text1024_5'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR5');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR6','Text1024_6'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR6');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR7','Text1024_7'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR7');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR8','Text1024_8'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR8');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR9','Text1024_9'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR9');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR10','Text1024_10'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR10');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR11','Text1024_11'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR11');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR12','Text1024_12'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR12');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR13','Text1024_13'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR13');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR14','Text1024_14'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR14');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'VARCHAR15','Text1024_15'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='VARCHAR15');

INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'TIMESTAMP1','Timestamp_1'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='TIMESTAMP1');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'TIMESTAMP2','Timestamp_2'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='TIMESTAMP2');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'TIMESTAMP3','Timestamp_3'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='TIMESTAMP3');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'TIMESTAMP4','Timestamp_4'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='TIMESTAMP4');
INSERT INTO "BOOM"."AGENTS_EXT_LABELS" ("COLUMNNAME","LABEL") select 'TIMESTAMP5','Timestamp_5'
from dual where not exists (select 1 from "BOOM"."AGENTS_EXT_LABELS" where COLUMNNAME='TIMESTAMP5');
