@ECHO OFF
rem To change the maximum memory the server can use, edit
rem the STARTSVC function. Set in the Java call the Parameter
rem -Xmx512M to e.g. -Xmx2048M to give the process up to 2GB RAM.

set cmd=%1
IF not defined cmd (
	goto :USAGE
)


FOR /f "delims=" %%L IN ('findstr /v /c:"#" boom_srv.cfg') DO set %%L

SET JAVA_OPTS=%JAVA_OPTS:"=%

:NEXT
IF /i %1 EQU -status (
	goto :STATUS
) ELSE IF /i %1 EQU -start (
	goto :START
) ELSE IF /i %1 EQU -stop (
	goto :STOP
) ELSE IF /i %1 EQU -restart (
	goto :RESTART
) ELSE IF /i %1 EQU -startsvc (
	goto :STARTSVC
) ELSE IF /i %1 EQU -stopsvc (
	goto :STOPSVC
) ELSE (
	goto :USAGE
) 


:RESTART
  net stop BOOMServer
  ping -n 5 127.0.0.1 > NUL 2>&1
  net start BOOMServer
  goto :END
:STOP
  net stop BOOMServer
  goto :END
:STOPSVC
  FOR /F %%i IN (boom_server.pid) DO  set PPID=%%i
  taskkill /PID %PPID% /FI "IMAGENAME eq java.exe"
  ping -n 5 127.0.0.1 > NUL 2>&1
  taskkill /F /PID %PPID% /FI "IMAGENAME eq java.exe"
  goto :END
:START
  net start BOOMServer
  goto :END
:STARTSVC
  IF "%JAVA_BIN%"=="" (set "JAVA_EXE=java.exe") else ( set "JAVA_EXE=%JAVA_BIN%\java.exe" )
  START "boom_server" /i /B %JAVA_EXE% -DBOOM_SERVER %JAVA_OPTS% --add-modules=ALL-SYSTEM --add-exports java.base/sun.security.pkcs10=boom.server --add-exports java.base/sun.security.x509=boom.server --add-exports java.base/sun.security.pkcs=boom.server --add-exports java.base/sun.security.util=boom.server -p srv\libs  -m boom.server/com.blixx.server.ServerEngine 2> boom_srv_error.log
  goto :END
:STATUS
 goto :USAGE

:USAGE
echo "%0 [-start | -stop ]"
:END
exit
