#!/bin/sh
OPT_BOOM_ROOT="${OPT_BOOM_ROOT:-/opt/boom}"
export OPT_BOOM_ROOT
JAVA_EXE=""

extract_major() {
  out="$1"
  inner=$(printf '%s' "$out" | sed -n 's/.*version[[:space:]]*"\([^"]*\)".*/\1/p')
  if [ -n "$inner" ]; then
    case "$inner" in
      1.*)
        m=$(printf '%s' "$inner" | sed 's/^1\.\([0-9][0-9]*\).*$/\1/')
        if [ -n "$m" ]; then
          printf '%s\n' "$m"
          return 0
        fi
        ;;
      [0-9]*)
        m=$(printf '%s' "$inner" | sed 's/^\([0-9][0-9]*\).*/\1/')
        if [ -n "$m" ]; then
          printf '%s\n' "$m"
          return 0
        fi
        ;;
    esac
  fi
  return 1
}

find_java_major_ge21() {
  JAVA_EXE=""
  best_major=-1
  best_path=""
  if [ -d "$OPT_BOOM_ROOT" ]; then
    tmpfile="/tmp/boom_find_$$.txt"
    find -L "$OPT_BOOM_ROOT" -type l -o -type f -name "java" -print > "$tmpfile" 2>/dev/null
    if [ -s "$tmpfile" ]; then
      while IFS= read -r p; do
        [ -x "$p" ] || continue
        version_out=$("$p" -version 2>&1 | head -n1)
        major=$(extract_major "$version_out")
        if [ -n "$major" ] && [ "$major" -ge 21 ]; then
          if [ "$major" -gt "$best_major" ]; then
            best_major="$major"
            best_path="$p"
          elif [ "$major" -eq "$best_major" ]; then
            best_path="$p"
          fi
        fi
      done < "$tmpfile" 2>/dev/null
    fi
    if [ "$best_major" -ge 21 ]; then
      JAVA_EXE="$best_path"
      rm -f "$tmpfile" 2>/dev/null
      return 0
    fi
    rm -f "$tmpfile" 2>/dev/null
  fi
  best_major=-1
  best_path=""
  oldIFS="$IFS"
  IFS=':'
  for dir in $PATH; do
    IFS="$oldIFS"
    [ -d "$dir" ] || continue
    candidate="$dir/java"
    if [ -x "$candidate" ]; then
      version_out=$("$candidate" -version 2>&1 | head -n1)
      major=$(extract_major "$version_out")
      if [ -n "$major" ] && [ "$major" -ge 21 ]; then
        if [ "$major" -gt "$best_major" ]; then
          best_major="$major"
          best_path="$candidate"
        elif [ "$major" -eq "$best_major" ]; then
          best_path="$candidate"
        fi
      fi
    fi
  done
  IFS="$oldIFS"
  if [ "$best_major" -ge 21 ]; then
    JAVA_EXE="$best_path"
    return 0
  fi
  return 1
}

if find_java_major_ge21; then
  echo "Compatible java version found in '$JAVA_EXE'"
  JAVA_BIN=$(dirname "$JAVA_EXE")
  export JAVA_BIN
  cfg_file="boom_srv.cfg"
  if [ -f "$cfg_file" ]; then
    if grep -q '^JAVA_BIN=' "$cfg_file"; then
      sed -i "s|^JAVA_BIN=.*|JAVA_BIN=${JAVA_BIN}|" "$cfg_file"
    else
      printf "JAVA_BIN=%s\n" "$JAVA_BIN" >> "$cfg_file"
    fi
  fi
  "$JAVA_EXE" -cp "srv/libs/*" com.blixx.jsi.Run jsi/install.jsi
else
  echo "No Java >= 21 found in $OPT_BOOM_ROOT and PATH"
  echo "You can unpack openjdk or jre version 21 or higher under $OPT_BOOM_ROOT/"
  echo "and this script will automatically detect appropriate path."
fi