######################################################################
#
#  Name: boom_prov_enc.sh
#
#  Description: Update config file:
#               BOOM_USR=<boom_user>
#               [SRV_PORT=<boom_server-HTTPS-port>]
#               Penc=<boom_user-pw-encrypted>
#
#
#  Author: Solmsdorf (equensWorldline)
#  Version: 1.00
#  Date: 14.12.2023
#
#  Input parameter: $1 (<boom user>)
#                   $2 (<boom user-password>)
#                  [$3 (<boom server HTTPS-port>)]
#
#  Return: 0 = Success
#          1: Error (config file not available!)
#          2: Error (config file entry BOOM_USR not available!)
#          3: Error (config file entry Penc not available!)
#          4: Error (config file entry SRV_PORT not available!)
#
#
#  History:
#
#     date    |name| reason
#  ----------------------------------------------------------------
#  14/12/2023 | ps | (1.00) Initial Release
#
######################################################################

NAME=$(basename $0)
PID=$$

CNFFIL="boom_env_ssl.cnf"

fil=${0}
fil_short=$(basename ${fil})
if [ `echo ${fil} | egrep "^\/" | wc -l` -eq 0 ]
then
# Pfad beginnt nicht mit /
  if [ `echo ${fil} | egrep "^\.\." | wc -l` -ge 1 ] || [ `echo ${fil} | egrep "\/" | wc -l` -ge 1 ]
  then
# Eingabe beginnt mit .. oder enthaelt /: Finde absoluten Pfad und fuege immer Pfad dazu
    pd=$(realpath ${fil})
    pd=$(dirname ${pd})
    fil="${pd}/${fil_short}"
  else
# Eingabe beginnnt nicht mit / und nicht mit ..: fuege immer Pfad dazu
    pd=$(pwd)
    fil="${pd}/${fil_short}"
  fi
fi
WORKDIR=$(dirname ${fil})

source "${WORKDIR}/${CNFFIL}"

user=${USER}
if [ -z "${user}" ]
then
  user=$(id |awk -F"=" '{print $2}' |awk -F"(" '{print $2}' | awk -F")" '{print $1}')
fi


USAGE="
Usage: ${NAME} <boom user> <boom user-password> [<boom server HTTPS-port>]
"

BOOMUSR_STR="BOOM_USR"
SRVPORT_STR="SRV_PORT"
PENC_STR="Penc"


# INIT+++++++++++++++++++++++++++++++++++++++
#  Arguments?
if [ $# -lt 2 ]
then
  printf "${USAGE} \n"
  exit 1
fi

if [ ! -s ${CNFFIL} ]
then
  echo "config file >>${CNFFIL}<< not available!"
  exit 1
fi
grep "${BOOMUSR_STR}" ${CNFFIL} >/dev/null
if [ $? -ne 0 ]
then
  echo "${CNFFIL}: config variable >>${BOOMUSR_STR}<< not available!"
  exit 2
fi
grep "${PENC_STR}" ${CNFFIL} >/dev/null
if [ $? -ne 0 ]
then
  echo "${CNFFIL}: config variable >>${PENC_STR}<< not available!"
  exit 3
fi
grep "${SRVPORT_STR}" ${CNFFIL} >/dev/null
if [ $? -ne 0 ]
then
  echo "${CNFFIL}: config variable >>${SRVPORT_STR}<< not available!"
  exit 4
fi

# MAIN++++++++++++++++++++++++++++++++++++++++++

enc1=$(echo "${2}" | `echo "${ev}"`)
## mask "/" if enc1 contains it
enc=$(echo "${enc1}" | sed 's/\//\\\//g')

if [ ! -z "${3}" ]
then
## Replace entry: SRV_PORT 
  res=$(sed -r 's/'"${SRVPORT_STR}"'=.*/'"${SRVPORT_STR}"'='"${3}"'  # boom server HTTPS port/' ${CNFFIL}) 
else
  res=$(cat ${CNFFIL})
fi

## Replace entry: BOOM_USR
res=$(echo "${res}" | sed -r 's/'"${BOOMUSR_STR}"'=.*/'"${BOOMUSR_STR}"'='"${1}"'  # boom admin group/' ) 

## Replace entry: Penc
res=$(echo "${res}" | sed -r 's/'"${PENC_STR}"'=.*/'"${PENC_STR}"'=\"'"${enc}"'\"/' ) 

echo "${res}" >${CNFFIL}
#echo "DBG: res=${res}"

if [ ! -z "${3}" ]
then
echo "config update done: value setting for ${SRVPORT_STR}, ${BOOMUSR_STR} and ${PENC_STR} in config file ${CNFFIL}"
else
  echo "config update done: value setting for ${BOOMUSR_STR} and ${PENC_STR} in config file ${CNFFIL}"
fi

exit

