@ECHO OFF
set cmd=%1
IF not defined cmd (
	goto :USAGE
)

REM 04072022@ps (2.01): JAVA_PATH inside boom_service.cfg set?
For /F "tokens=1* delims==" %%A IN (boom_service.cfg) DO (
    IF "%%A"=="JAVA_PATH" set JAVA_PATH=%%B
)

REM 13122022@ps (3.01): max. heap size default Win64
set "JAVA_OPTS=-Xmx512M"
REM 12122022@bs (3.00): JAVA_BIN, JAVA_OPTS inside boom_agt.cfg set?
FOR /f "delims=" %%L IN ('findstr /v /c:"#" boom_agt.cfg') DO set %%L
IF defined JAVA_BIN (
REM remove double quotes from assignment of JAVA_BIN
	set "JAVA_PATH=%JAVA_BIN:"=%"
)

REM remove double quotes from assignment of JAVA_PATH
IF defined JAVA_PATH (
	set "JAVA_PATH=%JAVA_PATH:"=%"
	IF not exist "%JAVA_PATH%" (
		echo "Java directory %JAVA_PATH% does not exist"
		goto :END
	)
)


IF defined JAVA_OPTS (
	set "JAVA_OPTS=%JAVA_OPTS:"=%"
)


:NEXT
IF /i %1 EQU -status (
	goto :STATUS
) ELSE IF /i %1 EQU -start (
	goto :START
) ELSE IF /i %1 EQU -stop (
	goto :STOP
) ELSE IF /i %1 EQU -restart (
	goto :RESTART
) ELSE IF /i %1 EQU -startsvc (
	goto :STARTSVC
) ELSE IF /i %1 EQU -stopsvc (
	goto :STOPSVC
) ELSE (
	goto :USAGE
)
:RESTART
  net stop BOOMAgent
  ping -n 5 127.0.0.1 > NUL 2>&1
  net start BOOMAgent
  goto :END
:STOP
  net stop BOOMAgent
  goto :END
:STOPSVC
  FOR /F %%i IN (boom_agent.pid) DO  set PPID=%%i
  taskkill /PID %PPID% /FI "IMAGENAME eq java.exe"
  ping -n 5 127.0.0.1 > NUL 2>&1
  taskkill /F /PID %PPID% /FI "IMAGENAME eq java.exe"
  goto :END
:START
  net start BOOMAgent
  goto :END
:STARTSVC
::echo Start
IF NOT EXIST boom_agent.jar.tmp goto :GO
MOVE /Y boom_agent.jar.tmp boom_agent.jar
:GO
rem - with Console window: START "boom_agent" /i java -jar boom_agent.jar
rem - without Console window: START "boom_agent" /i javaw -jar boom_agent.jar 


IF not defined JAVA_PATH (
	START "boom_agent" /i /B java.exe -DBOOM_AGENT %JAVA_OPTS% -jar boom_agent.jar
) ELSE (
REM wrap JAVA_PATH with double quotes because of "Program Files\..."
	START "boom_agent" /i /B "%JAVA_PATH%\java.exe" -DBOOM_AGENT %JAVA_OPTS% -jar boom_agent.jar
)


goto :END
:STATUS
echo "Not yet implemented"
goto :END
:USAGE
echo "%0 [-start | -stop | -restart]"
:END
exit
