@echo off

::######################################################################
::#
::#  Name: install_boom_WindowsAgent.bat
::#
::#  Description: Checks prequisites (Java) 
::#               installs (silent) boom agent on 
::#               target WINDOWS servers.
::#
::#  Author: Chavdar Borisov, Worldline Germany
::#  Version: 2.10
::#  Date: 30.9.2021
::#
::#  Input parameter: [$1 -u (uninstall)]
::#
::#  Return: 0 = Success
::#          1 = USAGE
::#          2 = ERROR: You do not have Administrator Rights to execute this operation
::#          3 = ERROR: Java directory %JAVA_PATH% does not exist
::#          4 = ERROR: Java version %jmajor% is not supported
::#          5 = ERROR: %fileToUnzip% does not exist
::#          6 = WARNING: Installation directory is not empty
::#          7 = ERROR: Stopping %agentService% service failed
::#          8 = ERROR: Uninstalling %agentService% service failed
::#          9 = ERROR: Service did not start after %MAXWAIT% seconds
::#
::#  Note: environment variable JAVA_HOME_BOOM is optional; but if set path must end with
::#        "\bin"
::#
::#  History:
::#
::#     date    |name| reason
::#  ----------------------------------------------------------------
::#  30/09/2021 | cbo | (1.00) Initial Release
::#  16/02/2022 | cbo | (1.01) adjustments
::#  31/05/2022 | ps  | (2.00) JAVA_PATH: if set via %BOOM_JAVA_HOME% path
::#                     checked and written to %INSTALLDIR%\boom_service.cfg
::#                     (value assignment not between double quotes!)
::#  04/07/2022 | ps  | (2.01) JAVA_PATH=%JAVA_HOME_BOOM%
::#  20/02/2024 | ps | (2.10) boom Agent 5.10.0 supported Java versions: 8, 17, 21
::#
::# Disclaimer: 
::# This information are provided "AS IS" without warranty of any kind, either expressed or implied. 
::# The entire risk arising out of the use or performance of the script and documentation remains with you. 
::# Furthermore, Worldline or the author shall not be liable for any damages you may sustain by using this information, 
::# whether direct, indirect, special, incidental or consequential, including, without limitation, damages for loss of business profits,
::# business interruption, loss of business information or other pecuniary loss even if it has been advised of the possibility of such damages.
::# Read all the implementation and usage notes thoroughly.
::######################################################################

::-------------------------------------
>nul 2>&1 "%SYSTEMROOT%\system32\cacls.exe" "%SYSTEMROOT%\system32\config\system"

REM --> If error flag set, we do not have admin.
if '%errorlevel%' NEQ '0' (
    call :ECHO_WITH_TIME "You do not have Administrator Rights to execute this operation."
    call :ECHO_WITH_TIME "exiting"
    exit /b 2
) else ( goto gotAdmin )

:gotAdmin
    if exist "%temp%\getadmin.vbs" ( del "%temp%\getadmin.vbs" )
    pushd "%CD%"
    CD /D "%~dp0"
::--------------------------------------

:: input arguments
set arg1=%1

REM -> Only modify these values

set MAXWAIT=10
set INSTALLDIR="%ProgramFiles%\boom\agent"
REM remove double quotes from JAVA_HOME_BOOM
set JAVA_HOME_BOOM=%JAVA_HOME_BOOM:"=%
REM wrap JAVA_PATH with double quotes
set JAVA_PATH="%JAVA_HOME_BOOM%"

REM -> Modifiable values END

:: variables
set java8Ver=8
set java17Ver=17
set java21Ver=21
set minVersion=8
set maxVersion=12
set fileToUnzip_64=win64_boom_agent.zip
set fileToUnzip_32=win32_boom_agent.zip
set fileToUnzip=%fileToUnzip_64%
set currentDir=%cd%
set agent_32=booma_service_32.exe
set agent_64=booma_service_64.exe
set boomAgent=
set agentService=BOOMAgent
set configFile=boom_service.cfg
set agentServiceKey="SERVICE_NAME="

call :reset_error

REM JAVA_PATH itself is surrounded by double quotes
IF defined JAVA_PATH (
REM provide complete assignment within double quotes
	set "JAVA_PATH=%JAVA_PATH:"=%"
	IF not exist %JAVA_PATH%\ (
		call :ECHO_WITH_TIME ERROR: "Java directory %JAVA_PATH% does not exist"
		exit /b 3
	)
)
	
call :GET_JAVA_VERSION


if "%JAVAX64%"=="true" ( 
	set boomAgent=%agent_64%
	set fileToUnzip=%fileToUnzip_64%
) else ( 
	set boomAgent=%agent_32%
	set fileToUnzip=%fileToUnzip_32% )
	
call :PROCESS_ARGUMENTS || goto :COMPLETE
if "%arg1%"=="-u" ( goto :COMPLETE )

call :CHECK_VERSION_COMPABILITY || goto :COMPLETE
REM -> call :UNINSTALL_SERVICE || goto :COMPLETE
call :UNZIP_FILES || goto :COMPLETE
call :INSTALL_SERVICE || goto :COMPLETE
call :CHECK_SERVICE_STARTED

goto :COMPLETE

:GET_JAVA_VERSION
IF defined JAVA_PATH (
	CD /D %JAVA_PATH%
)
where java >nul 2>&1
if errorlevel 1 goto NO_JAVA

for /f "tokens=3" %%g in ('java -version 2^>^&1 ^| findstr /i "version"') do (
	set JAVAVER=%%g
)
CD /D %currentDir%

set JAVAVER=%JAVAVER:"=%
call :ECHO_WITH_TIME INFO: "Found Java (%JAVA_PATH%) Version: %JAVAVER%"

for /f "delims=. tokens=1-3" %%v in ("%JAVAVER%") do (
	if "%%v"=="1" ( 
		set jmajor=%%w 
		set jminor=%%x 
		) else (
			set jmajor=%%v
			set jminor=%%w
	)

)

call :ECHO_WITH_TIME INFO: "Java Major version: %jmajor%"

set JAVAX64=false
IF defined JAVA_PATH (
	CD /D %JAVA_PATH%
)
for /f "tokens=3" %%g in ('java -version 2^>^&1 ^| findstr /i "64-bit"') do (
    set JAVAX64=true
)
CD /D %currentDir%

call :ECHO_WITH_TIME INFO: "Java is 64 bit: %JAVAX64%"
goto :eof


:CHECK_VERSION_COMPABILITY

if %jmajor% == %java8Ver% (
	call :ECHO_WITH_TIME INFO: "Java version %jmajor% is supported"
) else (
	if %jmajor% == %java17Ver% (
		call :ECHO_WITH_TIME INFO: "Java version %jmajor% is supported"
	) else (
			if %jmajor% == %java21Ver% (
				call :ECHO_WITH_TIME INFO: "Java version %jmajor% is supported"
			) else (
				call :ECHO_WITH_TIME ERROR: "Java version %jmajor% is not supported"
				exit /b 4
			)
		)
	)
)
goto :eof 


:UNZIP_FILES

if not exist %fileToUnzip% ( 
	call :ECHO_WITH_TIME ERROR: "%fileToUnzip% does not exist. "
	exit /b 5
	goto :eof
)

if not exist %INSTALLDIR% ( 
mkdir %INSTALLDIR%
)

call :CHECK_FOLDER_EMPTY
if "%isEmptyFolder%"=="false" (
	call :ECHO_WITH_TIME WARNING: "Installation directory is not empty. "
	exit /b 6
	goto :eof
)

call :ECHO_WITH_TIME INFO: "Extracting file %fileToUnzip%"

:: jar -xf do not have input paramater for target directory, it is extracting to working directory
:: we create a temp dir for extraction and then copy the files to given installation folder
if exist %currentDir%\tmpDir ( rmdir /s /q %currentDir%\tmpDir )
mkdir %currentDir%\tmpDir
cd %currentDir%\tmpDir
IF defined JAVA_PATH (
"%JAVA_PATH%"\jar -xf %currentDir%\%fileToUnzip%
) else ( 
	jar -xf %currentDir%\%fileToUnzip%)
echo errorlevel %ERRORLEVEL% >nul
if '%errorlevel%' NEQ '0' (
	call :ECHO_WITH_TIME INFO: "Extracting file %fileToUnzip% failed"
	cd %currentDir%
	exit /b 6
	goto :eof
)
xcopy /e /y %currentDir%\tmpDir %INSTALLDIR% >nul 2>&1
cd %currentDir%
rmdir /s /q %currentDir%\tmpDir
call :ECHO_WITH_TIME INFO: "Extracting file %fileToUnzip% finished"

IF defined JAVA_PATH (
REM write JAVA_PATH entry to boom_service.cfg
	call :ECHO_WITH_TIME INFO: "appending >>JAVA_PATH=%JAVA_PATH%<< to \"%INSTALLDIR%\"\%configFile% "
	echo JAVA_PATH=%JAVA_PATH% >>%INSTALLDIR%\%configFile%
)
goto :eof

:UNINSTALL_SERVICE
call :ECHO_WITH_TIME INFO: "Checking if %agentService% already exists"
if exist %INSTALLDIR%\%boomAgent% (
    call :ECHO_WITH_TIME INFO: "Stopping %agentService% service"
    %INSTALLDIR%\%boomAgent% -k
	if '%errorlevel%' NEQ '0' ( 
		call :ECHO_WITH_TIME ERROR: "Stopping %agentService% service failed"
		exit /b 7
		goto :eof
	)
	
	timeout /t 2 > nul
		
    call :ECHO_WITH_TIME INFO: "Uninstalling %agentService% service"
    %INSTALLDIR%\%boomAgent% -u
	if '%errorlevel%' NEQ '0' ( 
		call :ECHO_WITH_TIME ERROR: "Uninstalling %agentService% service failed"
		exit /b 8
		goto :eof
	)
	
	timeout /t 2 > nul
	call :ECHO_WITH_TIME INFO: "%agentService% service uninstalled"
)

goto :eof

:INSTALL_SERVICE
call :ECHO_WITH_TIME INFO: "Installing %agentService% service"
%INSTALLDIR%\%boomAgent% -i
if '%errorlevel%' NEQ '0' (
	call :ECHO_WITH_TIME ERROR: "Installing %agentService% service failed"
	exit /b 8 goto :eof )

call :ECHO_WITH_TIME INFO: "Installing %agentService% complete"

call :ECHO_WITH_TIME INFO: "Starting %agentService% service"
%INSTALLDIR%\%boomAgent% -s

goto :eof

:CHECK_SERVICE_STARTED
for /l %%x in (1, 1, %MAXWAIT%) do (
	call :CHECK_SERVICE_RUNNING
	if "%isRunning%"=="false" ( timeout /t 1 > nul )
	
	if "%isRunning%"=="true" (
		call :ECHO_WITH_TIME INFO: "Service started" 
		goto :eof
	)
)

if %isRunning%=="false" ( 
	call :ECHO_WITH_TIME ERROR: "Service did not start after %MAXWAIT% seconds." 
	exit /b 9 
	)
	
goto :eof

:PROCESS_ARGUMENTS

if "%arg1%"=="" ( goto :eof )
if "%arg1%"=="-u" (

    call :ECHO_WITH_TIME INFO: "Starting to Uninstal %agentService% service"
	call :UNINSTALL_SERVICE
	
	call :ECHO_WITH_TIME INFO: "Uninstalling %agentService% service completed, clearing installation directory"
	
	call :CLEAR_INSTALLATION_FOLDER
	exit /b 0
	goto :eof
) 
:: display usage if input argument can not be understood.
goto :SHOW_USAGE


:CLEAR_INSTALLATION_FOLDER
if exist %INSTALLDIR% ( 
	timeout /t 3 > nul
rem	rmdir /s /q %INSTALLDIR% 
	rd /s /q %INSTALLDIR%
	if exist %INSTALLDIR% rd /s /q %INSTALLDIR%
	if exist %INSTALLDIR% rd /s /q %INSTALLDIR%
 )

goto :eof


:NO_JAVA
call :ECHO_WITH_TIME INFO: "Java is not installed"
goto :eof

:CHECK_SERVICE_RUNNING
for /F "tokens=3 delims=: " %%H in ('sc query %agentService% ^| findstr "STATE"') do (
  if /I "%%H" NEQ "RUNNING" ( set "isRunning=false" ) else (
	set "isRunning=true")
)

goto :eof

:SHOW_USAGE
 call :ECHO_WITH_TIME INFO: "Usage: Run the script without any arguments."
 echo "-u for uninstallation is the only valid argument!"

 exit /b 1
 goto :eof
 
:ECHO_WITH_TIME
 set dt=%DATE:~0,2%.%DATE:~3,2%.%DATE:~6,4% %TIME:~0,2%.%TIME:~3,2%.%TIME:~6,2%
 echo %dt% %1 %2
goto :eof

:CHECK_FOLDER_EMPTY
 call :ECHO_WITH_TIME INFO: "Checking installation directory."
for /F %%i in ('dir /b %INSTALLDIR%\*.*') do (
	set isEmptyFolder=false
	goto :eof
)

set isEmptyFolder=true
goto :eof

:reset_error
exit /b 0

:COMPLETE
call :ECHO_WITH_TIME INFO: "Processing completed with exit code %errorlevel%"
goto :eof
