var root;
var node;


function getAgentsMapSVG() {

    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height();

    $(window).resize(function () {

        viewportWidth = $(window).width();
        viewportHeight = $(window).height();
        d3.select("#treemap-chart-area")
            .style("height", viewportHeight - (viewportHeight * 0.25) + "px");

    });

    d3.select("#treemap-chart-area")
        .style("height", viewportHeight - (viewportHeight * 0.25) + "px");

    var w = 1280 - 80,
        h = 800 - 180,
        x = d3.scale.linear().range([0, w]),
        y = d3.scale.linear().range([0, h]),
        color = d3.scale.category20c(),
        root,
        node,
        agentsMap,
        svg,
        selectValue;

    var treemap = d3.layout.treemap()
        .size([w, h])
        .sticky(false)
        .children(function (data, depth) {
            return data.agents
        })
        .value(function (d) {
            return d.os == "_External" ? 1 : 3;
            /* size of square */
        });
    //initial
    updateTreemap();

    setInterval(function () {
        //updateTreemapColor();
        updateTreemap();
        /// call your function here
    }, 2000);



    d3.select(".chart-panel").style("display", "none");

    var parseDate = d3.time.format("%d-%m-%Y");
    d3.select(".panel-title").text("Agents-Map-Layout: " + parseDate(new Date()));

    svg = d3.select("#treemap-chart-area").append("div")
        .attr("class", "chart")
        .style("width", 100 + "%")
        .style("height", 100 + "%")
        .append("svg:svg")
        //.attr("width", w)
        //.attr("height", h)
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .attr("viewBox", "0 0 " + w + " " + h)
        .attr("preserveAspectRatio", "xMidYMid meet")
        .attr("transform", "translate(.5,.5)");

    function updateTreemap() {

        var process = d3.json("/json/agent_list", function (json) {
            node = root = json;
            var agents = json;
            agentsMap = d3.map();
            agents.agents.forEach(function (entry) {
                agentsMap.set(entry.id, entry);
            });

            var
                //color = d3.interpolateRgb("rgb(0,255,0)", "rgb(255,0,0)");
                //xcolor = d3.scale.linear().domain([-26,13]).range("rgb(0,255,0)", "rgb(255,0,0)"),
                x = d3.scale.linear().domain([-26, 13]).range([0, 1]),
                stepsize = [2.46, 1.66],
                minval = [-16.28, -16.67];


            //        var treemap = d3.layout.treemap()
            //            .size([w, h])
            //            .sticky(true)
            //            .children(function (data, depth) {
            //                return data.agents
            //            })
            //            .value(function (d) {
            //                return d.os == "_External" ? 1 : 3;
            //                /* size of square */
            //            });

            var nodes = treemap.nodes(root);
            var children = nodes.filter(function (d) {
                return d.id;
            });
            var parents = nodes.filter(function (d) {
                return !d.id;
            });
            //
            //        var fisheye = d3.fisheye.circular()
            //            .radius(120);


            var cell = svg.selectAll("g")
                .data(children, function (d) {
                    return d.id
                });

            var entering = cell.enter().append("svg:g")
                .attr("class", "cell")
                .attr("transform", function (d) {
                    return "translate(" + d.x + "," + d.y + ")";
                })
                .on("click", function (d) {
                    window.open("indications.html?agent=" + d.id + "&label=" + d.label, "_self");
                    return;

                })
                .on("dblclick", function (d) {
                    return zoom(node == d.parent ? root : d.parent);
                });

            entering.append("svg:rect")
                .attr("width", function (d) {
                    return d.dx - 1;
                })
                .attr("height", function (d) {
                    return d.dy - 1;
                })
                //.style("fill", function(d) { return treemap_color(d.sev_total); })
                .style("fill", function (d) {
                    return treemap_color(d.sev_av);
                })
                .style("cursor", "pointer")
                .on("mouseover", function (d) {
                    //if (!(d.type == "agt")) return;

                    var tip = d3.select("#tooltipPartition");

                    tip.select("#value")
                        .text(fillListAgent(d, agentsMap));

                    var mousex = d3.event.pageX - 20; //Get X coodrinates
                    var mousey = d3.event.pageY - 20; //Get Y coordinates

                    var tipWidth = $(tip.node()).width(); //Find width of tooltip
                    var tipHeight = $(tip.node()).height(); //Find height of tooltip

                    //Distance of element from the right edge of viewport
                    var tipVisX = $(window).width() - (mousex + tipWidth);
                    //Distance of element from the bottom of viewport
                    var tipVisY = $(window).height() - (mousey + tipHeight);

                    if (tipVisX < 20) { //If tooltip exceeds the X coordinate of viewport

                        if (tipWidth > d3.event.pageX - 20) {
                            mousex = 0;
                        } else {
                            mousex = d3.event.pageX - tipWidth - 20;
                        }

                    }
                    if (tipVisY < 20) { //If tooltip exceeds the Y coordinate of viewport
                        mousey = d3.event.pageY - tipHeight - 20;
                    }
                    tip.style("left", mousex + "px")
                        .style("top", mousey + "px");

                    //Show the tooltip
                    tip.transition()
                        .duration(200)
                        .delay(100)
                        .style("opacity", .9);

                })
                .on("mouseout", function () {
                    //clearInterval(timerXY);
                    var tip = d3.select("#tooltipPartition");

                    tip.transition()
                        .duration(2)
                        .style("opacity", 0);
                });

            entering.append("svg:text")
                .attr("x", function (d) {
                    return d.dx / 2;
                })
                .attr("y", function (d) {
                    return d.dy / 2;
                })
                .attr("dy", ".35em")
                .attr("text-anchor", "middle")
                .text(function (d) {
                    return get_label(d);
                })
                .style("opacity", function (d) {
                    d.w = this.getComputedTextLength();
                    return d.dx > d.w ? 1 : 0;
                });

            cell.exit().remove();

            cell.select("rect")
                .style("fill", function (d) {
                    return treemap_color(d.sev_av);
                });


            zoom(node);

            function get_label(agent) {
                var text = "no label";
                text = agent.agents ? "" : "" ? agent.label : agent.label;
                text = text + " (" + agent.ind_total + ")";
                return text;
            }

            function cell() {
                this
                    .style("left", function (d) {
                        return d.x + "px";
                    })
                    .style("top", function (d) {
                        return d.y + "px";
                    })
                    .style("width", function (d) {
                        return d.dx - 1 + "px";
                    })
                    .style("height", function (d) {
                        return d.dy - 1 + "px";
                    })
                    .style("text-anchor", "middle");
            }           

            //Buttons Controll
            d3.select("#size").on("click", function () {
                selectValue = this.value;
                treemap.value(function (d) {
                        return switchTreeMap(selectValue, d);
                    })
                    .nodes(root);
                zoom(node);

                d3.select("#size").classed("active", true);
                d3.select("#count").classed("active", false);
            });

            d3.select("#count").on("click", function () {
                selectValue = this.value;
                treemap.value(function (d) {
                        return switchTreeMap(selectValue, d);
                    })
                    .nodes(root);
                zoom(node);

                d3.select("#size").classed("active", false);
                d3.select("#count").classed("active", true);
            });

        });

    }

    function switchTreeMap(value, d) {
        switch (value) {
            case "sev_total":
                return d.sev_total;
                break;
            case "sev_av":
                return d.sev_av;
                break;
            case "sev_kpi":
                return d.sev_kpi;
                break;
            case "sev_other":
                return d.sev_other;
                break;
            case "ind_total":
                return d.ind_total;
                break;
            default:
                return d.os == "_External" ? 1 : 3;
                break;
        }

    }

    function zoom(d) {
        var kx = w / d.dx,
            ky = h / d.dy;
        x.domain([d.x, d.x + d.dx]);
        y.domain([d.y, d.y + d.dy]);

        var t = svg.selectAll("g.cell").transition()
            .duration(750)
            .attr("transform", function (d) {
                return "translate(" + x(d.x) + "," + y(d.y) + ")";
            });

        t.select("rect")
            .attr("width", function (d) {
                return kx * d.dx - 1;
            })
            .attr("height", function (d) {
                return ky * d.dy - 1;
            })

        t.select("text")
            .attr("x", function (d) {
                return kx * d.dx / 2;
            })
            .attr("y", function (d) {
                return ky * d.dy / 2;
            })
            .style("opacity", function (d) {
                //return kx * d.dx > d.w && ky * d.dy > 10 ? 1 : 0;

                d.w = this.getComputedTextLength();
                return kx * d.dx > d.w ? 1 : 0;
            });

        node = d;
        if (d3.event) d3.event.stopPropagation();
    }


}



function GetWidth() {
    var x = 0;
    if (self.innerHeight) {
        x = self.innerWidth;
    } else if (document.documentElement && document.documentElement.clientHeight) {
        x = document.documentElement.clientWidth;
    } else if (document.body) {
        x = document.body.clientWidth;
    }
    return x;
}

function GetHeight() {
    var y = 0;
    if (self.innerHeight) {
        y = self.innerHeight;
    } else if (document.documentElement && document.documentElement.clientHeight) {
        y = document.documentElement.clientHeight;
    } else if (document.body) {
        y = document.body.clientHeight;
    }
    return y;
}