function renderAgentStatus() {

    var width = 960,
        height = 500,
        radius = Math.min(width, height) / 2;

    var color = d3.scale.ordinal()
        .range(["#98abc5", "#8a89a6", "#7b6888", "#6b486b", "#a05d56", "#d0743c", "#ff8c00"]);

    var arc = d3.svg.arc()
        .outerRadius(radius - 10)
        .innerRadius(0);

    var pie = d3.layout.pie()
        .sort(null)
        .value(function (d) {
            return d.value;
        });

    var svg = d3.select("#agent-pie-chart-area").append("svg")
        .attr("width", width)
        .attr("height", height)
        .append("g")
        .attr("transform", "translate(" + width / 2 + "," + height / 2 + ")");

    d3.json("/json/stats", function (error, data) {
        console.log("data", data);

        data2 = [
            {"label": "Online", "value": parseInt(data.agt_online)},
            {"label": "Offline", "value": parseInt(data.agt_offline)},
            {"label": "Not Approved", "value": parseInt(data.agt_notapproved)}
        ];


        var g = svg.selectAll(".arc")
            .data(pie(data2))
            .enter().append("g")
            .attr("class", "arc");

        g.append("path")
            .attr("d", arc)
            .style("fill", function (d, i) {
                return agt_status_color(data2[i].label);
            });

        g.append("text")
            .attr("transform", function (d) {
                return "translate(" + arc.centroid(d) + ")";
            })
            .attr("dy", ".35em")
            .style("text-anchor", "middle")
            .text(function (d, i) {
                return data2[i].label;
            });

    });

}
