function renderMetricSelector() {

    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height();

//    $(window).resize(function () {
//
//        viewportWidth = $(window).width();
//        viewportHeight = $(window).height() + 150;
//        d3.select("#perf-data-chart-area")
//            .style("height", viewportHeight + "px");
//
//        d3.select(".chart")
//            .style("height", viewportHeight + "px");
//
//    });

    d3.select("#perf-data-chart-area")
        .style("height", viewportHeight + "px");
    d3.select(".chart")
        .style("height", viewportHeight + "px");
//var parseDate = d3.time.format("%Y-%m-%d");
    // d3.select(".panel-title").text("Bundle-Layout: "+parseDate(new Date()));

    var diameter = 960,
        radius = diameter / 2,
        innerRadius = radius - 250,
        m0,
        ry = diameter / 2,
        rx = diameter / 2,
        rotate = 0,
        agentsMap,
        selected = false,
        pclass,
        dMetric,
        agentId,
        dAgent,
        agentObject,
        interval = 86400000;


    //var myLoader = loader({width: 960, height: 500, container: "#perf-data-chart-area", id: "loader"});
    //myLoader();

    d3.select("#loading-indicator").style("display", "inline");

    var cluster = d3.layout.cluster()
        .size([360, innerRadius])
        .sort(null)
        .value(function (d) {
            return d.size;
        });

    var bundle = d3.layout.bundle();

    var line = d3.svg.line.radial()
        .interpolate("bundle")
        .tension(.85)
        .radius(function (d) {
            return d.y;
        })
        .angle(function (d) {
            return d.x / 180 * Math.PI;
        });

//    // Chrome 15 bug: <http://code.google.com/p/chromium/issues/detail?id=98951>
//    var div = d3.select("body").insert("div", "h2")
//        .style("top", "-80px")
//        .style("left", "-160px")
//        .style("width", w + "px")
//        .style("height", w + "px")
//        .style("position", "absolute")
//        .style("-webkit-backface-visibility", "hidden");

    var div = d3.select("#perf-data-chart-area")
        .style("-webkit-backface-visibility", "hidden");

    var svg = div.append("svg")
        //.attr("width", diameter)
        //.attr("height", diameter)
        //.append("g")
        //.attr("transform", "translate(" + radius + "," + radius + ")")
        .attr("viewBox", "-" + diameter / 2 + " " + "-" + diameter / 2 + " " + diameter + " " + diameter)
        .attr("preserveAspectRatio", "xMidYMid meet")
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .append("svg:g")
        .attr("id", "container");

    svg.append("svg:path")
        .attr("class", "arc")
        .attr("d", d3.svg.arc().outerRadius(innerRadius).innerRadius(0).startAngle(0).endAngle(2 * Math.PI))
        //.on("mousedown", mousedown)
        .on("click", mouseclick);

    var link = svg.append("g").selectAll(".link"),
        node = svg.append("g").selectAll(".node");

    d3.json("/json/agent_list_real", function (json_agents) {

        var agents = json_agents;

        agentsMap = d3.map();

        agents.agents.forEach(function (entry) {
            agentsMap.set(entry.id, entry);
        });
    });

    var classes = [], links = [], json = [], classMap = d3.map(), jsonAgentsMap = d3.map(), jsonObjectsMap = d3.map(), jsonObjectsMap2 = d3.map(), jsonAgentObjectsMap = d3.map(), checkClass, metrics = [], perObjects = [];
    d3.json("/json/perfclasses", function (error, perfclasses) {

        var i = 0;
        for (var key in perfclasses) {
            d3.json("/json/perfclass?class=" + key, function (error, perfclass) {
                var objects = perfclass.objects;
                classMap.set(perfclass.class, perfclass);
                //console.log("classMap", classMap);

                checkClass = perfclass.class

                var metric = [],
                    indexOfAGENTID = perfclass.objects.indexOf("BOOMAGENTID");
                //metrics for all
                perfclass.metrics.forEach(function (i) {
                    metrics.push("perfclass#" + perfclass.class + "#" + i)
                });

                //metrics for class
                perfclass.metrics.forEach(function (i) {
                    metric.push("perfclass#" + perfclass.class + "#" + i)
                });

                perfclass.objectvalues.forEach(function (i) {
                    jsonAgentsMap.set(i[indexOfAGENTID], addImportsToAgents(i[indexOfAGENTID], metric, perfclass.class));
                });

                i++;

                classes.push(perfclass);

                if (i == Object.keys(perfclasses).length) render(jsonAgentsMap, metrics, perObjects, jsonAgentObjectsMap);

            });


            function addImportsToAgents(id, metrics, perfClass) {

                if (jsonAgentsMap.has(id)) {
                    return jsonAgentsMap.get(id).concat(metrics);
                } else {
                    return metrics;
                }
            }

            function addMetricsToObjects(id, metrics, perfClass) {

                if (jsonObjectsMap.has(id)) {
                    return jsonObjectsMap.get(id).concat(metrics);
                } else {
                    return metrics;
                }
            }
        }

    });
    d3.select(self.frameElement).style("height", diameter + "px");


    function render(jsonMap, metrics) {
        d3.select("#loading-indicator").style("display", "none");
        var classes = [];

        jsonMap.forEach(function (i) {
            classes.push({name: "perfclass#" + i, imports: jsonMap.get(i), type: "agent"})
        });
        metrics.forEach(function (i) {
            classes.push({name: i, type: "metric"})
        });


        var nodes = cluster.nodes(packageHierarchy(classes));
        links = packageImports(nodes);

        link = link
            .data(bundle(links))
            .enter().append("path")
            .each(function (d) {
                d.source = d[0], d.target = d[d.length - 1];
            })
            .attr("class", "link")
            .attr("d", line);

        node = node
            .data(nodes.filter(function (n) {
                return !n.children;
            }))
            .enter().append("g")
            //.attr("class", "node")
            .attr("class", function (d) {
                return "node " + d.type;
            })
            .attr("transform", function (d) {
                return "rotate(" + (d.x - 90) + ")translate(" + d.y + ")";
            })
            .append("text")

            .attr("dx", function (d) {
                return d.x < 180 ? 8 : -8;
            })
            .attr("dy", ".31em")
            .attr("text-anchor", function (d) {
                return d.x < 180 ? "start" : "end";
            })
            .attr("transform", function (d) {
                return d.x < 180 ? null : "rotate(180)";
            })
            .text(function (d) {
                return agentsMap.get(d.key) ? agentsMap.get(d.key).host : d.parent.key + "." + d.key;
            })
            .on("mouseover", mouseovered)
            .on("mouseout", mouseouted)
            .on("click", mouseclick);

        node.append("svg:title").text(function (d) {
            return d.type;
        });


    }

    function renderObjects(jsonAgentsMap, metrics, objects, jsonObjectsMap) {
        //console.log("renderObjects: ", jsonAgentsMap);
        svg.selectAll("g").remove();
        var classes = [], metricArray = [];

        dMetric.parent.children.forEach(function (i) {
            metricArray.push(i.name)
        });
        //console.log("metrArray: ", metricArray);
        jsonAgentsMap.forEach(function (i) {
            if (i == agentId) classes.push({name: "perfclass#" + i, imports: metricArray, type: "agent"})
        });

        dMetric.parent.children.forEach(function (i) {
            classes.push({name: i.name, type: "metric"})
        });

        metricArray.push("perfclass#" + agentId);
        //jsonObjectsMap.forEach(function(i){if(i.substring(i.lastIndexOf("#") + 1) == agentId && i.indexOf(metric.parent.key) != -1) classes.push({name:i, imports:metricArray, type:"object"}) });

        //TODO
        var indexOfAGENTID = classMap.get(pclass).objects.indexOf("BOOMAGENTID"),
            perfObjects = classMap.get(pclass).objects;

        classMap.get(pclass).objectvalues.forEach(function (i) {
            //console.log("jsonObjectsMap i++ ", i);
            if (i[indexOfAGENTID] == agentId) classes.push({name: "perfclass#objects#" + pclass + "#" + i[0] + "#" + i[1], imports: metricArray, type: "object", object: i, objects: perfObjects})
        });

        link = svg.append("g").selectAll(".link");
        node = svg.append("g").selectAll(".node");

        var nodes = cluster.nodes(packageHierarchy(classes));
        links = packageImports(nodes);

        link = link
            .data(bundle(links))
            .enter().append("path")
            .each(function (d) {
                d.source = d[0], d.target = d[d.length - 1];
            })
            .attr("class", "link")
            .attr("d", line);
        //.on("mousedown", function() {
        //console.log({"x": d3.event.x, "y": d3.event.y});
        //});

        // Exit…
        //link.data(bundle(links)).exit().remove("path");

        node = node
            .data(nodes.filter(function (n) {
                return !n.children;
            }))
            .enter().append("g")
            //.attr("class", "node")
            .attr("class", function (d) {
                return "node " + d.type;
            })
            .attr("transform", function (d) {
                return "rotate(" + (d.x - 90) + ")translate(" + d.y + ")";
            })
            .append("text")
            .attr("class", function (d) {
                if (d.key == dMetric.key || d.key == dAgent.key) {
                    return "node--hl";
                }

            })
            .attr("dx", function (d) {
                return d.x < 180 ? 8 : -8;
            })
            .attr("dy", ".31em")
            .attr("text-anchor", function (d) {
                return d.x < 180 ? "start" : "end";
            })
            .attr("transform", function (d) {
                return d.x < 180 ? null : "rotate(180)";
            })
            //.text(function(d) { return  agentsMap.get(d.key) ? d.type == "agent" ? agentsMap.get(d.key).host:agentsMap.get(d.key).host+ "." +d.parent.key+"." +d.parent.parent.key :d.parent.key			+"."+d.key; })
            .text(function (d) {
                return  agentsMap.get(d.key) ? d.type == "agent" ? agentsMap.get(d.key).host : d.parent.parent.key + " | " + d.parent.key : d.parent.key + "." + d.key;
            })
            .on("mouseover", mouseovered)
            .on("mouseout", mouseouted)
            .on("click", mouseclickRenderChart);

        node.append("svg:title").text(function (d) {
            return d.type;
        });


        // Exit…
        //node.data(bundle(links)).exit().remove("path");
        d3.select("#back").style("display", "inline-block");
    }

// Lazily construct the package hierarchy from class names.
    function packageHierarchy(classes) {
        var map = {};

        function find(name, data) {
            var node = map[name], i;
            if (!node) {
                node = map[name] = data || {name: name, children: []};
                if (name.length) {
                    node.parent = find(name.substring(0, i = name.lastIndexOf("#")));
                    node.parent.children.push(node);
                    node.key = name.substring(i + 1);
                }
            }
            return node;
        }

        classes.forEach(function (d) {
            find(d.name, d);
        });

        return map[""];
    }

// Return a list of imports for the given array of nodes.
    function packageImports(nodes) {
        var map = {},
            imports = [];

        // Compute a map from name to node.
        nodes.forEach(function (d) {
            map[d.name] = d;
        });

        // For each import, construct a link from the source to target node.
        nodes.forEach(function (d) {
            if (d.imports) d.imports.forEach(function (i) {
                imports.push({source: map[d.name], target: map[i]});
            });
        });

        return imports;
    }


    function renderChart(perfClass, metric, agentID, objects, object, interval, fromDate, toDate) {

        d3.select(".chart").select("svg").remove();

        var margin = {top: 10, right: 10, bottom: 100, left: 50},
            margin2 = {top: 430, right: 10, bottom: 20, left: 50},
            width = 960 - margin.left - margin.right,
            height = 500 - margin.top - margin.bottom,
            height2 = 500 - margin2.top - margin2.bottom;

        var parseDate = d3.time.format("%b %Y").parse;

        var x = d3.time.scale().range([0, width]),
            x2 = d3.time.scale().range([0, width]),
            y = d3.scale.linear().range([height, 0]),
            y2 = d3.scale.linear().range([height2, 0]);

        var xAxis = d3.svg.axis().scale(x).orient("bottom"),
            xAxis2 = d3.svg.axis().scale(x2).orient("bottom"),
            yAxis = d3.svg.axis().scale(y).orient("left").ticks(10);

        var brush = d3.svg.brush()
            .x(x2)
            .on("brush", brushed);
        //area
//        var area = d3.svg.area()
//            .interpolate("linear")
//            .x(function (d) {
//                return x(d.date);
//            })
//            .y0(height)
//            .y1(function (d) {
//                //console.log("d.close", d);
//                return y(d.close);
//            });
//
//        var area2 = d3.svg.area()
//            .interpolate("linear")
//            .x(function (d) {
//                return x2(d.date);
//            })
//            .y0(height2)
//            .y1(function (d) {
//                return y2(d.close);
//            });

        //line
        var area = d3.svg.line()
            .interpolate("linear")
            .x(function(d) { return x(d.date); })
            //.y0(height)
            .y(function(d) { return y(d.close); });

        var area2 = d3.svg.line()
            .interpolate("linear")
            .x(function(d) { return x2(d.date); })
            //.y0(height2)
            .y(function(d) { return y2(d.close); });


        var svg = d3.select(".chart").append("svg")
            //.attr("width", width + margin.left + margin.right)
            //.attr("height", height + margin.top + margin.bottom)
            .attr({
                "width": "100%",
                "height": "100%"
            })
            .attr("viewBox", "0 0 " + (width + margin.left) + " " + 500)
            .attr("preserveAspectRatio", "xMidYMid meet");

        svg.append("defs").append("clipPath")
            .attr("id", "clip")
            .append("rect")
            .attr("width", width)
            .attr("height", height);

        var focus = svg.append("g")
            .attr("class", "focus")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

        var context = svg.append("g")
            .attr("class", "context")
            .attr("transform", "translate(" + margin2.left + "," + margin2.top + ")");

        var objectsString = "", objectArray = [];

        objects.forEach(function (i, j) {
            objectArray.push(i + "=" + object[j])
        });

        objectsString = objectArray.join(",");

        //console.log("URL: " + "/json/perfdata?class=" + perfClass + "&metric=" + metric + "&id=" + agentID + "&objects=" + objectsString + "&interval=2592000000");
        //console.log("URL2: " + "/json/perfdata?class=" + perfClass + "&metric=" + metric + "&id=" + agentID + "&objects=" + objectsString + "&from=" + fromDate + "&to=" + toDate);


        var intervalValue = 86400000 * 10;
        //d3.csv("sp500.csv", type, function(error, data) {
        // d3.json("/json/perfdata?class=" + perfClass + "&metric=" + metric + "&id=" + agentID + "&objects=" + objectsString + "&interval=" + intervalValue, function (error, json) {
        d3.json("/json/perfdata?class=" + perfClass + "&metric=" + metric + "&id=" + agentID + "&objects=" + objectsString + "&from=" + fromDate + "&to=" + toDate, function (error, json) {

            var chartData = [], kv = json.data[0];

//            console.log("time", kv.times.length);

            for (var i = 0; i < kv.times.length; i++) {

                chartData.push({"date": new Date(kv.times[i]), "close": kv.values[i] });
            }

            //x.domain(d3.extent(data.map(function(d) { return d.date; })));
            x.domain(d3.extent(chartData.map(function (d) {
                //console.log("d.date",d.date);
                return d.date;
            })));
            //y.domain(d3.extent(chartData, function(d) { return d.close; }));

            y.domain([d3.min(chartData, function (d) {
                return d.close * 0.90;
            }), d3.max(chartData, function (d) {
                return d.close * 1.08;
            })]);

            //x.domain(d3.extent(chartData.map(function(d) { return chartData.date; })));
            //y.domain([0, d3.max(chartData.map(function(d) { return chartData.close; }))]);
            x2.domain(x.domain());
            y2.domain(y.domain());





            focus.append("g")
                .attr("class", "y axis")
                .call(yAxis)
                .append("text")
                .attr("transform", "rotate(-90)")
                .attr("y", 6)
                .attr("dy", ".71em")
                .style("text-anchor", "end")
                .style("font", "8px sans-serif")
                .text(metric);

            d3.selectAll("g.y.axis g.tick line")
                .attr("class", "tick-line");

            focus.selectAll("g.y.axis g.tick")
                .append("line")
                .classed("grid-line", true)
                .attr("x1", 0)
                .attr("y1", 0)
                .attr("x2", width)
                .attr("y2", 0);

            focus.append("path")
                .datum(chartData)
                .attr("transform", "translate(1, 0 )")
                .attr("class", "line")
                .attr("d", area);

            focus.append("g")
                .attr("class", "x axis")
                .attr("transform", "translate(0," + height + ")")
                .call(xAxis);

            d3.selectAll("g.x.axis g.tick line")
                .attr("class", "tick-line");

            context.append("path")
                .datum(chartData)
                .attr("class", "line")
                .attr("d", area2);

            context.append("g")
                .attr("class", "x axis")
                .attr("transform", "translate(0," + height2 + ")")
                .call(xAxis2);

            context.append("g")
                .attr("class", "x brush")
                .call(brush)
                .selectAll("rect")
                .attr("y", -6)
                .attr("height", height2 + 7);

            context.selectAll("g.x.axis g.tick line")
                .attr("class", "tick-line");

            //display chart and titel
            d3.select(".char-title").select(".chart-title-text").remove();
            d3.select(".char-title").append("span").attr("class", "chart-title-text").text(kv.HOST + " checked from agent: " + agentsMap.get(agentID).label);
            d3.select(".chart-panel").style("display", "block");


            d3.select("#bookmarkme")
                .attr("target", "_blank")
                .attr("href", "perf-data-bookmark.html?class="+perfClass
                    +"&metric="+metric
                    +"&id="+agentId
                    +"&objects="+objectsString
                    +"&from="+fromDate
                    +"&to="+toDate
                    +"&agentLabel="+agentsMap.get(agentId).label)

        });


        function brushed() {
            x.domain(brush.empty() ? x2.domain() : brush.extent());
            focus.select(".line").attr("d", area);
            focus.select(".x.axis").call(xAxis);

            focus.selectAll("g.x.axis g.tick line")
                .attr("class", "tick-line");
        }

        function type(d) {
            d.date = parseDate(d.data[0].times);
            d.close = +d.data[0].values;
            return d;
        }


    }

    function mouseclickRenderChart(d) {

        if (d) {

            if (d.type == "agent") {
                agentId = d.key;
            } else if (d.type == "metric") {
                dMetric = d;
                pclass = d.parent.key;
            } else if (d.type == "object") {
                agentObject = d;
            }
        }


        /*
         console.log(d, pclass,
         dMetric,
         agentId,
         agentObject,
         interval);
         */
        //console.log("d3: ", d);


        //if(dAgent && dMetric && agentObject) renderChart(pclass, dMetric.key, agentId, agentObject.objects, agentObject.object, interval);

        if (dAgent && dMetric && agentObject) renderChart(pclass, dMetric.key, agentId, agentObject.objects, agentObject.object, interval, past.getTime(), now.getTime());

        node
            .each(function (n) {
                n.target = n.source = false;
            });

        link
            .classed("link--target", function (l) {
                if (l.target === d) return l.source.source = true;
            })
            .classed("link--source", function (l) {
                if (l.source === d) return l.target.target = true;
            })
            .filter(function (l) {
                return l.target === d || l.source === d;
            })
            .each(function () {
                this.parentNode.appendChild(this);
            });

        node
            .classed("node--target", function (n) {
                return n.target;
            })
            .classed("node--source", function (n) {
                return n.source;
            })
            .classed("node--hl", false);
    }


    function mouseclick(d) {
        //if(!d3.select(this).classed("node--source")) return;
        //console.log("click0", d, this);

        if (d) {

            if (d.type == "agent") {
                agentId = d.key;
                dAgent = d;
            } else {
                //metric = d;
                pclass = d.parent.key;
                dMetric = d;
            }
        }

        if (dAgent && dMetric && d.target || d.source)  renderObjects(jsonAgentsMap, metrics, perObjects, jsonAgentObjectsMap);

        //console.log("click1", d, d3.select(this), this);

        node
            .each(function (n) {
                n.target = n.source = false;
            });

        link
            .classed("link--target", function (l) {
                if (l.target === d) return l.source.source = true;
            })
            .classed("link--source", function (l) {
                if (l.source === d) return l.target.target = true;
            })
            .filter(function (l) {
                return l.target === d || l.source === d;
            })
            .each(function () {
                this.parentNode.appendChild(this);
            });


        node
            .classed("node--target", function (n) {
                return n.target;
            })
            .classed("node--source", function (n) {
                return n.source;
            });

    }

    function mouseovered(d) {
//        console.log("mouseover render 2", node);
        if (agentId || dMetric) return;

        node
            .each(function (n) {
                n.target = n.source = false;
            });

        link
            .classed("link--target", function (l) {
                if (l.target === d) return l.source.source = true;
            })
            .classed("link--source", function (l) {
                if (l.source === d) return l.target.target = true;
            })
            .filter(function (l) {
                return l.target === d || l.source === d;
            })
            .each(function () {
                this.parentNode.appendChild(this);
            });

        node
            .classed("node--target", function (n) {
                return n.target;
            })
            .classed("node--source", function (n) {
                return n.source;
            });
    }

    function mouseouted(d) {
        //if(selected) return;
        if (agentId || dMetric) return;
        link
            .classed("link--target", false)
            .classed("link--source", false);

        node
            .classed("node--target", false)
            .classed("node--source", false);
    }

    d3.select(window)
        .on("mousemove", mousemove)
        .on("mouseup", mouseup);

    function mouse(e) {
        console.log("mouse: ", e);
        return [e.pageX - rx, e.pageY - ry];
    }

    function mousedown() {
        m0 = mouse(d3.event);
        console.log("down: ", m0);
        d3.event.preventDefault();
    }

    function mousemove() {
        if (m0) {
            var m1 = mouse(d3.event),
                dm = Math.atan2(cross(m0, m1), dot(m0, m1)) * 180 / Math.PI;
            console.log("move: ", m0, m1, dm);
            svg.style("-webkit-transform", "translateY(" + (ry - rx) + "px)rotateZ(" + dm + "deg)translateY(" + (rx - ry) + "px)");
        }
    }

    function mouseup() {
        if (m0) {
            var m1 = mouse(d3.event),
                dm = Math.atan2(cross(m0, m1), dot(m0, m1)) * 180 / Math.PI;

            rotate += dm;
            if (rotate > 360) rotate -= 360;
            else if (rotate < 0) rotate += 360;
            m0 = null;

            div.style("-webkit-transform", null);

            svg
                .attr("transform", "translate(" + rx + "," + ry + ")rotate(" + rotate + ")")
                .selectAll("g.node text")
                .attr("dx", function (d) {
                    return (d.x + rotate) % 360 < 180 ? 8 : -8;
                })
                .attr("text-anchor", function (d) {
                    return (d.x + rotate) % 360 < 180 ? "start" : "end";
                })
                .attr("transform", function (d) {
                    return (d.x + rotate) % 360 < 180 ? null : "rotate(180)";
                });
        }
    }

    function cross(a, b) {
        return a[0] * b[1] - a[1] * b[0];
    }

    function dot(a, b) {
        return a[0] * b[0] + a[1] * b[1];
    }

    d3.select("#back").on("click", renderMetricSelector);

//    $('#date-start .input-group.date').datepicker({
//        weekStart: 1,
//        orientation: "left auto"
//    });
//
//    $('#date-end .input-group.date').datepicker({
//        weekStart: 1,
//        orientation: "reight auto"
//    });

    $('.input-daterange').datepicker({
        format: "dd/mm/yyyy",
        weekStart: 1,
        orientation: "bottom auto",
        todayHighlight: true,
        autoclose: true,
        //startDate: '-30d',
        endDate: '0'

    });

    var nowTemp = new Date();
    var nowDataPicker = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 0, 0, 0, 0);
    var now = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 23, 59, 59, 0);

    nowTemp.setDate(nowTemp.getDate() - 5);
    var past = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 0, 0, 0, 0);

    $('.input-daterange .start-date').datepicker('setDate', past);
    $('.input-daterange .end-date').datepicker('setDate', nowDataPicker);

    $('#datepicker-go').on('click', function (e) {

        var fromDate = $('.start-date').val().split("/");;
        var toDate = $('.end-date').val().split("/");;

        fromDate2 = past = new Date(fromDate[2], fromDate[1] - 1, fromDate[0], 0,0,0);
        toDate2 = now = new Date(toDate[2], toDate[1] - 1, toDate[0], 23,59,59);


        //renderChart(pclass, dMetric.key, agentId, agentObject.objects, agentObject.object, interval, fromDate2.getTime(), toDate2.getTime());
        renderChart(pclass, dMetric.key, agentId, agentObject.objects, agentObject.object, interval, fromDate2.getTime(), toDate2.getTime());
    });

//    function GetWidth()
//    {
//        var x = 0;
//        if (self.innerHeight)
//        {
//            x = self.innerWidth;
//        }
//        else if (document.documentElement && document.documentElement.clientHeight)
//        {
//            x = document.documentElement.clientWidth;
//        }
//        else if (document.body)
//        {
//            x = document.body.clientWidth;
//        }
//        return x;
//    }
//
//    function GetHeight()
//    {
//        var y = 0;
//        if (self.innerHeight)
//        {
//            y = self.innerHeight;
//        }
//        else if (document.documentElement && document.documentElement.clientHeight)
//        {
//            y = document.documentElement.clientHeight;
//        }
//        else if (document.body)
//        {
//            y = document.body.clientHeight;
//        }
//        return y;
//    }

}

