function fillList(d, agentsMap) {

    if (d.type == "agt" && agentsMap.get(d.link)) {
        var text = d3.select("#label").text("");
        text.append("span").attr("class", "highlight").text(agentsMap.get(d.link).label);
        d3.select("#host").text("Host: " + agentsMap.get(d.link).host);
        d3.select("#ip").text("IP: " + agentsMap.get(d.link).ip);

        d3.select("#ind_total")
            .text(getIndTotal(d));
//            .text(function(d){
//                var d =d;
//                return d.obj ? agentsMap.get(d.link).ind_total : "";
//            });

        d3.select("#ind_av")
            .text(getIndAv(d))
            .style("background", getSevAv(d));

//        d3.select("#ind_av_number")
//            .text(getIndAv(d))
//            .style("background", getSevAv(d));


        d3.select("#ind_kpi")
            .text(getIndKpi(d))
            .style("background", getSevKpi(d));

        d3.select("#ind_other")
            .text(getIndOther(d))
            .style("background", getSevOther(d));
        //.style("width", function(){console.log("i++",this)});



    } else {

        var sum_ind_total = 0, sum_ind_av = 0, sum_ind_kpi = 0, sum_ind_other = 0;

        sumOfChild(d);

        var text = d3.select("#label").text("");
        text.append("span").attr("class", "highlight").text(d.name)
        //d3.select("#label span").text(agentsMap.get(d.link).label);
        //d3.select("#host").text("Host: " + agentsMap.get(d.link).host);
        //d3.select("#ip").text("IP: " + agentsMap.get(d.link).ip);


        d3.select("#ind_total")
            .text(sum_ind_total);

        d3.select("#ind_av")
            .text(sum_ind_av)
            .style("background", "#e5e5e5");

        d3.select("#ind_kpi")
            .text(sum_ind_kpi)
            .style("background", "#e5e5e5");

        d3.select("#ind_other")
            .text(sum_ind_other)
            .style("background", "#e5e5e5");
        //.style("width", function(){console.log("i++",this)});

    }

    function sumOfChild(d) {

        if (d.elements) {
            d.elements.forEach(function (i) {
                sumOfChild(i);
            });
        } else if (d.type == "agt" && agentsMap.get(d.link)) {
            sum_ind_total += agentsMap.get(d.link).ind_total;
            sum_ind_av += agentsMap.get(d.link).ind_av;
            sum_ind_kpi += agentsMap.get(d.link).ind_kpi;
            sum_ind_other += agentsMap.get(d.link).ind_other;
        }else{
            sum_ind_total = 0;
            sum_ind_av = 0;
            sum_ind_kpi = 0;
            sum_ind_other = 0;
        }

        return 0;

    }

    function getSevAv(d) {
        return d.obj ? treemap_color(agentsMap.get(d.link).sev_av) : ""
    }

    function getSevKpi(d) {
        return d.obj ? treemap_color(agentsMap.get(d.link).sev_kpi) : ""
    }

    function getSevOther(d) {
        return d.obj ? treemap_color(agentsMap.get(d.link).sev_other) : ""
    }

    function getIndAv(d) {
        return d.obj ? agentsMap.get(d.link).ind_av : ""
    }
    function getIndKpi(d) {
        return d.obj ? agentsMap.get(d.link).ind_kpi : ""
    }
    function getIndOther(d) {
        return d.obj ? agentsMap.get(d.link).ind_other : ""
    }
    function getIndTotal(d) {
        return d.obj ? agentsMap.get(d.link).ind_total : ""
    }

}

function fillListTreemap(d, agentsMap) {

    if (d.type == "agt") {
        //"lables: "+agentsMap.get(d.link).label+"\n\n host: "+agentsMap.get(d.link).host+"\nip: "+agentsMap.get(d.link).ip+"\n online: "+agentsMap.get(d.link).online
        var text = d3.select("#label").text("");
        text.append("span").attr("class", "highlight").text(d.parent.name + " / " + (agentsMap.get(d.link) ? agentsMap.get(d.link).label:"death link"));
        //d3.select("#label span").text(agentsMap.get(d.link).label);
        d3.select("#host").text("Host: " + (agentsMap.get(d.link) ? agentsMap.get(d.link).host: ""));
        d3.select("#ip").text("IP: " + (agentsMap.get(d.link) ? agentsMap.get(d.link).ip:""));


        d3.select("#ind_total")
            .text((d.type == "agt") ? agentsMap.get(d.link) ? agentsMap.get(d.link).ind_total : "":"");
//            .text(function(d){
//                var d =d;
//                return d.obj ? agentsMap.get(d.link).ind_total : "";
//            });

        d3.select("#ind_av")
            .text((d.type == "agt") ? agentsMap.get(d.link) ? agentsMap.get(d.link).ind_av : "":"")
            .style("background", (d.type == "agt") ? agentsMap.get(d.link) ? treemap_color(agentsMap.get(d.link).sev_av) : "":"");

        d3.select("#ind_kpi")
            .text((d.type == "agt") ? agentsMap.get(d.link) ? agentsMap.get(d.link).ind_kpi : "":"")
            .style("background", (d.type == "agt") ? agentsMap.get(d.link) ? treemap_color(agentsMap.get(d.link).sev_kpi) : "":"");

        d3.select("#ind_other")
            .text((d.type == "agt") ? agentsMap.get(d.link) ? agentsMap.get(d.link).ind_other : "":"")
            .style("background", (d.type == "agt") ? agentsMap.get(d.link) ? treemap_color(agentsMap.get(d.link).ind_other) : "":"");
        //.style("width", function(){console.log("i++",this)});


    }
}


function fillListAgent(d, agentsMap) {
    //if(!(d.type == "agt")) return;
    //"lables: "+agentsMap.get(d.link).label+"\n\n host: "+agentsMap.get(d.link).host+"\nip: "+agentsMap.get(d.link).ip+"\n online: "+agentsMap.get(d.link).online
    var text = d3.select("#label").text("");
    text.append("span").attr("class", "highlight").text(agentsMap.get(d.id).label)
    //d3.select("#label span").text(agentsMap.get(d.link).label);
    d3.select("#host").text("Host: " + agentsMap.get(d.id).host);
    d3.select("#ip").text("IP: " + agentsMap.get(d.id).ip);


    d3.select("#ind_total")
        .text(d.ind_total);

    d3.select("#ind_av")
        .text(d.ind_av)
        .style("background", treemap_color(d.sev_av));

    d3.select("#ind_kpi")
        .text(d.ind_kpi)
        .style("background", treemap_color(d.sev_kpi));

    d3.select("#ind_other")
        .text(d.ind_other)
        .style("background", treemap_color(d.sev_other));
    //.style("width", function(){console.log("i++",this)});

//    function getSevAv(d) {
//        return treemap_color(agentsMap.get(d.id).sev_av)
//    }
//
//    function getSevKpi(d) {
//        return  treemap_color(agentsMap.get(d.id).sev_kpi)
//    }
//
//    function getSevOther(d) {
//        return treemap_color(agentsMap.get(d.id).sev_other)
//    }

//    function getIndAv(d) {
//        return agentsMap.get(d.id).ind_av
//    };
//    function getIndKpi(d) {
//        return agentsMap.get(d.id).ind_kpi
//    };
//    function getIndOther(d) {
//        return agentsMap.get(d.id).ind_other
//    };
//    function getIndTotal(d) {
//        return agentsMap.get(d.id).ind_total
//    };


}

function treemap_color(severity) {

    switch (severity) {
        case 0:
        case -6:
            sev = "#D3D3D3";
            break;
        case 1:
        case -5:
            sev = "#92d967";
            break;
        case 2:
        case -4:
            sev ="#77d0ef";
            break;
        case 3:
        case -3:
            sev = "#f5e400";
            break;
        case 4:
        case -2:
            sev = "#ff9e00";
            break;
        case 5:
        case -1:
            sev = "#ff665a";
            break;
        default:
            sev = "#e8e8e8";
            break;
    }
    return sev;


    //if (severity < 2) {
    //    return "#92d967"; //rgb(146, 217, 103) green
    //}
    //if (severity == 2) {
    //    return "#77d0ef"; //rgb(119, 208, 239)
    //} else if (severity == 3) {
    //    return "#f5e400"; //rgb(245, 228, 0)
    //} else if (severity == 4) {
    //    return "#ff9e00"; //rgb(255, 158, 0)
    //} else if (severity == 5) {
    //    return "#ff665a"; //rgb(255, 102, 90) red
    //}
    //return "#e8e8e8";
}

function agt_status_color(status) {

    if (status == "Offline") {
        return "#ff665a";
    } else if (status == "Online") {
        return "#92d967";
    } else if (status == "Not Approved") {
        return "#ff9e00";
    }
    return "#e8e8e8";
}

//close tooltip
d3.select("#list-close").on("click", function () {

    d3.select("#tooltipPartition #tooltip").style("opacity", 0);

});

var iOS = ( navigator.userAgent.match(/(iPad|iPhone|iPod)/g) ? true : false );

if (!iOS){
    d3.select("#list-close").style("display", "none");

}
