var svg, colorScale, activ, indi = "sev_max";

function mouseover(d, fillList){

    var tip = d3.select("#tooltip");

    tip.select("#value")
        .text(fillList(d));

    var mousex = d3.event.pageX + 20; //Get X coodrinates
    var mousey = d3.event.pageY + 20; //Get Y coordinates

    var tipWidth = $(tip.node()).width(); //Find width of tooltip
    var tipHeight = $(tip.node()).height(); //Find height of tooltip

    //Distance of element from the right edge of viewport
    var tipVisX = $(window).width() - (mousex + tipWidth);
    //Distance of element from the bottom of viewport
    var tipVisY = $(window).height() - (mousey + tipHeight);

    if ( tipVisX < 20 ) { //If tooltip exceeds the X coordinate of viewport

        if( tipWidth > d3.event.pageX - 20 ){
            mousex = 0;
        } else {
            mousex = d3.event.pageX - tipWidth - 20;
        }

    } if ( tipVisY < 20 ) { //If tooltip exceeds the Y coordinate of viewport
        mousey = d3.event.pageY - tipHeight - 20;
    }
    tip.style("left", mousex + "px")
        .style("top", mousey + "px");

    //Show the tooltip
    tip.transition()
        .duration(200)
        .delay(100)
        .style("opacity", .9);

}

function mouseout(){

    var tip = d3.select("#tooltip");

    tip.transition()
        .duration(2)
        .style("opacity", 0);
}

function renderHeatmap() {


    activ = setInterval(function () {

        colorScale = d3.scale.quantile()
            .domain([ 0, 5])
            .range(colors);

        d3.json("/json/heatappgrp" + '?' + Math.floor(Math.random() * 1000), function (error, data) {
            //d3.json("../json_test/heatappgrp.json"+ '?' + Math.floor(Math.random() * 1000), function(error, data) {
            //var t = d3.select("svg").transition().duration(3000);

            var rowMap = d3.map(), colMap = d3.map(), colRowMap = d3.map(), dataBackground = [];

            data.forEach(function (i, j) {
                rowMap.set(i.app, i)
            });
            data.forEach(function (i, j) {
                colMap.set(i.grp, i)
            });
            data.forEach(function (i, j) {
                colRowMap.set(i.app + i.grp, i)
            });

            var cell = d3.select("svg").selectAll(".cell")
                .data(data, function (d) {
                    return d.app + ":" + d.grp;
                })
                //.select("rect")
                //.transition().duration(500)
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                });

        });

    }, 20000);

    d3.selectAll("svg").remove();

    var margin = { top: 150, right: 10, bottom: 50, left: 150 },
        cellSize = 12;
    col_number = 60;
    row_number = 50;
    width = 0, // - margin.left - margin.right,
        height = 0 , // - margin.top - margin.bottom,
        //gridSize = Math.floor(width / 24),
        legendElementWidth = cellSize * 2.5,
        colorBuckets = 6,
        //colors = ['#005824', '#699F83', '#D2E6E3', '#E6D3E1', '#BB6990', '#91003F'];//.reverse();
        colors = ['#e8e8e8', '#92d967', '#77d0ef', '#f5e400', '#ff9e00', '#ff665a'];//.reverse();
    //['#005824','#1A693B','#347B53','#4F8D6B','#699F83','#83B09B','#9EC2B3','#B8D4CB','#D2E6E3','#EDF8FB','#FFFFFF','#F1EEF6','#E6D3E1','#DBB9CD','#D19EB9','#C684A4','#BB6990','#B14F7C','#A63467','#9B1A53','#91003F'];
    hcrow = [] //change to gene name or probe id
    hccol = [] //change to gene name or probe id
    rowLabel = [] //change to gene name or probe id
    colLabel = [] //change to contrast name


    d3.select("#loading-indicator").style("display", "inline");

    d3.json("/json/heatappgrp" + '?' + Math.floor(Math.random() * 1000), function (error, data) {
//d3.json("../json_test/heatappgrp.json"+ '?' + Math.floor(Math.random() * 1000), function(error, data) {
        d3.select("#loading-indicator").style("display", "none");

        var rowMap = d3.map(), colMap = d3.map(), colRowMap = d3.map(), dataBackground = [];

        data.forEach(function (i, j) {
            rowMap.set(i.app, i)
        });
        data.forEach(function (i, j) {
            colMap.set(i.grp, i)
        });
        data.forEach(function (i, j) {
            colRowMap.set(i.app + i.grp, i)
        });

//background grid
        var lowEnd = 1;
        while (lowEnd <= colMap.keys().length) {
            dataBackground.push(lowEnd++);
        }

        var gridData = new Array(rowMap.keys().length);
        for (var i = 0; i < rowMap.keys().length; i++) {
            gridData[i] = dataBackground;
        }

        row_number = rowMap.keys().length;
        col_number = colMap.keys().length;

//var colSorted=d3.range(col_number).sort(function(a,b){ if(sortOrder){ return d3.ascending(colMap.keys()[a], colMap.keys()[b]);}else{ return d3.descending(colMap.keys()[a], colMap.keys()[b]);}});

//var rowSorted=d3.range(row_number).sort(function(a,b){ if(sortOrder){return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);}else{ return d3.descending(rowMap.keys()[a], rowMap.keys()[b]);}});

        width = cellSize * col_number < 300 ? 300 : cellSize * col_number; // - margin.left - margin.right,
        height = cellSize * row_number; // - margin.top - margin.bottom,
//console.log("wh++",width , height, col_number, row_number);

        colorScale = d3.scale.quantile()
            .domain([ 0, 5])
            .range(colors);

        svg = d3.select("#heatmap-chart-area").append("svg")
            .attr("width", width + margin.left + margin.right)
            .attr("height", height + margin.top + margin.bottom)
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")")
        ;
        var rowSortOrder = false;
        var colSortOrder = false;

        svg.append("text")      // text label for the x axis
            .attr("x", -20)
            .attr("y", -10)
            .attr("fill", "#ADADAD")
            .style("text-anchor", "end")
            .text("apps");

        svg.append("text")      // text label for the y axis
            .attr("x", 20)
            .attr("y", -15)
            .attr("fill", "#ADADAD")
            .style("text-anchor", "start")
            .text("groups")
            .attr("transform", "translate(" + cellSize / 2 + ",0) rotate (-90)");

        svg.append("line")
            .attr("x1", -5)
            .attr("y1", -5)
            .attr("x2", -50)
            .attr("y2", -50)
            .attr("stroke-width", 1)
            .attr("stroke", "#aaa");

        var rowLabels = svg.append("g")
            .selectAll(".rowLabelg")
            .data(rowMap.keys())
            .enter()
            .append("text")
            .text(function (d) {
                return d;
            })
            .attr("x", 0)
            .attr("y", function (d, i) {
                return rowMap.keys().indexOf(d) * cellSize;
            })
            .style("text-anchor", "end")
            .attr("transform", "translate(-6," + cellSize / 1.5 + ")")
            .attr("class", function (d, i) {
                return "rowLabel mono r" + i;
            })
            .on("mouseover", function (d) {
                d3.select(this).classed("text-hover", true);
            })
            .on("mouseout", function (d) {
                d3.select(this).classed("text-hover", false);
            })
            .on("click", function (d, i) {
                rowSortOrder = !rowSortOrder;
                sortbylabel("r", i, rowSortOrder);
                //d3.select("#order").property("selectedIndex", 3).node().focus();
            });


        var colLabels = svg.append("g")
            .selectAll(".colLabelg")
            .data(colMap.keys())
            .enter()
            .append("text")
            .text(function (d) {
                return d;
            })
            .attr("x", 0)
            .attr("y", function (d, i) {
                return colMap.keys().indexOf(d) * cellSize;
            })
            .style("text-anchor", "left")
            .attr("transform", "translate(" + cellSize / 2 + ",-6) rotate (-90)")
            .attr("class", function (d, i) {
                return "colLabel mono c" + i;
            })
            .on("mouseover", function (d) {
                d3.select(this).classed("text-hover", true);
            })
            .on("mouseout", function (d) {
                d3.select(this).classed("text-hover", false);
            })
            .on("click", function (d, i) {
                colSortOrder = !colSortOrder;
                sortbylabel("c", i, colSortOrder);
                //d3.select("#order").property("selectedIndex", 2).node().focus();
            });
        /*
         var row = svg.selectAll(".row")
         .data(matrix)
         .enter().append("g")
         .attr("class", "row")
         .attr("transform", function(d, i) { return "translate(0," + x(i) + ")"; })
         .each(row);*/

        var grid = svg.append("g").attr("class", "g3")
            .selectAll(".cellg")
            .data(gridData)
            .enter()
            .append("g")
            .each(row, i);

        function row(row, i) {
            var cell = d3.select(this).selectAll(".cell2")
                .data(row, function (i) {
                    return row[i]
                })
                .enter()
                .append("rect")
                .attr("x", function (d, j) {
                    return j * cellSize;
                })
                .attr("y", function (d) {
                    return i * cellSize;
                })
                //.attr("class", function(d){return "cell cell-border cr"+(rowLabel.indexOf(colLabel.indexOf(d.app))-1)+" cc"+(colLabel.indexOf(d.app)-1);})
                .attr("class", function (d, j) {
                    return "cell2 cell-border"
                })
                .attr("width", cellSize)
                .attr("height", cellSize)
                .style("fill", function (d) {
                    return d3.rgb(255, 255, 255);
                });
        }

        var heatMap = svg.append("g").attr("class", "g3")
                .selectAll(".cellg")
                .data(data, function (d) {
                    return d.app + ":" + d.grp;
                })
                .enter()
                .append("rect")
                .attr("x", function (d, j) {
                    return colMap.keys().indexOf(d.grp) * cellSize;
                })
                .attr("y", function (d, j) {
                    return  rowMap.keys().indexOf(d.app) * cellSize;
                })
                //.attr("class", function(d){return "cell cell-border cr"+(rowLabel.indexOf(colLabel.indexOf(d.app))-1)+" cc"+(colLabel.indexOf(d.app)-1);})
                .attr("class", function (d, j) {
                    return "cell cell-border cr" + (rowMap.keys().indexOf(d.app)) + " cc" + (colMap.keys().indexOf(d.grp));
                })
                .attr("width", cellSize)
                .attr("height", cellSize)
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                })
                /* .on("click", function(d) {
                 var rowtext=d3.select(".r"+(d.row-1));
                 if(rowtext.classed("text-selected")==false){
                 rowtext.classed("text-selected",true);
                 }else{
                 rowtext.classed("text-selected",false);
                 }
                 })*/
                .on("click", function (d) {

                    window.open("indications.html?app=" + d.app + "&grp=" + d.grp, "_self");
                    //var rowtext = d3.select(".r" + (d.row - 1));
                    //if (rowtext.classed("text-selected") == false) {
                    //    rowtext.classed("text-selected", true);
                    //} else {
                    //    rowtext.classed("text-selected", false);
                    //}
                })
                .on("mouseover", function (d) {
                    console.log("d", d);
                    //highlight text
                    d3.select(this).classed("cell-hover", true);
                    d3.selectAll(".rowLabel").classed("text-highlight", function (r, ri) {
                        return ri == (rowMap.keys().indexOf(d.app));
                    });
                    d3.selectAll(".colLabel").classed("text-highlight", function (c, ci) {
                        return ci == (colMap.keys().indexOf(d.grp));
                    });

                    mouseover(d, fillList);
                    //Update the tooltip position and value
//                    d3.select("#tooltip")
//                        .style("left", (d3.event.pageX + 10) + "px")
//                        .style("top", (d3.event.pageY - 10) + "px")
//                        .select("#value")
//                        .text(fillList(d));
//                    //Show the tooltip
//                    d3.select("#tooltip").classed("hidden", false);
                })
                .on("mouseout", function () {
                      mouseout();
                    d3.select(this).classed("cell-hover", false);
                    d3.selectAll(".rowLabel").classed("text-highlight", false);
                    d3.selectAll(".colLabel").classed("text-highlight", false);
//                    d3.select("#tooltip").classed("hidden", true);
                });
//                .call(function (d, i) {
//                    rowSortOrder = !rowSortOrder;
//                    sortbylabel("r", i, rowSortOrder);
//                }
//                ) ;


        var fillList = function (d) {

            d3.select("#app").text("App: ");
            d3.select("#app_value").text(d.app);

            d3.select("#grp").text("Group: ");
            d3.select("#grp_value").text(d.grp);
            d3.select("#indi_total").text("Total (cnt): ");
            d3.select("#indi_total_value").text(d.indi_total);
            d3.select("#cri_cnt").text("Critical (cnt): ");
            d3.select("#cri_cnt_value").text(d.cri_cnt);
            d3.select("#maj_cnt").text("Major (cnt): ");
            d3.select("#maj_cnt_value").text(d.maj_cnt);
            d3.select("#min_cnt").text("Minor (cnt): ");
            d3.select("#min_cnt_value").text(d.min_cnt);
            d3.select("#war_cnt").text("Warning (cnt): ");
            d3.select("#war_cnt_value").text(d.war_cnt);
            d3.select("#nor_cnt").text("Normal (cnt): ");
            d3.select("#nor_cnt_value").text(d.nor_cnt);
            d3.select("#unk_cnt").text("Unknow (cnt): ");
            d3.select("#unk_cnt_value").text(d.unk_cnt);

        }

        var legend = svg.selectAll(".legend")
            .data(["Un", "No", "Wa", "Mi", "Ma", "Cr" ])
            .enter().append("g")
            .attr("class", "legend");

        legend.append("rect")
            .attr("x", function (d, i) {
                return legendElementWidth * i;
            })
            .attr("y", height + (cellSize * 2))
            .attr("width", legendElementWidth)
            .attr("height", cellSize)
            .style("fill", function (d, i) {
                return colors[i];
            });

        legend.append("text")
            .attr("class", "mono")
            .text(function (d) {
                return d;
            })
            .attr("width", legendElementWidth)
            .attr("x", function (d, i) {
                return legendElementWidth * i + 3;
            })
            .attr("y", height + (cellSize * 4));

// Change ordering of cells

        function sortbylabel(rORc, i, sortOrder) {
            var t = svg.transition().duration(3000);
            var log2r = rowMap.keys();
            var sorted; // sorted is zero-based index
            d3.selectAll(".c" + rORc + i)
                .filter(function (ce) {
                    //log2r.push(rowMap.keys().indexOf(ce.app));
                })
            ;
            if (rORc == "r") { // sort log2ratio of a gene
                //sorted=d3.range(col_number).sort(function(a,b){ if(sortOrder){console.log("a-b++:",a,  b, log2r[a], log2r[b], log2r); return log2r[b]-log2r[a];}else{ return log2r[a]-log2r[b];}});

                sorted = d3.range(col_number).sort(function (a, b) {
                    if (sortOrder) {
                        return d3.ascending(colMap.keys()[a], colMap.keys()[b]);
                    } else {
                        return d3.descending(colMap.keys()[a], colMap.keys()[b]);
                    }
                });


                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return sorted.indexOf(colMap.keys().indexOf(d.grp)) * cellSize;
                    })
                ;
                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return sorted.indexOf(i) * cellSize;
                    })
                ;
            } else { // sort log2ratio of a contrast
                //sorted=d3.range(row_number).sort(function(a,b){if(sortOrder){ return log2r[b]-log2r[a];}else{ return log2r[a]-log2r[b];}});

                sorted = d3.range(row_number).sort(function (a, b) {
                    if (sortOrder) {
                        return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);
                    } else {
                        return d3.descending(rowMap.keys()[a], rowMap.keys()[b]);
                    }
                });

                t.selectAll(".cell")
                    .attr("y", function (d) {
                        return sorted.indexOf(rowMap.keys().indexOf(d.app)) * cellSize;
                    })
                ;
                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return sorted.indexOf(i) * cellSize;
                    })
                ;
            }
        }

        d3.select("#view").on("change", function (value) {
            if (this.value == "appgrp") {
                renderHeatmap();
            } else if (this.value == "hostapp") {
                renderHeatHostApp();
            } else if (this.value == "hostgrp") {
                renderHeatHostGroup();
            }
        });

        d3.select("#severity").on("change", function () {
            changeSeverity(this.value);
        });

        d3.select("#order").on("change", function () {
            rowSortOrder = !rowSortOrder;
            order(this.value);
        });

        function changeSeverity(value) {
            indi = value;
            //if(value=="sev_max"){
            //console.log("sev_max:", value);
            var t = svg.transition().duration(1000);
            t.selectAll(".cell")
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                });
            //.attr("x", function(d) { return (rowMap.keys().indexOf(d.grp)) * cellSize; })
            //.attr("y", function(d) { return (colMap.keys().indexOf(d.host)) * cellSize; });
            /*
             }else if (value=="sev_max_av"){
             var t = svg.transition().duration(1000);
             t.selectAll(".cell")
             .style("fill", function(d) { return colorScale(d.sev_max_av); });
             }else if (value=="sev_max_kpi"){
             var t = svg.transition().duration(1000);
             t.selectAll(".cell")
             .style("fill", function(d) { return colorScale(d.sev_max_kpi); });
             }else if (value=="sev_max_other"){
             var t = svg.transition().duration(1000);
             t.selectAll(".cell")
             .style("fill", function(d) { return colorScale(d.sev_max_other); });
             }*/

        }

        function order(value) {
            var colSorted = d3.range(col_number).sort(function (a, b) {
                return d3.ascending(colMap.keys()[a], colMap.keys()[b]);
            });

            var rowSorted = d3.range(row_number).sort(function (a, b) {
                return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);
            });

            if (value == "hclust") {
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (rowMap.keys().indexOf(d.app)) * cellSize;
                    })
                    .attr("y", function (d) {
                        return (colMap.keys().indexOf(d.grp)) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        console.log("cluster y2", d);
                        return rowMap.keys().indexOf(d) * cellSize;
                    })
                ;

                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        console.log("cluster y3", d);
                        return colMap.keys().indexOf(d) * cellSize;
                    })
                ;

            } else if (value == "probecontrast") {
                colSortOrder = !colSortOrder;
                rowSortOrder = !rowSortOrder;

                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (colSorted.indexOf(colMap.keys().indexOf(d.grp))) * cellSize;
                    })
                    .attr("y", function (d) {
                        return (rowSorted.indexOf(rowMap.keys().indexOf(d.app))) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return rowSorted.indexOf(i) * cellSize;
                    })
                ;

                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return colSorted.indexOf(i) * cellSize;
                    })
                ;

            } else if (value == "probe") {
                colSortOrder = !colSortOrder;
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("y", function (d) {
                        return (rowSorted.indexOf(rowMap.keys().indexOf(d.app))) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return rowSorted.indexOf(i) * cellSize;
                    })
                ;
            } else if (value == "contrast") {
                rowSortOrder = !rowSortOrder;
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (colSorted.indexOf(colMap.keys().indexOf(d.grp))) * cellSize;
                    })
                ;
                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return colSorted.indexOf(i) * cellSize;
                    })
                ;
            }
        }

        //
        var sa = d3.select(".g3")
                .on("mousedown", function () {
                    if (!d3.event.altKey) {
                        d3.selectAll(".cell-selected").classed("cell-selected", false);
                        d3.selectAll(".rowLabel").classed("text-selected", false);
                        d3.selectAll(".colLabel").classed("text-selected", false);
                    }
                    var p = d3.mouse(this);
                    sa.append("rect")
                        .attr({
                            rx: 0,
                            ry: 0,
                            class: "selection",
                            x: p[0],
                            y: p[1],
                            width: 1,
                            height: 1
                        })
                })
                .on("mousemove", function () {
                    var s = sa.select("rect.selection");

                    if (!s.empty()) {
                        var p = d3.mouse(this),
                            d = {
                                x: parseInt(s.attr("x"), 10),
                                y: parseInt(s.attr("y"), 10),
                                width: parseInt(s.attr("width"), 10),
                                height: parseInt(s.attr("height"), 10)
                            },
                            move = {
                                x: p[0] - d.x,
                                y: p[1] - d.y
                            }
                            ;

                        if (move.x < 1 || (move.x * 2 < d.width)) {
                            d.x = p[0];
                            d.width -= move.x;
                        } else {
                            d.width = move.x;
                        }

                        if (move.y < 1 || (move.y * 2 < d.height)) {
                            d.y = p[1];
                            d.height -= move.y;
                        } else {
                            d.height = move.y;
                        }
                        s.attr(d);

                        // deselect all temporary selected state objects
                        d3.selectAll('.cell-selection.cell-selected').classed("cell-selected", false);
                        d3.selectAll(".text-selection.text-selected").classed("text-selected", false);

                        d3.selectAll('.cell').filter(function (cell_d, i) {
                            if (
                                !d3.select(this).classed("cell-selected") &&
                                // inner circle inside selection frame
                                (this.x.baseVal.value) + cellSize >= d.x && (this.x.baseVal.value) <= d.x + d.width &&
                                (this.y.baseVal.value) + cellSize >= d.y && (this.y.baseVal.value) <= d.y + d.height
                                ) {

                                d3.select(this)
                                    .classed("cell-selection", true)
                                    .classed("cell-selected", true);

                                d3.select(".r" + (cell_d.row - 1))
                                    .classed("text-selection", true)
                                    .classed("text-selected", true);

                                d3.select(".c" + (cell_d.col - 1))
                                    .classed("text-selection", true)
                                    .classed("text-selected", true);
                            }
                        });
                    }
                })
                .on("mouseup", function () {
                    // remove selection frame
                    sa.selectAll("rect.selection").remove();

                    // remove temporary selection marker class
                    d3.selectAll('.cell-selection').classed("cell-selection", false);
                    d3.selectAll(".text-selection").classed("text-selection", false);
                })
                .on("mouseout", function () {
                    if (d3.event.relatedTarget.tagName == 'html') {
                        // remove selection frame
                        sa.selectAll("rect.selection").remove();
                        // remove temporary selection marker class
                        d3.selectAll('.cell-selection').classed("cell-selection", false);
                        d3.selectAll(".rowLabel").classed("text-selected", false);
                        d3.selectAll(".colLabel").classed("text-selected", false);
                    }
                })
            ;
    });


}


function renderHeatHostApp() {

    d3.selectAll("svg").remove();

    d3.select("#explanation")
        .style("display", "none");

    d3.select("#sequence")
        .style("display", "none");
    d3.select("#count").style("display", "none");
    d3.select("#size").style("display", "none");
    d3.select("#back").style("display", "none");
    d3.select("#order").style("display", "inline");
    d3.select("#view").style("display", "inline");
    d3.select("#severity").style("display", "inline");
    d3.select(".panel-title").text("Application/Host Matrix");
    d3.select(".chart-panel").style("display", "none");

    clearInterval(activ);

    activ = setInterval(function () {

        d3.json("/json/heatappgrp" + '?' + Math.floor(Math.random() * 1000), function (error, data) {

            var rowMap = d3.map(), colMap = d3.map(), colRowMap = d3.map(), dataBackground = [];

            data.forEach(function (i, j) {
                rowMap.set(i.app, i)
            });
            data.forEach(function (i, j) {
                colMap.set(i.grp, i)
            });
            data.forEach(function (i, j) {
                colRowMap.set(i.app + i.grp, i)
            });

            var cell = d3.select("svg").selectAll(".cell")
                .data(data, function (d) {
                    return d.app + ":" + d.grp;
                })
                //.select("rect")
                //.transition().duration(500)
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                });
        });

    }, 20000);


    var margin = { top: 150, right: 10, bottom: 50, left: 150 },
        cellSize = 12;
    col_number = 60;
    row_number = 50;
    width = 0, // - margin.left - margin.right,
        height = 0 , // - margin.top - margin.bottom,
//gridSize = Math.floor(width / 24),
        legendElementWidth = cellSize * 2.5,
        colorBuckets = 6,
        //colors = ['#005824', '#699F83', '#D2E6E3', '#E6D3E1', '#BB6990', '#91003F'];//.reverse();
        colors = ['#e8e8e8', '#92d967', '#77d0ef', '#f5e400', '#ff9e00', '#ff665a'];//.reverse();
//['#005824','#1A693B','#347B53','#4F8D6B','#699F83','#83B09B','#9EC2B3','#B8D4CB','#D2E6E3','#EDF8FB','#FFFFFF','#F1EEF6','#E6D3E1','#DBB9CD','#D19EB9','#C684A4','#BB6990','#B14F7C','#A63467','#9B1A53','#91003F'];
    hcrow = [] //change to gene name or probe id
    hccol = [] //change to gene name or probe id
    rowLabel = [] //change to gene name or probe id
    colLabel = [] //change to contrast name

    d3.select("#loading-indicator").style("display", "inline");

    d3.json("/json/heathostapp" + '?' + Math.floor(Math.random() * 1000), function (error, data) {

        d3.select("#loading-indicator").style("display", "none");

        var rowMap = d3.map(), colMap = d3.map(), colRowMap = d3.map(), dataBackground = [];

        data.forEach(function (i, j) {
            rowMap.set(i.app, i)
        });
        data.forEach(function (i, j) {
            colMap.set(i.host, i)
        });
        data.forEach(function (i, j) {
            colRowMap.set(i.app + i.host, i)
        });

        //background grid
        var lowEnd = 1;
        while (lowEnd <= colMap.keys().length) {
            dataBackground.push(lowEnd++);
        }

        var gridData = new Array(rowMap.keys().length);
        for (var i = 0; i < rowMap.keys().length; i++) {
            gridData[i] = dataBackground;
        }

        row_number = rowMap.keys().length;
        col_number = colMap.keys().length;

        width = cellSize * col_number < 300 ? 300 : cellSize * col_number; // - margin.left - margin.right,
        height = cellSize * row_number; // - margin.top - margin.bottom,

        var svg = d3.select("#heatmap-chart-area").append("svg")
                .attr("width", width + margin.left + margin.right)
                .attr("height", height + margin.top + margin.bottom)
                .append("g")
                .attr("transform", "translate(" + margin.left + "," + margin.top + ")")
            ;
        var rowSortOrder = false;
        var colSortOrder = false;

        svg.append("text")      // text label for the x axis
            .attr("x", -20)
            .attr("y", -10)
            .attr("fill", "#ADADAD")
            .attr("class", "y-label")
            .style("text-anchor", "end")
            .text("apps");

        svg.append("text")      // text label for the y axis
            .attr("x", 20)
            .attr("y", -15)
            .attr("fill", "#ADADAD")
            .attr("class", "x-label")
            .style("text-anchor", "start")
            .text("hosts")
            .attr("transform", "translate(" + cellSize / 2 + ",0) rotate (-90)");

        svg.append("line")
            .attr("x1", -5)
            .attr("y1", -5)
            .attr("x2", -50)
            .attr("y2", -50)
            .attr("stroke-width", 1)
            .attr("stroke", "#aaa");

        var rowLabels = svg.append("g")
                .selectAll(".rowLabelg")
                .data(rowMap.keys())
                .enter()
                .append("text")
                .text(function (d) {
                    return d;
                })
                .attr("x", 0)
                .attr("y", function (d, i) {
                    return rowMap.keys().indexOf(d) * cellSize;
                })
                .style("text-anchor", "end")
                .attr("transform", "translate(-6," + cellSize / 1.5 + ")")
                .attr("class", function (d, i) {
                    return "rowLabel mono r" + i;
                })
                .on("mouseover", function (d) {
                    d3.select(this).classed("text-hover", true);
                })
                .on("mouseout", function (d) {
                    d3.select(this).classed("text-hover", false);
                })
                .on("click", function (d, i) {
                    rowSortOrder = !rowSortOrder;
                    sortbylabel("r", i, rowSortOrder);
                    //d3.select("#order").property("selectedIndex", 3).node().focus();
                    ;
                })
            ;

        var colLabels = svg.append("g")
            .selectAll(".colLabelg")
            .data(colMap.keys())
            .enter()
            .append("text")
            .text(function (d) {
                return d;
            })
            .attr("x", 0)
            .attr("y", function (d, i) {
                return colMap.keys().indexOf(d) * cellSize;
            })
            .style("text-anchor", "left")
            .attr("transform", "translate(" + cellSize / 2 + ",-6) rotate (-90)")
            .attr("class", function (d, i) {
                return "colLabel mono c" + i;
            })
            .on("mouseover", function (d) {
                d3.select(this).classed("text-hover", true);
            })
            .on("mouseout", function (d) {
                d3.select(this).classed("text-hover", false);
            })
            .on("click", function (d, i) {
                colSortOrder = !colSortOrder;
                sortbylabel("c", i, colSortOrder);
                //d3.select("#order").property("selectedIndex", 2).node().focus();
            });


        var grid = svg.append("g").attr("class", "g3")
            .selectAll(".cellg")
            .data(gridData)
            .enter()
            .append("g")
            .each(row, i);

        function row(row, i) {
            var cell = d3.select(this).selectAll(".cell2")
                .data(row, function (i) {
                    return row[i]
                })
                .enter()
                .append("rect")
                .attr("x", function (d, j) {
                    return j * cellSize;
                })
                .attr("y", function (d) {
                    return i * cellSize;
                })
                //.attr("class", function(d){return "cell cell-border cr"+(rowLabel.indexOf(colLabel.indexOf(d.app))-1)+" cc"+(colLabel.indexOf(d.app)-1);})
                .attr("class", function (d, j) {
                    return "cell2 cell-border"
                })
                .attr("width", cellSize)
                .attr("height", cellSize)
                .style("fill", function (d) {
                    return d3.rgb(255, 255, 255);
                });
        }

        var heatMap = svg.append("g").attr("class", "g3")
                .selectAll(".cellg")
                .data(data, function (d) {
                    return d.app + ":" + d.host;
                })
                .enter()
                .append("rect")
                .attr("x", function (d, j) {
                    return colMap.keys().indexOf(d.host) * cellSize;
                })
                .attr("y", function (d, j) {
                    return  rowMap.keys().indexOf(d.app) * cellSize;
                })
                //.attr("class", function(d){return "cell cell-border cr"+(rowLabel.indexOf(colLabel.indexOf(d.app))-1)+" cc"+(colLabel.indexOf(d.app)-1);})
                .attr("class", function (d, j) {
                    return "cell cell-border cr" + (rowMap.keys().indexOf(d.app)) + " cc" + (colMap.keys().indexOf(d.host));
                })
                .attr("width", cellSize)
                .attr("height", cellSize)
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                })
                .on("click", function (d) {
                    console.log("d++", d);

                    window.open("indications.html?app=" + d.app + "&host=" + d.host, "_self");
                    var rowtext = d3.select(".r" + (d.row - 1));
                    if (rowtext.classed("text-selected") == false) {
                        rowtext.classed("text-selected", true);
                    } else {
                        rowtext.classed("text-selected", false);
                    }
                })
                .on("mouseover", function (d) {
                    console.log(d);
                    //highlight text
                    d3.select(this).classed("cell-hover", true);
                    d3.selectAll(".rowLabel").classed("text-highlight", function (r, ri) {
                        return ri == (rowMap.keys().indexOf(d.app));
                    });
                    d3.selectAll(".colLabel").classed("text-highlight", function (c, ci) {
                        return ci == (colMap.keys().indexOf(d.host));
                    });

                    //Update the tooltip position and value
                    mouseover(d, fillList);
//                    d3.select("#tooltip")
//                        .style("left", (d3.event.pageX + 10) + "px")
//                        .style("top", (d3.event.pageY - 10) + "px")
//                        .select("#value")
//                        .text(fillList(d));
//                    //Show the tooltip
//                    d3.select("#tooltip").classed("hidden", false);
                })
                .on("mouseout", function () {
                    mouseout();
                    d3.select(this).classed("cell-hover", false);
                    d3.selectAll(".rowLabel").classed("text-highlight", false);
                    d3.selectAll(".colLabel").classed("text-highlight", false);
//                    d3.select("#tooltip").classed("hidden", true);
                });

        var fillList = function (d) {

            d3.select("#app").text("App: ");
            d3.select("#app_value").text(d.app);

            d3.select("#grp").text("Host: ");
            d3.select("#grp_value").text(d.host);
            d3.select("#indi_total").text("Total (cnt): ");
            d3.select("#indi_total_value").text(d.indi_total);
            d3.select("#cri_cnt").text("Critical (cnt): ");
            d3.select("#cri_cnt_value").text(d.cri_cnt);
            d3.select("#maj_cnt").text("Major (cnt): ");
            d3.select("#maj_cnt_value").text(d.maj_cnt);
            d3.select("#min_cnt").text("Minor (cnt): ");
            d3.select("#min_cnt_value").text(d.min_cnt);
            d3.select("#war_cnt").text("Warning (cnt): ");
            d3.select("#war_cnt_value").text(d.war_cnt);
            d3.select("#nor_cnt").text("Norma (cnt)l: ");
            d3.select("#nor_cnt_value").text(d.nor_cnt);
            d3.select("#unk_cnt").text("Unknow (cnt): ");
            d3.select("#unk_cnt_value").text(d.unk_cnt);

        };

        var legend = svg.selectAll(".legend")
            .data(["Un", "No", "Wa", "Mi", "Ma", "Cr" ])
            .enter().append("g")
            .attr("class", "legend");

        legend.append("rect")
            .attr("x", function (d, i) {
                return legendElementWidth * i;
            })
            .attr("y", height + (cellSize * 2))
            .attr("width", legendElementWidth)
            .attr("height", cellSize)
            .style("fill", function (d, i) {
                return colors[i];
            });

        legend.append("text")
            .attr("class", "mono")
            .text(function (d) {
                return d;
            })
            .attr("width", legendElementWidth)
            .attr("x", function (d, i) {
                return legendElementWidth * i+ 3;
            })
            .attr("y", height + (cellSize * 4));

//Change ordering of cells

        function sortbylabel(rORc, i, sortOrder) {
            var t = svg.transition().duration(3000);
            var log2r = rowMap.keys();
            var sorted; // sorted is zero-based index
            d3.selectAll(".c" + rORc + i)
                .filter(function (ce) {
                    //log2r.push(rowMap.keys().indexOf(ce.app));
                })
            ;
            if (rORc == "r") { // sort log2ratio of a gene
                //sorted=d3.range(col_number).sort(function(a,b){ if(sortOrder){console.log("a-b++:",a,  b, log2r[a], log2r[b], log2r); return log2r[b]-log2r[a];}else{ return log2r[a]-log2r[b];}});

                sorted = d3.range(col_number).sort(function (a, b) {
                    if (sortOrder) {
                        return d3.ascending(colMap.keys()[a], colMap.keys()[b]);
                    } else {
                        return d3.descending(colMap.keys()[a], colMap.keys()[b]);
                    }
                });


                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return sorted.indexOf(colMap.keys().indexOf(d.host)) * cellSize;
                    })
                ;
                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return sorted.indexOf(i) * cellSize;
                    })
                ;
            } else { // sort log2ratio of a contrast
                //sorted=d3.range(row_number).sort(function(a,b){if(sortOrder){ return log2r[b]-log2r[a];}else{ return log2r[a]-log2r[b];}});

                sorted = d3.range(row_number).sort(function (a, b) {
                    if (sortOrder) {
                        return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);
                    } else {
                        return d3.descending(rowMap.keys()[a], rowMap.keys()[b]);
                    }
                });

                t.selectAll(".cell")
                    .attr("y", function (d) {
                        return sorted.indexOf(rowMap.keys().indexOf(d.app)) * cellSize;
                    })
                ;
                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return sorted.indexOf(i) * cellSize;
                    })
                ;
            }
        }

        d3.select("#view").on("change", function (value) {
            if (this.value == "appgrp") {
                renderHeatmap();
            } else if (this.value == "hostapp") {
                renderHeatHostApp();
            } else if (this.value == "hostgrp") {
                renderHeatHostGroup();
            }
        });

        d3.select("#severity").on("change", function () {
            changeSeverity(this.value);
        });

        d3.select("#order").on("change", function () {
            order(this.value);
        });

        function changeSeverity(value) {
            indi = value;
            //if(value=="sev_max"){
            //  console.log("sev_max:", value);
            var t = svg.transition().duration(1000);
            t.selectAll(".cell")
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                });

        }

        function order(value) {
            var colSorted = d3.range(col_number).sort(function (a, b) {
                return d3.ascending(colMap.keys()[a], colMap.keys()[b]);
            });

            var rowSorted = d3.range(row_number).sort(function (a, b) {
                return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);
            });

            if (value == "hclust") {
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (rowMap.keys().indexOf(d.app)) * cellSize;
                    })
                    .attr("y", function (d) {
                        return (colMap.keys().indexOf(d.host)) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        console.log("cluster y2", d);
                        return rowMap.keys().indexOf(d) * cellSize;
                    })
                ;

                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        console.log("cluster y3", d);
                        return colMap.keys().indexOf(d) * cellSize;
                    })
                ;

            } else if (value == "probecontrast") {
                //colSortOrder=!colSortOrder;
                //rowSortOrder=!rowSortOrder;

                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (colSorted.indexOf(colMap.keys().indexOf(d.host))) * cellSize;
                    })
                    .attr("y", function (d) {
                        return (rowSorted.indexOf(rowMap.keys().indexOf(d.app))) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return rowSorted.indexOf(i) * cellSize;
                    })
                ;

                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return colSorted.indexOf(i) * cellSize;
                    })
                ;

            } else if (value == "probe") {
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("y", function (d) {
                        return (rowSorted.indexOf(rowMap.keys().indexOf(d.app))) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return rowSorted.indexOf(i) * cellSize;
                    })
                ;
            } else if (value == "contrast") {
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (colSorted.indexOf(colMap.keys().indexOf(d.host))) * cellSize;
                    })
                ;
                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return colSorted.indexOf(i) * cellSize;
                    })
                ;
            }
        }

//
        var sa = d3.select(".g3")
                .on("mousedown", function () {
                    if (!d3.event.altKey) {
                        d3.selectAll(".cell-selected").classed("cell-selected", false);
                        d3.selectAll(".rowLabel").classed("text-selected", false);
                        d3.selectAll(".colLabel").classed("text-selected", false);
                    }
                    var p = d3.mouse(this);
                    sa.append("rect")
                        .attr({
                            rx: 0,
                            ry: 0,
                            class: "selection",
                            x: p[0],
                            y: p[1],
                            width: 1,
                            height: 1
                        })
                })
                .on("mousemove", function () {
                    var s = sa.select("rect.selection");

                    if (!s.empty()) {
                        var p = d3.mouse(this),
                            d = {
                                x: parseInt(s.attr("x"), 10),
                                y: parseInt(s.attr("y"), 10),
                                width: parseInt(s.attr("width"), 10),
                                height: parseInt(s.attr("height"), 10)
                            },
                            move = {
                                x: p[0] - d.x,
                                y: p[1] - d.y
                            }
                            ;

                        if (move.x < 1 || (move.x * 2 < d.width)) {
                            d.x = p[0];
                            d.width -= move.x;
                        } else {
                            d.width = move.x;
                        }

                        if (move.y < 1 || (move.y * 2 < d.height)) {
                            d.y = p[1];
                            d.height -= move.y;
                        } else {
                            d.height = move.y;
                        }
                        s.attr(d);

                        // deselect all temporary selected state objects
                        d3.selectAll('.cell-selection.cell-selected').classed("cell-selected", false);
                        d3.selectAll(".text-selection.text-selected").classed("text-selected", false);

                        d3.selectAll('.cell').filter(function (cell_d, i) {
                            if (
                                !d3.select(this).classed("cell-selected") &&
                                // inner circle inside selection frame
                                (this.x.baseVal.value) + cellSize >= d.x && (this.x.baseVal.value) <= d.x + d.width &&
                                (this.y.baseVal.value) + cellSize >= d.y && (this.y.baseVal.value) <= d.y + d.height
                                ) {

                                d3.select(this)
                                    .classed("cell-selection", true)
                                    .classed("cell-selected", true);

                                d3.select(".r" + (cell_d.row - 1))
                                    .classed("text-selection", true)
                                    .classed("text-selected", true);

                                d3.select(".c" + (cell_d.col - 1))
                                    .classed("text-selection", true)
                                    .classed("text-selected", true);
                            }
                        });
                    }
                })
                .on("mouseup", function () {
                    // remove selection frame
                    sa.selectAll("rect.selection").remove();

                    // remove temporary selection marker class
                    d3.selectAll('.cell-selection').classed("cell-selection", false);
                    d3.selectAll(".text-selection").classed("text-selection", false);
                })
                .on("mouseout", function () {
                    if (d3.event.relatedTarget.tagName == 'html') {
                        // remove selection frame
                        sa.selectAll("rect.selection").remove();
                        // remove temporary selection marker class
                        d3.selectAll('.cell-selection').classed("cell-selection", false);
                        d3.selectAll(".rowLabel").classed("text-selected", false);
                        d3.selectAll(".colLabel").classed("text-selected", false);
                    }
                })
            ;
    });


}

function renderHeatHostGroup() {

    d3.selectAll("svg").remove();

    d3.select("#explanation")
        .style("display", "none");

    d3.select("#sequence")
        .style("display", "none");
    d3.select("#count").style("display", "none");
    d3.select("#size").style("display", "none");
    d3.select("#back").style("display", "none");
    d3.select("#order").style("display", "inline");
    d3.select("#view").style("display", "inline");
    d3.select("#severity").style("display", "inline");
    d3.select(".panel-title").text("Group/Host Matrix");
    d3.select(".chart-panel").style("display", "none");

    clearInterval(activ);

    activ = setInterval(function () {
        console.log("timer3");
        /*
         var colorScale = d3.scale.quantile()
         .domain([ 0, 5])
         .range(colors);*/

        d3.json("/json/heatappgrp" + '?' + Math.floor(Math.random() * 1000), function (error, data) {
            //d3.json("../json_test/heathostgrp.json"+ '?' + Math.floor(Math.random() * 1000), function(error, data) {
            //var t = d3.select("svg").transition().duration(3000);

            var rowMap = d3.map(), colMap = d3.map(), colRowMap = d3.map(), dataBackground = [];

            data.forEach(function (i, j) {
                rowMap.set(i.app, i)
            });
            data.forEach(function (i, j) {
                colMap.set(i.grp, i)
            });
            data.forEach(function (i, j) {
                colRowMap.set(i.app + i.grp, i)
            });

            var cell = d3.select("svg").selectAll(".cell")
                .data(data, function (d) {
                    return d.app + ":" + d.grp;
                })
                //.select("rect")
                //.transition().duration(500)
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                });
            //console.log(cell);
        });

    }, 20000);


    var margin = { top: 150, right: 10, bottom: 50, left: 150 },
        cellSize = 12;
    col_number = 60;
    row_number = 50;
    width = 0, // - margin.left - margin.right,
        height = 0 , // - margin.top - margin.bottom,
//gridSize = Math.floor(width / 24),
        legendElementWidth = cellSize * 2.5,
        colorBuckets = 6,
        //colors = ['#005824', '#699F83', '#D2E6E3', '#E6D3E1', '#BB6990', '#91003F'];//.reverse();
        colors = ['#e8e8e8', '#92d967', '#77d0ef', '#f5e400', '#ff9e00', '#ff665a'];//.reverse();
//['#005824','#1A693B','#347B53','#4F8D6B','#699F83','#83B09B','#9EC2B3','#B8D4CB','#D2E6E3','#EDF8FB','#FFFFFF','#F1EEF6','#E6D3E1','#DBB9CD','#D19EB9','#C684A4','#BB6990','#B14F7C','#A63467','#9B1A53','#91003F'];
    hcrow = [] //change to gene name or probe id
    hccol = [] //change to gene name or probe id
    rowLabel = [] //change to gene name or probe id
    colLabel = [] //change to contrast name

    d3.select("#loading-indicator").style("display", "inline");

    d3.json("/json/heathostgrp" + '?' + Math.floor(Math.random() * 1000), function (error, data) {
//d3.json("../json_test/heathostgrp.json", function(error, data) {
        d3.select("#loading-indicator").style("display", "none");

        var rowMap = d3.map(), colMap = d3.map(), colRowMap = d3.map(), dataBackground = [];

        data.forEach(function (i, j) {
            rowMap.set(i.grp, i)
        });
        data.forEach(function (i, j) {
            colMap.set(i.host, i)
        });
        data.forEach(function (i, j) {
            colRowMap.set(i.grp + i.host, i)
        });

//background grid
        var lowEnd = 1;
        while (lowEnd <= colMap.keys().length) {
            dataBackground.push(lowEnd++);
        }

        var gridData = new Array(rowMap.keys().length);
        for (var i = 0; i < rowMap.keys().length; i++) {
            gridData[i] = dataBackground;
        }

        row_number = rowMap.keys().length;
        col_number = colMap.keys().length;

//var colSorted=d3.range(col_number).sort(function(a,b){ if(sortOrder){ return d3.ascending(colMap.keys()[a], colMap.keys()[b]);}else{ return d3.descending(colMap.keys()[a], colMap.keys()[b]);}});

//var rowSorted=d3.range(row_number).sort(function(a,b){ if(sortOrder){return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);}else{ return d3.descending(rowMap.keys()[a], rowMap.keys()[b]);}});

        width = cellSize * col_number < 300 ? 300 : cellSize * col_number; // - margin.left - margin.right,
        height = cellSize * row_number; // - margin.top - margin.bottom,

        var svg = d3.select("#heatmap-chart-area").append("svg")
                .attr("width", width + margin.left + margin.right)
                .attr("height", height + margin.top + margin.bottom)
                .append("g")
                .attr("transform", "translate(" + margin.left + "," + margin.top + ")")
            ;
        var rowSortOrder = false;
        var colSortOrder = false;

        svg.append("text")      // text label for the x axis
            .attr("x", -20)
            .attr("y", -10)
            .attr("fill", "#ADADAD")
            .style("text-anchor", "end")
            .text("groups");

        svg.append("text")      // text label for the y axis
            .attr("x", 20)
            .attr("y", -15)
            .attr("fill", "#ADADAD")
            .style("text-anchor", "start")
            .text("hosts")
            .attr("transform", "translate(" + cellSize / 2 + ",0) rotate (-90)");

        svg.append("line")
            .attr("x1", -5)
            .attr("y1", -5)
            .attr("x2", -50)
            .attr("y2", -50)
            .attr("stroke-width", 1)
            .attr("stroke", "#aaa");

        var rowLabels = svg.append("g")
                .selectAll(".rowLabelg")
                .data(rowMap.keys())
                .enter()
                .append("text")
                .text(function (d) {
                    return d;
                })
                .attr("x", 0)
                .attr("y", function (d, i) {
                    return rowMap.keys().indexOf(d) * cellSize;
                })
                .style("text-anchor", "end")
                .attr("transform", "translate(-6," + cellSize / 1.5 + ")")
                .attr("class", function (d, i) {
                    return "rowLabel mono r" + i;
                })
                .on("mouseover", function (d) {
                    d3.select(this).classed("text-hover", true);
                })
                .on("mouseout", function (d) {
                    d3.select(this).classed("text-hover", false);
                })
                .on("click", function (d, i) {
                    rowSortOrder = !rowSortOrder;
                    sortbylabel("r", i, rowSortOrder);
                    //d3.select("#order").property("selectedIndex", 3).node().focus();
                    ;
                })
            ;

        var colLabels = svg.append("g")
                .selectAll(".colLabelg")
                .data(colMap.keys())
                .enter()
                .append("text")
                .text(function (d) {
                    return d;
                })
                .attr("x", 0)
                .attr("y", function (d, i) {
                    return colMap.keys().indexOf(d) * cellSize;
                })
                .style("text-anchor", "left")
                .attr("transform", "translate(" + cellSize / 2 + ",-6) rotate (-90)")
                .attr("class", function (d, i) {
                    return "colLabel mono c" + i;
                })
                .on("mouseover", function (d) {
                    d3.select(this).classed("text-hover", true);
                })
                .on("mouseout", function (d) {
                    d3.select(this).classed("text-hover", false);
                })
                .on("click", function (d, i) {
                    colSortOrder = !colSortOrder;
                    sortbylabel("c", i, colSortOrder);
                    //d3.select("#order").property("selectedIndex", 2).node().focus();
                    ;
                })
            ;
        /*
         var row = svg.selectAll(".row")
         .data(matrix)
         .enter().append("g")
         .attr("class", "row")
         .attr("transform", function(d, i) { return "translate(0," + x(i) + ")"; })
         .each(row);*/

        var grid = svg.append("g").attr("class", "g3")
            .selectAll(".cellg")
            .data(gridData)
            .enter()
            .append("g")
            .each(row, i);


        function row(row, i) {
            var cell = d3.select(this).selectAll(".cell2")
                .data(row, function (i) {
                    return row[i]
                })
                .enter()
                .append("rect")
                .attr("x", function (d, j) {
                    return j * cellSize;
                })
                .attr("y", function (d) {
                    return i * cellSize;
                })
                //.attr("class", function(d){return "cell cell-border cr"+(rowLabel.indexOf(colLabel.indexOf(d.app))-1)+" cc"+(colLabel.indexOf(d.app)-1);})
                .attr("class", function (d, j) {
                    return "cell2 cell-border"
                })
                .attr("width", cellSize)
                .attr("height", cellSize)
                .style("fill", function (d) {
                    return d3.rgb(255, 255, 255);
                });
        }

        var heatMap = svg.append("g").attr("class", "g3")
                .selectAll(".cellg")
                .data(data, function (d) {
                    return d.grp + ":" + d.host;
                })
                .enter()
                .append("rect")
                .attr("x", function (d, j) {
                    return colMap.keys().indexOf(d.host) * cellSize;
                })
                .attr("y", function (d, j) {
                    return  rowMap.keys().indexOf(d.grp) * cellSize;
                })
                //.attr("class", function(d){return "cell cell-border cr"+(rowLabel.indexOf(colLabel.indexOf(d.grp))-1)+" cc"+(colLabel.indexOf(d.grp)-1);})
                .attr("class", function (d, j) {
                    return "cell cell-border cr" + (rowMap.keys().indexOf(d.grp)) + " cc" + (colMap.keys().indexOf(d.host));
                })
                .attr("width", cellSize)
                .attr("height", cellSize)
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                })
                /* .on("click", function(d) {
                 var rowtext=d3.select(".r"+(d.row-1));
                 if(rowtext.classed("text-selected")==false){
                 rowtext.classed("text-selected",true);
                 }else{
                 rowtext.classed("text-selected",false);
                 }
                 })*/
                .on("click", function (d) {

                    window.open("indications.html?grp=" + d.grp + "&host=" + d.host, "_self");
                    var rowtext = d3.select(".r" + (d.row - 1));
                    if (rowtext.classed("text-selected") == false) {
                        rowtext.classed("text-selected", true);
                    } else {
                        rowtext.classed("text-selected", false);
                    }
                })
                .on("mouseover", function (d) {

                    //highlight text
                    d3.select(this).classed("cell-hover", true);
                    d3.selectAll(".rowLabel").classed("text-highlight", function (r, ri) {
                        return ri == (rowMap.keys().indexOf(d.grp));
                    });
                    d3.selectAll(".colLabel").classed("text-highlight", function (c, ci) {
                        return ci == (colMap.keys().indexOf(d.host));
                    });

                    //Update the tooltip position and value
                    mouseover(d, fillList);
//                    d3.select("#tooltip")
//                        .style("left", (d3.event.pageX + 10) + "px")
//                        .style("top", (d3.event.pageY - 10) + "px")
//                        .select("#value")
//                        .text(fillList(d));
//                    //Show the tooltip
//                    d3.select("#tooltip").classed("hidden", false);
                })
                .on("mouseout", function () {
                    mouseout();
                    d3.select(this).classed("cell-hover", false);
                    d3.selectAll(".rowLabel").classed("text-highlight", false);
                    d3.selectAll(".colLabel").classed("text-highlight", false);
//                    d3.select("#tooltip").classed("hidden", true);
                })
            ;

        var fillList = function(d) {

            d3.select("#app").text("Group: ");
            d3.select("#app_value").text(d.grp);

            d3.select("#grp").text("Host: ");
            d3.select("#grp_value").text(d.host);
            d3.select("#indi_total").text("Total (cnt): ");
            d3.select("#indi_total_value").text(d.indi_total);
            d3.select("#cri_cnt").text("Critical (cnt): ");
            d3.select("#cri_cnt_value").text(d.cri_cnt);
            d3.select("#maj_cnt").text("Major (cnt): ");
            d3.select("#maj_cnt_value").text(d.maj_cnt);
            d3.select("#min_cnt").text("Minor (cnt): ");
            d3.select("#min_cnt_value").text(d.min_cnt);
            d3.select("#war_cnt").text("Warning (cnt): ");
            d3.select("#war_cnt_value").text(d.war_cnt);
            d3.select("#nor_cnt").text("Normal (cnt): ");
            d3.select("#nor_cnt_value").text(d.nor_cnt);
            d3.select("#unk_cnt").text("Unknow (cnt): ");
            d3.select("#unk_cnt_value").text(d.unk_cnt);

        }

        var legend = svg.selectAll(".legend")
            .data(["Un", "No", "Wa", "Mi", "Ma", "Cr" ])
            .enter().append("g")
            .attr("class", "legend");

        legend.append("rect")
            .attr("x", function (d, i) {
                return legendElementWidth * i;
            })
            .attr("y", height + (cellSize * 2))
            .attr("width", legendElementWidth)
            .attr("height", cellSize)
            .style("fill", function (d, i) {
                return colors[i];
            });

        legend.append("text")
            .attr("class", "mono")
            .text(function (d) {
                return d;
            })
            .attr("width", legendElementWidth)
            .attr("x", function (d, i) {
                return legendElementWidth * i + 3;
            })
            .attr("y", height + (cellSize * 4));

//Change ordering of cells

        function sortbylabel(rORc, i, sortOrder) {
            var t = svg.transition().duration(3000);
            var log2r = rowMap.keys();
            var sorted; // sorted is zero-based index
            d3.selectAll(".c" + rORc + i)
                .filter(function (ce) {
                    //log2r.push(rowMap.keys().indexOf(ce.app));
                })
            ;
            if (rORc == "r") { // sort log2ratio of a gene
                //sorted=d3.range(col_number).sort(function(a,b){ if(sortOrder){console.log("a-b++:",a,  b, log2r[a], log2r[b], log2r); return log2r[b]-log2r[a];}else{ return log2r[a]-log2r[b];}});

                sorted = d3.range(col_number).sort(function (a, b) {
                    if (sortOrder) {
                        return d3.ascending(colMap.keys()[a], colMap.keys()[b]);
                    } else {
                        return d3.descending(colMap.keys()[a], colMap.keys()[b]);
                    }
                });


                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return sorted.indexOf(colMap.keys().indexOf(d.host)) * cellSize;
                    })
                ;
                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return sorted.indexOf(i) * cellSize;
                    })
                ;
            } else { // sort log2ratio of a contrast
                //sorted=d3.range(row_number).sort(function(a,b){if(sortOrder){ return log2r[b]-log2r[a];}else{ return log2r[a]-log2r[b];}});

                sorted = d3.range(row_number).sort(function (a, b) {
                    if (sortOrder) {
                        return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);
                    } else {
                        return d3.descending(rowMap.keys()[a], rowMap.keys()[b]);
                    }
                });

                t.selectAll(".cell")
                    .attr("y", function (d) {
                        return sorted.indexOf(rowMap.keys().indexOf(d.grp)) * cellSize;
                    })
                ;
                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return sorted.indexOf(i) * cellSize;
                    })
                ;
            }
        }

        d3.select("#view").on("change", function (value) {
            if (this.value == "appgrp") {
                renderHeatmap();
            } else if (this.value == "hostapp") {
                renderHeatHostApp();
            } else if (this.value == "hostgrp") {
                renderHeatHostGroup();
            }
        });

        d3.select("#severity").on("change", function () {
            changeSeverity(this.value);
        });

        d3.select("#order").on("change", function () {
            order(this.value);
        });

        function changeSeverity(value) {
            indi = value;

            var t = svg.transition().duration(1000);
            t.selectAll(".cell")
                .style("fill", function (d) {
                    return colorScale(d[indi]);
                });
            //.attr("x", function(d) { return (rowMap.keys().indexOf(d.grp)) * cellSize; })
            //.attr("y", function(d) { return (colMap.keys().indexOf(d.host)) * cellSize; });
            /*
             }else if (value=="sev_max_av"){
             var t = svg.transition().duration(1000);
             t.selectAll(".cell")
             .style("fill", function(d) { return colorScale(d.sev_max_av); });
             }else if (value=="sev_max_kpi"){
             var t = svg.transition().duration(1000);
             t.selectAll(".cell")
             .style("fill", function(d) { return colorScale(d.sev_max_kpi); });
             }else if (value=="sev_max_other"){
             var t = svg.transition().duration(1000);
             t.selectAll(".cell")
             .style("fill", function(d) { return colorScale(d.sev_max_other); });
             }*/

        }

        function order(value) {
            var colSorted = d3.range(col_number).sort(function (a, b) {
                return d3.ascending(colMap.keys()[a], colMap.keys()[b]);
            });

            var rowSorted = d3.range(row_number).sort(function (a, b) {
                return d3.ascending(rowMap.keys()[a], rowMap.keys()[b]);
            });

            if (value == "hclust") {
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (rowMap.keys().indexOf(d.grp)) * cellSize;
                    })
                    .attr("y", function (d) {
                        return (colMap.keys().indexOf(d.host)) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        console.log("cluster y2", d);
                        return rowMap.keys().indexOf(d) * cellSize;
                    })
                ;

                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return colMap.keys().indexOf(d) * cellSize;
                    })
                ;

            } else if (value == "probecontrast") {
//colSortOrder=!colSortOrder;
//rowSortOrder=!rowSortOrder;

                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (colSorted.indexOf(colMap.keys().indexOf(d.host))) * cellSize;
                    })
                    .attr("y", function (d) {
                        return (rowSorted.indexOf(rowMap.keys().indexOf(d.grp))) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return rowSorted.indexOf(i) * cellSize;
                    })
                ;

                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return colSorted.indexOf(i) * cellSize;
                    })
                ;

            } else if (value == "probe") {
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("y", function (d) {
                        return (rowSorted.indexOf(rowMap.keys().indexOf(d.grp))) * cellSize;
                    })
                ;

                t.selectAll(".rowLabel")
                    .attr("y", function (d, i) {
                        return rowSorted.indexOf(i) * cellSize;
                    })
                ;
            } else if (value == "contrast") {
                var t = svg.transition().duration(3000);
                t.selectAll(".cell")
                    .attr("x", function (d) {
                        return (colSorted.indexOf(colMap.keys().indexOf(d.host))) * cellSize;
                    })
                ;
                t.selectAll(".colLabel")
                    .attr("y", function (d, i) {
                        return colSorted.indexOf(i) * cellSize;
                    })
                ;
            }
        }

//
        var sa = d3.select(".g3")
                .on("mousedown", function () {
                    if (!d3.event.altKey) {
                        d3.selectAll(".cell-selected").classed("cell-selected", false);
                        d3.selectAll(".rowLabel").classed("text-selected", false);
                        d3.selectAll(".colLabel").classed("text-selected", false);
                    }
                    var p = d3.mouse(this);
                    sa.append("rect")
                        .attr({
                            rx: 0,
                            ry: 0,
                            class: "selection",
                            x: p[0],
                            y: p[1],
                            width: 1,
                            height: 1
                        })
                })
                .on("mousemove", function () {
                    var s = sa.select("rect.selection");

                    if (!s.empty()) {
                        var p = d3.mouse(this),
                            d = {
                                x: parseInt(s.attr("x"), 10),
                                y: parseInt(s.attr("y"), 10),
                                width: parseInt(s.attr("width"), 10),
                                height: parseInt(s.attr("height"), 10)
                            },
                            move = {
                                x: p[0] - d.x,
                                y: p[1] - d.y
                            }
                            ;

                        if (move.x < 1 || (move.x * 2 < d.width)) {
                            d.x = p[0];
                            d.width -= move.x;
                        } else {
                            d.width = move.x;
                        }

                        if (move.y < 1 || (move.y * 2 < d.height)) {
                            d.y = p[1];
                            d.height -= move.y;
                        } else {
                            d.height = move.y;
                        }
                        s.attr(d);

                        // deselect all temporary selected state objects
                        d3.selectAll('.cell-selection.cell-selected').classed("cell-selected", false);
                        d3.selectAll(".text-selection.text-selected").classed("text-selected", false);

                        d3.selectAll('.cell').filter(function (cell_d, i) {
                            if (
                                !d3.select(this).classed("cell-selected") &&
                                // inner circle inside selection frame
                                (this.x.baseVal.value) + cellSize >= d.x && (this.x.baseVal.value) <= d.x + d.width &&
                                (this.y.baseVal.value) + cellSize >= d.y && (this.y.baseVal.value) <= d.y + d.height
                                ) {

                                d3.select(this)
                                    .classed("cell-selection", true)
                                    .classed("cell-selected", true);

                                d3.select(".r" + (cell_d.row - 1))
                                    .classed("text-selection", true)
                                    .classed("text-selected", true);

                                d3.select(".c" + (cell_d.col - 1))
                                    .classed("text-selection", true)
                                    .classed("text-selected", true);
                            }
                        });
                    }
                })
                .on("mouseup", function () {
                    // remove selection frame
                    sa.selectAll("rect.selection").remove();

                    // remove temporary selection marker class
                    d3.selectAll('.cell-selection').classed("cell-selection", false);
                    d3.selectAll(".text-selection").classed("text-selection", false);
                })
                .on("mouseout", function () {
                    if (d3.event.relatedTarget.tagName == 'html') {
                        // remove selection frame
                        sa.selectAll("rect.selection").remove();
                        // remove temporary selection marker class
                        d3.selectAll('.cell-selection').classed("cell-selection", false);
                        d3.selectAll(".rowLabel").classed("text-selected", false);
                        d3.selectAll(".colLabel").classed("text-selected", false);
                    }
                })
            ;
    });


}

/*
 function changeSeverity(value){
 indi = value;

 var t = d3.select("svg").transition().duration(1000);
 t.selectAll(".cell")
 .style("fill", function(d) { return colorScale(d[indi]); });

 }*/

//close tooltip
d3.select("#list-close").on("click", function () {

    d3.select("#tooltip").style("opacity", 0);

});

var iOS = ( navigator.userAgent.match(/(iPad|iPhone|iPod)/g) ? true : false );

if (!iOS){
    d3.select("#list-close").style("display", "none");

}
  

