function renderIndiStatus() {

    var width = 960,
        height = 500,
        radius = Math.min(width, height) / 2,
        labelr = radius + 3; // radius for label anchor

    var color = d3.scale.ordinal()
        .range(["#98abc5", "#8a89a6", "#7b6888", "#6b486b", "#a05d56", "#d0743c", "#ff8c00"]);

    var arc = d3.svg.arc()
        .outerRadius(radius - 10)
        .innerRadius(0);

    var pie = d3.layout.pie()
        .sort(null)
        .value(function (d) {
            return d.value;
        });

    var svg = d3.select("#indi-pie-chart-area").append("svg")
        .attr("width", width)
        .attr("height", height)
        .append("g")
        .attr("transform", "translate(" + width / 2 + "," + height / 2 + ")");

    d3.json("/json/stats", function (error, data) {
        console.log("data", data);

        data2 = [
            {"label": "Critical", "status": "5", "value": parseInt(data.indi_cri)},
            {"label": "Major", "status": 4, "value": parseInt(data.indi_maj)},
            {"label": "Minor", "status": 3, "value": parseInt(data.indi_min)},
            {"label": "Warning", "status": 2, "value": parseInt(data.indi_war)},
            {"label": "Normal", "status": 1, "value": parseInt(data.indi_nor)}
        ];


        var g = svg.selectAll(".arc")
            .data(pie(data2))
            .enter().append("g")
            .attr("class", "arc");

        g.append("path")
            .attr("d", arc)
            .style("fill", function (d, i) {
                return treemap_color(data2[i].status);
            });

        g.append("text")
            .attr("transform", function (d) {
                var c = arc.centroid(d),
                    x = c[0],
                    y = c[1],
                // pythagorean theorem for hypotenuse
                    h = Math.sqrt(x * x + y * y);
                return "translate(" + (x / h * labelr) + ',' +
                    (y / h * labelr) + ")";
            })
            .attr("dy", ".35em")
            .attr("text-anchor", function (d) {
                // are we past the center?
                return (d.endAngle + d.startAngle) / 2 > Math.PI ?
                    "end" : "start";
            })
            .text(function (d, i) {
                return data2[i].label;
            });

    });

}
