function renderIndiTable() {

    function format(d) {
        console.log("format", d);
        return '<a class="child" href="#">' + d.text.substring(0, 300) + '</a>' + '<br>';
    }


//    var barnumber = 10;
//    var page = 1;

    console.log("detailed info");

    fillTable();


    function fillTable() {

        $(document).ready(function () {

            var customSearchParam, initParam = [];

            var av = GetURLParameter("av") ? decodeURIComponent(GetURLParameter("av")) : GetURLParameter("av");
            var agent = GetURLParameter("agent") ? decodeURIComponent(GetURLParameter("agent")) : GetURLParameter("agent");
            var service = GetURLParameter("service") ? decodeURIComponent(GetURLParameter("service")) : GetURLParameter("service");

            var app = GetURLParameter("app") ? decodeURIComponent(GetURLParameter("app")) : GetURLParameter("app");
            var grp = GetURLParameter("grp") ? decodeURIComponent(GetURLParameter("grp")) : GetURLParameter("grp");
            var host = GetURLParameter("host") ? decodeURIComponent(GetURLParameter("host")) : GetURLParameter("host");

            var panelHeading = d3.select(".panel-heading");

            function severityNumberToFullNames(num) {
                var sev = "";
                switch (num) {
                    case "0":
                        sev = "Unknown";
                        break;
                    case "-6":
                        sev = "Unknown";
                        break;
                    case "1":
                        sev = "Normal";
                        break;
                    case "-5":
                        sev = "Normal";
                        break;
                    case "2":
                        sev = "Warning";
                        break;
                    case "-4":
                        sev = "Warning";
                        break;
                    case "-3":
                        sev = "Minor";
                        break;
                    case "3":
                        sev = "Minor";
                        break;
                    case "4":
                        sev = "Major";
                        break;
                    case "-2":
                        sev = "Major";
                        break;
                    case "5":
                        sev = "Critical";
                        break;
                    case "-1":
                        sev = "Critical";
                        break;
                    default:
                        sev = Math.abs(num);
                        break;
                }
                return sev;

            }

            if (av) {
                panelHeading.text("Indications Table. Filtered by severity: " + severityNumberToFullNames(av));
                customSearchParam = "ANY-3-";
                initParam.push("Severity-4-" + av);
                initParam.push("Severity-4-" + (av - 6));
            } else if (agent) {
                var agentLabel = GetURLParameter("label");
                panelHeading.text("Indications Table. Filtered by agent: " + agentLabel);
                customSearchParam = "ANY-3-";
                initParam.push("AgentID-4-" + agent);
            } else if (service) {
                var serviceName = GetURLParameter("serviceName");
                panelHeading.text("Indications Table. Filtered by service: " + decodeURIComponent(serviceName));
                customSearchParam = "ANY-3-";
                initParam.push("ServiceD-4-" + service);
            } else if ((app || app == "") && (grp || grp == "")) {
                panelHeading.text("Indications Table. Filtered by app: " + decodeURIComponent(app) + " & grp: " + decodeURIComponent(grp));
                customSearchParam = "ANY-3-"
                initParam.push("Application-4-" + app);
                initParam.push("Group-4-" + grp);
            }
            //else if (grp || (grp == "")) {
            //    panelHeading.text("Indications Table. Filtered by app: "+decodeURIComponent(app)+" & grp: "+decodeURIComponent(grp));
            //    customSearchParam = "ANY-3-"
            //    initParam.push("Group-4-"+grp);
            //}
            //else if (grp == "" && app == "") {
            //    panelHeading.text("Indications Table. Filtered by app: "+decodeURIComponent(app)+" & grp: "+decodeURIComponent(grp));
            //    customSearchParam = "ANY-3-"
            //    initParam.push("Group-4-"+grp);
            //    initParam.push("Application-4-"+app);
            //}
            else if ((app || (app == "")) && (host || host == "")) {
                panelHeading.text("Indications Table. Filtered by app: " + decodeURIComponent(app) + " & host: " + decodeURIComponent(host));
                customSearchParam = "ANY-3-"
                initParam.push("Host-4-" + host);
                initParam.push("Application-4-" + app);
            }
            //else if (app && host) {
            //    panelHeading.text("Indications Table. Filtered by app: "+decodeURIComponent(app)+" & host: "+decodeURIComponent(host));
            //    customSearchParam = "ANY-3-"
            //    initParam = ["Application-4-"+app, "Host-4-"+host];
            //}
            else if ((host || host == "") && (grp || grp == "")) {
                panelHeading.text("Indications Table. Filtered by host: " + decodeURIComponent(host) + " & grp: " + decodeURIComponent(grp));
                customSearchParam = "ANY-3-"
                initParam = ["Host-4-" + host, "Group-4-" + grp];
            } else {
                panelHeading.text("Indications Table");
                customSearchParam = "ANY-3-";
                initParam = "";
            }


            var table = $('#indi-table').DataTable({

                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "/json/indi_list",
                    "data": {
                        "fi": initParam
                    },
                    "dataSrc": "indis"
                },
                "language": {
                    "infoEmpty": "No entries to show",
                    "zeroRecords": "No records to display"
                },


                responsive: false,
                "scrollX": true,
                "ordering": false,
                customSearch: customSearchParam,
                //"autoWidth": true,

                "aoColumnDefs": [
//                    {
//                        "width": "10px",
//                        className: 'control',
//                        orderable: false,
//                        targets: 0,
//                        "mRender": function (data, type, full) {
//
//                            return  "";
//                        }
//                    },
                    {
                        "aTargets": [1, 8],
                        "mData": "download_link",
                        "mRender": function (data, type, full) {
                            var indDate = new Date(data);
                            return indDate.customFormat("#DD#/#MM#/#YYYY# #hh#:#mm#:#ss#");
                        }
                    },
                    {
                        "aTargets": [0],
                        "mData": "download_link",
                        "mRender": function (data, type, full) {

                            return '<div class="ind-table" style="background:' + treemap_color(data) + ';"><text style="' + (data < 0 ? "text-decoration:line-through;padding: 1px 1px 1px 4px;" : "") + ' font-size: 10px;">' + severityNumberToNames(data) /*Math.abs(data)*/ + '</text></div>';

                        }
                    },
                    //{ "bVisible": false, "sClass": 'none', "aTargets": [ 9 ] },
                    //{ "sClass": 'none', "aTargets": [  9 ] },
                    {"orderable": false, "targets": ['_all']}

//
                ],


                "drawCallback": function (settings) {
                    var api = this.api();
                    var rows = api.rows({page: 'current'}).nodes();
                    var last = null;

                    api.rows({page: 'current'}).data().each(function (item, i) {

                        $(rows).eq(i).after(
                            /* '<tr class="child"><td></td><td colspan="10">'+'<a class="indilink" href="#" data-item="'+JSON.stringify(item)+'" data-msg="'+item.text+'" data-toggle="modal" data-target="#indiMessage">'+item.text.substring(0, 100)+'</a>'+'</td></tr>'*/

                            '<tr class="' + (isEven(i) ? "child link odd" : "child link even") + '"> <!--<td></td>--> <td><div class="ind-table-bottom" style="background:' + treemap_color(item.severity) + ';"></div></td><td colspan="10">' + '<a class="indilink" href="#" data-i="' + i + '" data-toggle="modal" >' + item.text.substring(0, 100) + '</a>' + '</td></tr>'
                        );


                    });


                },


                aoColumns: [
//                    { data: null },
                    {"className": "left", data: 'severity'},
                    {"className": "left", data: 'time'},
                    {"className": "center", data: 'duplicates'},
                    {"className": "center", data: 'host'},
                    {"className": "center", data: 'application'},
                    {"className": "center", data: 'group'},
                    {"className": "center", data: 'object'},
                    {"className": "center", data: 'agent'},
                    {"className": "center", data: 'stime'}


                ]
            });

            function severityNumberToNames(num) {
                var sev = "";
                switch (num) {
                    case 6:
                    case 0:
                        sev = "Un";
                        break;
                    case -5:
                    case 1:
                        sev = "No";
                        break;
                    case -4:
                    case 2:
                        sev = "Wa";
                        break;
                    case -3:
                    case 3:
                        sev = "Mi";
                        break;
                    case -2:
                    case 4:
                        sev = "Ma";
                        break;
                    case -1:
                    case 5:
                        sev = "Cr";
                        break;
                    default:
                        sev = Math.abs(num);
                        break;
                }
                return sev;

            };


            $('#indi-table tbody').on('click', 'tr', function () {


                //workaround for classed two rows as selected
                if (!$("#indi-table").hasClass('collapsed')) {

                    if ($(this).hasClass("link")) {
                        $(this).toggleClass('selected');
                        $(this).prev().toggleClass('selected');
                    } else {
                        $(this).toggleClass('selected');
                        $(this).next().toggleClass('selected');
                    }
                } else {
                    if ($(this).hasClass("link")) {
                        $(this).toggleClass('selected');
                        $(this).prev().toggleClass('selected');
                    } else {
                        $(this).toggleClass('selected');
                        $(this).next().toggleClass('selected');
                    }
                }
            });

            $('#button').click(function () {
                //alert( table.rows('.selected').data().length +' row(s) selected' );
                //console.log("data: ", table.rows('.selected').data());

                $(".alert-success").css("display", "none");
                $(".alert-danger").css("display", "none");

                var selectedRowsData = table.rows('.selected:not(.child)').data();
                //console.log("selectedRowsData: ", selectedRowsData);

                var paramString = "";
                //var this_ = paramString;
                selectedRowsData.each(function (item) {
                    //console.log("item: ", item);
                    paramString += "id=" + item.id + "&";
                });

                console.log("paramString: ", paramString);
                var request = $.ajax({
                    url: "/json/closeindi?" + paramString,
                    type: "GET"
                    //data: { id : menuId }
                    //dataType: "html"
                });

                request.done(function (msg) {
                    if (paramString) $(".alert-success").css("display", "block");
                });

                request.fail(function (jqXHR, textStatus) {
                    //alert( "Request failed: " + textStatus );
                    if (paramString) $(".alert-danger").css("display", "block");

                });

                table.row('.selected').remove().draw(false);

            });


            /*
             $('#button').click( function () {
             table.row('.selected').remove().draw( false );
             } );
             */


//click message link
            $(function () {

                $('tbody').on('click', 'a', function (e) {

                    var rowData = table.row($(this).data("i")).data();

                    $.getJSON("/json/indi?id=" + rowData.id, function (result) {
                        console.log(result);

                        $('.to-clear').text("");
                        $('.checkbox-av').prop("checked", false);
                        $('.checkbox-kpi').prop("checked", false);


                        $('.row-value').addClass("hide");
                        $('.row-end-value').addClass("hide");
                        $('.row-instruction').addClass("hide");


                        $('#indiDetailsLabel').text(result.text.substring(0, 50) + " ... ");

                        $('.severity').html(severityNumberToText(result.severity));
                        $('.owned-by').text(result.owner);

                        $('.uuid').text(result.id);

                        if (result.typea) $('.checkbox-av').prop("checked", true);
                        if (result.typek) $('.checkbox-kpi').prop("checked", true);

                        $('.host').text(result.host);
                        $('.application').text(result.application);

                        $('.agent-host').text(result.agent);
                        $('.group').text(result.group);

                        $('.agent-id').text(result.agentid);
                        $('.slave-server').text(result.slave);
                        $('.close-mask').text(result.closemask);

                        $('.key').text(result.key);
                        $('.object').text(result.object);

                        //$('.auto-action').text(result.aaction);
                        //$('.aa-host').text(result.aactionnode);
                        $('.auto-action').text(result.aaction !== "" ? result.aaction : "-");
                        $('.aa-host').text(result.aactionnode !== "" ? result.aactionnode : "-");

                        $('.op-action').text(result.oaction);
                        //$('.object').text(result.object);

                        $('.text').text(result.text);

                        $('.source').text(result.policysource);

                        var _result = result;
                        $('.first-submit').text(function (result) {
                            var indDate = new Date(_result.stime);
                            return indDate.customFormat("#DD#-#MM#-#YYYY# #hh#:#mm#:#ss#");
                        });

                        $('.last-duplicates').text(function (result) {
                            var indDate = new Date(_result.time);
                            return indDate.customFormat("#DD#-#MM#-#YYYY# #hh#:#mm#:#ss#");
                        });

                        $('.server-received').text(function (result) {
                            var indDate = new Date(_result.ftime);
                            return indDate.customFormat("#DD#-#MM#-#YYYY# #hh#:#mm#:#ss#");
                        });

                        $('.state').text(function (result) {
                            if (_result.state == "-") return "Active";
                        });
                        $('.duplicates').text(result.duplicates);


                        if (result.monitor) {

                            $('.row-value').removeClass("hide");


                            $('.value').text(result.value);

                            if (result.tfa != 0) {
                                $('.row-end-value').removeClass("hide");
                                $('.end-value').text(result.vfa);

                                $('.alert-finished').text(function (result) {
                                    var indDate = new Date(_result.tfa);
                                    return indDate.customFormat("#DD#-#MM#-#YYYY# #hh#:#mm#:#ss#");
                                });
                            }

                        }


                        if (result.instruction_url) {
                            $('.instruction')
                                .attr("href", result.instruction_url)
                                .attr("target", "_blank")
                                .text(result.instruction_url)
                                .parent().parent().removeClass('hide');
                        }


                        $('.annotations').empty();
                        $('.annotation-text').append(result.annotations.length > 0 ? "Annotations " + "(" + result.annotations.length + ")" : "Annotations");


                        $.each(result.annotations, function (i, item) {
                            //alert(item.text);
                            $('.annotations').append(
                                '<div class="row">' +
                                '<label class="col-sm-2 control-label">Auto Action:</label>' +
                                '<div class="col-sm-10">' +
                                '<p class="form-control-static auto-action-an">' + item.text + '</p>' +
                                '</div>' +
                                '</div>' +
                                '<div class="row">' +
                                '<label class="col-sm-2 control-label">Flag:</label>' +
                                '<div class="col-sm-10">' +
                                '<p class="form-control-static flag-an">' + item.flag + '</p>' +
                                '</div>' +
                                '</div>' +
                                '<div class="row">' +
                                '<label class="col-sm-2 control-label">Time:</label>' +
                                '<div class="col-sm-10">' +
                                '<p class="form-control-static time-an">' + item.time + '</p>' +
                                '</div>' +
                                '</div>' +
                                '<br>'
                            );

                        });


                        $('.custom-attributes').empty();
                        $('.custom-attr-text').append(result.cas.length > 0 ? "Custom Attributes " + "(" + result.cas.length + ")" : "Custom Attributes");

                        $.each(result.cas, function (i, item) {
                            //console.log("cus", i, item);
                            $.each(item, function (i, item) {
                                $('.custom-attributes').append(
                                    '<div class="row">' +
                                    '<label class="col-sm-2 control-label">' + i + ':</label>' +
                                    '<div class="col-sm-10">' +
                                    '<p class="form-control-static auto-action-an">' + item + '</p>' +
                                    '</div>' +
                                    '</div>'
                                );

                            });
                        });

                        $('.advice-text').append(result.advice ? "Advice +" : "Advice");
                        $('.advice').text(result.advice);


                    });

                    e.stopPropagation();
                    e.preventDefault();
                    $('#indiDetails').modal('show')

                });

            });


        });


    }

    Date.prototype.customFormat = function (formatString) {
        var YYYY, YY, MMMM, MMM, MM, M, DDDD, DDD, DD, D, hhh, hh, h, mm, m, ss, s, ampm, AMPM, dMod, th;
        var dateObject = this;
        YY = ((YYYY = dateObject.getFullYear()) + "").slice(-2);
        MM = (M = dateObject.getMonth() + 1) < 10 ? ('0' + M) : M;
        MMM = (MMMM = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"][M - 1]).substring(0, 3);
        DD = (D = dateObject.getDate()) < 10 ? ('0' + D) : D;
        DDD = (DDDD = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"][dateObject.getDay()]).substring(0, 3);
        th = (D >= 10 && D <= 20) ? 'th' : ((dMod = D % 10) == 1) ? 'st' : (dMod == 2) ? 'nd' : (dMod == 3) ? 'rd' : 'th';
        formatString = formatString.replace("#YYYY#", YYYY).replace("#YY#", YY).replace("#MMMM#", MMMM).replace("#MMM#", MMM).replace("#MM#", MM).replace("#M#", M).replace("#DDDD#", DDDD).replace("#DDD#", DDD).replace("#DD#", DD).replace("#D#", D).replace("#th#", th);

        h = (hhh = dateObject.getHours());
        //if (h==0) h=24;
        //if (h>12) h-=12;
        hh = h < 10 ? ('0' + h) : h;
        AMPM = (ampm = hhh < 12 ? 'am' : 'pm').toUpperCase();
        mm = (m = dateObject.getMinutes()) < 10 ? ('0' + m) : m;
        ss = (s = dateObject.getSeconds()) < 10 ? ('0' + s) : s;
        return formatString.replace("#hhh#", hhh).replace("#hh#", hh).replace("#h#", h).replace("#mm#", mm).replace("#m#", m).replace("#ss#", ss).replace("#s#", s).replace("#ampm#", ampm).replace("#AMPM#", AMPM);
    }

    /*
     document.ondblclick = function(evt) {
     if (window.getSelection)
     window.getSelection().removeAllRanges();
     else if (document.selection)
     document.selection.empty();
     }
     */


    function severityNumberToText(severity) {

        switch (severity) {
            case 0:
            case -6:
                sev = '<div>unknow</div>';
                break;
            case 1:
            case -5:
                sev = '<div class="green">normal</div>';
                break;
            case 2:
            case -4:
                sev = '<div class="blue">warning</div>';
                break;
            case 3:
            case -3:
                sev = '<div class="yellow">minor</div>';
                break;
            case 4:
            case -2:
                sev = '<div class="orange">major</div>';;
                break;
            case 5:
            case -1:
                sev = '<div class="red">critical</div>';;
                break;
            default:
                sev = '<div>unknow</div>';
                break;
        }
        return sev;


    }

    function GetURLParameter(sParam) {
        var sPageURL = window.location.search.substring(1);
        var sURLVariables = sPageURL.split('&');
        for (var i = 0; i < sURLVariables.length; i++) {
            var sParameterName = sURLVariables[i].split('=');
            if (sParameterName[0] == sParam) {
                return sParameterName[1];
            }
        }
    }

    function isEven(n) {
        return isNumber(n) && (n % 2 == 0);
    }

    function isNumber(n) {
        return n == parseFloat(n);
    }

}



