function drawLineChart() {

    d3.selectAll("svg").remove();

    d3.select("#explanation")
        .style("display", "none");

    d3.select("#sequence")
        .style("display", "none");

// interval 1 day - 86400000
    // interval 7 days - 604800000
    var agentIDs = [];

    d3.json("/json/perfclass?class=IS_HTTP", function (error, json) {
        //d3.json("/json/perfclass?class=IS_HTTP", function(error, json) {
        var agentidpos = 2;

        for (var i = 0; i < json.objects.length; i++) {
            if ("BOOMAGENTID" == json.objects[i]) {
                agentidpos = i;
            }
        }
        json.objectvalues.forEach(function (val) {
            if (agentIDs.indexOf(val[agentidpos]) == -1) {
                agentIDs.push(val[agentidpos]);
            }
        });
        agentIDs.forEach(function (id) {
            getChartsForAgent(id)
        });

    });

    function getChartsForAgent(agentID) {
        d3.json("/json/" + agentID + ".json", function (error, json) {
            //d3.json("/json/perfdata?class=IS_HTTP&metric=TTIME&id="+agentID+"&objects=HOST&interval=86400000", function(error, json) {
            console.log(JSON.stringify(json));
            var data = json.data;
            var className = json.class;
            var agentID = json.agentid;
            var metricName = json.metric;
            ;
            var minX = 0;
            var maxX = 0;
            var minY = 0;
            var maxY = 0;
            var margin = {
                top: 20,
                right: 80,
                bottom: 30,
                left: 50
            }, width = 1200 - margin.left - margin.right, height = 200 - margin.top - margin.bottom;
            var x = d3.time.scale().range([0, width]);
            var y = d3.scale.linear().range([height, 0]);

            var xAxis = d3.svg.axis().scale(x).orient("bottom").tickFormat(d3.time.format("%b %d %H:%M"));
            var yAxis = d3.svg.axis().scale(y).orient("left");
            var line = d3.svg.line()
                .interpolate("basis")
                .x(function (d) {
                    return x(d.date);
                })
                .y(function (d) {
                    return y(d.close);
                });


            data.forEach(function (kv) {

                var chartData = [];
                for (var i = 0; i < kv.times.length; i++) {
                    chartData.push({"date": new Date(kv.times[i]), "close": kv.values[i]});
                }

                x.domain(d3.extent(chartData, function (d) {
                    return d.date;
                }));
                y.domain(d3.extent(chartData, function (d) {
                    return d.close;
                }));

                var svg = d3.select("#sunburst-chart-area").append("svg")
                    .attr("width", width + margin.left + margin.right)
                    .attr("height", height + margin.top + margin.bottom)
                    .append("g")
                    .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

                svg.append("g")
                    .attr("class", "x axis")
                    .attr("transform", "translate(0," + height + ")")
                    .call(xAxis)
                    .selectAll("text")
                    .style("text-anchor", "end")
                    .attr("dx", "2.8em")
                    .attr("transform", function (d) {
                        return "rotate(0)"
                    });

                svg.append("g")
                    .attr("class", "y axis")
                    .call(yAxis)
                    .append("text")
                    .attr("transform", "rotate(-90)")
                    .attr("y", 6)
                    .attr("dy", ".71em")
                    .style("text-anchor", "end")
                    .text("Total Response Time (ms)");

                svg.append("path")
                    .datum(chartData)
                    .attr("class", "line")
                    .attr("d", line);

                svg.append("text")
                    .attr("x", 30)
                    .attr("dy", ".35em")
                    .text(function (d) {
                        return kv.HOST + " checked from AgentID: " + agentID;
                    });

            });


        });
    }

}
