function renderPackHirarchieAppGroup(){

    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height()-100;
    //var viewportHeight = screen.height-500;

    $(window).resize(function() {

        viewportWidth = $(window).width();
        viewportHeight = $(window).height()-100;
        //viewportHeight = screen.height-500;
        d3.select("#pack-hierarchy-chart-area")
            .style("height", viewportHeight+"px");

    });

    d3.select("#pack-hierarchy-chart-area")
        .style("height", viewportHeight+"px");

    var diameter = 960,
        r = 960,
        x = d3.scale.linear().range([0, r]),
        y = d3.scale.linear().range([0, r]),
        format = d3.format(",d"),
        color = d3.scale.category20c(),
        node,
        nodeZoom,
        root2,
        groupsApps;

    var bubble = d3.layout.pack()
//        .children(function (d, depth) {
//             return d.elements;
//
//        })
        //.sort(null)
        .sort(function comparator(a, b) {
            return b.indi_total - a.indi_total;
        })
        .size([r, r])
        .value(function(d) {
            return  d.indi_total;

        })
        .padding(1.5);

    var svg = d3.select("#pack-hierarchy-chart-area").append("svg")
//        .attr("width", diameter)
//        .attr("height", diameter)
        .attr("viewBox", "-" + 0 + " " + "-" + 0 + " " + diameter + " " + diameter)
        .attr("preserveAspectRatio", "xMidYMid meet")
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .call(d3.behavior.zoom().on("zoom", redraw))
        .on("click", function(d) {if (d3.event.defaultPrevented) return zoom(root2, 1); })
        .append("g")
        .attr("class", "bubble");
        //.attr("transform", "translate(" + (diameter - r) / 1 + "," + (diameter - r) / 1 + ")");


    d3.json("/json/heatappgrp" + '?' + Math.floor(Math.random() * 1000), function(error, root) {

        groupsApps = {};

        groupsApps.children = root;

        root2 = nodeZoom = groupsApps;

        if(error){ return console.log(error); }

        //console.log("root: ", root, groupsApps);

         node = svg.selectAll(".node")
            .data(bubble.nodes(groupsApps)
            .filter(function(d) { return !d.children; }))
            .enter().append("g")
            .attr("class", "node")
            .attr("transform", function(d) {return "translate(" + d.x + "," + d.y + ")";});

//        node.append("title")
//            .text(function(d) { return d.app + "/" + d.grp+ ": " + format(d.indi_total); });

        node.append("circle")
            //.call(d3.behavior.zoom().on("zoom", zoom2))
//            .attr("cx", function(d) { return d.x; })
//            .attr("cy", function(d) { return d.y; })
            .attr("r", function(d) { return d.r; })
            .on("click", function(d) { if (d3.event.defaultPrevented) return; return zoom(nodeZoom == d ? root2 : d, nodeZoom == d ? 1 : 2); })
            .style("fill", function(d) { return d.children ? "#ddd":/*color(d.grp)*/ colorGradient(d); })
            .on("mouseover", function (d) {
                //Update the tooltip position and value
                d3.select("#tooltip")
                    .style("left", (d3.event.pageX + 10) + "px")
                    .style("top", (d3.event.pageY - 10) + "px")
                    .select("#value")
                    .text(fillList(d));
                //Show the tooltip
                d3.select("#tooltip").classed("hidden", false);
            })
            .on("mouseout", function () {
                d3.select("#tooltip").classed("hidden", true);
            });

        node.append("text")
            //.on("dblclick",clickOnCircleFunc)
            .attr("text-anchor", "middle")
            .attr("class", "nodetext")
            .attr("data-classname", function(d) {return d.app+" / " +d.grp;})
            .attr("style", function(d) {var szd = d.r/5;return "font-size:" + szd+"px";})
            .attr("data-classname", function(d) {return d.app+" / " +d.grp;})
//            .attr("x", function(d) { return d.x; })
//            .attr("y", function(d) { return  d.y; })
            .each(function(d, i) {
                var nm = d.app+" / " +d.grp;
                var arr = nm.replace(/[\(\)\\/,-]/g, " ").replace(/\s+/g, " ").split(" "),arrlength = (arr.length > 7) ? 8 : arr.length;

                d.arrlength = arrlength;

                d3.select(this).attr('y',"-" + (arrlength/2) + "em");

                //d3.select(this).attr("transform", function(d) { return "translate(" + 0 + "," +"-"+ (arrlength/2)  + ")"; });
                //if text is over 7 words then ellipse the 8th
                for(var n = 0; n < arrlength; n++) {
                    console.log("this ", d3.select(this));
                    var tsp = d3.select(this)
                        .append('tspan')
                        .attr("x", "0")
                        .attr("dy", "1em")
                        .attr("data-classname", nm);
                        //.on("dblclick",clickOnCircleFunc);
                    if(n === 7) {
                        tsp.text("...");
                    } else {
                        tsp.text(arr[n]);
                    }
                }
            });

//        node.append("text")
//            //.attr("dy", ".3em")
//            //.style("text-anchor", "middle")
//            .attr("x", function(d) { return d.x; })
//            .attr("y", function(d) { return  d.y; })
//            .attr("style", function(d) {var szd = d.r/5;return "font-size:" + szd+"px";})
//            .attr("dy", ".35em")
//            .attr("text-anchor", "middle")
//            .style("opacity", function(d) { return d.r > (d.app.length+d.grp.length)*2 ? 1 : 0; })
//            .text(function(d) {
//                //if (d.app && d.app != "") return d.app.substring(0, d.indi_total / 3)+" / " +d.grp.substring(0, d.indi_total / 3);
//                if (d.app && d.app != "") return d.app+" / " +d.grp;
//            });


//        node.append("text")
//            //.attr("dy", ".3em")
//            //.style("text-anchor", "middle")
//            .attr("x", function(d) { return d.x; })
//            .attr("y", function(d) { return  d.y; })
//            .attr("style", function(d) {var szd = d.r/5;return "font-size:" + szd+"px";})
//            .attr("dy", ".35em")
//            .attr("text-anchor", "middle")
//            .style("opacity", function(d) { return d.r > (d.app.length+d.grp.length)*2 ? 1 : 0; })
//            .text(function(d) {
//                //if (d.app && d.app != "") return d.app.substring(0, d.indi_total / 3)+" / " +d.grp.substring(0, d.indi_total / 3);
//                if (d.app && d.app != "") return d.app+" / " +d.grp;
//            });
    });

    function colorGradient(d){
        var colorR, colorG, colorB;

        colorR = (d.cri_cnt*255 + d.maj_cnt*255 + d.min_cnt*245 + d.war_cnt*119 + d.nor_cnt*146 + d.unk_cnt * 232)/ d.indi_total;
        colorG = (d.cri_cnt*102 + d.maj_cnt*158 + d.min_cnt*228 + d.war_cnt*208 + d.nor_cnt*217 + d.unk_cnt * 232)/ d.indi_total;
        colorB = (d.cri_cnt*90 + d.maj_cnt*0 + d.min_cnt*0 + d.war_cnt*239 + d.nor_cnt*103 + d.unk_cnt * 232)/ d.indi_total;

        return d3.rgb(colorR, colorG, colorB);

    }

    function fillList(d) {

        d3.select("#app").text("App: ");
        d3.select("#app_value").text(d.app);

        d3.select("#grp").text("Group: ");
        d3.select("#grp_value").text(d.grp);
        d3.select("#indi_total").text("Total: ");
        d3.select("#indi_total_value").text(d.indi_total);
        d3.select("#cri_cnt").text("Critical: ");
        d3.select("#cri_cnt_value").text(d.cri_cnt);
        d3.select("#maj_cnt").text("Major: ");
        d3.select("#maj_cnt_value").text(d.maj_cnt);
        d3.select("#min_cnt").text("Minor: ");
        d3.select("#min_cnt_value").text(d.min_cnt);
        d3.select("#war_cnt").text("Warning: ");
        d3.select("#war_cnt_value").text(d.war_cnt);
        d3.select("#nor_cnt").text("Normal: ");
        d3.select("#nor_cnt_value").text(d.nor_cnt);
        d3.select("#unk_cnt").text("Unknow: ");
        d3.select("#unk_cnt_value").text(d.unk_cnt);

    }



    //d3.select(self.frameElement).style("height", diameter + "px");

    function zoom(d, zoomFaktor) {
        console.log("zoom d: ", d)
        var k = r / d.r / 2;
        x.domain([d.x - d.r*zoomFaktor, d.x + d.r*zoomFaktor]);
        y.domain([d.y - d.r*zoomFaktor, d.y + d.r*zoomFaktor]);

        var t = svg.selectAll("g").transition()
            .duration(d3.event.altKey ? 7500 : 750)
            .attr("transform", function(d) { return "translate(" + x(d.x) + "," + y(d.y) + ")"; });

//
//        var t = svg.transition()
//            .duration(d3.event.altKey ? 7500 : 750)  ;
            //.attr("transform", function(d) { return "translate(" + x(d.x) + "," + y(d.y) + ")"; });

//        t.selectAll(".node")
//            .attr("transform", function(d) { return "translate(" + x(d.x) + "," + y(d.y) + ")"; });

//        t.selectAll(".node")
//            .attr("transform", function(d) {return "scale(" + r / d.r + ")";});

        t.selectAll("circle")
            //.attr("cx", function(d) { return x(d.x); })
            //.attr("cy", function(d) { return y(d.y); })
            .attr("r", function(d) { return k * d.r/zoomFaktor; });

        t.selectAll("text")
            //.attr("style", function(d) {var szd = d.r/5;return "font-size:" + szd+"px";})
//            .attr("x", function(d) { return x(d.x); })
//            .attr("y", function(d) { return y(d.y) /*+(d.depth*10)*/; })
            //.attr("dy", "1em")
            .attr('y',"-" + (d.arrlength/2) + "em")
            .attr("style", function(d) {var szd = d.r*k/5;return "font-size:" + szd+"px";});
            //.style("opacity", function(d) { return (k * d.r) > (d.app.length+d.grp.length)*2 ? 1 : 0; });

        t.selectAll("tspan")
            //.attr("style", function(d) {var szd = d.r/5;return "font-size:" + szd+"px";})
//            .attr("x", function(d) { return x(d.x); })
            //.attr("y", function(d) { return y(d.y) /*+(d.depth*10)*/; })
            //.attr("dy", function(d) { return y(d.dy); })
            //.attr("dy", "1em");
            //.style("opacity", function(d) { return (k * d.r) > (d.app.length+d.grp.length)*2 ? 1 : 0; });

        nodeZoom = d;
        d3.event.stopPropagation();
    }

    function zoom2(d) {
        var k = r / d.r / 2;
        //var point = d3.mouse(d)
        console.log("zoom2");

        var x = d3.event.x;
        var y = d3.event.y;
        svg.attr("transform", "translate(" + x +","+ y+ ")" + " scale(" + k + ")");

        nodeZoom = d;
        d3.event.stopPropagation();
    }

    function redraw() {
        console.log("redraw");
        svg.attr("transform", "translate(" + d3.event.translate + ")" + " scale(" + d3.event.scale + ")");
    }



}