function renderPackHirarchie(){


    var w = 1280,
        h = 800,
        r = 720,
        x = d3.scale.linear().range([0, r]),
        y = d3.scale.linear().range([0, r]),
        node,
        root,
        agentsMap;

    var color = d3.scale.category20c();

    var pack = d3.layout.pack()
        .children(function (d, depth) {
            console.log("depth: ", depth, d.elements);
//            if(d.elements) {
                return d.elements;
//            }else{
//                return (d.type == "agt") ? d.elements = {"av":agentsMap.get(d.link).ind_av }:200;
//            }
        })
        .size([r, r])
        .value(function(d) {
            console.log("value: ", d);
            return d.depth ? ((d.type == "agt") ? agentsMap.get(d.link).ind_total : d.ind) : "";

        });

    var vis = d3.select("#pack-hirarchie-chart-area").insert("svg:svg", "h2")
        .attr("width", w)
        .attr("height", h)
        .append("svg:g")
        .attr("transform", "translate(" + (w - r) / 2 + "," + (h - r) / 2 + ")");

    d3.json("/json/agent_list", function (json_agents) {

        console.log(json_agents);
        var agents = json_agents;
        agentsMap = d3.map();
        agents.agents.forEach(function (entry) {

            agentsMap.set(entry.id, entry);

        });
// Use d3.text and d3.csv.parseRows so that we do not need to have a header
// row, and can receive the csv as an array of arrays.
        d3.json("/json/ngtree", function (json) {
            //var csv = d3.csv.parseRows(text);
            //var json = buildHierarchy(csv);
            console.log("json: ",json);
//            json.children().each(function(element){
//                console.log("element: ",element);
//                if(element.type == "agt") element.push({"av":22});
//            })

//            $.each(json, function(key,val){
//                // do something with key and val
//                if(val.type == "agt") element.push({"av":22});
//            });
//            traverse(json);
//            function traverse(json) {
//                $.each(json, function (i, item) {
//                    console.log("item: ",i,item);
//                    if(typeof item === 'object') {
//                        if (item.type == "agt") item.push({"av": 22});
//                        if(item.elements)traverse(item.elements)
//                    }
//                });
//            }

            //called with every property and it's value
            function process(key,value) {
                console.log(key + " : "+value);
            }

            function traverse(o,func) {
                for (var i in o) {
                    func.apply(this,[i,o[i]]);
                    if (o[i] !== null && typeof(o[i])=="object") {

                        if (o[i].type == "agt"){
                            o[i].elements = [{"ind": agentsMap.get(o[i].link).ind_av, "name":"av"},
                                             {"ind": agentsMap.get(o[i].link).ind_kpi, "name":"kpi"},
                                             {"ind": agentsMap.get(o[i].link).ind_other, "name":"other"}
                            ]
                        };
                        traverse(o[i],func);
                    }
                }
            }

            traverse(json,process);

            createVisualization(json);
        });
    });

    //d3.json("flare.json", function(data) {
    function createVisualization(data) {
        node = root = data;

        var nodes = pack.nodes(root);

        //console.log("nodes: ", nodes);
        vis.data([data]).selectAll("circle")
            .data(nodes)
            .enter().append("svg:circle")
            //.attr("title", function(d) { return d.name; })
            .attr("display", function (d) {
                return d.depth ? null : "none";
            })
            .style("fill", function (d, i) {
                return (d.type == "agt") ? treemap_color(agentsMap.get(d.link).sev_av) : d.ind ? color(d.name) : color(d.depth);
            })
            .style("fill-opacity", function (d, i) {
                return ((d.type == "agt") || (d.ind)) ? 1 : /*d3.rgb("#5"+i+"668D");*/0.6;
            })
            .attr("class", function(d) { return d.children ? "parent" : "child"; })
            .attr("cx", function(d) { return d.x; })
            .attr("cy", function(d) { return d.y; })
            .attr("r", function(d) { return d.r; })
            .on("click", function(d) { return zoom(node == d ? root : d); })
            .append("svg:title").text(function (d) {
                return (d.type == "agt") ? agentsMap.get(d.link).label.match(/.{1,8}/g)[0] : d.name.match(/.{1,8}/g)[0];
            });



        vis.data([data]).selectAll("text")
            .data(nodes)
            .enter().append("svg:text")
            .attr("class", function(d) { return d.children ? "parent" : "child"; })
            .attr("x", function(d) { return d.x; })
            .attr("y", function(d) { return  d.y;/*!(d.type == "agt") ? d.y + (d.depth*10):d.y*/ })
            .attr("dy", ".35em")
            .attr("text-anchor", "middle")
            .style("opacity", function(d) { return d.r > 20 ? 1 : 0; })
            .text(function(d) {
                return d.depth ? ((d.type == "agt") ? agentsMap.get(d.link).label.match(/.{1,8}/g)[0] : d.name.match(/.{1,8}/g)[0]) : "";
            });

        d3.select(window).on("click", function() { zoom(root); });
    };

    function zoom(d, i) {
        var k = r / d.r / 2;
        x.domain([d.x - d.r, d.x + d.r]);
        y.domain([d.y - d.r, d.y + d.r]);

        var t = vis.transition()
            .duration(d3.event.altKey ? 7500 : 750);

        t.selectAll("circle")
            .attr("cx", function(d) { return x(d.x); })
            .attr("cy", function(d) { return y(d.y); })
            .attr("r", function(d) { return k * d.r; });

        t.selectAll("text")
            .attr("x", function(d) { return x(d.x); })
            .attr("y", function(d) { return y(d.y) /*+(d.depth*10)*/; })
            .style("opacity", function(d) { return k * d.r > 20 ? 1 : 0; });

        node = d;
        d3.event.stopPropagation();
    }



}