function rednderPerfClassList() {

    var objectsString = "", perfAgentClasses = null,
        className, metricname, agentId, agentLabel, dKeys, mtr, obj;

    var length=10, draw=0, start=0, agentsPagination = null, init = true, searchString = "";
//        "size": 10,
//        "draw": 0,
//        "start": 0,

//        "recordsTotal": 10,
//        "recordsFiltered": 10,

    renderAgents(length, draw, start, searchString);

    function renderAgents(length, draw, start, searchString) {
        d3.json("/json/agent_list_real?length="+length+"&draw="+draw+"&start="+start+"&fi="+searchString, function (json_agents) {

            draw = json_agents.draw++;
            agentsPagination = json_agents;

            var agents = json_agents;
            console.log("agents", agents);
            //agentsMap = d3.map();

            if(init || searchString != ""){
                $('.agents-badge').text(agentsPagination.recordsTotal);
				var rest = agentsPagination.recordsTotal % length;
				var pageRest = 0;
				if(rest > 0){
					pageRest = 1;
				}
                $('.pagination-agent').bootpag({
                    total: Math.floor( agentsPagination.recordsTotal / length ) + pageRest,
                    page: 1,
                    maxVisible: 5
                }).on('page', function (event, num) {
                    //$(".content2").html("Page " + num); // or some ajax content loading...
                    renderAgents(length, draw, length * num - length, searchString)
                });

                init = false;

            }


           var agt = d3.select(".agents").selectAll("a")
                .data(agents.agents)
               .text(function (d) {
                   return d.label;
               });

            agt.enter()
                .append("a")
                .attr("href", function (d) {
                    return "javascript:;"
                })
                .attr("class", "list-group-item")
                .on("click", clickAgent)
                .text(function (d) {
                    return d.label;
                });

            agt.exit().remove();
        });
    }


//    $('.pagination-agent').bootpag({
//        total: agentsPagination.recordsTotal / 5,
//        page: 1,
//        maxVisible: 5
//    }).on('page', function (event, num) {
//        //$(".content2").html("Page " + num); // or some ajax content loading...
//        renderAgents(length, draw, length * num - length)
//    });


    function clickAgent(agtd) {

        d3.selectAll(".agents").selectAll(".active").classed("active", false);
        d3.select(this).classed("active", true);


        d3.selectAll(".classes").selectAll(".active").classed("active", false);

        agentId = agtd.id;
        agentLabel = agtd.label;

        d3.select("#class-loading-indicator").style("display", "inline");

        d3.json("/json/perfagt?id=" + agtd.id, function (data) {


            console.log("click", agtd, data);

            var classesLength = data.classes.length;
            perfAgentClasses = data.classes;
            className = false;

            if(classesLength == 0) {

                //perfAgentClasses.push({ class:"Perf. classes not found!"});
                data.classes.push({ class:"Perf. classes not found!"});

            }

            var cls = d3.select(".classes").selectAll("a")
                .data(data.classes)
                .text(function (d) {
                    return d.class;
                });

            cls.enter()
                .append("a")
                .attr("href", function(d){return "javascript:;"})
                .attr("class", "list-group-item")
                .on("click", (classesLength > 0) ? clickPerfClass:"")
                .text(function (d) {
                    return d.class;
                });

            cls.exit().remove();

            if(mtr) {
                mtr.remove();
                obj.remove();
            }

            d3.select("#class-loading-indicator").style("display", "none");

//            var obj = d3.select(".objects").selectAll("li")
//                .data(data.classes);
//
//            obj.enter()
//                .append("li")
//                .attr("class", "list-group-item")
//                .on("click", clickPerfClass)
//                //.text(function(d){ return d.values[1]; });
//                .text(perpareObjects);
//
//            obj.exit().remove();

        });

    }

    function clickPerfClass(perfClass) {

        console.log("perfClass: ", perfClass);

        d3.selectAll(".classes").selectAll(".active").classed("active", false);
        d3.selectAll(".objects").selectAll(".active").classed("active", false)
        d3.selectAll(".metrics").selectAll(".active").classed("active", false)
        d3.select(this).classed("active", true);
        d3.selectAll(".metric-loading-indicator").style("display", "inline");

        className = perfClass.class;
        dKeys = perfClass.keys;

        metricname = false;
        objectsString = false;

        d3.json("/json/perfclass?class=" + perfClass.class, function (data) {
            console.log("clickPerfClass: ", "perfClass d: ", perfClass, "data: ", data);

            d3.select(".metrics").selectAll("li").remove();
            d3.select(".objects").selectAll("li").remove();

            mtr = d3.select(".metrics").selectAll("a")
                .data(data.metrics)
                .text(function (d) {
                    return d;
                });

            mtr.enter()
                .append("a")
                .attr("href", function(d){return "javascript:;"})
                .attr("class", "list-group-item")
                .on("click", clickMetric)
                .text(function (d) {
                    return d;
                });

            mtr.exit().remove();

            //cls.exit().remove();

            //render objects from variable perfAgentClasses
            obj = d3.select(".objects").selectAll("a")
//                .data(perfAgentClasses.filter(function (n) {
//                    return n.class == d.class;
//                }));
//                .data(perfClass.values.sort(function(a, b) {
//                    return d3.ascending(a[0], b[0]);
//                }))
                .data(perfClass.values)
                .text(perpareObjects);

            //obj.remove();

            obj.enter()
                .append("a")
                .attr("href", function(d){return "javascript:;"})
                .attr("class", "list-group-item")
                .on("click", clickObject)
                //.text(function(d){ return d.values[1]; });
                .text(perpareObjects);

            obj.exit().remove();

            d3.selectAll(".metric-loading-indicator").style("display", "none");

        });
    }

    function clickMetric(d) {
        d3.selectAll(".metrics").selectAll(".active").classed("active", false);
        d3.select(this).classed("active", true);

        metricname = d;

        if (objectsString && className && metricname && agentId) {

            var fromDate = $('.start-date').val().split("/");;
            var toDate = $('.end-date').val().split("/");;

            console.log("from: ", fromDate);

            fromDate2 = past = new Date(fromDate[2], fromDate[1] - 1, fromDate[0]);
            toDate2 = now = new Date(toDate[2], toDate[1] - 1, toDate[0], 23, 59, 59, 999);

            renderChart(fromDate2.getTime(), toDate2.getTime());
        }
        //renderChart();

    }

    function clickObject(d) {
        d3.selectAll(".objects").selectAll(".active").classed("active", false);
        d3.select(this).classed("active", true);

        var objectArray = [];

        d.forEach(function (z, j) {
            objectArray.push([dKeys[j] + "=" + z]);
        });

        objectsString = objectArray.join(",");

        if (objectsString && className && metricname && agentId) {

            var fromDate = $('.start-date').val().split("/");;
            var toDate = $('.end-date').val().split("/");;

            console.log("from: ", fromDate);

            fromDate2 = past = new Date(fromDate[2], fromDate[1] - 1, fromDate[0]);
            toDate2 = now = new Date(toDate[2], toDate[1] - 1, toDate[0], 23, 59, 59, 999);

            renderChart(fromDate2.getTime(), toDate2.getTime());
        }

        //console.log("clickObject: ", d, objectsString);

    }


    function perpareObjects(d) {

        console.log("prepair: ", d, dKeys);
        var labelString, indexOfAGENTID;

        indexOfAGENTID = dKeys.indexOf("BOOMAGENTID");
        if (indexOfAGENTID > -1) {
            var dtemp = d.slice();
            dtemp.splice(indexOfAGENTID, 1);
        }
        labelString = dtemp.join(",");

        return labelString;

    }


    function renderChart(fromDate, toDate) {

        d3.select(".chart").select("svg").remove();

        d3.select("#loading-indicator").style("display", "inline");

        var margin = {top: 10, right: 10, bottom: 300, left: 50},
            margin2 = {top: 230, right: 10, bottom: 220, left: 50},
            width = 960 - margin.left - margin.right,
            height = 500 - margin.top - margin.bottom,
            height2 = 500 - margin2.top - margin2.bottom;

        var parseDate = d3.time.format("%b %Y").parse;

        var x = d3.time.scale().range([0, width]),
            x2 = d3.time.scale().range([0, width]),
            y = d3.scale.linear().range([height, 0]),
            y2 = d3.scale.linear().range([height2, 0]);

        var xAxis = d3.svg.axis().scale(x).orient("bottom"),
            xAxis2 = d3.svg.axis().scale(x2).orient("bottom"),
            yAxis = d3.svg.axis().scale(y).orient("left");

        var brush = d3.svg.brush()
            .x(x2)
            .on("brush", brushed);
        //area
//        var area = d3.svg.area()
//            .interpolate("linear")
//            .x(function (d) {
//                return x(d.date);
//            })
//            .y0(height)
//            .y1(function (d) {
//                //console.log("d.close", d);
//                return y(d.close);
//            });
//
//        var area2 = d3.svg.area()
//            .interpolate("linear")
//            .x(function (d) {
//                return x2(d.date);
//            })
//            .y0(height2)
//            .y1(function (d) {
//                return y2(d.close);
//            });

//        var area2 = d3.svg.line()
//            .interpolate("linear")
//            .x(function (d) {
//                return x2(d.date);
//            })
//            //.y0(height2)
//            .y(function (d) {
//                return y2(d.close);
//            });

        //line
        var area = d3.svg.line()
            .interpolate("linear")
            .x(function(d) { return x(d.date); })
            //.y0(height)
            .y(function(d) { return y(d.close); });

        var area2 = d3.svg.line()
            .interpolate("linear")
            .x(function(d) { return x2(d.date); })
            //.y0(height2)
            .y(function(d) { return y2(d.close); });


        var svg = d3.select(".chart").append("svg")
            //.attr("width", width + margin.left + margin.right)
            //.attr("height", height + margin.top + margin.bottom)
            .attr({
                "width": "100%",
                "height": "100%"
            })
            .attr("viewBox", "0 0 " + (width + margin.left) + " " + 300)
            .attr("preserveAspectRatio", "xMidYMid meet");

        svg.append("defs").append("clipPath")
            .attr("id", "clip")
            .append("rect")
            .attr("width", width)
            .attr("height", height);


        var focus = svg.append("g")
            .attr("class", "focus")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

        var context = svg.append("g")
            .attr("class", "context")
            .attr("transform", "translate(" + margin2.left + "," + margin2.top + ")");


        //console.log("URL: " + "/json/perfdata?class=" + className + "&metric=" + metricname + "&id=" + agentId + "&objects=" + objectsString + "&from=" + fromDate + "&to=" + toDate);

        d3.json("/json/perfdata?class=" + className + "&metric=" + metricname + "&id=" + agentId + "&objects=" + objectsString + "&from=" + fromDate + "&to=" + toDate, function (error, json) {
            //d3.json("/json/perfdata?class=" + perfClass + "&metric=" + metric + "&id=" + agentID + "&objects=" + objectsString + "&from=" + fromDate + "&to=" + toDate, function (error, json) {

            var chartData = [], kv = json.data[0];

//            console.log("time", kv.times.length);

            for (var i = 0; i < kv.times.length; i++) {

                chartData.push({"date": new Date(kv.times[i]), "close": kv.values[i] });
            }

            //x.domain(d3.extent(data.map(function(d) { return d.date; })));
            x.domain(d3.extent(chartData.map(function (d) {
                //console.log("d.date",d.date);
                return d.date;
            })));
            //y.domain(d3.extent(chartData, function(d) { return d.close; }));

            y.domain([0, d3.max(chartData, function (d) {
                return d.close * 1.08;
            })]);

            x2.domain(x.domain());
            y2.domain(y.domain());

            focus.append("path")
                .datum(chartData)
                .attr("class", "line")
                .attr("d", area);

            focus.append("g")
                .attr("class", "x axis")
                .attr("transform", "translate(0," + height + ")")
                .call(xAxis);

            focus.append("g")
                .attr("class", "y axis")
                .call(yAxis)
                .append("text")
                .attr("transform", "rotate(-90)")
                .attr("y", 6)
                .attr("dy", ".71em")
                .style("text-anchor", "end")
                .style("font", "8px sans-serif")
                .text(metricname);

            context.append("path")
                .datum(chartData)
                .attr("class", "line")
                .attr("d", area2);

            context.append("g")
                .attr("class", "x axis")
                .attr("transform", "translate(0," + height2 + ")")
                .call(xAxis2);

            context.append("g")
                .attr("class", "x brush")
                .call(brush)
                .selectAll("rect")
                .attr("y", -6)
                .attr("height", height2 + 7);
            //display chart and titel
            d3.select(".char-title").text(kv.HOST + " checked from AgentID: " + agentId);
            //d3.select(".chart-panel").style("display", "block");

            //d3.json("/json/perfdata?class=" + className + "&metric=" + metricname + "&id=" + agentId + "&objects=" + objectsString + "&from=" + fromDate + "&to=" + toDate, function (error, json) {

                d3.select("#bookmarkme")
                    .attr("target", "_blank")
                    .attr("href", "perf-data-bookmark.html?class="+className
                        +"&metric="+metricname
                        +"&id="+agentId
                        +"&objects="+objectsString
                        +"&from="+fromDate
                        +"&to="+toDate
                        +"&agentLabel="+agentLabel);

            d3.select("#loading-indicator").style("display", "none");

        });


        function brushed() {
            x.domain(brush.empty() ? x2.domain() : brush.extent());
            focus.select(".line").attr("d", area);
            focus.select(".x.axis").call(xAxis);
        }

        function type(d) {
            d.date = parseDate(d.data[0].times);
            d.close = +d.data[0].values;
            return d;
        }


    }


    $('.input-daterange').datepicker({
        format: "dd/mm/yyyy",
        weekStart: 1,
        orientation: "bottom auto",
        todayHighlight: true,
        autoclose: true,
        //startDate: '-30d',
        endDate: '0'

    });

    var nowTemp = new Date();
    var now = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 23, 59, 59, 999);

    nowTemp.setDate(nowTemp.getDate() - 5);
    var past = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 0, 0, 0, 0);

    $('.input-daterange .start-date').datepicker('setDate', past);
    $('.input-daterange .end-date').datepicker('setDate', now);

    $('#datepicker-go').on('click', function (e) {

        d3.select(".alert-info").style("display", "none");

        var fromDate = $('.start-date').val().split("/");;
        var toDate = $('.end-date').val().split("/");;

        console.log("from: ", fromDate);

        fromDate2 = past = new Date(fromDate[2], fromDate[1] - 1, fromDate[0]);
        toDate2 = now = new Date(toDate[2], toDate[1] - 1, toDate[0], 23, 59, 59, 999);

        console.log("fromDate2: ", fromDate2);


        if (objectsString && className && metricname && agentId) {

            renderChart(fromDate2.getTime(), toDate2.getTime());
        } else {

            d3.select(".alert-info").style("display", "block");
        }
    });

    $('.agent-search-btn').on('click', function (e) {
        renderAgents(length, draw, start, $('.agent-search-txt').val());
    });

    $('.agent-search-txt').keyup(function( event ) {
            console.log(event.which)
        if ( event.which == 13 ) {
            renderAgents(length, draw, start, $('.agent-search-txt').val());
            event.preventDefault();
        }
    });

//    d3.select("#bookmarkme")
//      .on("click", function(){
//
//            window.open("indications.html?av=5", "_self");
//
//        })

//    $(function() {
//        $('#bookmarkme').click(function() {
//            if (window.sidebar && window.sidebar.addPanel) { // Mozilla Firefox Bookmark
//                window.sidebar.addPanel(document.title,window.location.href,'');
//            } else if(window.external && ('AddFavorite' in window.external)) { // IE Favorite
//                window.external.AddFavorite(location.href,document.title);
//            } else if(window.opera && window.print) { // Opera Hotlist
//                this.title=document.title;
//                return true;
//            } else { // webkit - safari/chrome
//                alert('Press ' + (navigator.userAgent.toLowerCase().indexOf('mac') != - 1 ? 'Command/Cmd' : 'CTRL') + ' + D to bookmark this page.');
//            }
//        });
//    });


}
