function renderServices() {

    var dataLocal;
    var gauges = [];

    setInterval(updateService, 20000);

    $(document).ready(function () {

        (function ($) {

            $('#filter').keyup(function () {

                var rex = new RegExp($(this).val(), 'i');
                $('.service').hide();
                $('.service').filter(function () {
                    return rex.test($(this).text());
                }).show();

            })

        }(jQuery));

    });

    $('#orderByName').on("click", function () {
            console.log("click");
        d3.selectAll(".service").remove();
        updateService(dataLocal.sort(function(a,b) { return d3.ascending(a.name, b.name) }));


    });

    $('#orderBySeverity').on("click", function () {
        console.log("click");
        d3.selectAll(".service").remove();
        updateService(dataLocal.sort(function(a,b) { return d3.descending(a.av_max, b.av_max) }));

    });





    function updateService(orderData) {

        d3.json("/json/sd1", function (data) {
            dataLocal =  data;

            console.log("data", data, orderData);

            var servicesContainer = d3.select("#services-chart-area");

            var services = servicesContainer.selectAll(".service")
                .data(orderData ? orderData: data, function(d) { return d.id; });

            //data-toggle="tooltip" data-placement="top" title="Click for details"


            var entering = services.enter()
                .append("div")
                .style("display", "inline-block")
                .style("background", function (d) {
                    return treemap_color(d.av_max)
                })
                .attr("class", "service")
                .attr("data-toggle", "tooltip")
                .attr("data-placement", "top")
                .attr("title", "Click for details");

            entering.append("ul")
                .attr("class", "list-info-service highlight-ind")
                .style("max-width", "170px")
                .append("li").text(function (d) {
                    return d.name
                });

            var total = entering.append("ul")
                .attr("class", "list-info-total-service")
                .style("margin-right", "5px");
            total.append("li").html(function (d) {
                return "&#931; " + totalCounts(d);
            });

            var background = entering.append("div")
                .attr("class", "background-service");


            var indiContainer = background.append("div")
                .attr("class", "service-indications");

            var criIndications = indiContainer.append("div");

            criIndications.append("div")
                .attr("class", "indi")
                .style("background", function (d) {
                    return "#ff665a"
                });
            criIndications.append("span")
                .attr("class", "ind-cri")
                .text(function (d) {
                    return criCounts(d)
                });

            var majIndications = indiContainer.append("div");

            majIndications.append("div")
                .attr("class", "indi")
                .style("background", function (d) {
                    return "#ff9e00"
                });
            majIndications.append("span")
                .attr("class", "ind-maj")
                .text(function (d) {
                    return majCounts(d)
                });

            var minIndications = indiContainer.append("div");

            minIndications.append("div")
                .attr("class", "indi")
                .style("background", function (d) {
                    return "#f5e400"
                });

            minIndications.append("span")
                .attr("class", "ind-min")
                .text(function (d) {
                    return minCounts(d)
                });

            var warIndications = indiContainer.append("div");

            warIndications.append("div")
                .attr("class", "indi")
                .style("background", function (d) {
                    return "#77d0ef"
                });
            warIndications.append("span")
                .attr("class", "ind-war")
                .text(function (d) {
                    return warCounts(d)
                });

            var norIndications = indiContainer.append("div");

            norIndications.append("div")
                .attr("class", "indi")
                .style("background", function (d) {
                    return "#92d967"
                });
            norIndications.append("span")
                .attr("class", "ind-nor")
                .text(function (d) {
                    return normalCounts(d);
                });


            background.append("div")
                .attr("id", function (d) {
                    return "GaugeContainer-" + d.id;
                })
                .attr("class", "gauge-container")
                .each(function (d) {
                    createGauge(d.id, "", 0, 1);
                    updateGauges(d.id, d.kp_wa);
                });


            d3.selectAll(".service").on("click", function (d) {
                //console.log("select", d);
                window.open("indications.html?service=" + d.id+"&serviceName="+ d.name, "_self");

            });

            //Upadate
            services.select(".list-info-service li").text(function(d){return d.name});

            services.select(".list-info-total-service li").html(function (d) {
                return "&#931; " + totalCounts(d);
            });
            services.select(".ind-cri").text(function (d) {
                return criCounts(d)
            });

            services.select(".ind-maj").text(function (d) {
                return majCounts(d)
            });
            services.select(".ind-min").text(function (d) {
                return minCounts(d)
            });
            services.select(".ind-war").text(function (d) {
                return warCounts(d)
            });
            services.select(".ind-nor").text(function (d) {
                return normalCounts(d)
            });

            data.forEach(function (d) {
                setTimeout(function(){updateGauges(d.id, d.kp_wa);},500);
            });

            // Exit…
            services.exit().remove();

            $(function () {
                $('[data-toggle="tooltip"]').tooltip();
            });

        });


//        var gauges = [];

        function createGauge(name, label, min, max) {
            //console.log("createGauge", name, label, min, max);
            var config =
            {
                size: 120,
                label: label,
                min: undefined != min ? min : 0,
                max: undefined != max ? max : 1,
//                minorTicks: 1,
//                majorTicks: 11
                minorTicks: 10,
                majorTicks: 2
            };

            var range = config.max - config.min;
            config.greenZones = [
                { from: config.min + range * 0.0, to: config.min + range * 0.2 }
            ];
            config.blueZones = [
                { from: config.min + range * 0.2, to: config.min + range * 0.4 }
            ];
            config.yellowZones = [
                { from: config.min + range * 0.4, to: config.min + range * 0.6 }
            ];
            config.orangeZones = [
                { from: config.min + range * 0.6, to: config.min + range * 0.8 }
            ];
            config.redZones = [
                { from: config.min + range * 0.8, to: config.max }
            ];

            gauges[name] = new Gauge("GaugeContainer-" + name, config);
            gauges[name].render();
        }

        function createGauges() {
            //createGauge("kpi", "KPI");
            //createGauge("cpu", "CPU");
            //createGauge("network", "Network");
            //createGauge("test", "Test", -50, 50 );
        }

        function updateGauges(value) {
            for (var key in gauges) {
                //console.log("key:value ", key, value);
                //var value = getRandomValue(gauges[key])
                gauges[key].redraw(value);
            }
        }

        function updateGauges(key, value) {
            gauges[key].redraw(value);
//            setInterval(updateService, 20000);
//            setInterval(updateGauges, 20000);
        }

        function getRandomValue(gauge) {
            var overflow = 0; //10;
            return gauge.config.min - overflow + (gauge.config.max - gauge.config.min + overflow * 2) * Math.random();
        }

        function initialize() {
            createGauges();
            setInterval(updateGauges, 20000);
        }

        function totalCounts(d) {
            var total = 0;
            for (var key in d) {
                var keylenght = key.length;
                if (key.substring(0, 3) == "cnt" && keylenght < 7) {
                    total += d[key];
                }
            }
            return total;
        }

        function normalCounts(d) {
            var total = 0;
            for (var key in d) {
                var keylenght = key.length;
                if (key.substring(0, 3) == "cnt" && key.substring(keylenght - 3, keylenght) == "nor") {
                    //console.log("key: ", key);
                    total += d[key];
                }
            }
            return total;
        }

        function warCounts(d) {
            var total = 0;
            for (var key in d) {
                var keylenght = key.length;
                if (key.substring(0, 3) == "cnt" && key.substring(keylenght - 3, keylenght) == "war") {
                    total += d[key];
                }
            }
            return total;
        }

        function minCounts(d) {
            var total = 0;
            for (var key in d) {
                var keylenght = key.length;
                if (key.substring(0, 3) == "cnt" && key.substring(keylenght - 3, keylenght) == "min") {
                    total += d[key];
                }
            }
            return total;
        }

        function majCounts(d) {
            var total = 0;
            for (var key in d) {
                var keylenght = key.length;
                if (key.substring(0, 3) == "cnt" && key.substring(keylenght - 3, keylenght) == "maj") {
                    total += d[key];
                }
            }
            return total;
        }

        function criCounts(d) {
            var total = 0;
            for (var key in d) {
                var keylenght = key.length;
                if (key.substring(0, 3) == "cnt" && key.substring(keylenght - 3, keylenght) == "cri") {
                    total += d[key];
                }
            }
            return total;
        }

    }

//initialize();
    updateService();
}
