function renderSunBurstNames() {


    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height();

    $(window).resize(function() {

        viewportWidth = $(window).width();
        viewportHeight = $(window).height();
        d3.select("#sunburst-names-chart-area")
            .style("height", viewportHeight - (viewportHeight*0.25) + "px");

    });

    updateSunburst();

   d3.select("#sunburst-names-chart-area")
       .style("height", viewportHeight - (viewportHeight*0.25) + "px");

    var width = 960,
        height = 960,
        radius = Math.min(width, height) / 2,
        padding = 5,
        duration = 1000,
        agentsMap,
        root,
        node,
        zoomOid,
        treeChanged={};

    var x = d3.scale.linear()
        .range([0, 2 * Math.PI]);

    var y = d3.scale.pow().exponent(0.8)
        .range([0, radius]);

    var color = d3.scale.category20c();

    var svg = d3.select("#sunburst-names-chart-area")
        .append("svg:svg")
        .attr("viewBox", "-" + width / 2 + " " + "-" + height / 2 + " " + width + " " + height)
        .attr("preserveAspectRatio", "xMidYMid meet")
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .append("svg:g");

    var partition = d3.layout.partition()
        .children(function (d, depth) {
            return d.elements;
        })
        .value(function (d) {
            return 1;
            /* size of square */
        });
    /*
     var arc = d3.svg.arc()
     .startAngle(function(d) { return Math.max(0, Math.min(2 * Math.PI, x(d.x))); })
     .endAngle(function(d) { return Math.max(0, Math.min(2 * Math.PI, x(d.x + d.dx))); })
     .innerRadius(function(d) { return Math.max(0, y(d.y)); })
     .outerRadius(function(d) { return Math.max(0, y(d.y + d.dy)); });
     */
    var arc = d3.svg.arc()
        .startAngle(function (d) {
            return Math.max(0, Math.min(2 * Math.PI, x(d.x)));
        })
        .endAngle(function (d) {
            return Math.max(0, Math.min(2 * Math.PI, x(d.x + d.dx)));
        })
        .innerRadius(function (d) {
            return Math.max(0, d.y ? y(d.y) : d.y);
        })
        .outerRadius(function (d) {
            return Math.max(0, y(d.y + d.dy));
        });

    function updateSunburst(){

//    d3.json("../json_test/beatfish/agent_list.json" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
    d3.json("/json/agent_list", function (json_agents) {

        var agents = json_agents;
        agentsMap = d3.map();
        agents.agents.forEach(function (entry) {

            agentsMap.set(entry.id, entry);

        });

           d3.json("/json/ngtree", function (json) {

               if(treeChanged.MD5 != json.attributes[0].MD5) {
                   treeChanged.changed = true;
               }else{
                   treeChanged.changed = false;
               }
               treeChanged.MD5 = json.attributes[0].MD5;

            root = json.elements[0];

           //console.log("root path", root, partition.nodes(root).filter(function(d, i) { return d.oid === "184e5eae7af7440199006d29b9027662" }));


            var path = svg.selectAll("path")
                .data(partition.nodes(root), function(d) { return (d.type == "agt") ? (d.parent.name + d.link): d.oid; })
                .on("click", click);

                var entering = path.enter().append("path")
                .attr("d", arc)
                //.style("fill", function(d) { return color((d.children ? d : d.parent)).name; })
                .style("fill", function (d, i) {
                    return (d.type === "agt") && agentsMap.get(d.link) ? treemap_color(agentsMap.get(d.link).sev_av) : /*d3.rgb("#5"+i+"668D");*/color(d.depth);
                })
                .attr("class", function (d, i) {
                    return (d.type == "agt") ? "agent":"grp";
                })
                .on("click", click)
                .on("mouseover", mouseover)
                .on("mouseout", mouseout);


            var text = svg.selectAll("text").data(partition.nodes(root), function(d) { return (d.type == "agt") ? (d.parent.name + d.link): d.oid; });


            var textEnter = text.enter().append("text")
                .style("fill-opacity", 1)
                .style("opacity",function (d) {
                    var kx = width * d.dx,
                        ky = height * d.dy;
                    return (ky > 24) && (kx > 12) ? 1 : 0;
                })
                .style("fill", function (d) {
                    return brightness(d3.rgb(colour(d))) < 125 ? "#eee" : "#000";
                })
                .attr("text-anchor", function (d) {
                    return x(d.x + d.dx / 2) > Math.PI ? "end" : "start";
                })
                //.attr("dy", ".2em")
                .attr("transform", function (d) {
                    //var multiline = (d.name || "").split(" ").length > 1,
                    var textlenght = Math.round(radius * d.dy/9);

                    var re = new RegExp(".{1,"+textlenght+"}","g");

                    var multiline = (d.name || "").match(re).length > 1,
                        angle = x(d.x + d.dx / 2) * 180 / Math.PI - 90,
                        rotate = angle + (multiline ? -.5 : 0);
                    return "rotate(" + rotate + ")translate(" + (y(d.y) + padding) + ")rotate(" + (angle > 90 ? -180 : 0) + ")";
                })
                .on("click", click);


            textEnter.append("tspan")
                .attr("x", 0)
                .text(function (d) {
                    var textlenght = Math.round(radius * d.dy/9);

                    var re = new RegExp(".{1,"+textlenght+"}","g");
                    return d.depth ? ((d.type == "agt") && agentsMap.get(d.link) ? agentsMap.get(d.link).label.match(re)[0] : d.name.match(re)[0]) : "";
                });
            //.text(function(d) { return d.depth ? d.name.split(" ")[0] : ""; });

            textEnter.append("tspan")
                .attr("x", 0)
                .attr("dy", "1em")
                .text(function (d) {
                    var textlenght = Math.round(radius * d.dy/9);

                    var re = new RegExp(".{1,"+textlenght+"}","g");
                    return (d.type == "agt") && agentsMap.get(d.link) ? agentsMap.get(d.link).label.match(re)[1] : d.name.match(re)[1];
                });
            //.text(function(d) { return d.depth ? d.name.split(" ")[1] || "" : ""; });

                path.exit().remove();
                text.exit().remove();

                //click(root);

            svg.selectAll(".agent")
                    .style("fill", function (d) {
                        return (d.type == "agt") && agentsMap.get(d.link) ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
                    });
            //console.log("node root", node, root);
            //click(node ? node:root);

               if(treeChanged.changed) {
                   //click(node ? node:root);
                   click(zoomOid ? partition.nodes(root).filter(function(d, i) { return d.oid === zoomOid })[0]:root);
               }

               //click(root);

            function mouseover(d){
                var tip = d3.select("#tooltipPartition");

                tip.select("#value")
                    .text(fillList(d, agentsMap));

                var mousex = d3.event.pageX - 20; //Get X coodrinates
                var mousey = d3.event.pageY - 20; //Get Y coordinates

                var tipWidth = $(tip.node()).width(); //Find width of tooltip
                var tipHeight = $(tip.node()).height(); //Find height of tooltip

                //Distance of element from the right edge of viewport
                var tipVisX = $(window).width() - (mousex + tipWidth);
                //Distance of element from the bottom of viewport
                var tipVisY = $(window).height() - (mousey + tipHeight);

                if ( tipVisX < 20 ) { //If tooltip exceeds the X coordinate of viewport

                    if( tipWidth > d3.event.pageX - 20 ){
                        mousex = 0;
                    } else {
                        mousex = d3.event.pageX - tipWidth - 20;
                    }

                } if ( tipVisY < 20 ) { //If tooltip exceeds the Y coordinate of viewport
                    mousey = d3.event.pageY - tipHeight - 20;
                }
                tip.style("left", mousex + "px")
                    .style("top", mousey + "px");

                //Show the tooltip
                tip.transition()
                    .duration(200)
                    .delay(100)
                    .style("opacity", .9);

//                if (d.type == "agt") {
//
//                    //Update the tooltip position and value
//                    d3.select("#tooltipPartition")
//                        .style("left", (d3.event.pageX - 200) + "px")
//                        .style("top", (d3.event.pageY + 10) + "px")
//                        .select("#value")
//                        .text(fillList(d, agentsMap));
//                    //Show the tooltip
//                    d3.select("#tooltipPartition").classed("hidden", false);
//                } else {
//
//                    //Update the tooltip position and value
//                    d3.select("#tooltipPartition")
//                        .style("left", (d3.event.pageX - 200) + "px")
//                        .style("top", (d3.event.pageY + 10) + "px")
//                        .select("#value")
//                        .text(fillList(d, agentsMap));
//                    //Show the tooltip
//                    d3.select("#tooltipPartition").classed("hidden", false);
//
//                }

            }

            function mouseout(d){
                var tip = d3.select("#tooltipPartition");

                //tip.style("opacity", 0);

                tip.transition()
                    .duration(2)
                    .style("opacity", 0);

            }

            function click(d) {
                //console.log("click: ", d, path)
                if(d.type ==  "agt"){
                    window.open("indications.html?agent=" + d.link + "&label="+agentsMap.get(d.link).label, "_self");
                    return;
                }

                path.transition()
                    .duration(750)
                    .attrTween("d", arcTween(d));

                // Somewhat of a hack as we rely on arcTween updating the scales.
                text.style("visibility", function (e) {
                    return isParentOf(d, e) ? null : d3.select(this).style("visibility");
                })
                    .transition()
                    .duration(duration)
                    .attrTween("text-anchor", function (d) {
                        return function () {
                            return x(d.x + d.dx / 2) > Math.PI ? "end" : "start";
                        };
                    })
                    .attrTween("transform", function (d) {
                        var multiline = (d.name || "").split(" ").length > 1;
                        return function () {
                            var angle = x(d.x + d.dx / 2) * 180 / Math.PI - 90,
                                rotate = angle + (multiline ? -.5 : 0);
                            return "rotate(" + rotate + ")translate(" + (y(d.y) + padding) + ")rotate(" + (angle > 90 ? -180 : 0) + ")";
                        };
                    })
                    .style("fill-opacity", function (e) {
                        return isParentOf(d, e) ? 1 : 1e-6;
                    })
                    .each("end", function (e) {
                        d3.select(this).style("visibility", isParentOf(d, e) ? null : "hidden");
                    });

                node = d;
                zoomOid = d.oid ? d.oid:false;

            }

            //Buttons Controll
            d3.select("#size").on("click", function () {
                path
                    .data(partition.value(function (d) {
                        return d.link ? agentsMap.get(d.link).ind_total : null;

                    }).nodes(root))
                    .transition()
                    .duration(1500)
                    .attrTween("d", arcTween2);

                d3.select("#size").classed("active", true);
                d3.select("#count").classed("active", false);
            });

            d3.select("#count").on("click", function () {
                path
                    .data(partition.value(function (d) {
                        return 1;
                    }).nodes)
                    .transition()
                    .duration(1500)
                    .attrTween("d", arcTween2);

                d3.select("#size").classed("active", false);
                d3.select("#count").classed("active", true);
            });
        });

    });

    }

    d3.select(self.frameElement).style("height", height + "px");
    /*
     // Interpolate the scales!
     function arcTween(d) {
     var xd = d3.interpolate(x.domain(), [d.x, d.x + d.dx]),
     yd = d3.interpolate(y.domain(), [d.y, 1]),
     yr = d3.interpolate(y.range(), [d.y ? 20 : 0, radius]);
     return function(d, i) {
     return i
     ? function(t) { return arc(d); }
     : function(t) { x.domain(xd(t)); y.domain(yd(t)).range(yr(t)); return arc(d); };
     };
     }
     */
    // Interpolate the scales!
    function arcTween(d) {
        var my = maxY(d),
            xd = d3.interpolate(x.domain(), [d.x, d.x + d.dx]),
            yd = d3.interpolate(y.domain(), [d.y, my]),
            yr = d3.interpolate(y.range(), [d.y ? 100 : 0, radius]);
        return function (d) {
            return function (t) {
                x.domain(xd(t));
                y.domain(yd(t)).range(yr(t));
                return arc(d);
            };
        };
    }

    //Interpolate the arcs in data space.
    function arcTween2(a) {
        var i = d3.interpolate({x: a.x0, dx: a.dx0}, a);
        return function (t) {
            var b = i(t);
            a.x0 = b.x;
            a.dx0 = b.dx;
            return arc(b);
        };
    }

    function colour(d) {
        if (d.children) {
            // There is a maximum of two children!
            var colours = d.children.map(colour),
                a = d3.hsl(colours[0]),
                b = d3.hsl(colours[1]);
            // L*a*b* might be better here...
            return d3.hsl((a.h + b.h) / 2, a.s * 1.2, a.l / 1.2);
        }
        return d.colour || "#fff";
    }

    // http://www.w3.org/WAI/ER/WD-AERT/#color-contrast
    function brightness(rgb) {
        return rgb.r * .299 + rgb.g * .587 + rgb.b * .114;
    }

    function maxY(d) {
        return d.children ? Math.max.apply(Math, d.children.map(maxY)) : d.y + d.dy;
    }

    function isParentOf(p, c) {
        //console.log("is ", _.isEqual(p,c), p, c)
        //console.log("is ", p === c)
        if (p === c) return true;
        //if ($(p).equals($(c))) return true;
        //if (objectEquals(p,c)) return true;
        //if ( _.isEqual(p,c)) return true;
        if (p.children) {
            return p.children.some(function (d) {
                return isParentOf(d, c);
            });
        }
        return false;
    }

//    function updateColor() {
//          d3.json("/json/agent_list" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
//        //d3.json("../json_test/beatfish/agent_list.json" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
//            var agents = json_agents;
//
//            agents.agents.forEach(function (entry) {
//                agentsMap.set(entry.id, entry);
//            });
//
//            svg.selectAll(".agent")
//                .style("fill", function (d) {
//                    return (d.type == "agt") ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
//                });
//
//        });
//    }


    function objectEquals(x, y) {
        // if both are function
        if (x instanceof Function) {
            if (y instanceof Function) {
                return x.toString() === y.toString();
            }
            return false;
        }
        if (x === null || x === undefined || y === null || y === undefined) { return x === y; }
        if (x === y || x.valueOf() === y.valueOf()) { return true; }

        // if one of them is date, they must had equal valueOf
        if (x instanceof Date) { return false; }
        if (y instanceof Date) { return false; }

        // if they are not function or strictly equal, they both need to be Objects
        if (!(x instanceof Object)) { return false; }
        if (!(y instanceof Object)) { return false; }

        var p = Object.keys(x);
        return Object.keys(y).every(function (i) { return p.indexOf(i) !== -1; }) ?
            p.every(function (i) { return objectEquals(x[i], y[i]); }) : false;
    }

    setInterval(function () {
        //updateColor();
        updateSunburst();
        /// call your function here
    }, 20000);
}
