function renderSunbirst() {

    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height()-200;
    //var viewportHeight = screen.height-500;

    $(window).resize(function() {

        viewportWidth = $(window).width();
        viewportHeight = $(window).height()-200;
        //viewportHeight = screen.height-500;
        d3.select("#sunburst-chart-area")
            .style("height", viewportHeight+"px");

    });

    d3.select("#sunburst-chart-area")
        .style("height", viewportHeight+"px");

    var parseDate = d3.time.format("%Y-%m-%d");
    d3.select(".panel-title").text("Sunbirst-Layout: " + parseDate(new Date()));

// Dimensions of sunburst.
    var width = 800;
    var height = 800;
    var radius = Math.min(width, height) / 2;
    var agentsMap;
    var path;

    var x = d3.scale.linear()
        .range([0, 2 * Math.PI]);

    var y = d3.scale.sqrt()
        .range([0, radius]);

//var y = d3.scale.pow().exponent(0.5)
//.range([0, radius]);

// Breadcrumb dimensions: width, height, spacing, width of tip/tail.
    var b = {
        w: 75, h: 30, s: 3, t: 10
    };

// Mapping of step names to colors.
    var colors_bu = {
        "ok": "rgb(118,178,76)",
        "problem": "rgb(59,177,216)",
        "faulure": "rgb(255,193,0)",
        "critical": "rgb(255,138,135)",
        "error": "rgb(239,126,141)",
        "other": "rgb(118,178,76)"
    };

    var colors = d3.scale.category20c();

//var colors = ["#eff3ff","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"].reverse();

// Total size of all segments; we set this later, after loading the data.
    var totalSize = 0;
    /*
     var vis = d3.select("#chart").append("svg:svg")
     .attr("width", width)
     .attr("height", height)
     .append("svg:g")
     .attr("id", "container")
     .attr("transform", "translate(" + width / 2 + "," + height / 2 + ")");
     */

    var vis = d3.select("#sunburst-chart-area").append("svg:svg")
//.attr("class", "chart")
//.style("width", 100 + "%")
//.style("height", 100 + "%")
        .attr("viewBox", "-" + width / 2 + " " + "-" + height / 2 + " " + width + " " + height)
        .attr("preserveAspectRatio", "xMidYMid meet")
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .append("svg:g")
        .attr("id", "container");
//.attr("transform", "translate(" + width / 2 + "," + height / 2 + ")")


    var partition = d3.layout.partition()
        .children(function (d, depth) {
            return  d.elements
        })
        //.size([2 * Math.PI, radius * radius])
        .value(function (d) {
            return 1;
        });
    /*
     var arc = d3.svg.arc()
     .startAngle(function(d) { return d.x; })
     .endAngle(function(d) { return d.x + d.dx; })
     .innerRadius(function(d) { return Math.sqrt(d.y); })
     .outerRadius(function(d) { return Math.sqrt(d.y + d.dy); });
     */

    var arc = d3.svg.arc()
        .startAngle(function (d) {
            return Math.max(0, Math.min(2 * Math.PI, x(d.x)));
        })
        .endAngle(function (d) {
            return Math.max(0, Math.min(2 * Math.PI, x(d.x + d.dx)));
        })
        .innerRadius(function (d) {
            return Math.max(0, d.y ? y(d.y) : d.y);
        })
        .outerRadius(function (d) {
            return Math.max(0, y(d.y + d.dy));
        });

//d3.json("../json_test/agent_list", function(json_agents){
    d3.json("/json/agent_list", function (json_agents) {

        console.log(json_agents);
        var agents = json_agents;
        agentsMap = d3.map();
        agents.agents.forEach(function (entry) {

            agentsMap.set(entry.id, entry);

        });
// Use d3.text and d3.csv.parseRows so that we do not need to have a header
// row, and can receive the csv as an array of arrays.
        d3.json("/json/ngtree", function (json) {
            //var csv = d3.csv.parseRows(text);
            //var json = buildHierarchy(csv);
            //console.log(json);
            createVisualization(json);
        });
    });
// Main function to draw and set up the visualization, once we have the data.
    function createVisualization(json) {

        // Basic setup of page elements.
        initializeBreadcrumbTrail();
        drawLegend();
        //d3.select("#togglelegend").on("click", toggleLegend);

        // Bounding circle underneath the sunburst, to make it easier to detect
        // when the mouse leaves the parent g.
        vis.append("svg:circle")
            .attr("r", radius)
            .style("opacity", 0);

        //var root = json.elements[0];
        // For efficiency, filter nodes to keep only those large enough to see.
        var nodes = partition.nodes(json)
            .filter(function (d) {
                return (d.dx > 0.0005); // 0.005 radians = 0.29 degrees
            });

        path = vis.data([json]).selectAll("path")
            .data(nodes)
            .enter().append("svg:path")
            .attr("class", "sunpath")
            .attr("display", function (d) {
                return d.depth ? null : "none";
            })
            .attr("d", arc)
            .attr("fill-rule", "evenodd")
            .style("fill", function (d) {
                return d.obj ? treemap_color(agentsMap.get(d.link).sev_av) : colors(d.depth);
            })
            .style("opacity", 1)
            .on("mouseover", mouseover)
            .on("click", click)
            //.on("touchstart", mouseover)
            //.on("touchend", click)
            .each(stash);

        // Add the mouseleave handler to the bounding circle.
        d3.select("#container").on("mouseleave touchend touchmove", mouseleave);

        //Change size
        d3.selectAll(".input").on("change", function change() {
            var value = this.value === "count"
                ? function () {
                return 1;
            }
                : function (d) {
                return d.link ? agentsMap.get(d.link).ind_total : null;
            };

            path
                .data(partition.value(value).nodes)
                .transition()
                .duration(1500)
                .attrTween("d", arcTween2);
        });

        //Buttons Controll
        d3.select("#size").on("click", function () {
            path
                .data(partition.value(function (d) {
                    return d.link ? agentsMap.get(d.link).ind_total : null;
                }).nodes)
                .transition()
                .duration(1500)
                .attrTween("d", arcTween2);

            d3.select("#size").classed("active", true);
            d3.select("#count").classed("active", false);
        });

        d3.select("#count").on("click", function () {
            path
                .data(partition.value(function (d) {
                    return 1;
                }))
                .transition()
                .duration(1500)
                .attrTween("d", arcTween2);

            d3.select("#size").classed("active", false);
            d3.select("#count").classed("active", true);
        });

        // Get total size of the tree = value of root node from partition.
        totalSize = path.node().__data__.value;
    };

//Interpolate the arcs in data space.
    function arcTween2(a) {
        var i = d3.interpolate({x: a.x0, dx: a.dx0}, a);
        return function (t) {
            var b = i(t);
            a.x0 = b.x;
            a.dx0 = b.dx;
            return arc(b);
        };
    }

//Stash the old values for transition.
    function stash(d) {
        d.x0 = d.x;
        d.dx0 = d.dx;
    }

// Fade all but the current sequence, and show it in the breadcrumb trail.
    function mouseover(d) {

        //e.preventDefault();
        d3.event.preventDefault();

        var percentage = (100 * d.value / totalSize).toPrecision(3);
        var percentageString = percentage + "%";
        if (percentage < 0.1) {
            percentageString = "< 0.1%";
        }

        d3.select("#percentage")
            .text(percentageString);
        /*
         d3.select("#ind_total")
         .text(getIndTotal(d));

         d3.select("#ind_av")
         .text(getIndAv(d))
         .style("background",getSevAv(d));

         d3.select("#ind_kpi")
         .text(getIndKpi(d))
         .style("background", getSevKpi(d));

         d3.select("#ind_other")
         .text(getIndOther(d))
         .style("background", getSevOther(d));
         //.style("width", function(){console.log("i++",this)});
         */
//indications numbers info
        d3.select("#explanation").remove();

        if (d.type === "agt") {
            var temp_d = d, padding = 4;
            var g = vis.append("svg:g").attr("id", "explanation");
            //.attr("transform", function(d) { return "translate(" + 20 + "," + 0 + ")"; });

            g.append("svg:text")
                .attr("y", "-80")
                .attr("x", "-70")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("Indications Total");

            var text_total = g.append("svg:text")
                .attr("y", "-20")
                .attr("x", "-50")
                .attr("font-size", "40")
                .attr("fill", "#666")
                //.attr("class", "ind_total")
                .text(function (d) {
                    return getIndTotal(temp_d);
                });


            var rect_ind_av = g.append("svg:rect")
                .attr("rx", 5)
                .attr("ry", 5)
                .attr("class", function (d) {
                    return "ind_av";
                })
                .attr("fill", function (d) {
                    return getSevAv(temp_d);
                });
            //Label
            g.append("svg:text")
                .attr("y", "15")
                .attr("x", "-120")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("AV");

            var text_ind_av = g.append("svg:text")
                .attr("y", "60")
                .attr("x", "-130")
                .attr("font-size", "40")
                .text(function (d) {
                    return getIndAv(temp_d);
                })
            //.attr("fill", "#666");
            //.attr("class", function(d) { return d.obj ? "agent_text" : "name_text"; });

            var rect_ind_kpi = g.append("svg:rect")
                .attr("rx", 5)
                .attr("ry", 5)
                .attr("class", function (d) {
                    return "ind_av";
                })
                .attr("fill", function (d) {
                    return getSevKpi(temp_d);
                });


            //Label
            g.append("svg:text")
                .attr("y", "15")
                .attr("x", "-50")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("KPI");

            var text_ind_kpi = g.append("svg:text")
                .attr("y", "60")
                .attr("x", "-50")
                .attr("font-size", "40")
                .text(function (d) {
                    return getIndKpi(temp_d);
                });
            //.attr("class", function(d) { return d.obj ? "agent_text" : "name_text"; });

            var rect_ind_other = g.append("svg:rect")
                .attr("rx", 5)
                .attr("ry", 5)
                .attr("class", function (d) {
                    return "ind_av";
                })
                .attr("fill", function (d) {
                    return getSevOther(temp_d);
                });

            //Label
            g.append("svg:text")
                .attr("y", "15")
                .attr("x", "25")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("Other");

            var text_ind_other = g.append("svg:text")
                .attr("y", "60")
                .attr("x", "20")
                .attr("font-size", "40")
                .text(function (d) {
                    return getIndOther(temp_d);
                });
            //.attr("class", function(d) { return d.obj ? "agent_text" : "name_text"; });

            adjustRect(text_ind_av, rect_ind_av);
            adjustRect(text_ind_kpi, rect_ind_kpi);
            adjustRect(text_ind_other, rect_ind_other);

        } else {


            var sum_ind_total = 0, sum_ind_av = 0, sum_ind_kpi = 0, sum_ind_other = 0;

            sumOfChild(d);

            function sumOfChild(d) {

                if (d.elements) {
                    d.elements.forEach(function (i) {
                        sumOfChild(i);
                    });
                } else if (d.type == "agt" && agentsMap.get(d.link)) {
                    sum_ind_total += agentsMap.get(d.link).ind_total;
                    sum_ind_av += agentsMap.get(d.link).ind_av;
                    sum_ind_kpi += agentsMap.get(d.link).ind_kpi;
                    sum_ind_other += agentsMap.get(d.link).ind_other;
                }

                return 0;

            }

            var temp_d = d, padding = 4;
            var g = vis.append("svg:g").attr("id", "explanation");
            //.attr("transform", function(d) { return "translate(" + 20 + "," + 0 + ")"; });

            g.append("svg:text")
                .attr("y", "-120")
                .attr("x", "-70")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("Indications Total");

            var text_total = g.append("svg:text")
                .attr("y", "-70")
                .attr("x", "-50")
                .attr("font-size", "45")
                .attr("fill", "#666")
                //.attr("class", "ind_total")
                .text(function (d) {
                    return sum_ind_total
                });


            var rect_ind_av = g.append("svg:rect")
                .attr("rx", 5)
                .attr("ry", 5)
                .attr("class", function (d) {
                    return "ind_av";
                })
                .attr("fill", "#e5e5e5");
            //Label
            g.append("svg:text")
                //.attr("lengthAdjust", "spacingAndGlyphs")
                .attr("y", "-50")
                .attr("x", "-30")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("AV");

            var text_ind_av = g.append("svg:text")
                .attr("y", "0")
                .attr("x", "-50")
                .attr("font-size", "45")
                .text(function (d) {
                    return sum_ind_av;
                })
            //.attr("fill", "#666");
            //.attr("class", function(d) { return d.obj ? "agent_text" : "name_text"; });

            var rect_ind_kpi = g.append("svg:rect")
                .attr("rx", 5)
                .attr("ry", 5)
                .attr("class", function (d) {
                    return "ind_av";
                })
                .attr("fill", "#e5e5e5");


            //Label
            g.append("svg:text")
                .attr("y", "110")
                .attr("x", "-30")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("KPI");

            var text_ind_kpi = g.append("svg:text")
                .attr("y", "155")
                .attr("x", "-50")
                .attr("font-size", "45")
                .text(function (d) {
                    return sum_ind_kpi;
                });
            //.attr("class", function(d) { return d.obj ? "agent_text" : "name_text"; });

            var rect_ind_other = g.append("svg:rect")
                .attr("rx", 5)
                .attr("ry", 5)
                .attr("class", function (d) {
                    return "ind_av";
                })
                .attr("fill", "#e5e5e5");

            //Label
            g.append("svg:text")
                .attr("y", "30")
                .attr("x", "-30")
                .attr("font-size", "16")
                //.attr("class", "ind_total")
                .text("Other");

            var text_ind_other = g.append("svg:text")
                .attr("y", "80")
                .attr("x", "-50")
                .attr("font-size", "45")
                .text(function (d) {
                    return sum_ind_other;
                });
            //.attr("class", function(d) { return d.obj ? "agent_text" : "name_text"; });

            adjustRect(text_ind_av, rect_ind_av);
            adjustRect(text_ind_kpi, rect_ind_kpi);
            adjustRect(text_ind_other, rect_ind_other);


        }
        function adjustRect(text, rect) {
            var bbox = text.node().getBBox();
            rect.attr("x", bbox.x - padding)
            rect.attr("y", bbox.y - padding)
            rect.attr("width", bbox.width + 2 * padding)
            rect.attr("height", bbox.height + 2 * padding)
        }


        function getSevAv(d) {
            return d.obj ? treemap_color(agentsMap.get(d.link).sev_av) : ""
        }

        function getSevKpi(d) {
            return d.obj ? treemap_color(agentsMap.get(d.link).sev_kpi) : ""
        }

        function getSevOther(d) {
            return d.obj ? treemap_color(agentsMap.get(d.link).sev_other) : ""
        }

        function getIndAv(d) {
            return d.obj ? agentsMap.get(d.link).ind_av : ""
        };
        function getIndKpi(d) {
            return d.obj ? agentsMap.get(d.link).ind_kpi : ""
        };
        function getIndOther(d) {
            return d.obj ? agentsMap.get(d.link).ind_other : ""
        };
        function getIndTotal(d) {
            return d.obj ? agentsMap.get(d.link).ind_total : ""
        };
        /*
         if(d.type === "agt"){
         d3.select("#explanation")
         .style("visibility", "");
         //d3.select("#indText")
         //.style("visibility", "");
         }else{
         d3.select("#explanation")
         .style("visibility", "hidden");
         }
         */
        var sequenceArray = getAncestors(d);
        updateBreadcrumbs(sequenceArray, percentageString);

        // Fade all the segments.
        d3.selectAll("path")
            .style("opacity", 0.3);

        // Then highlight only those that are an ancestor of the current segment.
        vis.selectAll("path")
            .filter(function (node) {
                return (sequenceArray.indexOf(node) >= 0);
            })
            .style("opacity", 1);
    }

// Restore everything to full opacity when moving off the visualization.
    function mouseleave(d) {

        // Hide the breadcrumb trail
        d3.select("#trail")
            .style("visibility", "hidden");

        // Deactivate all segments during transition.
        d3.selectAll("path").on("mouseover", null);

        // Transition each segment to full opacity and then reactivate it.
        d3.selectAll("path")
            .transition()
            .duration(1000)
            .style("opacity", 1)
            .each("end", function () {
                d3.select(this).on("mouseover", mouseover);
            });
        /*
         d3.select("#explanation")
         .transition()
         .duration(1000)
         .style("visibility", "hidden");
         */
        d3.select("#explanation").remove();
        //.transition()
        //.duration(1000)
    }

// Given a node in a partition layout, return an array of all of its ancestor
// nodes, highest first, but excluding the root.
    function getAncestors(node) {
        var path = [];
        var current = node;
        while (current.parent) {
            path.unshift(current);
            current = current.parent;
        }
        return path;
    }

    function initializeBreadcrumbTrail() {
        // Add the svg area.
        var trail = d3.select("#sequence").append("svg:svg")
            .attr("viewBox", "-" + 0 + " " + "-" + 0 + " " + width + " " + 50)
            .attr("preserveAspectRatio", "xMidYMid meet")
//      .attr({
//        "width": "100%",
//        "height": "100%"    
//      })
            //.attr("width", width)
            //.attr("height", 50)
            .attr("id", "trail");
        // Add the label at the end, for the percentage.
        trail.append("svg:text")
            .attr("id", "endlabel")
            .style("fill", "#000");
    }

// Generate a string that describes the points of a breadcrumb polygon.
    function breadcrumbPoints(d, i) {
        var points = [];
        points.push("0,0");
        points.push(b.w + ",0");
        points.push(b.w + b.t + "," + (b.h / 2));
        points.push(b.w + "," + b.h);
        points.push("0," + b.h);
        if (i > 0) { // Leftmost breadcrumb; don't include 6th vertex.
            points.push(b.t + "," + (b.h / 2));
        }
        return points.join(" ");
    }

// Update the breadcrumb trail to show the current sequence and percentage.
    function updateBreadcrumbs(nodeArray, percentageString) {

        // Data join; key function combines name and depth (= position in sequence).
        var g = d3.select("#trail")
            .selectAll("g")
            .data(nodeArray, function (d) {
                return d.name + d.depth;
            });

        // Add breadcrumb and label for entering nodes.
        var entering = g.enter().append("svg:g");

        entering.append("svg:polygon")
            .attr("points", breadcrumbPoints)
            .style("fill", function (d) {
                return d.obj ? treemap_color(agentsMap.get(d.link).sev_av) : colors(d.depth);
            });

        entering.append("svg:text")
            .attr("x", (b.w + b.t) / 2)
            .attr("y", b.h / 2)
            .attr("dy", "0.35em")
            .attr("text-anchor", "middle")
            .text(function (d) {
                return d.depth ? (d.obj ? agentsMap.get(d.link).host.match(/.{1,8}/g)[0] : d.name.match(/.{1,8}/g)[0]) : "";
            });

        // Set position for entering and updating nodes.
        g.attr("transform", function (d, i) {
            return "translate(" + i * (b.w + b.s) + ", 0)";
        });

        // Remove exiting nodes.
        g.exit().remove();

        // Now move and update the percentage at the end.
        /*
         d3.select("#trail").select("#endlabel")
         .attr("x", (nodeArray.length + 0.5) * (b.w + b.s))
         .attr("y", b.h / 2)
         .attr("dy", "0.35em")
         .attr("text-anchor", "middle")
         .text(percentageString);*/

        // Make the breadcrumb trail visible, if it's hidden.
        d3.select("#trail")
            .style("visibility", "");

    }

    function drawLegend() {

        // Dimensions of legend item: width, height, spacing, radius of rounded rect.
        var li = {
            w: 75, h: 30, s: 3, r: 3
        };

        var legend = d3.select("#legend").append("svg:svg")
            .attr("width", li.w)
            .attr("height", d3.keys(colors).length * (li.h + li.s));

        var g = legend.selectAll("g")
            .data(d3.entries(colors_bu))
            .enter().append("svg:g")
            .attr("transform", function (d, i) {
                return "translate(0," + i * (li.h + li.s) + ")";
            });

        g.append("svg:rect")
            .attr("rx", li.r)
            .attr("ry", li.r)
            .attr("width", li.w)
            .attr("height", li.h)
            .style("fill", function (d) {
                return d.value;
            });

        g.append("svg:text")
            .attr("x", li.w / 2)
            .attr("y", li.h / 2)
            .attr("dy", "0.35em")
            .attr("text-anchor", "middle")
            .text(function (d) {
                return d.key;
            });
    }

    function toggleLegend() {
        var legend = d3.select("#legend");
        if (legend.style("visibility") == "hidden") {
            legend.style("visibility", "");
        } else {
            legend.style("visibility", "hidden");
        }
    }

    /*
     function treemap_color(severity) {
     if (severity < 2){
     return "rgb(118,178,76)";
     }
     if (severity == 2) {
     return "rgb(59,177,216)";
     } else if (severity == 3) {
     return "rgb(255,193,0)";
     } else if (severity == 4) {
     return "rgb(255,138,135)";
     } else if (severity == 5) {
     return "#d9534f";
     }
     return "rgb(118,178,76)";
     }
     */
    function click(d) {
        if(d.type ==  "agt"){
            window.open("indications.html?agent=" + d.link, "_self");
            return;
        }
        path.transition()
            .duration(750)
            .attrTween("d", arcTween(d));

        /*
         // Somewhat of a hack as we rely on arcTween updating the scales.
         text.style("visibility", function(e) {
         return isParentOf(d, e) ? null : d3.select(this).style("visibility");
         })
         .transition()
         .duration(duration)
         .attrTween("text-anchor", function(d) {
         return function() {
         return x(d.x + d.dx / 2) > Math.PI ? "end" : "start";
         };
         })
         .attrTween("transform", function(d) {
         var multiline = (d.name || "").split(" ").length > 1;
         return function() {
         var angle = x(d.x + d.dx / 2) * 180 / Math.PI - 90,
         rotate = angle + (multiline ? -.5 : 0);
         return "rotate(" + rotate + ")translate(" + (y(d.y) + padding) + ")rotate(" + (angle > 90 ? -180 : 0) + ")";
         };
         })
         .style("fill-opacity", function(e) { return isParentOf(d, e) ? 1 : 1e-6; })
         .each("end", function(e) {
         d3.select(this).style("visibility", isParentOf(d, e) ? null : "hidden");
         });
         */
    }

    /*
     //Interpolate the scales!
     function arcTween(d) {
     var xd = d3.interpolate(x.domain(), [d.x, d.x + d.dx]),
     yd = d3.interpolate(y.domain(), [d.y, 1]),
     yr = d3.interpolate(y.range(), [d.y ? 20 : 0, radius]);
     return function(d, i) {
     return i
     ? function(t) { return arc(d); }
     : function(t) { x.domain(xd(t)); y.domain(yd(t)).range(yr(t)); return arc(d); };
     };
     }
     */
//Interpolate the scales!
    function arcTween(d) {
        var my = maxY(d),
            xd = d3.interpolate(x.domain(), [d.x, d.x + d.dx]),
            yd = d3.interpolate(y.domain(), [d.y, my]),
            yr = d3.interpolate(y.range(), [d.y ? 150 : 20, radius]);

        return function (d) {
            return function (t) {
                x.domain(xd(t));
                /*y.domain(yd(t)).range(yr(t));*/
                return arc(d);
            };
        };
    }

    function maxY(d) {
        return d.children ? Math.max.apply(Math, d.children.map(maxY)) : d.y + d.dy;
    }

    function updateColor() {
        //    d3.json("/json/agent_list" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
        d3.json("../json_test/beatfish/agent_list.json" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
            var agents = json_agents;

            agents.agents.forEach(function (entry) {
                agentsMap.set(entry.id, entry);
            });

            svg.selectAll("g.cell").select("rect")
                .style("fill", function (d) {
                    return (d.type == "agt") ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
                });

        });
    }

    setInterval(function () {
        console.log("timer");
        //updateColor();
        //updateTreemap();
        /// call your function here
    }, 5000);
}

