function renderTreemap() {


    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height();

    $(window).resize(function () {

        viewportWidth = $(window).width();
        viewportHeight = $(window).height();
        d3.select("#treemap-chart-area")
            .style("height", viewportHeight - (viewportHeight * 0.25) + "px");

    });

    d3.select("#treemap-chart-area")
        .style("height", viewportHeight - (viewportHeight * 0.25) + "px");

    var parseDate = d3.time.format("%d-%m-%Y");
    d3.select(".panel-title").text("Tree-Map-Layout: " + parseDate(new Date()));

    updateTreemap();

    setInterval(function () {
        //updateTreemapColor();
        updateTreemap();
        /// call your function here
    }, 20000);

    //d3.timer(paintTreemap, 5000);

    var w = viewportWidth,
        h = viewportHeight,
        x = d3.scale.linear().range([0, w]),
        y = d3.scale.linear().range([0, h]),
        color = d3.scale.category20c(),
        root,
        node,
        agentsMap,
        svg,
        selectValue,
        zoomNode,
        treeChanged = {};

    var treemap = d3.layout.treemap()
        .round(false)
        .size([w, h])
        .sticky(false)
        //.mode("squarify")
        .children(function (d, depth) {
            return d.elements;
        })
        //.value(function(d) { return d.obj ? 1 : 0; /* size of square */ });
        .value(function (d) {
            if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d)
        });

    svg = d3.select("#treemap-chart-area")
        .append("div")
        .append("svg:svg")
        //        .attr("width", w)
        //        .attr("height", h)
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .attr("viewBox", "0 0 " + w + " " + h)
        .attr("preserveAspectRatio", "xMidYMid meet")
        .attr("transform", "translate(.5,.5)");

    function updateTreemapColor() {
        d3.json("/json/agent_list" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
            var agents = json_agents;
            agents.agents.forEach(function (entry) {
                agentsMap.set(entry.id, entry);
            });
            svg.selectAll("g.cell").select("rect")
                .style("fill", function (d) {
                    return (d.type == "agt" && agentsMap.get(d.link)) ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
                });

            treemap.value(function (d) {
                if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d)
            }).nodes(root);
            zoom(node);
        });

    }

    function updateTreemap() {

        d3.json("/json/agent_list" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
            var agents = json_agents;

            agentsMap = d3.map();

            agents.agents.forEach(function (entry) {
                agentsMap.set(entry.id, entry);
            });

            d3.json("/json/ngtree" + '?' + Math.floor(Math.random() * 1000), function (json) {

                //Check if ngtree data changed on server
                if (treeChanged.MD5 != json.attributes[0].MD5) {
                    treeChanged.changed = true;
                } else {
                    treeChanged.changed = false;
                }
                treeChanged.MD5 = json.attributes[0].MD5;

                node = root = json;

                var nodes = treemap.nodes(root).filter(function (d) {
                    return !d.children;
                });

                //treemap.sticky(true);


                var timer;
                var cell = svg.selectAll("g")
                    .data(nodes, function (d) {
                        if (d.type == "agt") return d.parent.name + d.link;
                    });
                //                    .on("click", function (d) {
                //                        return zoom(zoomNode == d.parent ? root : d.parent);
                //                    });

                var entering = cell.enter().append("svg:g")
                    .attr("class", "cell")
                    .attr("transform", function (d) {
                        return "translate(" + d.x + "," + d.y + ")";
                    })
                    .on("dblclick", function (d) {
                        if (d.type == "agt") {
                            if (timer) clearTimeout(timer);
                            timer = setTimeout(function () {
                                window.open("indications.html?agent=" + d.link + "&label=" + agentsMap.get(d.link).label, "_self")
                                return;
                            }, 250);
                            //window.open("indications.html?agent=" + d.link, "_self");
                            return;
                        }
                    })
                    .on("click", function (d) {
                        clearTimeout(timer);
                        if (zoomNode) return zoom(zoomNode.oid == d.parent.oid ? root : d.parent);
                        //return zoom(zoomNode ? zoomNode.parent : root)
                    });

                entering.append("svg:rect")
                    .attr("width", function (d) {
                        return d.dx;
                    })
                    .attr("height", function (d) {
                        return d.dy;
                    })
                    //.style("fill", function(d) { return color(d.parent.name); })
                    .style("fill", function (d) {
                        return (d.type == "agt" && agentsMap.get(d.link)) ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
                    })
                    .style("cursor", "pointer")
                    .on("mouseover", function (d) {

                        if (!(d.type == "agt")) return;

                        var tip = d3.select("#tooltipPartition");

                        tip.select("#value")
                            .text(fillListTreemap(d, agentsMap));


                        var mousex = d3.event.pageX - 20; //Get X coodrinates
                        var mousey = d3.event.pageY - 20; //Get Y coordinates

                        var tipWidth = $(tip.node()).width(); //Find width of tooltip
                        var tipHeight = $(tip.node()).height(); //Find height of tooltip

                        //Distance of element from the right edge of viewport
                        var tipVisX = $(window).width() - (mousex + tipWidth);
                        //Distance of element from the bottom of viewport
                        var tipVisY = $(window).height() - (mousey + tipHeight);

                        if (tipVisX < 20) { //If tooltip exceeds the X coordinate of viewport

                            if (tipWidth > d3.event.pageX - 20) {
                                mousex = 0;
                            } else {
                                mousex = d3.event.pageX - tipWidth - 20;
                            }

                        }
                        if (tipVisY < 20) { //If tooltip exceeds the Y coordinate of viewport
                            mousey = d3.event.pageY - tipHeight - 20;
                        }



                        //Absolute position the tooltip according to mouse position
                        //                        tip.css({  top: mousey, left: mousex });

                        tip.style("left", mousex + "px")
                            .style("top", mousey + "px");


                        //Show the tooltip
                        tip.transition()
                            .duration(200)
                            .delay(100)
                            .style("opacity", .9);
                    })
                    .on("mouseout", function () {
                        //clearInterval(timerXY);
                        var tip = d3.select("#tooltipPartition");

                        tip.transition()
                            .duration(2)
                            .style("opacity", 0);
                    });

                entering.append("svg:text")
                    //                .attr("x", function (d) {
                    //                    return d.dx / 2;
                    //                })
                    .attr("y", function (d) {
                        return d.dy / 2;
                    })
                    .attr("dy", ".35em")
                    .attr("text-anchor", "middle")
                    //                .text(function (d) {
                    //                    return !d.obj ? null : d.parent.name + " : " + agentsMap.get(d.link).host;
                    //                })
                    //                .style("opacity", function (d) {
                    //                    d.w = this.getComputedTextLength();
                    //                    return d.dx > d.w ? 1 : 0;
                    //                })
                    //.style("opacity", function(d) { return d.r > (d.app.length+d.grp.length)*2 ? 1 : 0; })
                    .each(function (d, i) {
                        var nm = !(d.type == "agt" && agentsMap.get(d.link)) ? "" : /*d.parent.name + " / " +*/ agentsMap.get(d.link).label;
                        var arr = nm.replace(/[\(\)\\/]/g, " ").replace(/\s+/g, " ").split(" "),
                            arrlength = (arr.length > 7) ? 8 : arr.length;
                        //d3.select(this).attr('y',"-" + (arrlength/2) + "em");
                        d.arrLength = arrlength;
                        d.textArr = arr;
                        //opacity test string
                        //                    arr[0] = "fsklfaskljflkajslkdöfjklasdjklfajslkfklsadlfaslksdfafasdfasfasdfasfafhgfhfhgjf dfghfhdfhdgfh";
                        //                    arr[1] = "22fsklfaskljflkajslkdöfjklasdjklfajslkfkls sdfsf bbbfdg";

                        //d3.select(this).attr("transform", function(d) { return "translate(" + 0 + "," + "-" + (arrlength/2) + "em"  + ")"; });
                        //.attr('y',"-" + (arrlength/2) + "em");

                        d3.select(this).attr("transform", function (d) {
                            return "translate(" + 0 + "," + "-" + arrlength * 6 + ")";
                        });
                        //if text is over 7 words then ellipse the 8th
                        for (var n = 0; n < arrlength; n++) {
                            if (arr[n].length > d.dx / 5) {
                                arr[n] = arr[n].substring(0, d.dx / 5) + " ...";
                            }
                            var tsp = d3.select(this)
                                .append('tspan')
                                .attr("x", function (d) {
                                    return (d.dx) / 2;
                                })
                                .attr("dy", "1em");
                            //.attr("data-classname", nm);
                            //.on("dblclick",clickOnCircleFunc);
                            if (n === 7) {
                                tsp.text("...");
                            } else {
                                tsp.text(arr[n])
                            }
                        }
                    })
                    //                .style("opacity", function (d) {
                    //                    //test string lenght opacity
                    ////                    var arr=[];
                    ////                    arr[0] = "fsklfaskljflkajslkdöfjklasdjklfajslkfklsadlfaslksdfafasdfasfasdfasfafhgfhfhgjf dfghfhdfhdgfh";
                    ////                    arr[1] = "22fsklfaskljflkajslkdöfjklasdjklfajslkfkls";
                    //
                    //                    //d.w = this.getComputedTextLength();
                    //
                    //                    d.w = d.parent.name.length * 7;
                    //                    d.w2 = (d.type == "agt") ? agentsMap.get(d.link).host.length * 7: 0;
                    //                    return d.dx > (d.w && d.w2) ? 1 : 0;
                    //                })
                    .style("opacity", function (d) {

                        return d.dx > 30 ? 1 : 0;
                    })
                    .style("font-size", "10px");




                //                cell.select("text")
                //                    .attr("y", function (d) {
                //                        return d.dy / 2;
                //                    });
                //                    .attr("dy", ".35em")
                //                    .attr("text-anchor", "middle")

                //                cell.select("tspan")
                //                    .attr("x", function (d) {
                //                        return ( d.dx) / 2;
                //                    })
                //                    .attr("dy", "1em");

                cell.select("rect")
                    //                .attr("width", function (d) {
                    //                    return d.dx;
                    //                })
                    //                .attr("height", function (d) {
                    //                    return d.dy;
                    //                })
                    .style("fill", function (d) {
                        return (d.type == "agt" && agentsMap.get(d.link)) ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
                    });

                //exiting leavs without data
                var ex = cell.exit(); //.remove();
                ex.remove();

                d3.select(window).on("click", function () {
                    zoom(root);
                });

                d3.select("select").on("change", function () {
                    selectValue = this.value;
                    treemap.value(function (d) {
                            if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d)
                        })
                        .nodes(root);

                    cell.select("tspan")
                        .attr("x", function (d) {
                            return (d.dx) / 2;
                        })
                        .attr("dy", "1em");

                    zoom(node);
                });

                //Buttons Controll
                d3.select("#size").on("click", function () {
                    selectValue = this.value;
                    treemap.value(function (d) {
                            if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d);
                        })
                        .nodes(root);

                    cell.select("tspan")
                        .attr("x", function (d) {
                            return (d.dx) / 2;
                        })
                        .attr("dy", "1em");

                    zoom(node);

                    d3.select("#size").classed("active", true);
                    d3.select("#count").classed("active", false);
                });

                d3.select("#count").on("click", function () {
                    selectValue = this.value;
                    treemap.value(function (d) {
                            if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d);
                        })
                        .nodes(root);

                    cell.select("tspan")
                        .attr("x", function (d) {
                            return (d.dx) / 2;
                        })
                        .attr("dy", "1em");

                    zoom(node);

                    d3.select("#size").classed("active", false);
                    d3.select("#count").classed("active", true);
                });

                //new layout if new agents added or deleted
                //zoom(node);
                //zoom(node == zoomNode.parent ? root : zoomNode);

                //if(treeChanged.changed) zoom(zoomNode ? zoomNode.parent : root);
                if (treeChanged.changed) {
                    cell.select("tspan")
                        .attr("x", function (d) {
                            return (d.dx) / 2;
                        })
                        .attr("dy", "1em");

                    zoom(zoomNode ? zoomNode : root);
                }

            });
        });

    }

    function switchTreeMap(value, d) {
        switch (value) {
            case "sev_total":
                return agentsMap.get(d.link) ? agentsMap.get(d.link).sev_total : 1;
                break;
            case "sev_av":
                return agentsMap.get(d.link) ? agentsMap.get(d.link).sev_av : 1;
                break;
            case "sev_kpi":
                return agentsMap.get(d.link) ? agentsMap.get(d.link).sev_kpi : 1;
                break;
            case "sev_other":
                return agentsMap.get(d.link) ? agentsMap.get(d.link).sev_other : 1;
                break;
            case "ind_total":
                return agentsMap.get(d.link) ? agentsMap.get(d.link).ind_total : 1;
                break;
            default:
                return 1;
                break;
        }

    }

    function zoom(d) {
        var kx = w / d.dx,
            ky = h / d.dy;
        x.domain([d.x, d.x + d.dx]);
        y.domain([d.y, d.y + d.dy]);

        var t = svg.selectAll("g.cell").transition()
            .duration(750)
            .attr("transform", function (d) {
                return "translate(" + x(d.x) + "," + y(d.y) + ")";
            });

        //        var t2 = svg.selectAll("g.cell").transition()
        //            .duration(0)
        //            .attr("transform", function (d) {
        //                return "translate(" + x(d.x) + "," + y(d.y) + ")";
        //            });

        t.select("rect")
            .attr("width", function (d) {
                return kx * d.dx - 1;
            })
            .attr("height", function (d) {
                return ky * d.dy - 1;
            });

        t.select("text")
            //            .attr("y", function (d) {
            //                return d.dy / 2;
            //            })
            //            .style("opacity", function (d) {
            //                return kx * d.dx > (d.w && d.w2) && ky * d.dy > 20  ? 1 : 0;
            //            });
            .style("opacity", function (d) {

                //                if(kx * d.dx > 30){
                //                     return 1;
                //                }else if(ky * d.dy > 30){
                //                    return 1;
                //                }else{
                //                    return 0;
                //                }
                return kx * d.dx > 30 && ky * d.dy > 30 ? 1 : 0;
            });

        t.selectAll("tspan")
            //            .attr("transform", function (d) {
            //                return "translate(" + (kx * d.dx / 2) + "," + (ky * d.dy / 2 + i*12) + ")";
            //            })
            .attr("x", function (d) {
                return kx * d.dx / 2;
            })
            .attr("y", function (d, i) {
                return ky * d.dy / 2 + i * 12;
            })
            .attr("dy", "1em");
        //            .text(function(d, i) {
        //                var arr = d.textArr;
        //                for(var n = 0; n < d.arrlength; n++) {
        //                    if (arr[n].length > d.dx/5){
        //                        arr[n] = arr[n].substring(0, d.dx/5 )+" ...";
        //                    }
        //
        ////                    var tsp = d3.select(this)
        ////                        .append('tspan')
        ////                        .attr("x", function(d) { return ( d.dx)/2; })
        ////                        .attr("dy", "1em");
        ////                    //.attr("data-classname", nm);
        ////                    //.on("dblclick",clickOnCircleFunc);
        ////                    if(n === 7) {
        ////                        tsp.text("...");
        ////                    } else {
        ////                        tsp.text(arr[n])
        ////                    }
        //                }
        //                return "test";
        //            });
        //            .style("opacity", function (d) {
        //                return kx * d.dx > d.w  ? 1 : 0;
        //            });


        zoomNode = d;
        if (d3.event) d3.event.stopPropagation();
    }

}