function renderTreemap() {

//    var viewportWidth = d3.select(window).width();
//    var viewportHeight = d3.select(window).height();
//
//    d3.select(window).on('resize', resize);
//
//    resize = resize(function() {
//
//        viewportWidth = d3.select(window).width();
//        viewportHeight = d3.select(window).height();
//        d3.select("#treemap-chart-area")
//            .style("height", viewportHeight-100+"px");
//
//    });
//
//    d3.select("#treemap-chart-area")
//        .style("height", viewportHeight-100+"px");

    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height();

    $(window).resize(function() {

        viewportWidth = $(window).width();
        viewportHeight = $(window).height();
        d3.select("#treemap-chart-area")
            .style("height", viewportHeight-100+"px");

    });

    d3.select("#treemap-chart-area")
        .style("height", viewportHeight-100+"px");

    var parseDate = d3.time.format("%Y-%m-%d");
    d3.select(".panel-title").text("Tree-Map-Layout: " + parseDate(new Date()));

    updateTreemap();

    setInterval(function () {
        console.log("timer");
        updateTreemap();
        /// call your function here
    }, 5000);

    //d3.timer(paintTreemap, 5000);

    var w = 1280 - 80,
        h = 800 - 180,
        x = d3.scale.linear().range([0, w]),
        y = d3.scale.linear().range([0, h]),
        color = d3.scale.category20c(),
        root,
        node,
        agentsMap,
        svg,
        selectValue;

    var treemap = d3.layout.treemap()
        .round(false)
        .size([w, h])
        .sticky(true)
        //.mode("squarify")
        .children(function (d, depth) {
            return d.elements;
        })
        //.value(function(d) { return d.obj ? 1 : 0; /* size of square */ });
        .value(function (d) {
            if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d)
        });

    svg = d3.select("#treemap-chart-area")
        .append("div")
//                .attr("class", "chart")
        .style("width", 100 + "%")
        .style("height", 100 + "%")
        .append("svg:svg")
        //.attr("width", w)
        //.attr("height", h)
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .attr("viewBox", "0 0 " + w + " " + h)
        .attr("preserveAspectRatio", "xMidYMid meet")
        .attr("transform", "translate(.5,.5)");

    svg.append("defs").append("clipPath")
        .attr("id", "clip")
        .append("rect")
        .attr("width", w)
        .attr("height", h);

    function updateTreemap(){

//    d3.json("/json/agent_list" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
        d3.json("../json_test/beatfish/agent_list.json" + '?' + Math.floor(Math.random() * 1000), function(json_agents){

        var agents = json_agents;

        agentsMap = d3.map();

        agents.agents.forEach(function (entry) {
            agentsMap.set(entry.id, entry);
        });

//        d3.json("/json/ngtree" + '?' + Math.floor(Math.random() * 1000), function (json) {
            d3.json("../json_test/beatfish/ngtree.json" + "?" + Math.floor(Math.random() * 1000), function(json){

            node = root = json;

            var nodes = treemap.nodes(root).filter(function (d) {
                return !d.children;
            });

            treemap.sticky(true);

            //d3.select(".chart").remove();

            var timer;
            var cell = svg.selectAll("g")
                .data(nodes);

            var entering = cell.enter().append("svg:g")
                .attr("class", "cell")
                .attr("transform", function (d) {
                    return "translate(" + d.x + "," + d.y + ")";
                })
                .on("dblclick", function (d) {
                    if(d.type ==  "agt"){
                        if (timer) clearTimeout(timer);
                        timer = setTimeout(function() {
                            window.open("indications.html?agent=" + d.link, "_self")
                            return;
                        }, 250);
                        //window.open("indications.html?agent=" + d.link, "_self");
                        return;
                    }
                })
                .on("click", function (d) {
                    clearTimeout(timer);
                    return zoom(node == d.parent ? root : d.parent);
                });


            entering.append("svg:rect")
                .attr("width", function (d) {
                    return d.dx;
                })
                .attr("height", function (d) {
                    return d.dy;
                })
                //.style("fill", function(d) { return color(d.parent.name); })
                .style("fill", function (d) {
                    return d.obj ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
                })
                .on("mouseover", function (d) {

                    if (!(d.type == "agt")) return;
                    //highlight text
                    d3.select(this).classed("cell-hover", true);
                    d3.selectAll(".rowLabel").classed("text-highlight", function (r, ri) {
                        return ri == (d.row - 1);
                    });
                    d3.selectAll(".colLabel").classed("text-highlight", function (c, ci) {
                        return ci == (d.col - 1);
                    });

                    //Update the tooltip position and value
                    d3.select("#tooltipPartition")
                        .style("left", (d3.event.pageX - 200) + "px")
                        .style("top", (d3.event.pageY + 10) + "px")
                        .select("#value")
                        .text(fillList(d, agentsMap));
                    //Show the tooltip
                    d3.select("#tooltipPartition").classed("hidden", false);
                })
                .on("mouseout", function () {
                    d3.select(this).classed("cell-hover", false);
                    d3.selectAll(".rowLabel").classed("text-highlight", false);
                    d3.selectAll(".colLabel").classed("text-highlight", false);
                    d3.select("#tooltipPartition").classed("hidden", true);
                });
            ;

            entering.append("svg:text")
//                .attr("x", function (d) {
//                    return d.dx / 2;
//                })
                .attr("y", function (d) {
                    return d.dy / 2;
                })
                .attr("dy", ".35em")
                .attr("text-anchor", "middle")
//                .text(function (d) {
//                    return !d.obj ? null : d.parent.name + " : " + agentsMap.get(d.link).host;
//                })
//                .style("opacity", function (d) {
//                    d.w = this.getComputedTextLength();
//                    return d.dx > d.w ? 1 : 0;
//                })
                //.style("opacity", function(d) { return d.r > (d.app.length+d.grp.length)*2 ? 1 : 0; })
                .each(function(d, i) {
                    var nm = !(d.type == "agt") ? "" : d.parent.name + " / " + agentsMap.get(d.link).host;
                    var arr = nm.replace(/[\(\)\\/]/g, " ").replace(/\s+/g, " ").split(" "),arrlength = (arr.length > 7) ? 8 : arr.length;
                    //d3.select(this).attr('y',"-" + (arrlength/2) + "em");
                    d.arrLength=  arrlength;
                    d.textArr = arr;
                    //opacity test string
//                    arr[0] = "fsklfaskljflkajslkdöfjklasdjklfajslkfklsadlfaslksdfafasdfasfasdfasfafhgfhfhgjf dfghfhdfhdgfh";
//                    arr[1] = "22fsklfaskljflkajslkdöfjklasdjklfajslkfkls sdfsf bbbfdg";

                    //d3.select(this).attr("transform", function(d) { return "translate(" + 0 + "," + "-" + (arrlength/2) + "em"  + ")"; });
                        //.attr('y',"-" + (arrlength/2) + "em");

                    d3.select(this).attr("transform", function(d) { return "translate(" + 0 + "," +"-"+ arrlength*6  + ")"; });
                    //if text is over 7 words then ellipse the 8th
                    for(var n = 0; n < arrlength; n++) {
                        if (arr[n].length > d.dx/5){
                            arr[n] = arr[n].substring(0, d.dx/5 )+" ...";
                        }
                        var tsp = d3.select(this)
                            .append('tspan')
                            .attr("x", function(d) { return ( d.dx)/2; })
                            .attr("dy", "1em");
                            //.attr("data-classname", nm);
                        //.on("dblclick",clickOnCircleFunc);
                        if(n === 7) {
                            tsp.text("...");
                        } else {
                            tsp.text(arr[n])
                        }
                    }
                })
//                .style("opacity", function (d) {
//                    //test string lenght opacity
////                    var arr=[];
////                    arr[0] = "fsklfaskljflkajslkdöfjklasdjklfajslkfklsadlfaslksdfafasdfasfasdfasfafhgfhfhgjf dfghfhdfhdgfh";
////                    arr[1] = "22fsklfaskljflkajslkdöfjklasdjklfajslkfkls";
//
//                    //d.w = this.getComputedTextLength();
//
//                    d.w = d.parent.name.length * 7;
//                    d.w2 = (d.type == "agt") ? agentsMap.get(d.link).host.length * 7: 0;
//                    return d.dx > (d.w && d.w2) ? 1 : 0;
//                })
                .style("opacity", function (d) {

                    return d.dx > 30 ? 1 : 0;
                })
                .style("font-size", "10px");

            //exiting leavs without data
            cell.exit().remove();

            cell.select("rect")
//                .attr("width", function (d) {
//                    return d.dx;
//                })
//                .attr("height", function (d) {
//                    return d.dy;
//                })
                .style("fill", function (d) {
                    return d.obj ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.name);
                });

            d3.select(window).on("click", function () {
                zoom(root);
            });

            d3.select("select").on("change", function () {
                selectValue = this.value;
                treemap.value(function (d) {
                    if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d)
                })
                    .nodes(root);
                zoom(node);
            });

            //Buttons Controll
            d3.select("#size").on("click", function () {
                selectValue = this.value;
                treemap.value(function (d) {
                    if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d);
                })
                    .nodes(root);
                zoom(node);

                d3.select("#size").classed("active", true);
                d3.select("#count").classed("active", false);
            });

            d3.select("#count").on("click", function () {
                selectValue = this.value;
                treemap.value(function (d) {
                    if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d);
                })
                    .nodes(root);
                zoom(node);

                d3.select("#size").classed("active", false);
                d3.select("#count").classed("active", true);
            });

        });
    });

    }

    function switchTreeMap(value, d) {
        switch (value) {
            case "sev_total":
                return agentsMap.get(d.link).sev_total;
                break;
            case "sev_av":
                return agentsMap.get(d.link).sev_av;
                break;
            case "sev_kpi":
                return agentsMap.get(d.link).sev_kpi;
                break;
            case "sev_other":
                return agentsMap.get(d.link).sev_other;
                break;
            case "ind_total":
                return agentsMap.get(d.link).ind_total;
                break;
            default:
                return 1;
                break;
        }

    }

    function zoom(d) {
        var kx = w / d.dx, ky = h / d.dy;
        x.domain([d.x, d.x + d.dx]);
        y.domain([d.y, d.y + d.dy]);

        var t = svg.selectAll("g.cell").transition()
            .duration(d3.event.altKey ? 7500 : 750)
            .attr("transform", function (d) {
                return "translate(" + x(d.x) + "," + y(d.y) + ")";
            });

        t.select("rect")
            .attr("width", function (d) {
                return kx * d.dx - 1;
            })
            .attr("height", function (d) {
                return ky * d.dy-1;
            });

        t.select("text")
//            .style("opacity", function (d) {
//                return kx * d.dx > (d.w && d.w2) && ky * d.dy > 20  ? 1 : 0;
//            });
            .style("opacity", function (d) {
                return kx * d.dx > 30  ? 1 : 0;
            });

        t.selectAll("tspan")
//            .attr("transform", function (d) {
//                return "translate(" + (kx * d.dx / 2) + "," + (ky * d.dy / 2 + i*12) + ")";
//            })
            .attr("x", function (d) {
                return kx * d.dx / 2;
            })
            .attr("y", function (d,i) {
                return ky * d.dy / 2 + i*12;
            })
            .attr("dy", "1em");
//            .text(function(d, i) {
//                var arr = d.textArr;
//                for(var n = 0; n < d.arrlength; n++) {
//                    if (arr[n].length > d.dx/5){
//                        arr[n] = arr[n].substring(0, d.dx/5 )+" ...";
//                    }
//
////                    var tsp = d3.select(this)
////                        .append('tspan')
////                        .attr("x", function(d) { return ( d.dx)/2; })
////                        .attr("dy", "1em");
////                    //.attr("data-classname", nm);
////                    //.on("dblclick",clickOnCircleFunc);
////                    if(n === 7) {
////                        tsp.text("...");
////                    } else {
////                        tsp.text(arr[n])
////                    }
//                }
//                return "test";
//            });
//            .style("opacity", function (d) {
//                return kx * d.dx > d.w  ? 1 : 0;
//            });


        node = d;
        d3.event.stopPropagation();
    }

};  
