function renderPartition() {

    var viewportWidth = $(window).width();
    var viewportHeight = $(window).height();

    $(window).resize(function () {

        viewportWidth = $(window).width();
        viewportHeight = $(window).height();
        d3.select("#partition-chart-area")
            .style("height", viewportHeight - (viewportHeight*0.25) + "px");

    });

    d3.select("#partition-chart-area")
        .style("height", viewportHeight - (viewportHeight*0.25) + "px");

    var parseDate = d3.time.format("%d-%m-%Y");
    d3.select(".panel-title").text("Partition-Layout: " + parseDate(new Date()));

//    setInterval(function () {
//        //paintPartition();
//        updatePartitionColor();
//
//    }, 2000);

    //d3.timer(paintPartition, 5000);

    var w = 1120,
        h = 600,
        x = d3.scale.linear().range([0, w]),
        y = d3.scale.linear().range([0, h]),
        agentsMap,
        nodeHight = 80,
        zoomNode,
        selectValue = "",
        root;

    var color = d3.scale.category20c();

    var vis = d3.select("#partition-chart-area").append("div")
        .attr("class", "chart")
        .style("width", 100 + "%")
        .style("height", 100 + "%")
        .append("svg:svg")
        //.attr("width", w)
        //.attr("height", h)
        .attr({
            "width": "100%",
            "height": "100%"
        })
        .attr("viewBox", "0 0 " + w + " " + h)
        .attr("preserveAspectRatio", "xMidYMid meet");

    var partition = d3.layout.partition()
        .children(function (d, depth) {
            return d.elements;
        })
        .value(function (d) {
            return (d.type == "agt") ? 1 : 0;
            /* size of square */
        });

    setInterval(function () {
        paintPartition();
//      updatePartitionColor();

    }, 5000);

    function paintPartition() {
        d3.json("/json/agent_list" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {

            var agents = json_agents;
            agentsMap = d3.map();
            agents.agents.forEach(function (entry) {

                agentsMap.set(entry.id, entry);

            });

            d3.json("/json/ngtree" + '?' + Math.floor(Math.random() * 1000), function (json) {

                root = json.elements[0];

                var g = vis.selectAll("g")
                    .data(partition.nodes(root), function (d) {
                        return (d.type == "agt") ? (d.parent.name + d.link) : d.oid;
                    })
                    .on("click", click);

                var entering = g.enter().append("svg:g")
                    .attr("transform", function (d) {
                        return "translate(" + x(d.y) + "," + y(d.x) + ")";
                    })
                    .on("click", click);

                var kx = w / root.dx,
                    ky = h;

                entering.append("svg:rect")
                    .attr("width", root.dy * kx)
                    .attr("height", function (d) {
                        return d.dx * ky;
                    })
                    .attr("fill", function (d) {
                        return (d.type == "agt" && agentsMap.get(d.link)) ? treemap_color(agentsMap.get(d.link).sev_max) : color(d.depth);
                    })
                    .attr("class", function (d) {
                        return d.children ? "parent" : "child";
                    })
                    .style("cursor", "pointer")
                    .on("mouseover", function (d) {
                        if (d.type == "agt") {
                            mouseover(d);
                        } else {
                            mouseover(d);
                        }
                    })
                    .on("mouseout", function () {
                        mouseout();
                    });

                entering.append("svg:text")
                    .attr("transform", function (d) {
                        return (d.type == "agt") ? null : transform(d);
                    })
                    .attr("x", function (d) {
                        return (d.type == "agt") ? 15 : null;
                    })
                    .attr("y", function (d) {
                        return (d.type == "agt") ? 12 : null;
                    })
                    .attr("dy", ".35em")
                    .style("opacity", function (d) {
                        return d.dx * ky > 12 ? 1 : 0;
                    })
                    .text(function (d) {
                        return (d.type == "agt") ? agentsMap.get(d.link).label + " (" + agentsMap.get(d.link).ind_total + ") " : d.name;
                    })
                    .attr("class", function (d) {
                        return (d.type == "agt") ? "agent_text" : "name_text";
                    });

                g.exit().remove();

                // Update color
                var rec = vis.selectAll("g")
                    .data(partition.nodes(root), function (d) {
                        return (d.type == "agt") ? (d.parent.name + d.link) : d.oid;
                    })
                    .selectAll(".child")
                    .attr("fill", function (d) {
                        return (d.type == "agt") ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.depth);
                    });

                //arrange partition with new item
                //click(root);
                click(zoomNode ? zoomNode : root);

                d3.select(window)
                    .on("click", function () {
                        click(root);
                    });

                d3.select("select").on("change", function () {
                    var selectValue = this.value;
                    partition.value(function (d) {
                        if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d);
                    }).nodes(root);
                    //click(root);
                });

                //Buttons Controll
                d3.select("#size").on("click", function () {
                    selectValue = this.value;
                    partition.value(function (d) {
                        if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d);
                    }).nodes(root);
                    //click(root);

                    d3.select("#size").classed("active", true);
                    d3.select("#count").classed("active", false);
                });

                d3.select("#count").on("click", function () {
                    selectValue = this.value;
                    partition.value(function (d) {
                        if (typeof d.link != 'undefined') return 1;
                    }).nodes(root);
                    //click(root);

                    d3.select("#size").classed("active", false);
                    d3.select("#count").classed("active", true);
                });

                function mouseover(d) {

                    var tip = d3.select("#tooltipPartition");

                    tip.select("#value")
                        .text(fillList(d, agentsMap));

                    var mousex = d3.event.pageX - 20; //Get X coodrinates
                    var mousey = d3.event.pageY - 20; //Get Y coordinates

                    var tipWidth = $(tip.node()).width(); //Find width of tooltip
                    var tipHeight = $(tip.node()).height(); //Find height of tooltip

                    //Distance of element from the right edge of viewport
                    var tipVisX = $(window).width() - (mousex + tipWidth);
                    //Distance of element from the bottom of viewport
                    var tipVisY = $(window).height() - (mousey + tipHeight);

                    if (tipVisX < 20) { //If tooltip exceeds the X coordinate of viewport

                        if (tipWidth > d3.event.pageX - 20) {
                            mousex = 0;
                        } else {
                            mousex = d3.event.pageX - tipWidth - 20;
                        }

                    }
                    if (tipVisY < 20) { //If tooltip exceeds the Y coordinate of viewport
                        mousey = d3.event.pageY - tipHeight - 20;
                    }
                    tip.style("left", mousex + "px")
                        .style("top", mousey + "px");

                    //Show the tooltip
                    tip.transition()
                        .duration(200)
                        .delay(100)
                        .style("opacity", .9);

                }

                function mouseout() {

                    var tip = d3.select("#tooltipPartition");

                    tip.transition()
                        .duration(2)
                        .style("opacity", 0);
                }

                function switchTreeMap(value, d) {

                    switch (value) {
                        case "sev_total":
                            return agentsMap.get(d.link).sev_total;
                            break;
                        case "sev_av":
                            return agentsMap.get(d.link).sev_av;
                            break;
                        case "sev_kpi":
                            return agentsMap.get(d.link).sev_kpi;
                            break;
                        case "sev_other":
                            return agentsMap.get(d.link).sev_other;
                            break;
                        case "ind_total":
                            return agentsMap.get(d.link).ind_total;
                            break;
                        default:
                            return 1;
                            break;
                    }

                }


                function click(d) {
                    //Zoom controll of last elements e.g. agents
                    if (d.type == "agt") {
                        window.open("indications.html?agent=" + d.link + "&label=" + agentsMap.get(d.link).label, "_self");
                        return;
                    }

                    kx = (d.y ? w - 40 : w) / (1 - d.y);
                    ky = h / d.dx;
                    x.domain([d.y, 1]).range([d.y ? 40 : 0, w]);
                    y.domain([d.x, d.x + d.dx]);


                    //console.log("w:", w,"h: ", h, "d.y: ", d.y, "d.dx: ", d.dx, "kx: ", kx, "ky: ", ky);

                    var t = vis.selectAll("g").transition()
                        //.duration(d3.event.altKey ? 7500 : 750)
                        .duration(750)
                        .attr("transform", function (d) {
                            return "translate(" + x(d.y) + "," + y(d.x) + ")";
                        });

                    t.select("rect")
                        .attr("width", d.dy * kx)
                        .attr("height", function (d) {
                            return d.dx * ky;
                        });

                    t.select(".agent_text")
                        .style("opacity", function (d) {
                            return d.dx * ky > 12 ? 1 : 0;
                        });

                    t.select(".name_text")
                        .attr("transform", transform)
                        .style("opacity", function (d) {
                            return d.dx * ky > 12 ? 1 : 0;
                        });

                    zoomNode = d;

                    if (d3.event) d3.event.stopPropagation();
                }

                function transform(d) {
                    return "translate(8," + d.dx * ky / 2 + ")";
                }

//                function updatePartitionColor() {
//                    d3.json("/json/agent_list" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
//                        //d3.json("../json_test/beatfish/agent_list.json" + '?' + Math.floor(Math.random() * 1000), function (json_agents) {
//                        var agents = json_agents;
//
//                        agents.agents.forEach(function (entry) {
//                            agentsMap.set(entry.id, entry);
//                        });
//
//                        vis.selectAll("g").select("text").text(function (d) {
//                            return (d.type == "agt") ? agentsMap.get(d.link).label + " ("+agentsMap.get(d.link).ind_total+") " : d.name;
//                        });
//
//                        vis.selectAll("g").select("rect")
//                            .style("fill", function (d) {
//                                return (d.type == "agt") ? treemap_color(agentsMap.get(d.link).sev_av) : color(d.depth);
//                            });
//
//                        partition.value(function (d) {
//                            if (typeof d.link != 'undefined') return switchTreeMap(selectValue, d); //agentsMap.get(d.link).sev_av;
//                        }).nodes(root);
//
//                        click(zoomNode);
//
//                    });
//
//                }
//
//                setInterval(function () {
//                    paintPartition();
////                    updatePartitionColor();
//
//                }, 5000);


            });

        });
    }

    paintPartition();


}
