#!/bin/sh
######################################################################
#
#  Name: go.sh
#
#  Description: Determines additional inventory data
#  Change (2017-11-06) disabled detection of HW.CPUMHZ due to noisy inventory changes.
#
#  Version: 5.5
#  Date: 
#  Copyright: Worldline GmbH
#
######################################################################

#set -x
OSNAME=`uname`

SUNOS=`echo "${OSNAME}" | grep -c -i "SunOS"`
if [ $SUNOS -eq 1 ]; then
# SunOS section
        AWK=
        rc= 
        which awk 1>/dev/null 2>&1
        rc=$?
        if [ "$rc" = "1" ]; then
           AWK="awk"
        else
           AWK="nawk"
        fi
	MODEL=`uname -i`
	echo "HW.MODEL=${MODEL}"
#	SPEED=`psrinfo -v | grep -i "MHz" | head -1`
#	echo "HW.CPUMHZ=${SPEED}"
        rc=
        which swap 1>/dev/null 2>&1
        rc=$?
        if [ "$rc" = "0" ]; then
           SWAP=`swap -l | $AWK 'NR>1 { sum += $4 } END { print sum/2048 }'`
#	    SWAP=`df -kh swap | grep swap | awk '{print $2}'`
           echo "HW.SWAP=${SWAP} MB"
        fi
	MEM=`prtconf -vp | grep -i "Memory size" | awk -F':' '{print $2}'`
	echo "HW.MEM=${MEM}"
	DISKS=`iostat -n | head -1 | xargs | tr ' ' '\n' | grep c | grep d | grep t`    
	for DISK in $DISKS
  do
		MODEL=`iostat -En $DISK | grep Serial`
		SIZE=`iostat -En $DISK | grep Size` 
		echo "HW.DISK=${MODEL} ${SIZE}"
	done
	for IFACE in `netstat -i | egrep -v "^Name|^lo0" | awk '{print $1}' | sort | uniq`
	do
		MAC=`ifconfig $IFACE | grep ether | awk '{print $NF}'`
		echo "HW.NETCARD=${IFACE} MAC:${MAC}"
	done
	exit 0
fi

HPUX=`echo "${OSNAME}" | grep -c "HP-UX"`
if [ $HPUX -eq 1 ]; then
# HP-UX section (exits at the end)
	MODEL=$(uname -m)
	SERIAL=$(uname -i)
	echo "HW.MODEL=${MODEL}"
	echo "HW.SERIAL=${SERIAL}"
	
	DISKINFO=$(which diskinfo)
	if [ $DISKINFO ] && [ -x $DISKINFO ]; then
		DISKS=$(ls /dev/rdsk)
		for DISK in $DISKS
   	do
   		VENDOR=$(${DISKINFO} /dev/rdsk/${DISK} | grep vendor | awk -F: '{print $NF}')
   		PRODUCT=$(${DISKINFO} /dev/rdsk/${DISK} | grep product | awk -F: '{print $NF}')
   		SIZE=$(${DISKINFO} /dev/rdsk/${DISK} | grep size | awk -F: '{print $NF}')
   		echo "HW.DISK=${VENDOR}${PRODUCT}${SIZE}"
   	done
	fi
	
	LANSCAN=$(which lanscan)
	if [ $LANSCAN ] && [ -x $LANSCAN ]; then
		CARD=$(${LANSCAN} | grep "/" | awk -F' ' '{print "HW.NETCARD="$5; print "MAC:"$2; print "PATH:"; system("ioscan -H" $1" | grep lan")}')
		echo $CARD
	fi
	
	SWAPINFO=$(which swapinfo)
	if [ $SWAPINFO ] && [ -x $SWAPINFO ]; then
		SWAP=$($SWAPINFO -dt | grep total | awk '{print "HW.SWAP="$2; print " Kb"}')
		echo $SWAP
	fi
	
	MEM=$(dmesg | grep Physical | awk -F',' '{print $1}')
	echo "HW.MEM=${MEM}"
	
	exit 0
fi

FREEBSD=`echo "${OSNAME}" | grep -c "FreeBSD"`
if [ $FREEBSD -eq 1 ]; then
#  set -x
        echo "HW.MODEL=$(sysctl -n 'hw.machine')"
        sysctl -n 'dev.cpu.0.freq' 1>/dev/null 2>&1
        rc=$?
        if [ "$rc" = "0" ]; then
           echo "HW.CPUMHZ=$(sysctl -n 'dev.cpu.0.freq')"
        else
           echo "HW.CPUMHZ=$(sysctl -n 'hw.clockrate')"
        fi

        echo "HW.CPU=$(sysctl -n 'hw.model')"
#       echo "HW.NCPU=$(sysctl -n 'hw.ncpu')"
        MEM=`sysctl -n 'hw.realmem'`
        echo "HW.MEM=`expr ${MEM} / 1024 / 1024` MB"

        echo "MAC=$(ifconfig | grep ether | cut -d " " -f2)"

        exit 0
fi

DARWIN=`echo "${OSNAME}" | grep -c "Darwin"`
if [ $DARWIN -eq 1 ]; then
	export PATH=/sbin:/usr/sbin:/bin:/usr/bin:$PATH
	echo $(system_profiler SPHardwareDataType | grep Identifier | awk -F':' '{print "HW.MODEL="$NF}')
#	echo $(system_profiler SPHardwareDataType | grep "Processor Speed" | awk -F':' '{print "HW.CPUMHZ="$NF}')
	echo $(system_profiler SPHardwareDataType | grep "Processor Name" | awk -F':' '{print "HW.CPU="$NF}')
	echo $(system_profiler SPHardwareDataType | grep "Memory" | awk -F':' '{print "HW.MEM="$NF}')
	echo $(system_profiler SPHardwareDataType | grep "Serial" | awk -F':' '{print "HW.SERIAL="$NF}')
	for IFACE in $(ifconfig -l)
	do
		MAC=$(ifconfig $IFACE | grep ether | awk '{print $NF}')
		if [ "$MAC" != "" ]; then
			echo "HW.NETCARD=${IFACE} MAC:${MAC}"
		fi
	done
	STR=$(system_profiler SPSerialATADataType | grep -e "Serial Number" | head -1 | tr ' ' '@')
	LENGTH1=$(echo $STR | wc -m | xargs)
	STR=$(echo $STR | tr '@' ' ');
	TRIMMED=$(echo $STR | wc -m | xargs)
	GAP=$(expr $LENGTH1 - $TRIMMED)
	GAP=$(expr $GAP + 1)
	
	echo "$(system_profiler SPSerialATADataType | grep -e "Serial Number" \
	-e "Capacity:" -e "Model:" -e "BSD Name" \
	| sed -e 's/[ ]\{'$GAP'\}.*//g' \
	| xargs | sed 's/ Capacity/^Capacity/' \
	| awk -F'^' '{ for(i = 1; i <= NF; i++){printf("HW.DISK=%s\n",$i)}; }')"
	
	exit 0
fi

LINUX=`echo "${OSNAME}" | grep -c "Linux"`
if [ $LINUX -eq 1 ]; then
## LINUX SECTION
# cpu info
	if [ -f /proc/cpuinfo ]
	then
	    CPU=$(cat /proc/cpuinfo | grep -i -m 1 "model name" | awk -F: {'print $2'} | sed 's/^ *//;s/ *$//')
		if [ -z "${CPU}" ]
                then
                    CPU=$(cat /proc/cpuinfo | grep -i -m 1 "vendor_id" | awk -F: {'print $2'} | sed 's/^ *//;s/ *$//')
					if [ -z "${CPU}" ]
						then
							CPU=$(cat /proc/cpuinfo | grep -i -m 1 "processor" | awk -F: {'print $2'} | sed 's/^ *//;s/ *$//')
					fi
        fi
	    echo "HW.CPU=${CPU}"
	    CPUMHZ=$(cat /proc/cpuinfo | grep -i -m 1 "cpu MHz" | awk -F: {'print $2'} | sed 's/^ *//;s/ *$//')
	    echo "HW.CPUMHZ=${CPUMHZ}"
	fi
	
# memory and swap
	if [ -f /proc/meminfo ]
	then
	    MEM=$(cat /proc/meminfo | grep -i "MemTotal" | awk -F: {'print $2'} | sed 's/^ *//;s/ *$//')
	    echo "HW.MEM=${MEM}"
	    SWAP=$(cat /proc/meminfo | grep -i "SwapTotal" | awk -F: {'print $2'} | sed 's/^ *//;s/ *$//')
	    echo "HW.SWAP=${SWAP}"
	fi
	
# disks
	DISKS=$(fdisk -l | grep "/dev/" | grep ":" | cut -d" " -f 2-4) 2>/dev/null
	if [ -n "${DISKS}" ]; then
	  DPATH=
          for DISK in ${DISKS}
	  do
	    if [ -z "${DPATH}" ]; then
		DPATH=$(echo "${DISK}" | sed 's/\(.*\):$/\1/g')
		if [ ! -e "${DPATH}" ]; then
		  DPATH=
		fi
	    elif [ -z "${SIZE}" ]; then
		SIZE="${DISK}" 
	    else
		UNIT=$(echo "${DISK}" | sed 's/\(.*\),$/\1/g')
                rc=0
                which hdparm 1>/dev/null 2>&1
                rc=$?
                if [ "$rc" = "0" ]; then
	        	MODEL=$(hdparm -i "${DPATH}"| grep -i "model" | sed 's/^ *//;s/ *$//;s/ \+/ /g;s/ ,/,/g') 2>/dev/null
                fi
		echo "HW.DISK=${DPATH} ${MODEL} Size=${SIZE}${UNIT}"
		DPATH=
		SIZE=
		UNIT=
	    fi
	  done
	else
	  DISKS=$(ls -l hd? 2>/dev/null)
	  for DISK in $DISKS
          do
	    if [ -f ${DISK}/model ]; then
	      MODEL=$(cat ${DISK}/model)
	      CAP=$(cat ${DISK}/capacity)
	      CAP=$(expr $CAP / 1073741824)
	      echo "HW.DISK=/dev/hda ${MODEL}"
	    fi
          done
        fi
        
#SCSI
	  if [ -f /proc/scsi/scsi ]; then
	    MODELS=$(cat /proc/scsi/scsi )
	    #echo $MODELS
	    HOST=""
	    hoststart=0
	    for MODEL in $MODELS
	    do
		if [ "$MODEL" = "Host:" ]; then
		    hoststart=1
		    if [ "$HOST" != "" ]; then
			echo "HW.SCSIDISK=$HOST"
		    fi
		    HOST=""
		elif [ $hoststart -eq 1 ]; then
		    HOST="$HOST $MODEL"
		fi
	        #echo $MODEL
	    done
	    if [ $hoststart -eq 1 ]; then
	        echo "HW.SCSIDISK=$HOST"
	    fi
	  fi
	fi

        rc=0
        which lspci 1>/dev/null 2>&1
        rc=$?
        if [ "$rc" = "0" ]; then
	  LSPCI=$(which lspci)
	  if [ $LSPCI ] && [ -x $LSPCI ]; then
	     IFLIST=$(ifconfig -a | cut -d' ' -f 1 | grep eth |xargs)
	     for IF in $IFLIST
	     do
		MAC=$(ifconfig $IF | grep HWaddr |awk '{print $NF}')
		IRQ=$(grep $IF /proc/interrupts | awk -F: {'print $1'} )
		if [ "$IRQ" = "" ]; then
		    IRQ=$(ifconfig $IF | grep Interrupt | awk '{print $1}' | awk -F: '{print $2}')
		fi
		if [ "$IRQ" = "" ]; then
			MEM=$(ifconfig $IF | grep Memory | awk '{print $3}' | awk -F: '{print $2}' | awk -F- '{print $1}')
			if [ "$MEM" = "" ]; then
				SLOT=""
         		else
	       			SLOT=$(lspci -v | tr '\n\t' '\t' | sed -e 's/[0-9a-f]\+:..\.. /\r\n/g' | grep "Memory at *$MEM" | cut -d'	' -f 1 )
			fi
		else
			SLOT=$(lspci -v | tr '\n\t' '\t' | sed -e 's/[0-9a-f]\+:..\.. /\r\n/g' | grep "IRQ *$IRQ" | cut -d'	' -f 1 )
		fi
		if [ "$SLOT" = "" ]; then
			SLOT="no description available"
		fi
		echo HW.NETCARD=$IF MAC:$MAC - $SLOT
	    done
	  fi
        fi
	exit 0
fi

AIX=`echo "${OSNAME}" | grep -c "AIX"`
## AIX SECTION
if [ $AIX -eq 1 ]; then
  echo "HW.MODEL=$(lsconf | grep "System Model" | awk '{print $3}')"
  echo "HW.CPU=$((lsconf | grep "Processor Type" | awk '{print $3}' ; lsconf -c | awk '{print $3}') | xargs )"
  echo "HW.CPUMHZ=$(lsconf -s |awk '{print $4 $5}')"
  echo "HW.MEM=$(lsconf -m | awk '{print $3$4}')"
  echo "HW.SWAP=$(swap -l | grep /dev/ | awk '{print $4}')"
  for IFACE in $(netstat -i | egrep -v "^Name|^lo0" | awk '{print $1}' | sort | uniq)
    do
      MAC=$(entstat -d en0 | grep "Hardware Address:" | awk '{print $3}')
      echo "HW.NETCARD=${IFACE} MAC:${MAC}"
    done
  DISKS=$(lspv | awk '{print $1}' | xargs)
  for DISK in $DISKS
    do
      MODEL=$((lscfg -vl hdisk0 | grep Manufacturer | sed 's/^[ \t]*Manufacturer\.*//g' ;lscfg -vl hdisk0 | grep "Machine Type and Model" | sed 's/^[ \t]*Machine Type and Model\.*//g') | xargs)
      SIZE=$(lscfg -vl $DISK | grep $DISK | awk 'BEGIN{FS="(";RS=")"}/\(/{print $2}')
      echo "HW.DISK=${MODEL} ${SIZE}" 
    done
  exit 0
fi

