/*
- SQL 
- Use 'PolicyName' as MONITOR  -- to specify monitor name
- Use 'ObjectName' as OBJECT   -- to specify object name
- Use 'COUNT' as TYPE   -- to specify type of counter (will deliver delta on the polling interval)
-
*/

SELECT 'ORA_ClusterWaitTime' as MONITOR, 'COUNT/INTERVAL_SEC' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'cluster wait time' 
UNION

SELECT 'ORA_ConcurWaitTime' as MONITOR, 'COUNT/INTERVAL_SEC' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'concurrency wait time' 
UNION

SELECT 'ORA_AppWaitTime' as MONITOR, 'COUNT/INTERVAL_SEC' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'application wait time' 
UNION

SELECT 'ORA_UserIOWaitTime' as MONITOR, 'COUNT/INTERVAL_SEC' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'user I/O wait time' 
UNION

SELECT 'ORA_LogonsCurrent' as MONITOR, 'GAUGE' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'logons current' 
UNION

SELECT 'ORA_TblScansLong' as MONITOR, 'COUNT' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'table scans (long tables)'
UNION

SELECT 'ORA_TblScanBlocks' as MONITOR, 'COUNT' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'table scan blocks gotten'
UNION
 
SELECT 'ORA_CursorsOpen' as MONITOR, 'GAUGE' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'opened cursors current'
UNION

SELECT 'ORA_CorruptBlocks' as MONITOR, 'COUNT' as TYPE, VALUE FROM V$SYSSTAT WHERE name = 'db corrupt blocks detected'
UNION
 
SELECT 'ORA_DbBlockGetsDirectRatio' as MONITOR, 'GAUGE' as TYPE, round(100 * (b.value/(0.001 + a.value)),2) VALUE 
FROM V$SYSSTAT a, V$SYSSTAT b WHERE a.name = 'db block gets' AND b.name = 'db block gets direct'
UNION
 
SELECT 'ORA_DbBlockGetsCachedRatio' as MONITOR, 'GAUGE' as TYPE, round(100 * (b.value/(0.001 + a.value)),2) VALUE 
FROM V$SYSSTAT a, V$SYSSTAT b WHERE a.name = 'db block gets' AND b.name = 'db block gets from cache'
UNION 

SELECT 'ORA_PhysReadsCachedRatio' as MONITOR, 'GAUGE' as TYPE, round(100 * (b.value/(0.001 + a.value)),2) VALUE 
FROM V$SYSSTAT a, V$SYSSTAT b WHERE a.name = 'physical reads' AND b.name = 'physical reads cache'
UNION 

SELECT 'ORA_SortsDiskRatio' as MONITOR, 'GAUGE' as TYPE, round(100 * (b.value/(0.001 + a.value + b.value)),2) VALUE 
FROM V$SYSSTAT a, V$SYSSTAT b
WHERE a.name = 'sorts (memory)' AND b.name = 'sorts (disk)'
UNION

SELECT 'ORA_CommitsPerformedRatio' as MONITOR, 'GAUGE' as TYPE, round(100 * (b.value/(0.001 + a.value)),2) VALUE 
FROM V$SYSSTAT a, V$SYSSTAT b
WHERE a.name = 'commit batch/immediate requested' AND b.name = 'commit batch/immediate performed'
UNION

SELECT 'ORA_SuccessCommitCleanoutsRatio' as MONITOR, 'GAUGE' as TYPE, round(100 * (b.value/(0.001 + a.value)),2) VALUE 
FROM V$SYSSTAT a, V$SYSSTAT b
WHERE a.name = 'commit cleanouts' AND b.name = 'commit cleanouts successfully completed';

select 'ORA_LIBGetHitRatio' as MONITOR, NAMESPACE as OBJECT, round((100 * GETHITRATIO),2) as VALUE from V$LIBRARYCACHE
UNION
select 'ORA_LIBPinHitRatio' as MONITOR, NAMESPACE as OBJECT, round((100 * PINHITRATIO),2) as VALUE from V$LIBRARYCACHE;
/*
 next query will be treated as status monitor 
*/
select '1' as VALUE from DUAL;