#!/bin/ksh
######################################################################
#
#  Name: table_util.ksh
#
#  Description: determines the kernel table utilization
#               (semaphores, shared memory and message queues)
#
#  Version:	1.0
#  Date: 15.03.2011
#  Copyright: BLUE ELEPHANT SYSTEMS GmbH
#
######################################################################

#set -x

# NOTE:
# use kmtune before 11.23 
# kctune from 11.23 HP-UX
#
# semaphores
PROG=$(which kctune)
if [ $PROG ] && [ -x $PROG ]; then
	SEMTOTAL=$(kctune |grep semmns| awk '{ print $2}')
else
	SEMTOTAL=$(kmtune |grep semmns| awk '{ print $2}')
fi
SEM=$(ipcs -s |grep 0x |wc -l)
SEMPCT=$((($SEM * 100) / $SEMTOTAL))


# shared memory
PROG=$(which kctune)
if [ $PROG ] && [ -x $PROG ]; then
	SHMTOTAL=$(kctune |grep shmmni| awk '{ print $2}')
else
	SHMTOTAL=$(kmtune |grep shmmni| awk '{ print $2}')
fi
SHM=$(ipcs -m |grep 0x |wc -l)
SHMPCT=$((($SHM * 100) / $SHMTOTAL))

# messages queues
PROG=$(which kctune)
if [ $PROG ] && [ -x $PROG ]; then
	MSGTOTAL=$(kctune |grep msgmni| awk '{ print $2}')
else
	MSGTOTAL=$(kmtune |grep msgmni| awk '{ print $2}')
fi
MSG=$(ipcs -q |grep 0x |wc -l)
MSGPCT=$((($MSG * 100) / $MSGTOTAL))
print sem: $SEM shm: $SHM mq: $MSG semmax: $SEMTOTAL shmmax: $SHMTOTAL mqmax: $MSGTOTAL
print semaphores @ $SEMPCT%;
print shared memory @ $SHMPCT%;
print message queues @ $MSGPCT%;

exit 0