######################################################################
#
#  Name: na_pslist.sh
#
#  Description: returns list of currently running processes
#
#  Version: 1.0
#  Date: 15.02.2011
#  Copyright: BLUE ELEPHANT SYSTEMS GmbH
#
######################################################################

  num_GLOBAL_ZONE=0

# check if global zone
if [ -x /usr/bin/zonename ]; then
  if [ `/usr/bin/zonename` = "global" ]; then
    num_GLOBAL_ZONE=1
  fi
fi

# execute appropriate PS command
if [ $num_GLOBAL_ZONE -eq 1 ]; then
  ps -o pid,tty,s,time,args -z global
else
  if [ -x /usr/ucb/ps ]; then
    /usr/ucb/ps -axww
  else
    ps -eo pid,tty,s,time,args
  fi
fi
