Option Explicit
On Error Resume Next

Dim objWMIService, strComputer, colItems, objItem, strPolicy

If WScript.Arguments.Count <> 1 Then
  Wscript.Echo "Usage: checkShareStatus <Policy Name>"
  Wscript.Quit(-1)
Else
  strPolicy = WScript.Arguments.Item(0)
  strComputer = "."
  Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")

  If( Err.Number <> 0 ) Then
    'Connection to WMI failed - WMI is not running or insufficient privileges
    Wscript.Echo strPolicy & "=-2"
  Else
    Set colItems = objWMIService.ExecQuery( "Select * from Win32_Share" )
    If( colItems.Count = 0 ) Then
      'No Shares configured
      Wscript.Echo strPolicy & "=-1"
    Else
      For Each objItem In colItems
        If( Err.Number <> 0 ) Then
          'No Shares configured
          Wscript.Echo strPolicy & "=-1"
          Err.Clear 
        Else
          If( UCase( objItem.Status ) <> "OK" ) Then
            Wscript.Echo strPolicy & "=0 o=""" & objItem.Name & """"
          Else
            Wscript.Echo strPolicy & "=1 o=""" & objItem.Name & """"
          End If
        End If
      Next
    End If
  End If
End If
Wscript.Quit(0)
