On Error Resume Next
Dim strPolicy

If WScript.Arguments.Count <> 1 Then
  strPolicy = "winOSMPI_aWinOSTrigger"
Else
  strPolicy = WScript.Arguments.Item(0)
End If

strComputer = "."
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")
If( Err.Number <> 0 ) Then
    'Connection to WMI failed - WMI is not running, insufficient privileges, wrong user/password
    Wscript.Echo "Connection to WMI failed"
    Wscript.Echo strPolicy & "=-2"
Else
  Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfOS_System",,48)
  For Each objItem in colItems
    Wscript.Echo "winOSMPI_FileReadPersecKB=" & (objItem.FileReadBytesPersec / 1024)
    Wscript.Echo "winOSMPI_FileWritePersecKB=" & (objItem.FileWriteBytesPersec / 1024)
    Wscript.Echo "winOSMPI_WinPercentRegistryQuotaInUse=" & objItem.PercentRegistryQuotaInUse
    Wscript.Echo "winOSMPI_WinProcesses=" & objItem.Processes
    Wscript.Echo "winOSMPI_WinSysCallsPersec=" & objItem.SystemCallsPersec
    Wscript.Echo "winOSMPI_WinThreads=" & objItem.Threads
    Wscript.Echo "winOSMPI_ProcessorQueue=" & objItem.ProcessorQueueLength 
  Next

  Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfOS_Memory",,48)
  For Each objItem in colItems
    Wscript.Echo "winOSMPI_WinMemFreeMB=" & objItem.AvailableMBytes
    Wscript.Echo "winOSMPI_MemPagePerSec=" & objItem.PagesPerSec
  Next
  Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfOS_PagingFile",,48)
  For Each objItem in colItems
	  Wscript.Echo "winOSMPI_WinPageFilePercent=" & objItem.PercentUsage & " o=" & objItem.Name
  Next
  Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfOS_Processor",,48)
  For Each objItem in colItems
    Wscript.Echo "winOSMPI_WinCPUUsagePercent=" & objItem.PercentProcessorTime & " o=" & objItem.Name
  Next
  Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfDisk_LogicalDisk",,48)
  For Each objItem in colItems
    Wscript.Echo "winOSMPI_WinLDiskFreeMB=" & objItem.FreeMegabytes & " o=" & objItem.Name
	  Wscript.Echo "winOSMPI_WinLDiskFreePercent=" & objItem.PercentFreeSpace & " o=" & objItem.Name
  Next
  Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_TermService_TerminalServices",,48)
  For Each objItem in colItems
    Wscript.Echo "winOSMPI_WinTSActiveSessions=" & objItem.ActiveSessions
  	Wscript.Echo "winOSMPI_WinTSInactiveSessions=" & objItem.InactiveSessions
  Next
  Wscript.Echo strPolicy & "=0"
End If

