Option Explicit
On Error Resume Next
Dim WshShell, WshNetwork
Dim strPolicy, strComputer, strUser, strPassword, strFilename, intInterval
Dim wbemLocator, objWMIService, colItems, objItem
Dim objRefresher, objRefreshableSystem, objRefreshableMemory, objRefreshableTS, objRefreshableDisc, objRefreshableProc, objRefreshablePage, objRefreshableNet
Dim valCPU, valCPUQueue, valMemFree, valFR, valFW, valProcs, valThreads, valSysCalls, valSessAct, valSessIn, valReg, valPagePerSec
Dim count, out
Dim objFS

strComputer = "."
strPolicy   = "rwinOSMPI_WinOSTrigger"
strUser     = ""
strPassword = ""
intInterval = 10
strFilename = ""

Sub initError()
  Dim errorFile
  Set objFS = CreateObject("Scripting.FileSystemObject")
  Set errorFile = objFS.OpenTextFile(".\remotePerfSys.log", 2, TRUE)
End Sub

Sub CheckAndLogError()
  Dim errorFile, msg
  If Err.Number <> 0 Then
    msg = Err.Description
    Set errorFile = objFS.OpenTextFile(".\remotePerfSys.log", 8, TRUE)
    errorFile.Writeline(Now() & ": Error: " & Err.Description)
    errorFile.Close
    Err.Clear
  End If
End Sub

Sub LogError(msg)
  Dim errorFile
  If msg > "" Then
    Set errorFile = objFS.OpenTextFile(".\remotePerfSys.log", 8, TRUE)
    errorFile.Writeline(Now() & ": Error: " & msg)
    errorFile.Close
  End If
End Sub

initError
If WScript.Arguments.Count < 1 or WScript.Arguments.Count > 9 Then
  Wscript.Echo "Usage: remotePerfSys.vbs <PolicyName> [-c <Computer> [-u <user> [-p <password>]] | -f <config file>] [-i <ProbeInterval in Seconds>]"
  LogError "Usage: remotePerfSys.vbs <PolicyName> [-c <Computer> [-u <user> [-p <password>]] | -f <config file>] [-i <ProbeInterval in Seconds>]"
  Wscript.Quit(-1)
Else
  strPolicy   = WScript.Arguments.Item(0)
  count = 2
  Do While count < WScript.Arguments.Count
    If instr(WScript.Arguments.Item(count-1), "-c") then
      strComputer = lcase(WScript.Arguments.Item(count))
    ElseIf instr(WScript.Arguments.Item(count-1), "-f") then
      strFilename = WScript.Arguments.Item(count)
    ElseIf instr(WScript.Arguments.Item(count-1), "-i") then
      intInterval = WScript.Arguments.Item(count)
    ElseIf instr(WScript.Arguments.Item(count-1), "-u") then
      strUser = WScript.Arguments.Item(count)
    ElseIf instr(WScript.Arguments.Item(count-1), "-p") then
      strPassword = WScript.Arguments.Item(count)
    Else
      Wscript.Echo "Usage: remotePerfSys.vbs <PolicyName> [-c <Computer> [-u <user> [-p <password>]] | -f <config file>] [-i <ProbeInterval in Seconds>]"
      out = "remotePerfSys.vbs "
      For Each strPolicy in WScript.Arguments
        out = out & strPolicy & " "
      Next
      LogError out
      LogError "Failed Paramter (" & count-1 & "): " & WScript.Arguments.Item(count-1)
      LogError "Usage: remotePerfSys.vbs <PolicyName> [-c <Computer> [-u <user> [-p <password>]] | -f <config file>] [-i <ProbeInterval in Seconds>]"
      Wscript.Echo strPolicy & "=-1"
      Wscript.Quit(-1)
    End If
    count = count + 2
  Loop
End If
  Set objRefresher = CreateObject("WbemScripting.SWbemRefresher")
  CheckAndLogError
  Set WshShell = WScript.CreateObject("WScript.Shell")
  CheckAndLogError
  Set wbemLocator   = CreateObject("WbemScripting.SWbemLocator")
  CheckAndLogError
  wbemLocator.Security_.AuthenticationLevel = 6 'SWbemSecurity.wbemAuthenticationLevelPkt
  wbemLocator.Security_.ImpersonationLevel  = 3 'SWbemSecurity.wbemImpersonationLevelImpersonate

  If (strUser > "") then
    If (strPassword > "") then
      Set objWMIService = wbemLocator.connectserver(strComputer, "root\cimv2", strUser, strPassword)
    Else
      Set objWMIService = wbemLocator.connectserver(strComputer, "root\cimv2", strUser)
    End If
  Else
    Set objWMIService = wbemLocator.connectserver(strComputer, "root\cimv2")
  End If

  If( Err.Number <> 0 ) Then
    'Connection to WMI failed - WMI is not running, insufficient privileges, wrong user/password
    CheckAndLogError
    LogError "Connection to WMI failed"
    Wscript.Echo strPolicy & "=-2"
  Else
    If strcomp(strComputer, ".") = 0 then
      Set WshNetwork = WScript.CreateObject("WScript.Network")
      If Err.Number <> 0 then
        Err.Clear
        Set colItems = objWMIService.ExecQuery("Select * from Win32_ComputerSystem",,48)
        For Each objItem in colItems
          strComputer = lcase(objItem.Name)
        Next
      Else
        strComputer = lcase(WshNetwork.ComputerName)
      End If
    End If
    CheckAndLogError

    Set objRefreshableSystem = objRefresher.AddEnum(objWMIService, "Win32_PerfFormattedData_PerfOS_System")
    CheckAndLogError
    Set objRefreshableMemory = objRefresher.AddEnum(objWMIService, "Win32_PerfFormattedData_PerfOS_Memory")
    CheckAndLogError
    Set objRefreshableTS = objRefresher.AddEnum(objWMIService, "Win32_PerfFormattedData_TermService_TerminalServices")
    CheckAndLogError
    Set objRefreshableDisc = objRefresher.AddEnum(objWMIService, "Win32_PerfFormattedData_PerfDisk_LogicalDisk")
    CheckAndLogError
    Set objRefreshableProc = objRefresher.AddEnum(objWMIService, "Win32_PerfFormattedData_PerfOS_Processor")
    CheckAndLogError
    Set objRefreshablePage = objRefresher.AddEnum(objWMIService, "Win32_PerfFormattedData_PerfOS_PagingFile")
    CheckAndLogError
    Set objRefreshableNet = objRefresher.AddEnum(objWMIService, "Win32_PerfFormattedData_Tcpip_NetworkInterface")
    CheckAndLogError
    objRefresher.Refresh
    If( Err.Number <> 0 ) Then
      'Refreshing of values failed
      Wscript.Echo "WMI Refresh of counters failed"
      CheckAndLogError
      LogError "WMI Refresh of counters failed"
      Wscript.Echo strPolicy & "=-1"
    End If
    Wscript.Sleep(intInterval*1000) 'Data Collection Interval in Secs
    objRefresher.Refresh
    CheckAndLogError
    For Each objItem in objRefreshableSystem.ObjectSet
      valFR = objItem.FileReadBytesPersec / 1024
      valFW = objItem.FileWriteBytesPersec / 1024
      valReg = objItem.PercentRegistryQuotaInUse
      valProcs = objItem.Processes
      valSysCalls = objItem.SystemCallsPersec
      valThreads = objItem.Threads
      valCPUQueue = objItem.ProcessorQueueLength
      Wscript.Echo "rwinOSMPI_FileReadPersecKB=" & valFR & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_FileWritePersecKB=" & valFW & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_WinPercentRegistryQuotaInUse=" & valReg & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_WinProcesses=" & valProcs & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_WinSysCallsPersec=" & valSysCalls & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_WinThreads=" & valThreads & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_ProcessorQueue=" & valCPUQueue & " HOST=" & strComputer
    Next
    'Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfOS_Memory",,48)
    'For Each objItem in colItems
    For Each objItem in objRefreshableMemory.ObjectSet
      valMemFree    = objItem.AvailableMBytes
      valPagePerSec = objItem.PagesPerSec
      Wscript.Echo "rwinOSMPI_WinMemFreeMB=" & valMemFree & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_MemPagePerSec=" & valPagePerSec & " HOST=" & strComputer
    Next
    'Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_TermService_TerminalServices",,48)
    'For Each objItem in colItems
    For Each objItem in objRefreshableTS.ObjectSet
      valSessAct = objItem.ActiveSessions
      valSessIn = objItem.InactiveSessions
      Wscript.Echo "rwinOSMPI_WinTSActiveSessions=" & valSessAct & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_WinTSInactiveSessions=" & valSessIn & " HOST=" & strComputer
    Next
    'Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfDisk_LogicalDisk",,48)
    'For Each objItem in colItems
    For Each objItem in objRefreshableDisc.ObjectSet
      Wscript.Echo "rwinOSMPI_WinLDiskFreeMB=" & objItem.FreeMegabytes & " o=" & objItem.Name  & " HOST=" & strComputer
      Wscript.Echo "rwinOSMPI_WinLDiskFreePercent=" & objItem.PercentFreeSpace & " o=" & objItem.Name  & " HOST=" & strComputer
      out = "boomperfstore.exe WINOS_DISK " & strComputer & " " & Chr(34) & objItem.Name & Chr(34) & " " & objItem.FreeMegabytes & _
            " " & objItem.PercentFreeSpace & " " & objItem.AvgDiskQueueLength & " " & objItem.DiskTransfersPerSec & _
            " " & objItem.PercentDiskTime
      WshShell.Run out, 0, true
      CheckAndLogError
    Next
    valCPU = "0"
    'Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfOS_Processor",,48)
    'For Each objItem in colItems
    For Each objItem in objRefreshableProc.ObjectSet
      If Instr(objItem.Name, "Total") then
        valCPU = objItem.PercentProcessorTime
      End If
      Wscript.Echo "rwinOSMPI_WinCPUUsagePercent=" & objItem.PercentProcessorTime & " o=" & objItem.Name & " HOST=" & strComputer
      out = "boomperfstore.exe WINOS_CPU " & strComputer & " " & Chr(34) & objItem.Name & Chr(34) & " " & objItem.PercentProcessorTime & _
            " " & objItem.PercentPrivilegedTime & " " & objItem.PercentUserTime & " " & objItem.PercentInterruptTime
      WshShell.Run out, 0, true
      CheckAndLogError
    Next
    'Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfFormattedData_PerfOS_PagingFile",,48)
    'For Each objItem in colItems
    For Each objItem in objRefreshablePage.ObjectSet
      Wscript.Echo "rwinOSMPI_WinPageFilePercent=" & objItem.PercentUsage & " o=" & objItem.Name  & " HOST=" & strComputer
      out = "boomperfstore.exe WINOS_PAGING " & strComputer & " " & Chr(34) & objItem.Name & Chr(34) & " " & objItem.PercentUsage & _
            " " & objItem.PercentUsagePeak
      WshShell.Run out, 0, true
      CheckAndLogError
    Next
    For Each objItem in objRefreshableNet.ObjectSet
      ' Wscript.Echo "rwinOSMPI_WinPageFilePercent=" & objItem.PercentUsage & " o=" & objItem.Name  & " HOST=" & strComputer
      out = "boomperfstore.exe WINOS_NET " & strComputer & " " & Chr(34) & objItem.Name & Chr(34) & " " & objItem.BytesReceivedPerSec & _
            " " & objItem.BytesSentPerSec & " " & objItem.PacketsOutboundDiscarded & " " & objItem.PacketsOutboundErrors & _
            " " & objItem.PacketsReceivedDiscarded & " " & objItem.PacketsReceivedErrors & " " & objItem.PacketsSentPerSec & _
            " " & objItem.PacketsReceivedPerSec & " " & objItem.OutputQueueLength & " " & objItem.CurrentBandwidth
      WshShell.Run out, 0, true
      CheckAndLogError
    Next

    out = "boomperfstore.exe WINOS_GEN " & strComputer & " " & valCPU & " " & valCPUQueue & " " & valMemFree & _
    " " & valPagePerSec & " " & valFR & " " & valFW & " " & valProcs & " " & valThreads & " " & valSysCalls & " " & valSessAct & _
    " " & valSessIn & " " & valReg
    WshShell.Run out, 0, true
    CheckAndLogError
    objRefresher.DeleteAll
    set objRefresher=nothing
    Wscript.Echo strPolicy & "=0"
    If IsObject(errorFile) then
      errorFile.close
    End If
End If
' WINOS_GEN: HOST_NAME = 1, CPU = 2, CPUQUEUE = 3, MEMORYFREEMB = 4, PAGEPERSEC = 5, FILEREADPERSECKB = 6, FILEWRITEPERSECKB = 7, PROCESSES = 8
'   THREADS = 9, SYSTEMCALLS = 10, SESSIONSACT = 11, SESSIONSINACT = 12, REGISTRYQUOTA = 13
' WINOS_DISK: HOST_NAME = 1, OBJECT = 2, FREEMB = 3, FREEPERC = 4, QUEUELENGTH = 5, TRANSFERS = 6, BUSYPERC = 7
' WINOS_CPU:  HOST_NAME = 1, OBJECT = 2, CPUBUSYPERC = 3, CPUPRIVPERC = 4, CPUUSERPERC = 5, CPUINTERPERC = 6
' WINOS_PAGING: HOST_NAME = 1, OBJECT = 2, USED = 3, PEAKUSED = 4 
' WINOS_NET: HOST_NAME = 1, OBJECT = 2, RCVBPS = 3, OUTBPS = 4, OUTPACKDISCARD = 5, OUTPACKERR = 6, RCVPACKDISCARD = 7,
'   RCVPACKERR = 8, OUTPACKPS = 9, RCVPACKPS = 10, OUTPUTQUEUE=11, BANDWIDTH = 12

