$logfilename=$args[0]
$mainfile = $logfilename + '_event.log'
$tmpfile = $logfilename + '_tmp.log'

$lastId = 0

	$content = Get-Content -Encoding UTF8 $mainfile

	foreach ($line in $content)
	{
		if($line -match 'Index\s*:\s*(\d+)\s*'){
			$lastId = ($line -replace 'Index\s*:\s*(\d+)\s*', '$1')
		}
		
	}

#echo $lastId
Try {
	$dt=(get-date).addminutes(-5); #consider last 5 minutes
	$data=(get-eventlog -logname $logfilename -newest 1000) | where {$_.Index -gt $lastId -and $_.TimeWritten -gt $dt} | sort -property index | format-list | Out-String -Width 4096;
	
	$data | out-file -Encoding UTF8 $tmpfile;
	
	if ((Test-Path $mainfile) -and (Test-Path $tmpfile)) { 
	    if((Get-Item $tmpfile).length -gt 2){
	        if ((Get-Item $mainfile).length -gt 1024000){
	            remove-item $mainfile;
	            rename-item $tmpfile -NewName $mainfile;
	            #echo "tmpfile is smaller than main -> replace"
	        } else {
	            remove-item $tmpfile;
	            $data | out-file -Encoding UTF8 -Append $mainfile
	            #echo "tmpfile is greater than main -> append"
	        }
	        
	    } else {
	        #echo "tmp file empty";
	    }
	} else{
	    remove-item $tmpfile;
	    $data | out-file -Encoding UTF8 -Append $mainfile;
	    #echo "original file not found -> write main"
	}
}
Catch 
{
	"Index : 0 `nError trying to access event log: " + $_.Exception.Message| out-file -Encoding UTF8 -Append $mainfile;
}